/*
 * Decompiled with CFR 0.152.
 */
package com.aquenos.epics.jackie.common.value.internal;

import com.aquenos.epics.jackie.common.io.ByteSink;
import com.aquenos.epics.jackie.common.value.ChannelAccessAcknowledgeAlarm;
import com.aquenos.epics.jackie.common.value.ChannelAccessAlarmAcknowledgementStatus;
import com.aquenos.epics.jackie.common.value.ChannelAccessAlarmValue;
import com.aquenos.epics.jackie.common.value.ChannelAccessConfigureAcknowledgeTransientAlarms;
import com.aquenos.epics.jackie.common.value.ChannelAccessControlsValue;
import com.aquenos.epics.jackie.common.value.ChannelAccessFloatingPointGraphicsValue;
import com.aquenos.epics.jackie.common.value.ChannelAccessGraphicsEnum;
import com.aquenos.epics.jackie.common.value.ChannelAccessGraphicsValue;
import com.aquenos.epics.jackie.common.value.ChannelAccessNumericControlsValue;
import com.aquenos.epics.jackie.common.value.ChannelAccessNumericGraphicsValue;
import com.aquenos.epics.jackie.common.value.ChannelAccessTimeValue;
import com.aquenos.epics.jackie.common.value.ChannelAccessValue;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public abstract class ChannelAccessValueBase<ElementType, ImplementationType extends ChannelAccessValueBase<ElementType, ImplementationType>>
implements ChannelAccessValue<ElementType> {
    protected ImplementationType delegate;

    ChannelAccessValueBase() {
    }

    ChannelAccessValueBase(ImplementationType delegate) {
        this.delegate = delegate;
    }

    @Override
    public ListIterator<ElementType> iterator() {
        if (this.delegate != null) {
            return ((ChannelAccessValueBase)this.delegate).iterator();
        }
        return new ListIterator<ElementType>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.nextIndex() < ChannelAccessValueBase.this.getValueSize();
            }

            @Override
            public ElementType next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("This iterator is already at the end of the list.");
                }
                ++this.index;
                return ChannelAccessValueBase.this.getGenericValueElement(this.index);
            }

            @Override
            public boolean hasPrevious() {
                int previousIndex = this.previousIndex();
                if (previousIndex < 0) {
                    return false;
                }
                return previousIndex < ChannelAccessValueBase.this.getValueSize();
            }

            @Override
            public ElementType previous() {
                if (!this.hasPrevious()) {
                    throw new NoSuchElementException("This iterator is already at the beginning of the list.");
                }
                --this.index;
                return ChannelAccessValueBase.this.getGenericValueElement(this.index);
            }

            @Override
            public int nextIndex() {
                return this.index + 1;
            }

            @Override
            public int previousIndex() {
                return this.index - 1;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("This iterator allows read access only.");
            }

            @Override
            public void set(ElementType e) {
                throw new UnsupportedOperationException("This iterator allows read access only.");
            }

            @Override
            public void add(ElementType e) {
                throw new UnsupportedOperationException("This iterator allows read access only.");
            }
        };
    }

    @Override
    public boolean isReadOnly() {
        return this.delegate != null;
    }

    protected static Object extractDelegate(Object obj) {
        if (obj != null && obj instanceof ChannelAccessValueBase) {
            ChannelAccessValueBase other = (ChannelAccessValueBase)obj;
            if (other.delegate != null) {
                return other.delegate;
            }
        }
        return obj;
    }

    @Override
    public boolean equals(Object obj) {
        assert (!this.isReadOnly());
        if (obj == null) {
            return false;
        }
        return this.getClass().equals(obj.getClass());
    }

    @Override
    public int hashCode() {
        assert (!this.isReadOnly());
        return new HashCodeBuilder(91, 13).append((Object)this.getType()).toHashCode();
    }

    private static void addAlarmString(StringBuilder sb, ChannelAccessAlarmValue<?> value) {
        sb.append("status=");
        sb.append(value.getAlarmStatus().toString());
        sb.append(", severity=");
        sb.append(value.getAlarmSeverity().toString());
        sb.append(", ");
    }

    private static void addTimeString(StringBuilder sb, ChannelAccessTimeValue<?> value) {
        sb.append("time=");
        sb.append(value.getTimeStamp().toString());
        sb.append(", ");
    }

    private static void addGraphicsString(StringBuilder sb, ChannelAccessGraphicsValue<?> graphicsValue) {
        ChannelAccessGraphicsValue value;
        if (graphicsValue instanceof ChannelAccessFloatingPointGraphicsValue) {
            value = (ChannelAccessFloatingPointGraphicsValue)graphicsValue;
            sb.append("precision=");
            short precision = value.getPrecision();
            sb.append(precision & 0xFFFF);
            sb.append(", ");
        }
        if (graphicsValue instanceof ChannelAccessNumericGraphicsValue) {
            value = (ChannelAccessNumericGraphicsValue)graphicsValue;
            sb.append("units=\"");
            sb.append(StringEscapeUtils.escapeJava((String)value.getUnits()));
            sb.append("\", upperDisplayLimit=");
            sb.append(value.getGenericUpperDisplayLimit().toString());
            sb.append(", lowerDisplayLimit=");
            sb.append(value.getGenericLowerDisplayLimit().toString());
            sb.append(", upperAlarmLimit=");
            sb.append(value.getGenericUpperAlarmLimit().toString());
            sb.append(", upperWarningLimit=");
            sb.append(value.getGenericUpperWarningLimit().toString());
            sb.append(", lowerWarningLimit=");
            sb.append(value.getGenericLowerWarningLimit().toString());
            sb.append(", lowerAlarmLimit=");
            sb.append(value.getGenericLowerAlarmLimit().toString());
            sb.append(", ");
        }
        if (graphicsValue instanceof ChannelAccessGraphicsEnum) {
            value = (ChannelAccessGraphicsEnum)graphicsValue;
            sb.append("labels=[");
            boolean first = true;
            for (String label : value.getLabels()) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append('\"');
                sb.append(StringEscapeUtils.escapeJava((String)label));
                sb.append('\"');
            }
            sb.append("], ");
        }
    }

    private static void addControlsString(StringBuilder sb, ChannelAccessControlsValue<?> controlsValue) {
        if (controlsValue instanceof ChannelAccessNumericControlsValue) {
            ChannelAccessNumericControlsValue value = (ChannelAccessNumericControlsValue)controlsValue;
            sb.append("upperControlLimit=");
            sb.append(value.getGenericUpperControlLimit().toString());
            sb.append(", lowerControlLimit=");
            sb.append(value.getGenericLowerControlLimit().toString());
            sb.append(", ");
        }
    }

    @Override
    public String toString() {
        ChannelAccessValue<Short> value;
        if (this.delegate != null) {
            return ((ChannelAccessValueBase)this.delegate).toString();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.getType().toString());
        sb.append('{');
        if (this instanceof ChannelAccessConfigureAcknowledgeTransientAlarms) {
            value = (ChannelAccessConfigureAcknowledgeTransientAlarms)((Object)this);
            sb.append("explicitlyAcknowledgeTransientAlarms=");
            sb.append(value.isExplicitlyAcknowledgeTransientAlarms());
            sb.append(", ");
        } else if (this instanceof ChannelAccessAcknowledgeAlarm) {
            value = (ChannelAccessAcknowledgeAlarm)((Object)this);
            sb.append("acknowledgeAlarmSeverity=");
            sb.append(value.getAcknowledgeAlarmSeverity().toString());
            sb.append(", ");
        } else if (this instanceof ChannelAccessAlarmAcknowledgementStatus) {
            value = (ChannelAccessAlarmAcknowledgementStatus)((Object)this);
            sb.append("status=");
            sb.append(value.getAlarmStatus().toString());
            sb.append(", severity=");
            sb.append(value.getAlarmSeverity().toString());
            sb.append(", explicitlyAcknowledgeTransientAlarms");
            sb.append(value.isExplicitlyAcknowledgeTransientAlarms());
            sb.append(", unacknowledgedSeverity=");
            sb.append(value.getUnacknowledgedAlarmSeverity().toString());
            sb.append(", ");
        } else {
            if (this instanceof ChannelAccessAlarmValue) {
                ChannelAccessValueBase.addAlarmString(sb, (ChannelAccessAlarmValue)((Object)this));
            }
            if (this instanceof ChannelAccessTimeValue) {
                ChannelAccessValueBase.addTimeString(sb, (ChannelAccessTimeValue)((Object)this));
            }
            if (this instanceof ChannelAccessGraphicsValue) {
                ChannelAccessValueBase.addGraphicsString(sb, (ChannelAccessGraphicsValue)((Object)this));
            }
            if (this instanceof ChannelAccessControlsValue) {
                ChannelAccessValueBase.addControlsString(sb, (ChannelAccessControlsValue)((Object)this));
            }
        }
        sb.append("value=");
        int numberOfElements = this.getValueSize();
        if (numberOfElements == 1) {
            Object element = this.getGenericValueElement(0);
            if (element instanceof String) {
                String stringElement = (String)element;
                sb.append('\"');
                sb.append(StringEscapeUtils.escapeJava((String)stringElement));
                sb.append('\"');
            } else {
                sb.append(element.toString());
            }
        } else {
            sb.append('[');
            boolean first = true;
            for (int i = 0; i < numberOfElements; ++i) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                Object element = this.getGenericValueElement(i);
                if (element instanceof String) {
                    String stringElement = (String)element;
                    sb.append('\"');
                    sb.append(StringEscapeUtils.escapeJava((String)stringElement));
                    sb.append('\"');
                    continue;
                }
                sb.append(element.toString());
            }
            sb.append(']');
        }
        sb.append('}');
        return sb.toString();
    }

    @Override
    public ChannelAccessValue<ElementType> clone() {
        assert (!this.isReadOnly());
        try {
            ChannelAccessValue copy = (ChannelAccessValue)super.clone();
            return copy;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Unexpected error: " + e.getMessage(), e);
        }
    }

    public abstract void serialize(ByteSink var1, int var2);
}

