/*
 * Decompiled with CFR 0.152.
 */
package com.aquenos.epics.jackie.common.value.internal;

import com.aquenos.epics.jackie.common.io.ByteSink;
import com.aquenos.epics.jackie.common.io.ByteSource;
import com.aquenos.epics.jackie.common.value.ChannelAccessAlarmSeverity;
import com.aquenos.epics.jackie.common.value.ChannelAccessAlarmStatus;

public class ValueCodecUtils {
    private ValueCodecUtils() {
    }

    public static ChannelAccessAlarmStatus deserializeAlarmStatus(ByteSource byteSource) {
        return ChannelAccessAlarmStatus.forAlarmStatusCode(byteSource.getShort());
    }

    public static ChannelAccessAlarmSeverity deserializeAlarmSeverity(ByteSource byteSource) {
        try {
            return ChannelAccessAlarmSeverity.forSeverityCode(byteSource.getShort());
        }
        catch (IllegalArgumentException e) {
            return ChannelAccessAlarmSeverity.INVALID_ALARM;
        }
    }

    public static boolean deserializeBooleanFromShort(ByteSource byteSource) {
        return byteSource.getShort() != 0;
    }

    public static int deserializeTimeSeconds(ByteSource byteSource) {
        return byteSource.getInt();
    }

    public static int deserializeTimeNanoseconds(ByteSource byteSource) {
        return byteSource.getInt();
    }

    public static void serializeAlarms(ByteSink byteSink, ChannelAccessAlarmStatus alarmStatus, ChannelAccessAlarmSeverity alarmSeverity) {
        byteSink.putShort(alarmStatus.toAlarmStatusCode());
        byteSink.putShort(alarmSeverity.toSeverityCode());
    }

    public static void serializeAlarmSeverity(ByteSink byteSink, ChannelAccessAlarmSeverity alarmSeverity) {
        byteSink.putShort(alarmSeverity.toSeverityCode());
    }

    public static void serializeBooleanAsShort(ByteSink byteSink, boolean value) {
        byteSink.putShort(value ? (short)1 : 0);
    }

    public static void serializeTime(ByteSink byteSink, int seconds, int nanoseconds) {
        byteSink.putInt(seconds);
        byteSink.putInt(nanoseconds);
    }
}

