/*
 * Decompiled with CFR 0.152.
 */
package com.arakelian.faker.reader;

import com.arakelian.faker.reader.ImmutableColumn;
import com.arakelian.jackson.utils.JacksonUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.immutables.value.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import repackaged.com.arakelian.faker.com.google.common.base.Charsets;
import repackaged.com.arakelian.faker.com.google.common.base.Preconditions;
import repackaged.com.arakelian.faker.com.google.common.collect.Lists;
import repackaged.com.arakelian.faker.com.google.common.collect.Maps;
import repackaged.com.arakelian.faker.org.apache.commons.lang3.StringUtils;

public class TextReader<T> {
    private static final String[] EMPTY_COLUMNS = new String[0];
    private static final Logger LOGGER = LoggerFactory.getLogger(TextReader.class);
    private static final Pattern IDENTIFIER = Pattern.compile("[A-Za-z0-9_]+");
    public static final Pattern COLUMN = Pattern.compile("([a-zA-Z]+)(?:\\(([a-zA-Z]+)(?:,([0-9]+))?\\))?");
    private final URL resource;
    private final Class<T> dataClass;
    private final Map<String, String> properties = Maps.newLinkedHashMap();
    private List<Object[]> rows;
    private List<T> values;
    private Map<String, Column> columns;
    private String[] columnNames;
    private boolean haveColumnWidths;
    private Format format;
    private String delimiter;
    private int lineCount;

    public TextReader(String resourceName, Class<T> dataClass) {
        this.resource = TextReader.class.getResource(resourceName);
        Preconditions.checkArgument(this.resource != null, "Resource \"" + resourceName + "\" not found");
        this.dataClass = Preconditions.checkNotNull(dataClass);
    }

    public TextReader(URL resource, Class<T> dataClass) {
        this.resource = Preconditions.checkNotNull(resource);
        this.dataClass = Preconditions.checkNotNull(dataClass);
    }

    public Column getColumn(int index) {
        return this.columns != null ? this.columns.get(this.columnNames[index]) : null;
    }

    public Column getColumn(String name) {
        return this.columns != null ? this.columns.get(name) : null;
    }

    public int getColumnCount() {
        return this.columns != null ? this.columns.size() : 0;
    }

    public String[] getColumnNames() {
        return this.columnNames != null ? this.columnNames : EMPTY_COLUMNS;
    }

    public Class<T> getDataClass() {
        return this.dataClass;
    }

    public Double getDouble(int row, int column) {
        return this.getValue(row, column, Double.class);
    }

    public Integer getInt(int row, int column) {
        return this.getValue(row, column, Integer.class);
    }

    public int getLineCount() {
        return this.lineCount;
    }

    public Long getLong(int row, int column) {
        return this.getValue(row, column, Long.class);
    }

    public String getProperty(String name) {
        return this.properties.get(name);
    }

    public Set<String> getPropertyNames() {
        return this.properties.keySet();
    }

    public T getRow(int row) {
        Preconditions.checkArgument(row >= 0 && row < this.rows.size(), "row index '%s' is out of bounds; there are %s row(s)", row, this.rows.size());
        return this.values.get(row);
    }

    public Object[] getRowAsArray(int row) {
        Preconditions.checkArgument(row >= 0 && row < this.rows.size(), "row index '%s' is out of bounds; there are %s row(s)", row, this.rows.size());
        return this.rows != null ? this.rows.get(row) : null;
    }

    public Map<String, Object> getRowAsMap(int index) {
        Object[] data = this.getRowAsArray(index);
        return this.toMap(data);
    }

    public int getRowCount() {
        return this.rows != null ? this.rows.size() : 0;
    }

    public String getString(int row, int column) {
        return this.getValue(row, column, String.class);
    }

    public <V> V getValue(int row, int column, Class<V> clazz) {
        Preconditions.checkArgument(column >= 0 && column < this.getColumnCount(), "column index '%s' is out of bounds; there are %s column(s)", column, this.getColumnCount());
        Object[] data = this.getRowAsArray(row);
        Object value = data[column];
        Preconditions.checkState(value == null || clazz.isInstance(value), "Column '%s' is not %s (row index: %s)", this.columnNames[column], clazz.getName(), row);
        return clazz.cast(value);
    }

    public void read() throws IOException {
        LOGGER.debug("Reading {}", (Object)this.resource);
        this.reset();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.resource.openConnection().getInputStream(), Charsets.UTF_8));){
            this.lineCount = 0;
            String line = reader.readLine();
            while (line != null) {
                ++this.lineCount;
                this.parseLine(line);
                line = reader.readLine();
            }
        }
        catch (IOException | IllegalArgumentException | IllegalStateException e) {
            throw new IOException("Unable to load resource: " + this.resource, e);
        }
        finally {
            LOGGER.debug("Loaded {} rows from {}", (Object)this.getRowCount(), (Object)this.resource);
        }
    }

    private void parseColumns(String value) throws IOException {
        Preconditions.checkState(this.columns == null, "columns can only be specified once");
        Preconditions.checkState(this.rows == null, "columns cannot be specified after rows have been ingested");
        this.columns = Maps.newLinkedHashMap();
        Matcher matcher = COLUMN.matcher(value);
        while (matcher.find()) {
            String type = StringUtils.defaultIfEmpty(matcher.group(2), Type.STRING.name());
            String length = StringUtils.defaultIfEmpty(matcher.group(3), "0");
            try {
                ImmutableColumn column = ImmutableColumn.builder().name(StringUtils.defaultString(matcher.group(1))).type(Type.valueOf(type.toUpperCase())).length(length != null ? Integer.parseInt(length) : 0).build();
                if (column.getLength() != 0) {
                    this.haveColumnWidths = true;
                }
                this.columns.put(column.getName(), column);
            }
            catch (Exception e) {
                throw new IOException("Unable to parse column specification: " + matcher.group(), e);
            }
        }
        this.columnNames = this.columns.keySet().toArray(new String[this.columns.size()]);
    }

    private void parseComment(String line) throws IOException {
        int colon = line.indexOf(58);
        if (colon == -1) {
            return;
        }
        String name = StringUtils.trimToEmpty(line.substring(1, colon).toLowerCase());
        String value = StringUtils.trimToEmpty(line.substring(colon + 1));
        if ("columns".equals(name)) {
            this.parseColumns(value);
        } else if ("format".equals(name)) {
            this.format = Format.valueOf(value.toUpperCase());
        } else if ("delimiter".equals(name)) {
            this.delimiter = value;
        } else if (IDENTIFIER.matcher(name).matches()) {
            this.properties.put(name, StringUtils.trimToEmpty(value));
        }
    }

    private Object[] parseFixedWidth(String line) {
        int numColumns = this.getColumnCount();
        Object[] data = new Object[numColumns];
        int offset = 0;
        for (int i = 0; i < numColumns; ++i) {
            Column column = this.getColumn(i);
            int length = column.getLength();
            String value = length != 0 ? StringUtils.substring(line, offset, offset + length) : StringUtils.substring(line, offset);
            String trimmed = StringUtils.trimToEmpty(value);
            data[i] = column.getType().parse(trimmed);
            offset += length;
        }
        return data;
    }

    private void parseLine(String line) throws IOException {
        Object[] data;
        if (StringUtils.isEmpty(line)) {
            return;
        }
        if (StringUtils.startsWith(line, "#")) {
            this.parseComment(line);
            return;
        }
        if (this.rows == null) {
            this.preflightChecks();
            this.rows = Lists.newArrayList();
            this.values = Lists.newArrayList();
        }
        switch (this.format) {
            case DELIMITED: {
                data = new Object[]{line};
                break;
            }
            case FIXED_WIDTH: {
                data = this.parseFixedWidth(line);
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported format: " + (Object)((Object)this.format));
            }
        }
        this.rows.add(data);
        T value = this.convert(data);
        this.values.add(value);
    }

    private void preflightChecks() throws IOException {
        block10: {
            block9: {
                if (this.format == null) {
                    this.format = this.haveColumnWidths ? Format.FIXED_WIDTH : Format.DELIMITED;
                }
                if (this.columns == null) {
                    this.parseColumns("value(string)");
                }
                if (this.format != Format.DELIMITED) break block9;
                Preconditions.checkState(!this.haveColumnWidths, "Cannot specific column widths for delimited input files");
                if (StringUtils.isEmpty(this.delimiter)) {
                    this.delimiter = "\t";
                }
                Preconditions.checkArgument(this.delimiter.length() == 1 || this.delimiter.length() == 2 && this.delimiter.charAt(0) == '/', "delimiter must be a single character or escape sequence (\\n, \\t, etc)");
                if (this.delimiter.charAt(0) != '\\') break block10;
                switch (this.delimiter.charAt(1)) {
                    case 't': {
                        this.delimiter = "\\t";
                        break block10;
                    }
                    default: {
                        throw new IllegalStateException("Invalid delimiter escape sequence: " + this.delimiter);
                    }
                }
            }
            if (this.format == Format.FIXED_WIDTH) {
                int size = this.columnNames.length - 1;
                for (int i = 0; i < size; ++i) {
                    Column column = this.getColumn(i);
                    Preconditions.checkState(column.getLength() > 0, "Column width must be specified for \"%s\"", column.getName());
                }
            }
        }
        LOGGER.debug("Format: {}", (Object)this.format);
        for (String name : this.getColumnNames()) {
            Column column = this.getColumn(name);
            LOGGER.debug("Column: {}", (Object)column);
        }
    }

    private void reset() {
        this.properties.clear();
        this.lineCount = 0;
        this.rows = null;
        this.values = null;
        this.columns = null;
        this.columnNames = null;
        this.haveColumnWidths = false;
        this.format = null;
        this.delimiter = null;
    }

    protected T convert(Object[] data) {
        if (this.dataClass.isAssignableFrom(Object[].class)) {
            return this.dataClass.cast(data);
        }
        Map<String, Object> map = this.toMap(data);
        return (T)JacksonUtils.convertValue(map, this.dataClass);
    }

    protected Map<String, Object> toMap(Object[] data) {
        LinkedHashMap<String, Object> map = Maps.newLinkedHashMap();
        int size = this.getColumnCount();
        for (int i = 0; i < size; ++i) {
            Column column = this.getColumn(i);
            map.put(column.getName(), data[i]);
        }
        return map;
    }

    @Value.Immutable
    public static interface Column {
        @Value.Default
        default public int getLength() {
            return 0;
        }

        public String getName();

        @Value.Default
        default public Type getType() {
            return Type.STRING;
        }

        @Value.Check
        default public void validate() {
            Preconditions.checkState(!StringUtils.isEmpty(this.getName()), "name is required");
            Preconditions.checkState(this.getLength() >= 0, "length must be >= 0");
        }
    }

    public static enum Type {
        STRING{

            @Override
            public Object parse(String value) {
                return value;
            }
        }
        ,
        INT{

            @Override
            public Object parse(String value) {
                return value.length() != 0 ? Integer.valueOf(Integer.parseInt(value)) : null;
            }
        }
        ,
        LONG{

            @Override
            public Object parse(String value) {
                return value.length() != 0 ? Long.valueOf(Long.parseLong(value)) : null;
            }
        }
        ,
        DOUBLE{

            @Override
            public Object parse(String value) {
                return value.length() != 0 ? Double.valueOf(Double.parseDouble(value)) : null;
            }
        };


        public abstract Object parse(String var1);
    }

    public static enum Format {
        DELIMITED,
        FIXED_WIDTH;

    }
}

