/*
 * Decompiled with CFR 0.152.
 */
package com.arakelian.faker.service;

import com.arakelian.core.utils.DateUtils;
import com.arakelian.faker.model.ImmutableRandomDataConfig;
import com.arakelian.faker.model.RandomDataConfig;
import com.arakelian.faker.reader.TextReader;
import java.io.IOException;
import java.time.ZonedDateTime;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import repackaged.com.arakelian.faker.com.google.common.base.Preconditions;
import repackaged.com.arakelian.faker.com.google.common.cache.CacheBuilder;
import repackaged.com.arakelian.faker.com.google.common.cache.CacheLoader;
import repackaged.com.arakelian.faker.com.google.common.cache.LoadingCache;
import repackaged.com.arakelian.faker.org.apache.commons.lang3.StringUtils;

public class RandomData {
    private static RandomData INSTANCE = new RandomData(ImmutableRandomDataConfig.builder().build());
    private LoadingCache<String, TextReader<?>> cache;
    private final RandomDataConfig config;

    public static RandomData get() {
        return INSTANCE;
    }

    public RandomData(RandomDataConfig config) {
        this.config = Preconditions.checkNotNull(config);
        CacheLoader loader = new CacheLoader<String, TextReader<?>>(){

            @Override
            public TextReader<?> load(String key) throws IOException {
                TextReader<Object[]> reader = new TextReader<Object[]>(key, Object[].class);
                reader.read();
                return reader;
            }
        };
        this.cache = CacheBuilder.newBuilder().build(loader);
    }

    public TextReader<Object[]> get(String name) {
        return this.get(name, Object[].class);
    }

    public <T extends Enum> T next(Class<T> enumClass) {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        return this.next(enumClass, (Random)random);
    }

    public <T extends Enum> T next(Class<T> enumClass, Random random) {
        Enum[] values = (Enum[])enumClass.getEnumConstants();
        int size = values.length;
        int index = random.nextInt(size);
        return (T)values[index];
    }

    public Object[] next(String name) {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        return this.next(name, (Random)random);
    }

    public <T> T next(String name, Class<T> clazz) {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        return this.next(name, random, clazz);
    }

    public Object[] next(String name, Random random) {
        TextReader<Object[]> reader = this.get(name);
        int size = reader.getRowCount();
        int index = random.nextInt(size);
        return reader.getRowAsArray(index);
    }

    public <T> T next(String name, Random random, Class<T> clazz) {
        TextReader<T> reader = this.get(name, clazz);
        int size = reader.getRowCount();
        int index = random.nextInt(size);
        return reader.getRow(index);
    }

    public ZonedDateTime nextDate(String name) {
        ZonedDateTime from = this.config.getFromBirthday();
        ZonedDateTime to = this.config.getToBirthday();
        ZonedDateTime data = DateUtils.randomZonedDateTimeUtc((ZonedDateTime)from, (ZonedDateTime)to);
        return data;
    }

    public int nextInt(int min, int maxInclusive) {
        return min + this.random().nextInt(maxInclusive - min + 1);
    }

    public String nextParagraphs(String name, int min, int max) {
        StringBuilder buf = new StringBuilder();
        int paragraphs = this.nextInt(min, max);
        for (int p = 0; p < paragraphs; ++p) {
            if (p != 0) {
                buf.append('\n');
            }
            int sentences = this.nextInt(2, 6);
            for (int s = 0; s < sentences; ++s) {
                if (s != 0) {
                    buf.append("  ");
                }
                buf.append(this.nextWord(name, Capitalization.TITLE));
                int words = this.nextInt(2, 20);
                for (int w = 0; w < words; ++w) {
                    buf.append(' ').append(this.nextWord(name, Capitalization.LOWER));
                }
                buf.append(".");
            }
        }
        return buf.toString();
    }

    public String nextString(String name) {
        Object[] data = this.next(name);
        return Objects.toString(data[0], null);
    }

    public String nextWord(String name, Capitalization capitalization) {
        String word = this.nextString(name);
        switch (Preconditions.checkNotNull(capitalization, "capitalization must be non-null")) {
            case TITLE: {
                return word.substring(0, 1).toUpperCase() + word.substring(1).toLowerCase();
            }
            case UPPER: {
                return word.toUpperCase();
            }
        }
        return word.toLowerCase();
    }

    public Random random() {
        return ThreadLocalRandom.current();
    }

    private <T> TextReader<T> get(String name, Class<T> clazz) {
        String resourceName = StringUtils.replace(name, ".", "/");
        if (!StringUtils.startsWith(resourceName, "/")) {
            resourceName = "/com/arakelian/faker/" + resourceName;
        }
        TextReader<?> reader = this.cache.getUnchecked(resourceName);
        Class<?> dataClass = reader.getDataClass();
        Preconditions.checkState(clazz.isAssignableFrom(dataClass));
        return reader;
    }

    public static enum Capitalization {
        LOWER,
        UPPER,
        TITLE;

    }
}

