/*
 * Decompiled with CFR 0.152.
 */
package com.arakelian.faker.service;

import com.arakelian.faker.model.Gender;
import com.arakelian.faker.model.ImmutablePerson;
import com.arakelian.faker.model.Person;
import com.arakelian.faker.service.AbstractRandomService;
import com.arakelian.faker.service.RandomData;
import repackaged.com.arakelian.faker.com.google.common.base.Preconditions;

public class RandomPerson
extends AbstractRandomService<Person> {
    private static RandomPerson INSTANCE = new RandomPerson();
    private final RandomData randomData;

    public static RandomPerson get() {
        return INSTANCE;
    }

    public RandomPerson() {
        this(RandomData.get());
    }

    public RandomPerson(RandomData randomData) {
        this.randomData = Preconditions.checkNotNull(randomData);
    }

    @Override
    public Person next() {
        String firstName;
        Gender gender = this.randomData.next(Gender.class);
        switch (gender) {
            case FEMALE: {
                firstName = this.randomData.nextString("name.female");
                break;
            }
            case MALE: {
                firstName = this.randomData.nextString("name.male");
                break;
            }
            default: {
                throw new IllegalStateException("Unknown gender: " + (Object)((Object)gender));
            }
        }
        ImmutablePerson person = ImmutablePerson.builder().firstName(firstName).lastName(this.randomData.nextString("name.surname")).gender(gender).title(this.randomData.nextString("job.title")).birthdate(this.randomData.nextDate("birthday")).comments(this.randomData.nextParagraphs("words.lorem", 1, 1)).build();
        return person;
    }
}

