/*
 * Decompiled with CFR 0.152.
 */
package repackaged.com.arakelian.faker.com.google.common.collect;

import java.io.Serializable;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Set;
import repackaged.com.arakelian.faker.com.google.common.base.Preconditions;
import repackaged.com.arakelian.faker.com.google.common.collect.Hashing;
import repackaged.com.arakelian.faker.com.google.common.collect.ImmutableCollection;
import repackaged.com.arakelian.faker.com.google.common.collect.ImmutableList;
import repackaged.com.arakelian.faker.com.google.common.collect.JdkBackedImmutableSet;
import repackaged.com.arakelian.faker.com.google.common.collect.RegularImmutableAsList;
import repackaged.com.arakelian.faker.com.google.common.collect.RegularImmutableSet;
import repackaged.com.arakelian.faker.com.google.common.collect.Sets;
import repackaged.com.arakelian.faker.com.google.common.collect.SingletonImmutableSet;
import repackaged.com.arakelian.faker.com.google.common.collect.UnmodifiableIterator;
import repackaged.com.arakelian.faker.com.google.common.math.IntMath;

public abstract class ImmutableSet<E>
extends ImmutableCollection<E>
implements Set<E> {
    private transient ImmutableList<E> asList;

    public static <E> ImmutableSet<E> of() {
        return RegularImmutableSet.EMPTY;
    }

    public static <E> ImmutableSet<E> of(E element) {
        return new SingletonImmutableSet<E>(element);
    }

    private static <E> ImmutableSet<E> constructUnknownDuplication(int n, Object ... elements) {
        return ImmutableSet.construct(n, Math.max(4, IntMath.sqrt(n, RoundingMode.CEILING)), elements);
    }

    private static <E> ImmutableSet<E> construct(int n, int expectedSize, Object ... elements) {
        switch (n) {
            case 0: {
                return ImmutableSet.of();
            }
            case 1: {
                Object elem = elements[0];
                return ImmutableSet.of(elem);
            }
        }
        SetBuilderImpl builder = new RegularSetBuilderImpl<Object>(expectedSize);
        for (int i = 0; i < n; ++i) {
            Object e = Preconditions.checkNotNull(elements[i]);
            builder = ((SetBuilderImpl)builder).add(e);
        }
        return ((SetBuilderImpl)builder).review().build();
    }

    public static <E> ImmutableSet<E> copyOf(E[] elements) {
        switch (elements.length) {
            case 0: {
                return ImmutableSet.of();
            }
            case 1: {
                return ImmutableSet.of(elements[0]);
            }
        }
        return ImmutableSet.constructUnknownDuplication(elements.length, (Object[])elements.clone());
    }

    ImmutableSet() {
    }

    boolean isHashCodeFast() {
        return false;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ImmutableSet && this.isHashCodeFast() && ((ImmutableSet)object).isHashCodeFast() && this.hashCode() != object.hashCode()) {
            return false;
        }
        return Sets.equalsImpl(this, object);
    }

    @Override
    public int hashCode() {
        return Sets.hashCodeImpl(this);
    }

    @Override
    public abstract UnmodifiableIterator<E> iterator();

    @Override
    public ImmutableList<E> asList() {
        ImmutableList<E> result = this.asList;
        return result == null ? (this.asList = this.createAsList()) : result;
    }

    ImmutableList<E> createAsList() {
        return new RegularImmutableAsList(this, this.toArray());
    }

    @Override
    Object writeReplace() {
        return new SerializedForm(this.toArray());
    }

    static Object[] rebuildHashTable(int newTableSize, Object[] elements, int n) {
        Object[] hashTable = new Object[newTableSize];
        int mask = hashTable.length - 1;
        for (int i = 0; i < n; ++i) {
            int j0;
            Object e = elements[i];
            int j = j0 = Hashing.smear(e.hashCode());
            while (true) {
                int index;
                if (hashTable[index = j & mask] == null) break;
                ++j;
            }
            hashTable[index] = e;
        }
        return hashTable;
    }

    static int chooseTableSize(int setSize) {
        if ((setSize = Math.max(setSize, 2)) < 0x2CCCCCCC) {
            int tableSize = Integer.highestOneBit(setSize - 1) << 1;
            while ((double)tableSize * 0.7 < (double)setSize) {
                tableSize <<= 1;
            }
            return tableSize;
        }
        Preconditions.checkArgument(setSize < 0x40000000, "collection too large");
        return 0x40000000;
    }

    static boolean hashFloodingDetected(Object[] hashTable) {
        int startOfEndRun;
        int maxRunBeforeFallback = ImmutableSet.maxRunBeforeFallback(hashTable.length);
        int endOfStartRun = 0;
        while (endOfStartRun < hashTable.length && hashTable[endOfStartRun] != null) {
            if (++endOfStartRun <= maxRunBeforeFallback) continue;
            return true;
        }
        for (startOfEndRun = hashTable.length - 1; startOfEndRun > endOfStartRun && hashTable[startOfEndRun] != null; --startOfEndRun) {
            if (endOfStartRun + (hashTable.length - 1 - startOfEndRun) <= maxRunBeforeFallback) continue;
            return true;
        }
        int testBlockSize = maxRunBeforeFallback / 2;
        int i = endOfStartRun + 1;
        while (i + testBlockSize <= startOfEndRun) {
            block5: {
                for (int j = 0; j < testBlockSize; ++j) {
                    if (hashTable[i + j] != null) {
                        continue;
                    }
                    break block5;
                }
                return true;
            }
            i += testBlockSize;
        }
        return false;
    }

    private static int maxRunBeforeFallback(int tableSize) {
        return 13 * IntMath.log2(tableSize, RoundingMode.UNNECESSARY);
    }

    private static final class JdkBackedSetBuilderImpl<E>
    extends SetBuilderImpl<E> {
        private final Set<Object> delegate;

        JdkBackedSetBuilderImpl(SetBuilderImpl<E> toCopy) {
            super(toCopy);
            this.delegate = Sets.newHashSetWithExpectedSize(this.distinct);
            for (int i = 0; i < this.distinct; ++i) {
                this.delegate.add(this.dedupedElements[i]);
            }
        }

        @Override
        SetBuilderImpl<E> add(E e) {
            Preconditions.checkNotNull(e);
            if (this.delegate.add(e)) {
                this.addDedupedElement(e);
            }
            return this;
        }

        @Override
        ImmutableSet<E> build() {
            switch (this.distinct) {
                case 0: {
                    return ImmutableSet.of();
                }
                case 1: {
                    return ImmutableSet.of(this.dedupedElements[0]);
                }
            }
            return new JdkBackedImmutableSet(this.delegate, ImmutableList.asImmutableList(this.dedupedElements, this.distinct));
        }
    }

    private static final class RegularSetBuilderImpl<E>
    extends SetBuilderImpl<E> {
        private Object[] hashTable;
        private int maxRunBeforeFallback;
        private int expandTableThreshold;
        private int hashCode;

        RegularSetBuilderImpl(int expectedCapacity) {
            super(expectedCapacity);
            int tableSize = ImmutableSet.chooseTableSize(expectedCapacity);
            this.hashTable = new Object[tableSize];
            this.maxRunBeforeFallback = ImmutableSet.maxRunBeforeFallback(tableSize);
            this.expandTableThreshold = (int)(0.7 * (double)tableSize);
        }

        void ensureTableCapacity(int minCapacity) {
            if (minCapacity > this.expandTableThreshold && this.hashTable.length < 0x40000000) {
                int newTableSize = this.hashTable.length * 2;
                this.hashTable = ImmutableSet.rebuildHashTable(newTableSize, this.dedupedElements, this.distinct);
                this.maxRunBeforeFallback = ImmutableSet.maxRunBeforeFallback(newTableSize);
                this.expandTableThreshold = (int)(0.7 * (double)newTableSize);
            }
        }

        @Override
        SetBuilderImpl<E> add(E e) {
            Preconditions.checkNotNull(e);
            int eHash = e.hashCode();
            int i0 = Hashing.smear(eHash);
            int mask = this.hashTable.length - 1;
            int i = i0;
            while (i - i0 < this.maxRunBeforeFallback) {
                int index = i & mask;
                Object tableEntry = this.hashTable[index];
                if (tableEntry == null) {
                    this.addDedupedElement(e);
                    this.hashTable[index] = e;
                    this.hashCode += eHash;
                    this.ensureTableCapacity(this.distinct);
                    return this;
                }
                if (tableEntry.equals(e)) {
                    return this;
                }
                ++i;
            }
            return new JdkBackedSetBuilderImpl<E>(this).add(e);
        }

        @Override
        SetBuilderImpl<E> review() {
            int targetTableSize = ImmutableSet.chooseTableSize(this.distinct);
            if (targetTableSize * 2 < this.hashTable.length) {
                this.hashTable = ImmutableSet.rebuildHashTable(targetTableSize, this.dedupedElements, this.distinct);
                this.maxRunBeforeFallback = ImmutableSet.maxRunBeforeFallback(targetTableSize);
                this.expandTableThreshold = (int)(0.7 * (double)targetTableSize);
            }
            return ImmutableSet.hashFloodingDetected(this.hashTable) ? new JdkBackedSetBuilderImpl(this) : this;
        }

        @Override
        ImmutableSet<E> build() {
            switch (this.distinct) {
                case 0: {
                    return ImmutableSet.of();
                }
                case 1: {
                    return ImmutableSet.of(this.dedupedElements[0]);
                }
            }
            Object[] elements = this.distinct == this.dedupedElements.length ? this.dedupedElements : Arrays.copyOf(this.dedupedElements, this.distinct);
            return new RegularImmutableSet(elements, this.hashCode, this.hashTable, this.hashTable.length - 1);
        }
    }

    private static abstract class SetBuilderImpl<E> {
        E[] dedupedElements;
        int distinct;

        SetBuilderImpl(int expectedCapacity) {
            this.dedupedElements = new Object[expectedCapacity];
            this.distinct = 0;
        }

        SetBuilderImpl(SetBuilderImpl<E> toCopy) {
            this.dedupedElements = Arrays.copyOf(toCopy.dedupedElements, toCopy.dedupedElements.length);
            this.distinct = toCopy.distinct;
        }

        private void ensureCapacity(int minCapacity) {
            if (minCapacity > this.dedupedElements.length) {
                int newCapacity = ImmutableCollection.Builder.expandedCapacity(this.dedupedElements.length, minCapacity);
                this.dedupedElements = Arrays.copyOf(this.dedupedElements, newCapacity);
            }
        }

        final void addDedupedElement(E e) {
            this.ensureCapacity(this.distinct + 1);
            this.dedupedElements[this.distinct++] = e;
        }

        abstract SetBuilderImpl<E> add(E var1);

        SetBuilderImpl<E> review() {
            return this;
        }

        abstract ImmutableSet<E> build();
    }

    private static class SerializedForm
    implements Serializable {
        final Object[] elements;
        private static final long serialVersionUID = 0L;

        SerializedForm(Object[] elements) {
            this.elements = elements;
        }

        Object readResolve() {
            return ImmutableSet.copyOf(this.elements);
        }
    }
}

