/*
 * Decompiled with CFR 0.152.
 */
package repackaged.com.arakelian.faker.com.google.common.util.concurrent;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import repackaged.com.arakelian.faker.com.google.common.base.Function;
import repackaged.com.arakelian.faker.com.google.common.base.Preconditions;
import repackaged.com.arakelian.faker.com.google.common.util.concurrent.AbstractTransformFuture;
import repackaged.com.arakelian.faker.com.google.common.util.concurrent.GwtFuturesCatchingSpecialization;
import repackaged.com.arakelian.faker.com.google.common.util.concurrent.ImmediateFuture;
import repackaged.com.arakelian.faker.com.google.common.util.concurrent.ListenableFuture;
import repackaged.com.arakelian.faker.com.google.common.util.concurrent.Uninterruptibles;

public final class Futures
extends GwtFuturesCatchingSpecialization {
    public static <V> ListenableFuture<V> immediateFuture(V value) {
        if (value == null) {
            ListenableFuture<?> typedNull = ImmediateFuture.NULL;
            return typedNull;
        }
        return new ImmediateFuture<V>(value);
    }

    public static <V> ListenableFuture<V> immediateFailedFuture(Throwable throwable) {
        Preconditions.checkNotNull(throwable);
        return new ImmediateFuture.ImmediateFailedFuture(throwable);
    }

    public static <I, O> ListenableFuture<O> transform(ListenableFuture<I> input, Function<? super I, ? extends O> function, Executor executor) {
        return AbstractTransformFuture.create(input, function, executor);
    }

    public static <V> V getDone(Future<V> future) throws ExecutionException {
        Preconditions.checkState(future.isDone(), "Future was expected to be done: %s", future);
        return Uninterruptibles.getUninterruptibly(future);
    }
}

