/*
 * Decompiled with CFR 0.152.
 */
package com.arakelian.jackson.model;

import com.arakelian.jackson.model.ImmutableGeoPoint;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import org.immutables.value.Value;
import repackaged.com.arakelian.jackson.com.google.common.base.Preconditions;

@JsonSerialize(as=ImmutableGeoPoint.class)
@JsonDeserialize(using=GeoPointDeserializer.class)
@JsonPropertyOrder(value={"lat", "lon"})
@Value.Immutable(copy=false)
public abstract class GeoPoint
implements Serializable {
    private static final long[] MAGIC = new long[]{0x5555555555555555L, 0x3333333333333333L, 0xF0F0F0F0F0F0F0FL, 0xFF00FF00FF00FFL, 0xFFFF0000FFFFL, 0xFFFFFFFFL, -6148914691236517206L};
    private static final short[] SHIFT = new short[]{1, 2, 4, 8, 16};
    private static final char[] BASE_32 = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'j', 'k', 'm', 'n', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    private static final String BASE_32_STRING = new String(BASE_32);
    public static final int PRECISION = 12;
    public static final short BITS = 31;
    private static final double LAT_SCALE = 1.1930464711111112E7;
    private static final double LON_SCALE = 5965232.355555556;
    private static final short MORTON_OFFSET = 2;
    public static final double MIN_LON_INCL = -180.0;
    public static final double MAX_LON_INCL = 180.0;
    public static final double MIN_LAT_INCL = -90.0;
    public static final double MAX_LAT_INCL = 90.0;
    private static final double LAT_DECODE = 4.190951585769653E-8;
    private static final double LON_DECODE = 8.381903171539307E-8;
    public static final int DEFAULT_PLACES = 6;
    public static final double DEFAULT_ERROR = 1.0E-6;

    public static final long flipFlop(long val) {
        return (val & MAGIC[6]) >>> 1 | (val & MAGIC[0]) << 1;
    }

    public static GeoPoint of(double lat, double lon) {
        return ImmutableGeoPoint.builder().lat(lat).lon(lon).build();
    }

    public static GeoPoint of(String value) {
        double lon;
        double lat;
        int comma = value.indexOf(44);
        if (comma != -1) {
            lat = Double.parseDouble(value.substring(0, comma).trim());
            lon = Double.parseDouble(value.substring(comma + 1).trim());
        } else {
            int level = 11;
            long l = 0L;
            for (char c : value.toCharArray()) {
                long b = BASE_32_STRING.indexOf(c);
                l |= b << level-- * 5 + 2;
            }
            long mortonHash = GeoPoint.flipFlop(l);
            lat = (double)GeoPoint.deinterleave(mortonHash >>> 1) / 1.1930464711111112E7 - 90.0;
            lon = (double)GeoPoint.deinterleave(mortonHash) / 5965232.355555556 - 180.0;
        }
        return GeoPoint.of(lat, lon);
    }

    public static double round(double value) {
        return GeoPoint.round(value, 6);
    }

    public static double round(double value, int places) {
        Preconditions.checkArgument(places >= 0, "places must be >= 0");
        return new BigDecimal(Double.toString(value)).setScale(places, RoundingMode.HALF_UP).doubleValue();
    }

    protected static long deinterleave(long value) {
        value &= MAGIC[0];
        value = (value ^ value >>> SHIFT[0]) & MAGIC[1];
        value = (value ^ value >>> SHIFT[1]) & MAGIC[2];
        value = (value ^ value >>> SHIFT[2]) & MAGIC[3];
        value = (value ^ value >>> SHIFT[3]) & MAGIC[4];
        value = (value ^ value >>> SHIFT[4]) & MAGIC[5];
        return value;
    }

    @JsonIgnore
    @Value.Lazy
    @Value.Auxiliary
    public String getGeohash() {
        double longitude;
        double latitude = this.getLat();
        if (latitude == 90.0) {
            latitude = Math.nextDown(latitude);
        }
        if ((longitude = this.getLon()) == 180.0) {
            longitude = Math.nextDown(longitude);
        }
        long even = (long)((int)Math.floor(longitude / 8.381903171539307E-8) ^ Integer.MIN_VALUE) & 0xFFFFFFFFL;
        even = (even | even << SHIFT[4]) & MAGIC[4];
        even = (even | even << SHIFT[3]) & MAGIC[3];
        even = (even | even << SHIFT[2]) & MAGIC[2];
        even = (even | even << SHIFT[1]) & MAGIC[1];
        even = (even | even << SHIFT[0]) & MAGIC[0];
        long odd = (long)((int)Math.floor(latitude / 4.190951585769653E-8) ^ Integer.MIN_VALUE) & 0xFFFFFFFFL;
        odd = (odd | odd << SHIFT[4]) & MAGIC[4];
        odd = (odd | odd << SHIFT[3]) & MAGIC[3];
        odd = (odd | odd << SHIFT[2]) & MAGIC[2];
        odd = (odd | odd << SHIFT[1]) & MAGIC[1];
        long result = (odd = (odd | odd << SHIFT[0]) & MAGIC[0]) << 1 | even;
        long morton = result == -1L ? GeoPoint.flipFlop(result & 0xC000000000000000L) : GeoPoint.flipFlop(result >>> 2);
        long geohash = (morton >>>= 2) << 4 | 0xCL;
        int level = (int)geohash & 0xF;
        geohash >>>= 4;
        char[] chars = new char[level];
        do {
            chars[--level] = BASE_32[(int)(geohash & 0x1FL)];
            geohash >>>= 5;
        } while (level > 0);
        return new String(chars);
    }

    public abstract double getLat();

    public abstract double getLon();

    public GeoPoint round(int places) {
        double lat = this.getLat();
        double newLat = GeoPoint.round(lat, places);
        double lon = this.getLon();
        double newLon = GeoPoint.round(lon, places);
        if (Double.doubleToLongBits(lat) == Double.doubleToLongBits(newLat) && Double.doubleToLongBits(lon) == Double.doubleToLongBits(newLon)) {
            return this;
        }
        return GeoPoint.of(newLat, newLon);
    }

    @Value.Check
    protected GeoPoint normalize() {
        double lat = this.getLat();
        if (Double.isNaN(lat) || lat < -90.0 || lat > 90.0) {
            throw new IllegalArgumentException("invalid latitude " + lat + "; must be between " + -90.0 + " and " + 90.0);
        }
        double lon = this.getLon();
        if (Double.isNaN(lon) || lon < -180.0 || lon > 180.0) {
            throw new IllegalArgumentException("invalid longitude " + lon + "; must be between " + -180.0 + " and " + 180.0);
        }
        return this.round(6);
    }

    public static class GeoPointDeserializer
    extends JsonDeserializer<GeoPoint> {
        public GeoPoint deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JsonNode node = (JsonNode)ctxt.readValue(p, JsonNode.class);
            if (node instanceof ObjectNode) {
                ObjectNode obj = (ObjectNode)node;
                JsonNode lat = obj.get("lat");
                JsonNode lon = obj.get("lon");
                if (lat == null || lon == null) {
                    ctxt.reportInputMismatch((JsonDeserializer)this, "Expecting object with 'lat' and 'lon' fields", new Object[0]);
                    return null;
                }
                return ImmutableGeoPoint.builder().lat(lat.asDouble()).lon(lon.asDouble()).build();
            }
            if (node instanceof ArrayNode) {
                ArrayNode arr = (ArrayNode)node;
                if (arr.size() != 2) {
                    ctxt.reportInputMismatch((JsonDeserializer)this, "Expecting array with 2 elements but found %s elements", new Object[]{arr.size()});
                    return null;
                }
                return ImmutableGeoPoint.builder().lon(arr.get(0).asDouble()).lat(arr.get(1).asDouble()).build();
            }
            if (node instanceof TextNode) {
                TextNode text = (TextNode)node;
                String v = text.asText("");
                return GeoPoint.of(v);
            }
            ctxt.reportInputMismatch((JsonDeserializer)this, "Expecting array, object or text node", new Object[0]);
            return null;
        }
    }
}

