/*
 * Decompiled with CFR 0.152.
 */
package com.arakelian.jackson.model;

import com.arakelian.jackson.model.GeoPoint;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.Objects;
import org.immutables.value.Generated;
import repackaged.com.arakelian.jackson.com.google.common.base.MoreObjects;
import repackaged.com.arakelian.jackson.com.google.common.primitives.Doubles;

@Generated(from="GeoPoint", generator="Immutables")
public final class ImmutableGeoPoint
extends GeoPoint {
    private final double lat;
    private final double lon;
    private volatile transient long lazyInitBitmap;
    private static final long GEOHASH_LAZY_INIT_BIT = 1L;
    private transient String geohash;

    private ImmutableGeoPoint(Builder builder) {
        this.lat = builder.lat;
        this.lon = builder.lon;
    }

    @Override
    @JsonProperty(value="lat")
    public double getLat() {
        return this.lat;
    }

    @Override
    @JsonProperty(value="lon")
    public double getLon() {
        return this.lon;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGeoPoint && this.equalTo((ImmutableGeoPoint)another);
    }

    private boolean equalTo(ImmutableGeoPoint another) {
        return Double.doubleToLongBits(this.lat) == Double.doubleToLongBits(another.lat) && Double.doubleToLongBits(this.lon) == Double.doubleToLongBits(another.lon);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Doubles.hashCode(this.lat);
        h += (h << 5) + Doubles.hashCode(this.lon);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("GeoPoint").omitNullValues().add("lat", this.lat).add("lon", this.lon).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableGeoPoint fromJson(Json json) {
        Builder builder = ImmutableGeoPoint.builder();
        if (json.latIsSet) {
            builder.lat(json.lat);
        }
        if (json.lonIsSet) {
            builder.lon(json.lon);
        }
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getGeohash() {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            ImmutableGeoPoint immutableGeoPoint = this;
            synchronized (immutableGeoPoint) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.geohash = Objects.requireNonNull(super.getGeohash(), "geohash");
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.geohash;
    }

    private static ImmutableGeoPoint validate(ImmutableGeoPoint instance) {
        instance = (ImmutableGeoPoint)instance.normalize();
        return instance;
    }

    private Object readResolve() throws ObjectStreamException {
        return ImmutableGeoPoint.validate(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="GeoPoint", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_LAT = 1L;
        private static final long INIT_BIT_LON = 2L;
        private long initBits = 3L;
        private double lat;
        private double lon;

        private Builder() {
        }

        public final Builder from(GeoPoint instance) {
            Objects.requireNonNull(instance, "instance");
            this.lat(instance.getLat());
            this.lon(instance.getLon());
            return this;
        }

        @JsonProperty(value="lat")
        public final Builder lat(double lat) {
            this.lat = lat;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="lon")
        public final Builder lon(double lon) {
            this.lon = lon;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableGeoPoint build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutableGeoPoint.validate(new ImmutableGeoPoint(this));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("lat");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("lon");
            }
            return "Cannot build GeoPoint, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="GeoPoint", generator="Immutables")
    static final class Json
    extends GeoPoint {
        double lat;
        boolean latIsSet;
        double lon;
        boolean lonIsSet;

        Json() {
        }

        @JsonProperty(value="lat")
        public void setLat(double lat) {
            this.lat = lat;
            this.latIsSet = true;
        }

        @JsonProperty(value="lon")
        public void setLon(double lon) {
            this.lon = lon;
            this.lonIsSet = true;
        }

        @Override
        public double getLat() {
            throw new UnsupportedOperationException();
        }

        @Override
        public double getLon() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getGeohash() {
            throw new UnsupportedOperationException();
        }
    }
}

