/*
 * Decompiled with CFR 0.152.
 */
package com.arakelian.jackson.utils;

import com.arakelian.jackson.model.Jackson;
import com.arakelian.jackson.utils.JsonGeneratorCallback;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;

public class JacksonUtils {
    private static Jackson JACKSON = Jackson.of();

    public static CharSequence buildJson(Object ... keyValues) {
        return JACKSON.buildJson(keyValues);
    }

    public static JsonNode buildJsonNode(Object ... keyValues) {
        return JACKSON.buildJsonNode(keyValues);
    }

    public static <T> T convertValue(Object value, Class<T> type) {
        return JACKSON.convertValue(value, type);
    }

    public static Map<String, Object> convertValueToMap(Object value) {
        return JACKSON.convertValueToMap(value);
    }

    public static ObjectMapper getObjectMapper() {
        return JACKSON.getObjectMapper();
    }

    public static ObjectWriter getObjectWriter(boolean pretty) {
        return JACKSON.getObjectWriter(JACKSON.getView(), pretty);
    }

    public static ObjectWriter getObjectWriter(Class<?> view) {
        return JACKSON.getObjectWriter(view, false);
    }

    public static ObjectWriter getObjectWriter(Class<?> view, boolean pretty) {
        return JACKSON.getObjectWriter(view, pretty);
    }

    public static <T> T readValue(String json, Class<T> valueType) throws IOException {
        return JACKSON.readValue(json, valueType);
    }

    public static <T> T readValue(String json, JavaType valueType) throws IOException {
        return JACKSON.readValue(json, valueType);
    }

    public static <T> T readValue(String json, TypeReference<T> valueType) throws IOException {
        return JACKSON.readValue(json, valueType);
    }

    public static <K, V> Map<K, V> readValueAsMap(String json, Class<K> keyType, Class<V> valueType) throws IOException {
        return JACKSON.readValueAsMap(json, keyType, valueType);
    }

    public static CharSequence toCharSequence(boolean pretty, JsonGeneratorCallback callback) throws UncheckedIOException {
        return JACKSON.toCharSequence(pretty, callback);
    }

    public static String toString(boolean pretty, JsonGeneratorCallback callback) throws UncheckedIOException {
        return Objects.toString(JACKSON.toCharSequence(pretty, callback), null);
    }

    public static String toString(Object value, boolean pretty) throws UncheckedIOException {
        return JACKSON.toString(value, pretty);
    }

    public static String toStringSafe(Object value, boolean pretty) throws UncheckedIOException {
        return JACKSON.toString(value, pretty);
    }

    public static void traverse(JsonNode node, Predicate<String> fieldPredicate, Consumer<JsonNode> consumer) {
        if (node == null || node.isNull() || node.isMissingNode()) {
            return;
        }
        if (node.isArray()) {
            int size = node.size();
            for (int i = 0; i < size; ++i) {
                JsonNode item = node.get(i);
                JacksonUtils.traverse(item, null, consumer);
            }
            return;
        }
        if (node.isObject()) {
            ObjectNode obj = (ObjectNode)node;
            Iterator it = obj.fieldNames();
            while (it.hasNext()) {
                String name = (String)it.next();
                if (fieldPredicate != null && !fieldPredicate.test(name)) continue;
                JsonNode child = obj.get(name);
                JacksonUtils.traverse(child, null, consumer);
            }
            return;
        }
        if (!node.isPojo()) {
            consumer.accept(node);
        }
    }

    public static ObjectMapper withView(ObjectMapper mapper, Class<?> view) {
        return Jackson.from(mapper).view(view).build().getObjectMapper();
    }

    private JacksonUtils() {
    }
}

