/*
 * Decompiled with CFR 0.152.
 */
package com.arakelian.jackson;

import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.util.JsonGeneratorDelegate;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import repackaged.com.arakelian.jackson.com.google.common.base.Preconditions;
import repackaged.com.arakelian.jackson.com.google.common.collect.ImmutableSet;
import repackaged.com.arakelian.jackson.org.apache.commons.lang3.StringUtils;

public class FilteringJsonGenerator
extends JsonGeneratorDelegate {
    private static final String ARRAY_BRACKETS = "[]";
    private static final char CONTEXT_SEPARATOR = '.';
    private static final Logger LOGGER = LoggerFactory.getLogger(FilteringJsonGenerator.class);
    protected final Set<String> includes;
    protected final Set<String> excludes;
    protected final List<Context> contexts = new ArrayList<Context>();
    protected String fieldName;

    public FilteringJsonGenerator(JsonGenerator delegate, Set<String> includes, Set<String> excludes) {
        super(delegate, false);
        this.includes = includes != null ? includes : ImmutableSet.of();
        this.excludes = excludes != null ? excludes : ImmutableSet.of();
    }

    protected void afterValue() {
        this.resetField();
    }

    protected String getCurrentPath() {
        StringBuilder path = new StringBuilder();
        for (Context context : this.contexts) {
            context.buildPath(path);
        }
        if (this.fieldName != null) {
            path.append('.');
            path.append(this.fieldName);
        }
        if (path.length() == 0) {
            path.append('.');
        }
        return path.toString();
    }

    private boolean hasArrayBrackets(CharSequence path, int index) {
        return index + 1 < path.length() && path.charAt(index) == ARRAY_BRACKETS.charAt(0) && path.charAt(index + 1) == ARRAY_BRACKETS.charAt(1);
    }

    private boolean isRoot(CharSequence path) {
        return StringUtils.equals(".", path);
    }

    private boolean pathStartsWith(CharSequence path, CharSequence prefix, boolean excluding) {
        boolean test;
        if (path == prefix) {
            return true;
        }
        if (path == null || prefix == null) {
            return false;
        }
        int pathLength = path.length();
        int prefixLength = prefix.length();
        int length = Math.min(pathLength, prefixLength);
        for (int i = 0; i < length; ++i) {
            if (path.charAt(i) == prefix.charAt(0 + i)) continue;
            return false;
        }
        if (pathLength == prefixLength) {
            return true;
        }
        if (pathLength > prefixLength) {
            test = path.charAt(prefixLength) == '.' || this.hasArrayBrackets(path, prefixLength);
            return test;
        }
        boolean bl = test = this.isRoot(path) || prefix.charAt(pathLength) == '.' || this.hasArrayBrackets(prefix, pathLength);
        return test ? !excluding : false;
    }

    protected void resetField() {
        this.fieldName = null;
    }

    protected boolean test() {
        boolean test = this.test_();
        if (LOGGER.isTraceEnabled()) {
            StackTraceElement[] trace;
            for (StackTraceElement e : trace = Thread.currentThread().getStackTrace()) {
                String m = e.getMethodName();
                if (!StringUtils.startsWith(m, "write")) continue;
                LOGGER.trace("{} {}: {}", new Object[]{this.getCurrentPath(), m, test});
                break;
            }
        }
        return test;
    }

    protected boolean test_() {
        int depth = this.contexts.size();
        if (depth != 0) {
            Context current = this.contexts.get(depth - 1);
            if (current.test != null) {
                return current.test;
            }
        }
        String path = this.getCurrentPath();
        if (this.excludes != null) {
            for (String exclude : this.excludes) {
                if (!this.pathStartsWith(path, exclude, true)) continue;
                return false;
            }
        }
        if (this.includes != null) {
            for (String include : this.includes) {
                if (!this.pathStartsWith(path, include, false)) continue;
                return true;
            }
        }
        return this.includes == null || this.includes.size() == 0;
    }

    protected boolean testEnd(Type type) {
        int depth = this.contexts.size();
        Preconditions.checkState(depth != 0, "extra call to writeEndArray or writeEndObject");
        Context current = this.contexts.remove(depth - 1);
        Preconditions.checkState(current.type.equals((Object)type), "mismatch start/end of %s", (Object)type);
        if (current.test != null) {
            return current.test;
        }
        return true;
    }

    protected boolean testStartArray() {
        boolean test = this.test();
        this.contexts.add(new Context(Type.ARRAY, this.fieldName, test ? null : Boolean.FALSE));
        this.resetField();
        return test;
    }

    protected boolean testStartObject() {
        boolean test = this.test();
        this.contexts.add(new Context(Type.OBJECT, this.fieldName, test ? null : Boolean.FALSE));
        this.resetField();
        return test;
    }

    public String toString() {
        return this.getCurrentPath();
    }

    public void writeBinary(Base64Variant b64variant, byte[] data, int offset, int len) throws IOException {
        if (this.test()) {
            this.delegate.writeBinary(b64variant, data, offset, len);
            this.afterValue();
        }
    }

    public int writeBinary(Base64Variant b64variant, InputStream data, int dataLength) throws IOException {
        if (this.test()) {
            int bytesRead = this.delegate.writeBinary(b64variant, data, dataLength);
            this.afterValue();
            return bytesRead;
        }
        return -1;
    }

    public void writeBoolean(boolean v) throws IOException {
        if (this.test()) {
            this.delegate.writeBoolean(v);
            this.afterValue();
        }
    }

    public void writeEndArray() throws IOException {
        if (this.testEnd(Type.ARRAY)) {
            this.delegate.writeEndArray();
            this.afterValue();
        }
    }

    public void writeEndObject() throws IOException {
        if (this.testEnd(Type.OBJECT)) {
            this.delegate.writeEndObject();
            this.afterValue();
        }
    }

    public void writeFieldName(SerializableString name) throws IOException {
        this.fieldName = name.getValue();
        if (this.test()) {
            this.delegate.writeFieldName(name);
        }
    }

    public void writeFieldName(String name) throws IOException {
        this.fieldName = name;
        if (this.test()) {
            this.delegate.writeFieldName(name);
        }
    }

    public void writeNull() throws IOException {
        if (this.test()) {
            this.delegate.writeNull();
            this.afterValue();
        }
    }

    public void writeNumber(BigDecimal v) throws IOException {
        if (this.test()) {
            this.delegate.writeNumber(v);
            this.afterValue();
        }
    }

    public void writeNumber(BigInteger v) throws IOException {
        if (this.test()) {
            this.delegate.writeNumber(v);
            this.afterValue();
        }
    }

    public void writeNumber(double v) throws IOException {
        if (this.test()) {
            this.delegate.writeNumber(v);
            this.afterValue();
        }
    }

    public void writeNumber(float v) throws IOException {
        if (this.test()) {
            this.delegate.writeNumber(v);
            this.afterValue();
        }
    }

    public void writeNumber(int v) throws IOException {
        if (this.test()) {
            this.delegate.writeNumber(v);
            this.afterValue();
        }
    }

    public void writeNumber(long v) throws IOException {
        if (this.test()) {
            this.delegate.writeNumber(v);
            this.afterValue();
        }
    }

    public void writeNumber(short v) throws IOException {
        if (this.test()) {
            this.delegate.writeNumber(v);
            this.afterValue();
        }
    }

    public void writeNumber(String encodedValue) throws IOException, UnsupportedOperationException {
        if (this.test()) {
            this.delegate.writeNumber(encodedValue);
            this.afterValue();
        }
    }

    public void writeObjectId(Object id) throws IOException {
        if (this.test()) {
            this.delegate.writeObjectId(id);
            this.afterValue();
        }
    }

    public void writeObjectRef(Object id) throws IOException {
        if (this.test()) {
            this.delegate.writeObjectRef(id);
            this.afterValue();
        }
    }

    public void writeOmittedField(String fieldName) throws IOException {
        if (this.test()) {
            this.delegate.writeOmittedField(fieldName);
        }
    }

    public void writeRaw(char c) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void writeRaw(char[] text, int offset, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void writeRaw(SerializableString text) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void writeRaw(String text) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void writeRaw(String text, int offset, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void writeRawUTF8String(byte[] text, int offset, int length) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void writeRawValue(char[] text, int offset, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void writeRawValue(String text) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void writeRawValue(String text, int offset, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void writeStartArray() throws IOException {
        if (this.testStartArray()) {
            this.delegate.writeStartArray();
        }
    }

    public void writeStartArray(int size) throws IOException {
        if (this.testStartArray()) {
            this.delegate.writeStartArray(size);
        }
    }

    public void writeStartArray(Object forValue) throws IOException {
        if (this.testStartArray()) {
            this.delegate.writeStartArray(forValue);
        }
    }

    public void writeStartArray(Object forValue, int size) throws IOException {
        if (this.testStartArray()) {
            this.delegate.writeStartArray(forValue, size);
        }
    }

    public void writeStartObject() throws IOException {
        if (this.testStartObject()) {
            this.delegate.writeStartObject();
        }
    }

    public void writeStartObject(Object forValue) throws IOException {
        if (this.testStartObject()) {
            this.delegate.writeStartObject(forValue);
        }
    }

    public void writeStartObject(Object forValue, int size) throws IOException {
        if (this.testStartObject()) {
            this.delegate.writeStartObject(forValue, size);
        }
    }

    public void writeString(char[] text, int offset, int len) throws IOException {
        if (this.test()) {
            this.delegate.writeString(text, offset, len);
            this.afterValue();
        }
    }

    public void writeString(SerializableString value) throws IOException {
        if (this.test()) {
            this.delegate.writeString(value);
            this.afterValue();
        }
    }

    public void writeString(String value) throws IOException {
        if (this.test()) {
            this.delegate.writeString(value);
            this.afterValue();
        }
    }

    public void writeTypeId(Object id) throws IOException {
        if (this.test()) {
            this.delegate.writeTypeId(id);
            this.afterValue();
        }
    }

    public void writeUTF8String(byte[] text, int offset, int length) throws IOException {
        if (this.test()) {
            this.delegate.writeUTF8String(text, offset, length);
            this.afterValue();
        }
    }

    protected static enum Type {
        OBJECT,
        ARRAY;

    }

    protected static final class Context {
        final Type type;
        final String name;
        final Boolean test;

        public Context(Type type, String name, Boolean test) {
            this.type = Preconditions.checkNotNull(type);
            this.name = name;
            this.test = test;
        }

        public void buildPath(StringBuilder path) {
            switch (this.type) {
                case ARRAY: {
                    path.append('.');
                    if (this.name != null) {
                        path.append(this.name);
                    }
                    path.append(FilteringJsonGenerator.ARRAY_BRACKETS);
                    break;
                }
                case OBJECT: {
                    if (this.name == null) break;
                    path.append('.').append(this.name);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
    }
}

