/*
 * Decompiled with CFR 0.152.
 */
package com.arakelian.jackson.databind;

import com.arakelian.core.utils.DateUtils;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.time.ZonedDateTime;

public class ZonedDateTimeDeserializer
extends StdDeserializer<ZonedDateTime> {
    public ZonedDateTimeDeserializer() {
        super(ZonedDateTime.class);
    }

    public ZonedDateTime deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonToken token = p.getCurrentToken();
        if (token == JsonToken.VALUE_STRING) {
            String str = p.getText().trim();
            return DateUtils.toZonedDateTimeUtc((String)str);
        }
        throw ctxt.wrongTokenException(p, ZonedDateTime.class, JsonToken.VALUE_STRING, "Expected a string");
    }
}

