/*
 * Decompiled with CFR 0.152.
 */
package com.arakelian.jackson.model;

import com.arakelian.jackson.model.ImmutableCoordinate;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Iterator;
import java.util.regex.Pattern;
import org.immutables.value.Value;
import repackaged.com.arakelian.jackson.com.google.common.base.Preconditions;
import repackaged.com.arakelian.jackson.com.google.common.base.Splitter;

@JsonSerialize(using=CoordinateSerializer.class)
@JsonDeserialize(using=CoordinateDeserializer.class)
@JsonPropertyOrder(value={"lat", "lon"})
@Value.Immutable(copy=false)
public abstract class Coordinate
implements Serializable,
Comparable<Coordinate> {
    private static final Splitter COMMA_SPLITTER = Splitter.on(Pattern.compile("\\s*,\\s*"));
    public static final int DEFAULT_PLACES = 6;
    public static final double DEFAULT_ERROR = 1.0E-6;
    public static final double NULL_ORDINATE = Double.NaN;

    private static boolean equalsWithTolerance(double x1, double x2, double tolerance) {
        return Math.abs(x1 - x2) <= tolerance;
    }

    public static Coordinate of(double x, double y) {
        return ImmutableCoordinate.builder().x(x).y(y).build();
    }

    public static Coordinate of(double x, double y, double z) {
        return ImmutableCoordinate.builder().x(x).y(y).z(z).build();
    }

    public static Coordinate of(String value) {
        double z;
        Iterator<String> it = COMMA_SPLITTER.split(value).iterator();
        Preconditions.checkState(it.hasNext(), "Expected coordinate in x,y,z format but have: %s", value);
        double x = Double.parseDouble(it.next());
        Preconditions.checkState(it.hasNext(), "Expected coordinate in x,y,z format but have: %s", value);
        double y = Double.parseDouble(it.next());
        if (it.hasNext()) {
            z = Double.parseDouble(it.next());
            Preconditions.checkState(!it.hasNext(), "Expected coordinate in x,y,z format but have: %s", value);
        } else {
            z = Double.NaN;
        }
        return Coordinate.of(x, y, z);
    }

    public static double round(double value) {
        return Coordinate.round(value, 6);
    }

    public static double round(double value, int places) {
        Preconditions.checkArgument(places >= 0, "places must be >= 0");
        if (Double.isNaN(value)) {
            return value;
        }
        return new BigDecimal(Double.toString(value)).setScale(places, RoundingMode.HALF_UP).doubleValue();
    }

    @Override
    public int compareTo(Coordinate other) {
        if (this.getX() < other.getX()) {
            return -1;
        }
        if (this.getX() > other.getX()) {
            return 1;
        }
        if (this.getY() < other.getY()) {
            return -1;
        }
        if (this.getY() > other.getY()) {
            return 1;
        }
        return 0;
    }

    public double distance(Coordinate c) {
        double dx = this.getX() - c.getX();
        double dy = this.getY() - c.getY();
        return Math.sqrt(dx * dx + dy * dy);
    }

    public double distance3D(Coordinate c) {
        double dx = this.getX() - c.getX();
        double dy = this.getY() - c.getY();
        double dz = this.getZ() - c.getZ();
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    public boolean equalInZ(Coordinate c, double tolerance) {
        return Coordinate.equalsWithTolerance(this.getZ(), c.getZ(), tolerance);
    }

    public boolean equals2D(Coordinate c, double tolerance) {
        if (!Coordinate.equalsWithTolerance(this.getX(), c.getX(), tolerance)) {
            return false;
        }
        return Coordinate.equalsWithTolerance(this.getY(), c.getY(), tolerance);
    }

    public boolean equals3D(Coordinate other) {
        return this.getX() == other.getX() && this.getY() == other.getY() && (this.getZ() == other.getZ() || Double.isNaN(this.getZ()) && Double.isNaN(other.getZ()));
    }

    public abstract double getX();

    public abstract double getY();

    @Value.Default
    public double getZ() {
        return Double.NaN;
    }

    @Value.Check
    protected Coordinate normalize() {
        double x = this.getX();
        if (Double.isNaN(x)) {
            throw new IllegalArgumentException("invalid x: " + x);
        }
        double y = this.getY();
        if (Double.isNaN(y)) {
            throw new IllegalArgumentException("invalid y: " + y);
        }
        return this.round(6);
    }

    public Coordinate round(int places) {
        double x = this.getX();
        double newX = Coordinate.round(x, places);
        double y = this.getY();
        double newY = Coordinate.round(y, places);
        double z = this.getZ();
        double newZ = Coordinate.round(z, places);
        if (Double.doubleToLongBits(x) == Double.doubleToLongBits(newX) && Double.doubleToLongBits(y) == Double.doubleToLongBits(newY) && Double.doubleToLongBits(z) == Double.doubleToLongBits(newZ)) {
            return this;
        }
        return Coordinate.of(newX, newY, newZ);
    }

    public String toString() {
        return "(" + this.getX() + ", " + this.getY() + ", " + this.getZ() + ")";
    }

    public static class CoordinateSerializer
    extends JsonSerializer<Coordinate> {
        public void serialize(Coordinate value, JsonGenerator gen, SerializerProvider serializers) throws IOException, JsonProcessingException {
            gen.writeStartArray();
            gen.writeNumber(value.getX());
            gen.writeNumber(value.getY());
            double z = value.getZ();
            if (!Double.isNaN(z)) {
                gen.writeNumber(z);
            }
            gen.writeEndArray();
        }
    }

    public static class CoordinateDeserializer
    extends JsonDeserializer<Coordinate> {
        public Coordinate deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JsonNode node = (JsonNode)ctxt.readValue(p, JsonNode.class);
            if (node instanceof ArrayNode) {
                ArrayNode arr = (ArrayNode)node;
                int size = arr.size();
                if (size == 2) {
                    return ImmutableCoordinate.builder().x(arr.get(0).asDouble()).y(arr.get(1).asDouble()).build();
                }
                if (size == 3) {
                    return ImmutableCoordinate.builder().x(arr.get(0).asDouble()).y(arr.get(1).asDouble()).z(arr.get(2).asDouble()).build();
                }
                ctxt.reportInputMismatch((JsonDeserializer)this, "Expecting array with 2 or 3 elements but found %s elements", new Object[]{size});
                return null;
            }
            if (node instanceof TextNode) {
                TextNode text = (TextNode)node;
                String v = text.asText("");
                return Coordinate.of(v);
            }
            ctxt.reportInputMismatch((JsonDeserializer)this, "Expecting array, object or text node", new Object[0]);
            return null;
        }
    }
}

