/*
 * Decompiled with CFR 0.152.
 */
package com.arakelian.jackson.model;

import com.arakelian.core.feature.Nullable;
import com.arakelian.jackson.model.Jackson;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.immutables.value.Generated;
import repackaged.com.arakelian.jackson.com.google.common.base.MoreObjects;
import repackaged.com.arakelian.jackson.com.google.common.collect.ImmutableMap;
import repackaged.com.arakelian.jackson.com.google.common.collect.ImmutableSet;
import repackaged.com.arakelian.jackson.com.google.common.collect.Maps;

@Generated(from="Jackson", generator="Immutables")
public final class ImmutableJackson
extends Jackson {
    @Nullable
    private final ObjectMapper defaultMapper;
    private final ImmutableMap<DeserializationFeature, Boolean> deserializationFeatures;
    private final ImmutableMap<JsonGenerator.Feature, Boolean> generatorFeatures;
    @Nullable
    private final Locale locale;
    private final ImmutableMap<MapperFeature, Boolean> mapperFeatures;
    private final ImmutableSet<Module> modules;
    private final ImmutableMap<JsonParser.Feature, Boolean> parserFeatures;
    private final ImmutableMap<SerializationFeature, Boolean> serializationFeatures;
    @Nullable
    private final JsonInclude.Include serializationInclusion;
    @Nullable
    private final Class<?> view;
    private final boolean defaultViewInclusion;
    private final boolean findAndRegisterModules;
    @Nullable
    private final Boolean pretty;
    private final boolean registerDateModule;
    private final boolean registerEnumModule;
    private final boolean registerTrimModule;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();
    private volatile transient long lazyInitBitmap;
    private static final long OBJECT_MAPPER_LAZY_INIT_BIT = 1L;
    private transient ObjectMapper objectMapper;
    private static final long OBJECT_WRITER_LAZY_INIT_BIT = 2L;
    private transient ObjectWriter objectWriter;
    private static final long OBJECT_WRITER_WITH_PRETTY_PRINTER_LAZY_INIT_BIT = 4L;
    private transient ObjectWriter objectWriterWithPrettyPrinter;

    private ImmutableJackson(Builder builder) {
        this.defaultMapper = builder.defaultMapper;
        this.deserializationFeatures = Maps.immutableEnumMap(builder.deserializationFeatures.build());
        this.generatorFeatures = Maps.immutableEnumMap(builder.generatorFeatures.build());
        this.locale = builder.locale;
        this.mapperFeatures = Maps.immutableEnumMap(builder.mapperFeatures.build());
        this.parserFeatures = Maps.immutableEnumMap(builder.parserFeatures.build());
        this.serializationFeatures = Maps.immutableEnumMap(builder.serializationFeatures.build());
        this.serializationInclusion = builder.serializationInclusion;
        this.view = builder.view;
        this.pretty = builder.pretty;
        if (builder.modulesIsSet()) {
            this.initShim.modules(builder.modules.build());
        }
        if (builder.defaultViewInclusionIsSet()) {
            this.initShim.defaultViewInclusion(builder.defaultViewInclusion);
        }
        if (builder.findAndRegisterModulesIsSet()) {
            this.initShim.findAndRegisterModules(builder.findAndRegisterModules);
        }
        if (builder.registerDateModuleIsSet()) {
            this.initShim.registerDateModule(builder.registerDateModule);
        }
        if (builder.registerEnumModuleIsSet()) {
            this.initShim.registerEnumModule(builder.registerEnumModule);
        }
        if (builder.registerTrimModuleIsSet()) {
            this.initShim.registerTrimModule(builder.registerTrimModule);
        }
        this.modules = this.initShim.getModules();
        this.defaultViewInclusion = this.initShim.isDefaultViewInclusion();
        this.findAndRegisterModules = this.initShim.isFindAndRegisterModules();
        this.registerDateModule = this.initShim.isRegisterDateModule();
        this.registerEnumModule = this.initShim.isRegisterEnumModule();
        this.registerTrimModule = this.initShim.isRegisterTrimModule();
        this.initShim = null;
    }

    private ImmutableJackson(@Nullable ObjectMapper defaultMapper, ImmutableMap<DeserializationFeature, Boolean> deserializationFeatures, ImmutableMap<JsonGenerator.Feature, Boolean> generatorFeatures, @Nullable Locale locale, ImmutableMap<MapperFeature, Boolean> mapperFeatures, ImmutableSet<Module> modules, ImmutableMap<JsonParser.Feature, Boolean> parserFeatures, ImmutableMap<SerializationFeature, Boolean> serializationFeatures, @Nullable JsonInclude.Include serializationInclusion, @Nullable Class<?> view, boolean defaultViewInclusion, boolean findAndRegisterModules, @Nullable Boolean pretty, boolean registerDateModule, boolean registerEnumModule, boolean registerTrimModule) {
        this.defaultMapper = defaultMapper;
        this.deserializationFeatures = deserializationFeatures;
        this.generatorFeatures = generatorFeatures;
        this.locale = locale;
        this.mapperFeatures = mapperFeatures;
        this.modules = modules;
        this.parserFeatures = parserFeatures;
        this.serializationFeatures = serializationFeatures;
        this.serializationInclusion = serializationInclusion;
        this.view = view;
        this.defaultViewInclusion = defaultViewInclusion;
        this.findAndRegisterModules = findAndRegisterModules;
        this.pretty = pretty;
        this.registerDateModule = registerDateModule;
        this.registerEnumModule = registerEnumModule;
        this.registerTrimModule = registerTrimModule;
        this.initShim = null;
    }

    @Override
    @Nullable
    public ObjectMapper getDefaultMapper() {
        return this.defaultMapper;
    }

    public ImmutableMap<DeserializationFeature, Boolean> getDeserializationFeatures() {
        return this.deserializationFeatures;
    }

    public ImmutableMap<JsonGenerator.Feature, Boolean> getGeneratorFeatures() {
        return this.generatorFeatures;
    }

    @Override
    @Nullable
    public Locale getLocale() {
        return this.locale;
    }

    public ImmutableMap<MapperFeature, Boolean> getMapperFeatures() {
        return this.mapperFeatures;
    }

    public ImmutableSet<Module> getModules() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getModules() : this.modules;
    }

    public ImmutableMap<JsonParser.Feature, Boolean> getParserFeatures() {
        return this.parserFeatures;
    }

    public ImmutableMap<SerializationFeature, Boolean> getSerializationFeatures() {
        return this.serializationFeatures;
    }

    @Override
    @Nullable
    public JsonInclude.Include getSerializationInclusion() {
        return this.serializationInclusion;
    }

    @Override
    @Nullable
    public Class<?> getView() {
        return this.view;
    }

    @Override
    public boolean isDefaultViewInclusion() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isDefaultViewInclusion() : this.defaultViewInclusion;
    }

    @Override
    public boolean isFindAndRegisterModules() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isFindAndRegisterModules() : this.findAndRegisterModules;
    }

    @Override
    @Nullable
    public Boolean isPretty() {
        return this.pretty;
    }

    @Override
    public boolean isRegisterDateModule() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isRegisterDateModule() : this.registerDateModule;
    }

    @Override
    public boolean isRegisterEnumModule() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isRegisterEnumModule() : this.registerEnumModule;
    }

    @Override
    public boolean isRegisterTrimModule() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isRegisterTrimModule() : this.registerTrimModule;
    }

    public final ImmutableJackson withDefaultMapper(@Nullable ObjectMapper value) {
        if (this.defaultMapper == value) {
            return this;
        }
        return new ImmutableJackson(value, this.deserializationFeatures, this.generatorFeatures, this.locale, this.mapperFeatures, this.modules, this.parserFeatures, this.serializationFeatures, this.serializationInclusion, this.view, this.defaultViewInclusion, this.findAndRegisterModules, this.pretty, this.registerDateModule, this.registerEnumModule, this.registerTrimModule);
    }

    public final ImmutableJackson withDeserializationFeatures(Map<DeserializationFeature, ? extends Boolean> entries) {
        if (this.deserializationFeatures == entries) {
            return this;
        }
        ImmutableMap<DeserializationFeature, Boolean> newValue = Maps.immutableEnumMap(entries);
        return new ImmutableJackson(this.defaultMapper, newValue, this.generatorFeatures, this.locale, this.mapperFeatures, this.modules, this.parserFeatures, this.serializationFeatures, this.serializationInclusion, this.view, this.defaultViewInclusion, this.findAndRegisterModules, this.pretty, this.registerDateModule, this.registerEnumModule, this.registerTrimModule);
    }

    public final ImmutableJackson withGeneratorFeatures(Map<JsonGenerator.Feature, ? extends Boolean> entries) {
        if (this.generatorFeatures == entries) {
            return this;
        }
        ImmutableMap<JsonGenerator.Feature, Boolean> newValue = Maps.immutableEnumMap(entries);
        return new ImmutableJackson(this.defaultMapper, this.deserializationFeatures, newValue, this.locale, this.mapperFeatures, this.modules, this.parserFeatures, this.serializationFeatures, this.serializationInclusion, this.view, this.defaultViewInclusion, this.findAndRegisterModules, this.pretty, this.registerDateModule, this.registerEnumModule, this.registerTrimModule);
    }

    public final ImmutableJackson withLocale(@Nullable Locale value) {
        if (this.locale == value) {
            return this;
        }
        return new ImmutableJackson(this.defaultMapper, this.deserializationFeatures, this.generatorFeatures, value, this.mapperFeatures, this.modules, this.parserFeatures, this.serializationFeatures, this.serializationInclusion, this.view, this.defaultViewInclusion, this.findAndRegisterModules, this.pretty, this.registerDateModule, this.registerEnumModule, this.registerTrimModule);
    }

    public final ImmutableJackson withMapperFeatures(Map<MapperFeature, ? extends Boolean> entries) {
        if (this.mapperFeatures == entries) {
            return this;
        }
        ImmutableMap<MapperFeature, Boolean> newValue = Maps.immutableEnumMap(entries);
        return new ImmutableJackson(this.defaultMapper, this.deserializationFeatures, this.generatorFeatures, this.locale, newValue, this.modules, this.parserFeatures, this.serializationFeatures, this.serializationInclusion, this.view, this.defaultViewInclusion, this.findAndRegisterModules, this.pretty, this.registerDateModule, this.registerEnumModule, this.registerTrimModule);
    }

    public final ImmutableJackson withModules(Module ... elements) {
        ImmutableSet<Module> newValue = ImmutableSet.copyOf(elements);
        return new ImmutableJackson(this.defaultMapper, this.deserializationFeatures, this.generatorFeatures, this.locale, this.mapperFeatures, newValue, this.parserFeatures, this.serializationFeatures, this.serializationInclusion, this.view, this.defaultViewInclusion, this.findAndRegisterModules, this.pretty, this.registerDateModule, this.registerEnumModule, this.registerTrimModule);
    }

    public final ImmutableJackson withModules(Iterable<? extends Module> elements) {
        if (this.modules == elements) {
            return this;
        }
        ImmutableSet<Module> newValue = ImmutableSet.copyOf(elements);
        return new ImmutableJackson(this.defaultMapper, this.deserializationFeatures, this.generatorFeatures, this.locale, this.mapperFeatures, newValue, this.parserFeatures, this.serializationFeatures, this.serializationInclusion, this.view, this.defaultViewInclusion, this.findAndRegisterModules, this.pretty, this.registerDateModule, this.registerEnumModule, this.registerTrimModule);
    }

    public final ImmutableJackson withParserFeatures(Map<JsonParser.Feature, ? extends Boolean> entries) {
        if (this.parserFeatures == entries) {
            return this;
        }
        ImmutableMap<JsonParser.Feature, Boolean> newValue = Maps.immutableEnumMap(entries);
        return new ImmutableJackson(this.defaultMapper, this.deserializationFeatures, this.generatorFeatures, this.locale, this.mapperFeatures, this.modules, newValue, this.serializationFeatures, this.serializationInclusion, this.view, this.defaultViewInclusion, this.findAndRegisterModules, this.pretty, this.registerDateModule, this.registerEnumModule, this.registerTrimModule);
    }

    public final ImmutableJackson withSerializationFeatures(Map<SerializationFeature, ? extends Boolean> entries) {
        if (this.serializationFeatures == entries) {
            return this;
        }
        ImmutableMap<SerializationFeature, Boolean> newValue = Maps.immutableEnumMap(entries);
        return new ImmutableJackson(this.defaultMapper, this.deserializationFeatures, this.generatorFeatures, this.locale, this.mapperFeatures, this.modules, this.parserFeatures, newValue, this.serializationInclusion, this.view, this.defaultViewInclusion, this.findAndRegisterModules, this.pretty, this.registerDateModule, this.registerEnumModule, this.registerTrimModule);
    }

    public final ImmutableJackson withSerializationInclusion(@Nullable JsonInclude.Include value) {
        if (this.serializationInclusion == value) {
            return this;
        }
        return new ImmutableJackson(this.defaultMapper, this.deserializationFeatures, this.generatorFeatures, this.locale, this.mapperFeatures, this.modules, this.parserFeatures, this.serializationFeatures, value, this.view, this.defaultViewInclusion, this.findAndRegisterModules, this.pretty, this.registerDateModule, this.registerEnumModule, this.registerTrimModule);
    }

    public final ImmutableJackson withView(@Nullable Class<?> value) {
        if (this.view == value) {
            return this;
        }
        return new ImmutableJackson(this.defaultMapper, this.deserializationFeatures, this.generatorFeatures, this.locale, this.mapperFeatures, this.modules, this.parserFeatures, this.serializationFeatures, this.serializationInclusion, value, this.defaultViewInclusion, this.findAndRegisterModules, this.pretty, this.registerDateModule, this.registerEnumModule, this.registerTrimModule);
    }

    public final ImmutableJackson withDefaultViewInclusion(boolean value) {
        if (this.defaultViewInclusion == value) {
            return this;
        }
        return new ImmutableJackson(this.defaultMapper, this.deserializationFeatures, this.generatorFeatures, this.locale, this.mapperFeatures, this.modules, this.parserFeatures, this.serializationFeatures, this.serializationInclusion, this.view, value, this.findAndRegisterModules, this.pretty, this.registerDateModule, this.registerEnumModule, this.registerTrimModule);
    }

    public final ImmutableJackson withFindAndRegisterModules(boolean value) {
        if (this.findAndRegisterModules == value) {
            return this;
        }
        return new ImmutableJackson(this.defaultMapper, this.deserializationFeatures, this.generatorFeatures, this.locale, this.mapperFeatures, this.modules, this.parserFeatures, this.serializationFeatures, this.serializationInclusion, this.view, this.defaultViewInclusion, value, this.pretty, this.registerDateModule, this.registerEnumModule, this.registerTrimModule);
    }

    public final ImmutableJackson withPretty(@Nullable Boolean value) {
        if (Objects.equals(this.pretty, value)) {
            return this;
        }
        return new ImmutableJackson(this.defaultMapper, this.deserializationFeatures, this.generatorFeatures, this.locale, this.mapperFeatures, this.modules, this.parserFeatures, this.serializationFeatures, this.serializationInclusion, this.view, this.defaultViewInclusion, this.findAndRegisterModules, value, this.registerDateModule, this.registerEnumModule, this.registerTrimModule);
    }

    public final ImmutableJackson withRegisterDateModule(boolean value) {
        if (this.registerDateModule == value) {
            return this;
        }
        return new ImmutableJackson(this.defaultMapper, this.deserializationFeatures, this.generatorFeatures, this.locale, this.mapperFeatures, this.modules, this.parserFeatures, this.serializationFeatures, this.serializationInclusion, this.view, this.defaultViewInclusion, this.findAndRegisterModules, this.pretty, value, this.registerEnumModule, this.registerTrimModule);
    }

    public final ImmutableJackson withRegisterEnumModule(boolean value) {
        if (this.registerEnumModule == value) {
            return this;
        }
        return new ImmutableJackson(this.defaultMapper, this.deserializationFeatures, this.generatorFeatures, this.locale, this.mapperFeatures, this.modules, this.parserFeatures, this.serializationFeatures, this.serializationInclusion, this.view, this.defaultViewInclusion, this.findAndRegisterModules, this.pretty, this.registerDateModule, value, this.registerTrimModule);
    }

    public final ImmutableJackson withRegisterTrimModule(boolean value) {
        if (this.registerTrimModule == value) {
            return this;
        }
        return new ImmutableJackson(this.defaultMapper, this.deserializationFeatures, this.generatorFeatures, this.locale, this.mapperFeatures, this.modules, this.parserFeatures, this.serializationFeatures, this.serializationInclusion, this.view, this.defaultViewInclusion, this.findAndRegisterModules, this.pretty, this.registerDateModule, this.registerEnumModule, value);
    }

    public String toString() {
        return MoreObjects.toStringHelper("Jackson").omitNullValues().add("locale", this.locale).add("mapperFeatures", this.mapperFeatures).add("modules", this.modules).add("parserFeatures", this.parserFeatures).add("serializationFeatures", this.serializationFeatures).add("serializationInclusion", this.serializationInclusion).add("view", this.view).add("defaultViewInclusion", this.defaultViewInclusion).add("findAndRegisterModules", this.findAndRegisterModules).add("pretty", this.pretty).add("registerDateModule", this.registerDateModule).add("registerEnumModule", this.registerEnumModule).add("registerTrimModule", this.registerTrimModule).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ObjectMapper getObjectMapper() {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            ImmutableJackson immutableJackson = this;
            synchronized (immutableJackson) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.objectMapper = Objects.requireNonNull(super.getObjectMapper(), "objectMapper");
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.objectMapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ObjectWriter getObjectWriter() {
        if ((this.lazyInitBitmap & 2L) == 0L) {
            ImmutableJackson immutableJackson = this;
            synchronized (immutableJackson) {
                if ((this.lazyInitBitmap & 2L) == 0L) {
                    this.objectWriter = Objects.requireNonNull(super.getObjectWriter(), "objectWriter");
                    this.lazyInitBitmap |= 2L;
                }
            }
        }
        return this.objectWriter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ObjectWriter getObjectWriterWithPrettyPrinter() {
        if ((this.lazyInitBitmap & 4L) == 0L) {
            ImmutableJackson immutableJackson = this;
            synchronized (immutableJackson) {
                if ((this.lazyInitBitmap & 4L) == 0L) {
                    this.objectWriterWithPrettyPrinter = Objects.requireNonNull(super.getObjectWriterWithPrettyPrinter(), "objectWriterWithPrettyPrinter");
                    this.lazyInitBitmap |= 4L;
                }
            }
        }
        return this.objectWriterWithPrettyPrinter;
    }

    public static ImmutableJackson copyOf(Jackson instance) {
        if (instance instanceof ImmutableJackson) {
            return (ImmutableJackson)instance;
        }
        return ImmutableJackson.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Jackson", generator="Immutables")
    public static final class Builder {
        private static final long OPT_BIT_MODULES = 1L;
        private static final long OPT_BIT_DEFAULT_VIEW_INCLUSION = 2L;
        private static final long OPT_BIT_FIND_AND_REGISTER_MODULES = 4L;
        private static final long OPT_BIT_REGISTER_DATE_MODULE = 8L;
        private static final long OPT_BIT_REGISTER_ENUM_MODULE = 16L;
        private static final long OPT_BIT_REGISTER_TRIM_MODULE = 32L;
        private long optBits;
        private ObjectMapper defaultMapper;
        private ImmutableMap.Builder<DeserializationFeature, Boolean> deserializationFeatures = ImmutableMap.builder();
        private ImmutableMap.Builder<JsonGenerator.Feature, Boolean> generatorFeatures = ImmutableMap.builder();
        private Locale locale;
        private ImmutableMap.Builder<MapperFeature, Boolean> mapperFeatures = ImmutableMap.builder();
        private ImmutableSet.Builder<Module> modules = ImmutableSet.builder();
        private ImmutableMap.Builder<JsonParser.Feature, Boolean> parserFeatures = ImmutableMap.builder();
        private ImmutableMap.Builder<SerializationFeature, Boolean> serializationFeatures = ImmutableMap.builder();
        private JsonInclude.Include serializationInclusion;
        private Class<?> view;
        private boolean defaultViewInclusion;
        private boolean findAndRegisterModules;
        private Boolean pretty;
        private boolean registerDateModule;
        private boolean registerEnumModule;
        private boolean registerTrimModule;

        private Builder() {
        }

        public final Builder from(Jackson instance) {
            Class<?> viewValue;
            Objects.requireNonNull(instance, "instance");
            ObjectMapper defaultMapperValue = instance.getDefaultMapper();
            if (defaultMapperValue != null) {
                this.defaultMapper(defaultMapperValue);
            }
            this.putAllDeserializationFeatures(instance.getDeserializationFeatures());
            this.putAllGeneratorFeatures(instance.getGeneratorFeatures());
            Locale localeValue = instance.getLocale();
            if (localeValue != null) {
                this.locale(localeValue);
            }
            this.putAllMapperFeatures(instance.getMapperFeatures());
            this.addAllModules(instance.getModules());
            this.putAllParserFeatures(instance.getParserFeatures());
            this.putAllSerializationFeatures(instance.getSerializationFeatures());
            JsonInclude.Include serializationInclusionValue = instance.getSerializationInclusion();
            if (serializationInclusionValue != null) {
                this.serializationInclusion(serializationInclusionValue);
            }
            if ((viewValue = instance.getView()) != null) {
                this.view(viewValue);
            }
            this.defaultViewInclusion(instance.isDefaultViewInclusion());
            this.findAndRegisterModules(instance.isFindAndRegisterModules());
            Boolean prettyValue = instance.isPretty();
            if (prettyValue != null) {
                this.pretty(prettyValue);
            }
            this.registerDateModule(instance.isRegisterDateModule());
            this.registerEnumModule(instance.isRegisterEnumModule());
            this.registerTrimModule(instance.isRegisterTrimModule());
            return this;
        }

        public final Builder defaultMapper(@Nullable ObjectMapper defaultMapper) {
            this.defaultMapper = defaultMapper;
            return this;
        }

        public final Builder putDeserializationFeatures(DeserializationFeature key, boolean value) {
            this.deserializationFeatures.put(key, value);
            return this;
        }

        public final Builder putDeserializationFeatures(Map.Entry<DeserializationFeature, ? extends Boolean> entry) {
            this.deserializationFeatures.put(entry);
            return this;
        }

        public final Builder deserializationFeatures(Map<DeserializationFeature, ? extends Boolean> entries) {
            this.deserializationFeatures = ImmutableMap.builder();
            return this.putAllDeserializationFeatures(entries);
        }

        public final Builder putAllDeserializationFeatures(Map<DeserializationFeature, ? extends Boolean> entries) {
            this.deserializationFeatures.putAll(entries);
            return this;
        }

        public final Builder putGeneratorFeatures(JsonGenerator.Feature key, boolean value) {
            this.generatorFeatures.put(key, value);
            return this;
        }

        public final Builder putGeneratorFeatures(Map.Entry<JsonGenerator.Feature, ? extends Boolean> entry) {
            this.generatorFeatures.put(entry);
            return this;
        }

        public final Builder generatorFeatures(Map<JsonGenerator.Feature, ? extends Boolean> entries) {
            this.generatorFeatures = ImmutableMap.builder();
            return this.putAllGeneratorFeatures(entries);
        }

        public final Builder putAllGeneratorFeatures(Map<JsonGenerator.Feature, ? extends Boolean> entries) {
            this.generatorFeatures.putAll(entries);
            return this;
        }

        public final Builder locale(@Nullable Locale locale) {
            this.locale = locale;
            return this;
        }

        public final Builder putMapperFeatures(MapperFeature key, boolean value) {
            this.mapperFeatures.put(key, value);
            return this;
        }

        public final Builder putMapperFeatures(Map.Entry<MapperFeature, ? extends Boolean> entry) {
            this.mapperFeatures.put(entry);
            return this;
        }

        public final Builder mapperFeatures(Map<MapperFeature, ? extends Boolean> entries) {
            this.mapperFeatures = ImmutableMap.builder();
            return this.putAllMapperFeatures(entries);
        }

        public final Builder putAllMapperFeatures(Map<MapperFeature, ? extends Boolean> entries) {
            this.mapperFeatures.putAll(entries);
            return this;
        }

        public final Builder addModules(Module element) {
            this.modules.add((Object)element);
            this.optBits |= 1L;
            return this;
        }

        public final Builder addModules(Module ... elements) {
            this.modules.add(elements);
            this.optBits |= 1L;
            return this;
        }

        public final Builder modules(Iterable<? extends Module> elements) {
            this.modules = ImmutableSet.builder();
            return this.addAllModules(elements);
        }

        public final Builder addAllModules(Iterable<? extends Module> elements) {
            this.modules.addAll(elements);
            this.optBits |= 1L;
            return this;
        }

        public final Builder putParserFeatures(JsonParser.Feature key, boolean value) {
            this.parserFeatures.put(key, value);
            return this;
        }

        public final Builder putParserFeatures(Map.Entry<JsonParser.Feature, ? extends Boolean> entry) {
            this.parserFeatures.put(entry);
            return this;
        }

        public final Builder parserFeatures(Map<JsonParser.Feature, ? extends Boolean> entries) {
            this.parserFeatures = ImmutableMap.builder();
            return this.putAllParserFeatures(entries);
        }

        public final Builder putAllParserFeatures(Map<JsonParser.Feature, ? extends Boolean> entries) {
            this.parserFeatures.putAll(entries);
            return this;
        }

        public final Builder putSerializationFeatures(SerializationFeature key, boolean value) {
            this.serializationFeatures.put(key, value);
            return this;
        }

        public final Builder putSerializationFeatures(Map.Entry<SerializationFeature, ? extends Boolean> entry) {
            this.serializationFeatures.put(entry);
            return this;
        }

        public final Builder serializationFeatures(Map<SerializationFeature, ? extends Boolean> entries) {
            this.serializationFeatures = ImmutableMap.builder();
            return this.putAllSerializationFeatures(entries);
        }

        public final Builder putAllSerializationFeatures(Map<SerializationFeature, ? extends Boolean> entries) {
            this.serializationFeatures.putAll(entries);
            return this;
        }

        public final Builder serializationInclusion(@Nullable JsonInclude.Include serializationInclusion) {
            this.serializationInclusion = serializationInclusion;
            return this;
        }

        public final Builder view(@Nullable Class<?> view) {
            this.view = view;
            return this;
        }

        public final Builder defaultViewInclusion(boolean defaultViewInclusion) {
            this.defaultViewInclusion = defaultViewInclusion;
            this.optBits |= 2L;
            return this;
        }

        public final Builder findAndRegisterModules(boolean findAndRegisterModules) {
            this.findAndRegisterModules = findAndRegisterModules;
            this.optBits |= 4L;
            return this;
        }

        public final Builder pretty(@Nullable Boolean pretty) {
            this.pretty = pretty;
            return this;
        }

        public final Builder registerDateModule(boolean registerDateModule) {
            this.registerDateModule = registerDateModule;
            this.optBits |= 8L;
            return this;
        }

        public final Builder registerEnumModule(boolean registerEnumModule) {
            this.registerEnumModule = registerEnumModule;
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder registerTrimModule(boolean registerTrimModule) {
            this.registerTrimModule = registerTrimModule;
            this.optBits |= 0x20L;
            return this;
        }

        public ImmutableJackson build() {
            return new ImmutableJackson(this);
        }

        private boolean modulesIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean defaultViewInclusionIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean findAndRegisterModulesIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean registerDateModuleIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean registerEnumModuleIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private boolean registerTrimModuleIsSet() {
            return (this.optBits & 0x20L) != 0L;
        }
    }

    @Generated(from="Jackson", generator="Immutables")
    private final class InitShim {
        private byte modulesBuildStage = 0;
        private ImmutableSet<Module> modules;
        private byte defaultViewInclusionBuildStage = 0;
        private boolean defaultViewInclusion;
        private byte findAndRegisterModulesBuildStage = 0;
        private boolean findAndRegisterModules;
        private byte registerDateModuleBuildStage = 0;
        private boolean registerDateModule;
        private byte registerEnumModuleBuildStage = 0;
        private boolean registerEnumModule;
        private byte registerTrimModuleBuildStage = 0;
        private boolean registerTrimModule;

        private InitShim() {
        }

        ImmutableSet<Module> getModules() {
            if (this.modulesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.modulesBuildStage == 0) {
                this.modulesBuildStage = (byte)-1;
                this.modules = ImmutableSet.copyOf(ImmutableJackson.super.getModules());
                this.modulesBuildStage = 1;
            }
            return this.modules;
        }

        void modules(ImmutableSet<Module> modules) {
            this.modules = modules;
            this.modulesBuildStage = 1;
        }

        boolean isDefaultViewInclusion() {
            if (this.defaultViewInclusionBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.defaultViewInclusionBuildStage == 0) {
                this.defaultViewInclusionBuildStage = (byte)-1;
                this.defaultViewInclusion = ImmutableJackson.super.isDefaultViewInclusion();
                this.defaultViewInclusionBuildStage = 1;
            }
            return this.defaultViewInclusion;
        }

        void defaultViewInclusion(boolean defaultViewInclusion) {
            this.defaultViewInclusion = defaultViewInclusion;
            this.defaultViewInclusionBuildStage = 1;
        }

        boolean isFindAndRegisterModules() {
            if (this.findAndRegisterModulesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.findAndRegisterModulesBuildStage == 0) {
                this.findAndRegisterModulesBuildStage = (byte)-1;
                this.findAndRegisterModules = ImmutableJackson.super.isFindAndRegisterModules();
                this.findAndRegisterModulesBuildStage = 1;
            }
            return this.findAndRegisterModules;
        }

        void findAndRegisterModules(boolean findAndRegisterModules) {
            this.findAndRegisterModules = findAndRegisterModules;
            this.findAndRegisterModulesBuildStage = 1;
        }

        boolean isRegisterDateModule() {
            if (this.registerDateModuleBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.registerDateModuleBuildStage == 0) {
                this.registerDateModuleBuildStage = (byte)-1;
                this.registerDateModule = ImmutableJackson.super.isRegisterDateModule();
                this.registerDateModuleBuildStage = 1;
            }
            return this.registerDateModule;
        }

        void registerDateModule(boolean registerDateModule) {
            this.registerDateModule = registerDateModule;
            this.registerDateModuleBuildStage = 1;
        }

        boolean isRegisterEnumModule() {
            if (this.registerEnumModuleBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.registerEnumModuleBuildStage == 0) {
                this.registerEnumModuleBuildStage = (byte)-1;
                this.registerEnumModule = ImmutableJackson.super.isRegisterEnumModule();
                this.registerEnumModuleBuildStage = 1;
            }
            return this.registerEnumModule;
        }

        void registerEnumModule(boolean registerEnumModule) {
            this.registerEnumModule = registerEnumModule;
            this.registerEnumModuleBuildStage = 1;
        }

        boolean isRegisterTrimModule() {
            if (this.registerTrimModuleBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.registerTrimModuleBuildStage == 0) {
                this.registerTrimModuleBuildStage = (byte)-1;
                this.registerTrimModule = ImmutableJackson.super.isRegisterTrimModule();
                this.registerTrimModuleBuildStage = 1;
            }
            return this.registerTrimModule;
        }

        void registerTrimModule(boolean registerTrimModule) {
            this.registerTrimModule = registerTrimModule;
            this.registerTrimModuleBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.modulesBuildStage == -1) {
                attributes.add("modules");
            }
            if (this.defaultViewInclusionBuildStage == -1) {
                attributes.add("defaultViewInclusion");
            }
            if (this.findAndRegisterModulesBuildStage == -1) {
                attributes.add("findAndRegisterModules");
            }
            if (this.registerDateModuleBuildStage == -1) {
                attributes.add("registerDateModule");
            }
            if (this.registerEnumModuleBuildStage == -1) {
                attributes.add("registerEnumModule");
            }
            if (this.registerTrimModuleBuildStage == -1) {
                attributes.add("registerTrimModule");
            }
            return "Cannot build Jackson, attribute initializers form cycle " + attributes;
        }
    }
}

