/*
 * Decompiled with CFR 0.152.
 */
package com.arakelian.jackson;

import com.arakelian.jackson.model.GeoPoint;
import com.arakelian.jackson.utils.JacksonUtils;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.immutables.value.Value;

public abstract class AbstractMapPath
implements Serializable {
    public static final char PATH_SEPARATOR = '/';
    private transient ObjectMapper mapper;

    public <R> R find(String path, Function<Object, R> function, R defaultValue) {
        int start;
        if (this.getProperties().size() == 0 || StringUtils.isEmpty((CharSequence)path)) {
            return defaultValue;
        }
        Map map = this.getProperties();
        int length = path.length();
        int n = start = length > 0 && path.charAt(0) == '/' ? 1 : 0;
        while (start < length) {
            String segment;
            boolean lastSegment = (start += (segment = this.getSegment(path, start, map)).length()) >= length;
            Object value = map.get(segment);
            if (lastSegment) {
                return function.apply(value);
            }
            if (value == null) {
                return defaultValue;
            }
            if (!(value instanceof Map)) {
                throw new IllegalArgumentException("Expected \"" + path.substring(0, start) + "\" of path \"" + path + "\" to resolve to Map but was " + value.getClass().getSimpleName());
            }
            map = (Map)Map.class.cast(value);
            ++start;
        }
        return defaultValue;
    }

    public <T> T first(String path, Class<T> clazz) {
        return this.first(path, clazz, null);
    }

    public <T> T first(String path, Class<T> clazz, T defaultValue) {
        Preconditions.checkArgument((clazz != null ? 1 : 0) != 0, (Object)"clazz must be non-null");
        Object result = this.find(path, value -> {
            if (value == null) {
                return defaultValue;
            }
            if (value instanceof Collection) {
                Collection c = (Collection)value;
                if (c.size() == 0) {
                    return defaultValue;
                }
                return this.getObjectMapper().convertValue(c.iterator().next(), clazz);
            }
            return this.getObjectMapper().convertValue(value, clazz);
        }, defaultValue);
        return (T)result;
    }

    public Double firstDouble(String path) {
        return this.firstDouble(path, null);
    }

    public Double firstDouble(String path, Double defaultValue) {
        return this.first(path, Double.class, defaultValue);
    }

    public Integer firstInt(String path) {
        return this.firstInt(path, null);
    }

    public Integer firstInt(String path, Integer defaultValue) {
        return this.first(path, Integer.class, defaultValue);
    }

    public Long firstLong(String path) {
        return this.firstLong(path, null);
    }

    public Long firstLong(String path, Long defaultValue) {
        return this.first(path, Long.class, defaultValue);
    }

    public String firstString(String path) {
        return this.firstString(path, null);
    }

    public String firstString(String path, String defaultValue) {
        return this.first(path, String.class, defaultValue);
    }

    public <T> T get(String path, Class<T> clazz) {
        return this.get(path, clazz, null);
    }

    public <T> T get(String path, Class<T> clazz, T defaultValue) {
        Preconditions.checkArgument((clazz != null ? 1 : 0) != 0, (Object)"clazz must be non-null");
        Object result = this.find(path, value -> value != null ? this.getObjectMapper().convertValue(value, clazz) : defaultValue, defaultValue);
        return (T)result;
    }

    public Double getDouble(String path) {
        return this.get(path, Double.class);
    }

    public Float getFloat(String path) {
        return this.get(path, Float.class);
    }

    public GeoPoint getGeoPoint(String path) {
        return this.get(path, GeoPoint.class);
    }

    public Integer getInt(String path) {
        return this.get(path, Integer.class);
    }

    public <T> List<T> getList(String path) {
        List list = this.get(path, List.class);
        return list;
    }

    public Long getLong(String path) {
        return this.get(path, Long.class);
    }

    public Map getMap(String path) {
        return this.get(path, Map.class);
    }

    public Object getObject(String path) {
        return this.get(path, Object.class);
    }

    @JsonIgnore
    @Value.Lazy
    public ObjectMapper getObjectMapper() {
        if (this.mapper == null) {
            this.mapper = JacksonUtils.getObjectMapper();
        }
        return this.mapper;
    }

    @JsonAnyGetter
    @Value.Default
    public Map<Object, Object> getProperties() {
        return ImmutableMap.of();
    }

    protected String getSegment(String path, int start, Map map) {
        int length = path.length();
        for (int i = start; i < length; ++i) {
            String segment;
            char ch = path.charAt(i);
            if (ch != '/' && ch != '.' || !map.containsKey(segment = path.substring(start, i))) continue;
            return segment;
        }
        return path.substring(start);
    }

    public String getString(String path) {
        return this.get(path, String.class);
    }

    public ZonedDateTime getZonedDateTime(String path) {
        return this.get(path, ZonedDateTime.class);
    }

    public boolean hasProperty(String path) {
        return this.find(path, value -> value != null, false);
    }

    public void setObjectMapper(ObjectMapper mapper) {
        this.mapper = mapper;
    }
}

