/*
 * Decompiled with CFR 0.152.
 */
package com.arakelian.jackson;

import com.arakelian.jackson.AbstractMapPath;
import com.arakelian.jackson.MapPath;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="MapPath", generator="Immutables")
@Immutable
public final class ImmutableMapPath
extends MapPath {
    private final ImmutableMap<Object, Object> properties;
    private volatile transient long lazyInitBitmap;
    private static final long OBJECT_MAPPER_LAZY_INIT_BIT = 1L;
    private transient ObjectMapper objectMapper;

    private ImmutableMapPath(Builder builder) {
        this.properties = builder.propertiesIsSet() ? builder.properties.build() : ImmutableMap.copyOf(super.getProperties());
    }

    private ImmutableMapPath(ImmutableMap<Object, Object> properties) {
        this.properties = properties;
    }

    @JsonProperty(value="properties")
    @JsonAnyGetter
    public ImmutableMap<Object, Object> getProperties() {
        return this.properties;
    }

    public final ImmutableMapPath withProperties(Map<? extends Object, ? extends Object> entries) {
        if (this.properties == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new ImmutableMapPath((ImmutableMap<Object, Object>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMapPath && this.equalTo(0, (ImmutableMapPath)another);
    }

    private boolean equalTo(int synthetic, ImmutableMapPath another) {
        return this.properties.equals(another.properties);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.properties.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"MapPath").omitNullValues().add("properties", this.properties).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ObjectMapper getObjectMapper() {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            ImmutableMapPath immutableMapPath = this;
            synchronized (immutableMapPath) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.objectMapper = Objects.requireNonNull(super.getObjectMapper(), "objectMapper");
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.objectMapper;
    }

    public static ImmutableMapPath copyOf(MapPath instance) {
        if (instance instanceof ImmutableMapPath) {
            return (ImmutableMapPath)instance;
        }
        return ImmutableMapPath.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="MapPath", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long OPT_BIT_PROPERTIES = 1L;
        private long optBits;
        private ImmutableMap.Builder<Object, Object> properties = ImmutableMap.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(MapPath instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(AbstractMapPath instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            AbstractMapPath instance;
            long bits = 0L;
            if (object instanceof MapPath) {
                instance = (MapPath)object;
                if ((bits & 1L) == 0L) {
                    this.putAllProperties(instance.getProperties());
                    bits |= 1L;
                }
            }
            if (object instanceof AbstractMapPath) {
                instance = (AbstractMapPath)object;
                if ((bits & 1L) == 0L) {
                    this.putAllProperties(instance.getProperties());
                    bits |= 1L;
                }
            }
        }

        @JsonAnySetter
        @CanIgnoreReturnValue
        public final Builder putProperties(Object key, Object value) {
            this.properties.put(key, value);
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putProperties(Map.Entry<? extends Object, ? extends Object> entry) {
            this.properties.put(entry);
            this.optBits |= 1L;
            return this;
        }

        @JsonProperty(value="properties")
        @CanIgnoreReturnValue
        public final Builder properties(Map<? extends Object, ? extends Object> entries) {
            this.properties = ImmutableMap.builder();
            this.optBits |= 1L;
            return this.putAllProperties(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllProperties(Map<? extends Object, ? extends Object> entries) {
            this.properties.putAll(entries);
            this.optBits |= 1L;
            return this;
        }

        public ImmutableMapPath build() {
            return new ImmutableMapPath(this);
        }

        private boolean propertiesIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

