/*
 * Decompiled with CFR 0.152.
 */
package com.arakelian.jackson.databind;

import com.arakelian.jackson.FilteringJsonGenerator;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.Set;

public class ExcludeSerializer<T>
extends JsonSerializer<T> {
    private final Class<T> handledType;
    private final Set<String> excludes;
    private final JsonSerializer<Object> delegate;

    public ExcludeSerializer(Class<T> handledType, JsonSerializer<Object> delegate, String ... excludes) {
        this.handledType = (Class)Preconditions.checkNotNull(handledType);
        this.delegate = delegate;
        this.excludes = ImmutableSet.copyOf((Object[])excludes);
    }

    public ExcludeSerializer(Class<T> handledType, String ... excludes) {
        this(handledType, (JsonSerializer<Object>)null, excludes);
    }

    public Class<T> handledType() {
        return this.handledType;
    }

    public void serialize(T value, JsonGenerator gen, SerializerProvider serializers) throws IOException, JsonProcessingException {
        FilteringJsonGenerator filtering = new FilteringJsonGenerator(gen, null, this.excludes);
        if (value == null || this.delegate == null) {
            serializers.defaultSerializeValue(value, (JsonGenerator)filtering);
        } else {
            this.delegate.serialize(value, (JsonGenerator)filtering, serializers);
        }
    }
}

