/*
 * Decompiled with CFR 0.152.
 */
package com.arakelian.jackson.model;

import com.arakelian.core.feature.Nullable;
import com.arakelian.jackson.databind.EnumUppercaseDeserializerModifier;
import com.arakelian.jackson.databind.TrimWhitespaceDeserializer;
import com.arakelian.jackson.databind.ZonedDateTimeDeserializer;
import com.arakelian.jackson.databind.ZonedDateTimeSerializer;
import com.arakelian.jackson.model.ImmutableJackson;
import com.arakelian.jackson.utils.JsonGeneratorCallback;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.type.MapType;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.io.input.CharSequenceReader;
import org.apache.commons.lang3.StringUtils;
import org.immutables.value.Value;

@Value.Immutable
public abstract class Jackson {
    public static final SimpleModule DATE_MODULE = new SimpleModule().addSerializer((JsonSerializer)new ZonedDateTimeSerializer()).addDeserializer(ZonedDateTime.class, (JsonDeserializer)new ZonedDateTimeDeserializer());
    public static final SimpleModule ENUM_MODULE = new SimpleModule().setDeserializerModifier((BeanDeserializerModifier)new EnumUppercaseDeserializerModifier());
    public static final SimpleModule TRIM_MODULE = new SimpleModule().addDeserializer(String.class, (JsonDeserializer)TrimWhitespaceDeserializer.SINGLETON);
    private static final ObjectMapper DEFAULT_OBJECT_MAPPER = Jackson.defaultBuilder().build().getObjectMapper();

    public static ImmutableJackson.Builder defaultBuilder() {
        return ImmutableJackson.builder().locale(Locale.getDefault()).pretty(true).serializationInclusion(JsonInclude.Include.NON_EMPTY).findAndRegisterModules(true).registerTrimModule(true).registerDateModule(true).registerEnumModule(true).putMapperFeatures(MapperFeature.IGNORE_DUPLICATE_MODULE_REGISTRATIONS, true).putMapperFeatures(MapperFeature.USE_GETTERS_AS_SETTERS, false).putParserFeatures(JsonParser.Feature.ALLOW_COMMENTS, true).putParserFeatures(JsonParser.Feature.ALLOW_YAML_COMMENTS, true).putParserFeatures(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true).putParserFeatures(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true).putParserFeatures(JsonParser.Feature.ALLOW_BACKSLASH_ESCAPING_ANY_CHARACTER, true).putSerializationFeatures(SerializationFeature.WRITE_EMPTY_JSON_ARRAYS, false).putSerializationFeatures(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false).putSerializationFeatures(SerializationFeature.FAIL_ON_EMPTY_BEANS, false).putDeserializationFeatures(DeserializationFeature.FAIL_ON_READING_DUP_TREE_KEY, true).putDeserializationFeatures(DeserializationFeature.FAIL_ON_NUMBERS_FOR_ENUMS, true).putDeserializationFeatures(DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES, true).putDeserializationFeatures(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true).putGeneratorFeatures(JsonGenerator.Feature.WRITE_BIGDECIMAL_AS_PLAIN, true);
    }

    public static ImmutableJackson.Builder from(ObjectMapper mapper) {
        return ImmutableJackson.builder().defaultMapper(mapper);
    }

    public static ImmutableJackson.Builder fromDefault() {
        return Jackson.from(DEFAULT_OBJECT_MAPPER);
    }

    public static Jackson of() {
        return Jackson.fromDefault().build();
    }

    public static Jackson of(ObjectMapper mapper) {
        return Jackson.from(mapper).build();
    }

    public CharSequence buildJson(Object ... keyValues) {
        int length = keyValues.length;
        Preconditions.checkArgument((length % 2 == 0 ? 1 : 0) != 0, (Object)"Expected key-value pairs, but received array with odd number of entries");
        return this.toCharSequence(true, gen -> {
            gen.writeStartObject();
            int i = 0;
            while (i < length) {
                Object value;
                String key;
                if ((key = Objects.toString(keyValues[i++], null)) == null || (value = keyValues[i++]) == null) continue;
                gen.writeObjectField(key, value);
            }
            gen.writeEndObject();
        });
    }

    public JsonNode buildJsonNode(Object ... keyValues) {
        CharSequence json = this.buildJson(keyValues);
        try {
            return this.readValue((Reader)new CharSequenceReader(json), JsonNode.class);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public <T> T convertValue(Object value, Class<T> valueType) {
        return (T)this.getObjectMapper().convertValue(value, valueType);
    }

    public Map<String, Object> convertValueToMap(Object value) {
        return this.convertValueToMap(value, String.class, Object.class);
    }

    public <K, V> Map<K, V> convertValueToMap(Object value, Class<K> keyType, Class<V> valueType) {
        MapType type = this.mapType(LinkedHashMap.class, keyType, valueType);
        return (Map)this.getObjectMapper().convertValue(value, (JavaType)type);
    }

    public JsonGenerator createGenerator(Writer writer, boolean pretty) throws IOException {
        JsonGenerator generator = this.getObjectMapper().getFactory().createGenerator(writer);
        if (pretty) {
            return generator.useDefaultPrettyPrinter();
        }
        return generator;
    }

    private ObjectWriter createObjectWriter(Class<?> view, boolean pretty) {
        ObjectMapper mapper = this.getObjectMapper();
        if (view != null) {
            if (pretty) {
                return mapper.writerWithView(view).withDefaultPrettyPrinter();
            }
            return mapper.writerWithView(view).withoutFeatures(new SerializationFeature[]{SerializationFeature.INDENT_OUTPUT});
        }
        if (pretty) {
            return mapper.writerWithDefaultPrettyPrinter();
        }
        return mapper.writer().withoutFeatures(new SerializationFeature[]{SerializationFeature.INDENT_OUTPUT});
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public ImmutableJackson.Builder from() {
        return Jackson.from(this.getObjectMapper());
    }

    @Nullable
    @Value.Auxiliary
    public abstract ObjectMapper getDefaultMapper();

    @Value.Auxiliary
    public abstract Map<DeserializationFeature, Boolean> getDeserializationFeatures();

    @Value.Auxiliary
    public abstract Map<JsonGenerator.Feature, Boolean> getGeneratorFeatures();

    @Nullable
    public abstract Locale getLocale();

    public abstract Map<MapperFeature, Boolean> getMapperFeatures();

    @Value.Default
    public Set<Module> getModules() {
        ImmutableSet.Builder modules = ImmutableSet.builder();
        if (this.isRegisterTrimModule()) {
            modules.add((Object)TRIM_MODULE);
        }
        if (this.isRegisterEnumModule()) {
            modules.add((Object)ENUM_MODULE);
        }
        if (this.isRegisterDateModule()) {
            modules.add((Object)DATE_MODULE);
        }
        return modules.build();
    }

    @Value.Lazy
    public ObjectMapper getObjectMapper() {
        JsonInclude.Include serializationInclusion;
        ObjectMapper defaultMapper = this.getDefaultMapper();
        ObjectMapper mapper = defaultMapper != null ? defaultMapper : new ObjectMapper();
        Locale locale = this.getLocale();
        if (locale != null) {
            mapper.setLocale(locale);
        }
        Map<JsonGenerator.Feature, Boolean> features = this.getGeneratorFeatures();
        for (JsonGenerator.Feature feature : features.keySet()) {
            mapper.configure(feature, features.get(feature).booleanValue());
        }
        Map<SerializationFeature, Boolean> serializationFeatures = this.getSerializationFeatures();
        for (SerializationFeature feature : serializationFeatures.keySet()) {
            mapper.configure(feature, serializationFeatures.get(feature).booleanValue());
        }
        Boolean bl = this.isPretty();
        if (bl != null) {
            mapper.configure(SerializationFeature.INDENT_OUTPUT, bl.booleanValue());
        }
        Map<DeserializationFeature, Boolean> deserializationFeatures = this.getDeserializationFeatures();
        for (DeserializationFeature deserializationFeature : deserializationFeatures.keySet()) {
            mapper.configure(deserializationFeature, deserializationFeatures.get(deserializationFeature).booleanValue());
        }
        Map<JsonParser.Feature, Boolean> parserFeatures = this.getParserFeatures();
        for (JsonParser.Feature feature : parserFeatures.keySet()) {
            mapper.configure(feature, parserFeatures.get(feature).booleanValue());
        }
        Map<MapperFeature, Boolean> map = this.getMapperFeatures();
        for (MapperFeature feature : map.keySet()) {
            mapper.configure(feature, map.get(feature).booleanValue());
        }
        if (this.isFindAndRegisterModules()) {
            mapper.findAndRegisterModules();
        }
        for (Module module : this.getModules()) {
            mapper.registerModule(module);
        }
        Class<?> clazz = this.getView();
        if (clazz != null) {
            mapper.configure(MapperFeature.DEFAULT_VIEW_INCLUSION, this.isDefaultViewInclusion());
            mapper.setConfig(mapper.getSerializationConfig().withView(clazz));
            mapper.setConfig(mapper.getDeserializationConfig().withView(clazz));
        }
        if ((serializationInclusion = this.getSerializationInclusion()) != null) {
            mapper.setSerializationInclusion(serializationInclusion);
        }
        return mapper;
    }

    @Value.Lazy
    public ObjectWriter getObjectWriter() {
        return this.createObjectWriter(this.getView(), false);
    }

    public ObjectWriter getObjectWriter(Class<?> view, boolean pretty) {
        if (view == this.getView()) {
            if (pretty) {
                return this.getObjectWriterWithPrettyPrinter();
            }
            return this.getObjectWriter();
        }
        return this.createObjectWriter(view, pretty);
    }

    @Value.Lazy
    public ObjectWriter getObjectWriterWithPrettyPrinter() {
        return this.createObjectWriter(this.getView(), true);
    }

    public abstract Map<JsonParser.Feature, Boolean> getParserFeatures();

    public abstract Map<SerializationFeature, Boolean> getSerializationFeatures();

    @Nullable
    public abstract JsonInclude.Include getSerializationInclusion();

    @Nullable
    public abstract Class<?> getView();

    public int hashCode() {
        return super.hashCode();
    }

    @Value.Default
    public boolean isDefaultViewInclusion() {
        return true;
    }

    @Value.Default
    public boolean isFindAndRegisterModules() {
        return false;
    }

    @Nullable
    public abstract Boolean isPretty();

    @Value.Default
    public boolean isRegisterDateModule() {
        return true;
    }

    @Value.Default
    public boolean isRegisterEnumModule() {
        return true;
    }

    @Value.Default
    public boolean isRegisterTrimModule() {
        return true;
    }

    public <K, V> MapType mapType(Class<? extends Map> mapClass, Class<K> keyType, Class<V> valueType) {
        Preconditions.checkArgument((keyType != null ? 1 : 0) != 0, (Object)"keyType must be non-null");
        Preconditions.checkArgument((valueType != null ? 1 : 0) != 0, (Object)"valueType must be non-null");
        MapType type = this.getObjectMapper().getTypeFactory().constructMapType(mapClass, keyType, valueType);
        return type;
    }

    public <T> T readValue(Reader src, Class<T> valueType) throws IOException {
        return (T)this.getObjectMapper().readValue(src, valueType);
    }

    public <T> T readValue(String json, Class<T> type) throws IOException {
        return (T)(StringUtils.isEmpty((CharSequence)json) ? null : this.getObjectMapper().readValue(json, type));
    }

    public <T> T readValue(String json, JavaType valueType) throws IOException {
        return (T)(StringUtils.isEmpty((CharSequence)json) ? null : this.getObjectMapper().readValue(json, valueType));
    }

    public <T> T readValue(String json, TypeReference<T> valueType) throws IOException {
        return (T)(StringUtils.isEmpty((CharSequence)json) ? null : this.getObjectMapper().readValue(json, valueType));
    }

    public <K, V> Map<K, V> readValueAsMap(String json, Class<K> keyType, Class<V> valueType) throws IOException {
        if (StringUtils.isEmpty((CharSequence)json)) {
            return Collections.emptyMap();
        }
        MapType type = this.mapType(LinkedHashMap.class, keyType, valueType);
        return (Map)this.getObjectMapper().readValue(json, (JavaType)type);
    }

    public CharSequence toCharSequence(boolean pretty, JsonGeneratorCallback callback) throws UncheckedIOException {
        StringWriter out = new StringWriter(128);
        try (JsonGenerator gen = this.createGenerator(out, pretty);){
            callback.accept(gen);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return out.getBuffer();
    }

    public CharSequence toCharSequence(JsonGeneratorCallback callback) {
        return this.toCharSequence(true, callback);
    }

    public String toString(Object value) throws UncheckedIOException {
        if (value == null) {
            return "";
        }
        try {
            return this.getObjectMapper().writeValueAsString(value);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public String toString(Object value, boolean pretty) throws UncheckedIOException {
        if (value == null) {
            return "";
        }
        try {
            ObjectWriter w = pretty ? this.getObjectWriterWithPrettyPrinter() : this.getObjectWriter();
            return w.writeValueAsString(value);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

