/*
 * Decompiled with CFR 0.152.
 */
package com.arakelian.jq;

import com.arakelian.jq.ImmutableNativeLib;
import com.arakelian.jq.NativeLib;
import com.sun.jna.Callback;
import com.sun.jna.Function;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.Union;
import com.sun.jna.ptr.PointerByReference;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.immutables.value.Value;
import repackaged.com.arakelian.jq.com.google.common.base.Charsets;
import repackaged.com.arakelian.jq.com.google.common.base.Preconditions;
import repackaged.com.arakelian.jq.com.google.common.collect.ImmutableList;

@Value.Immutable(singleton=true)
public abstract class JqLibrary {
    private static final Logger LOGGER = Logger.getLogger(JqLibrary.class.getName());
    public static final int JV_KIND_INVALID = 0;
    public static final int JV_KIND_NULL = 1;
    public static final int JV_KIND_FALSE = 2;
    public static final int JV_KIND_TRUE = 3;
    public static final int JV_KIND_NUMBER = 4;
    public static final int JV_KIND_STRING = 5;
    public static final int JV_KIND_ARRAY = 6;
    public static final int JV_KIND_OBJECT = 7;
    public static final int JV_PARSE_SEQ = 1;
    public static final int JV_PARSE_STREAMING = 2;
    public static final int JV_PARSE_STREAM_ERRORS = 4;
    public static final int JV_PRINT_PRETTY = 1;
    public static final int JV_PRINT_ASCII = 2;
    public static final int JV_PRINT_COLOR = 4;
    public static final int JV_PRINT_SORTED = 8;
    public static final int JV_PRINT_INVALID = 16;
    public static final int JV_PRINT_REFCOUNT = 32;
    public static final int JV_PRINT_TAB = 64;
    public static final int JV_PRINT_ISATTY = 128;
    public static final int JV_PRINT_SPACE0 = 256;
    public static final int JV_PRINT_SPACE1 = 512;
    public static final int JV_PRINT_SPACE2 = 1024;
    public static final Object[] NO_ARGS = new Object[0];

    @Value.Auxiliary
    public Function getJqCompile() {
        return this.getLoader().getNativeLibrary().getFunction("jq_compile");
    }

    @Value.Auxiliary
    public Function getJqCompileArgs() {
        return this.getLoader().getNativeLibrary().getFunction("jq_compile_args");
    }

    @Value.Auxiliary
    public Function getJqInit() {
        return this.getLoader().getNativeLibrary().getFunction("jq_init");
    }

    @Value.Auxiliary
    public Function getJqNext() {
        return this.getLoader().getNativeLibrary().getFunction("jq_next");
    }

    @Value.Auxiliary
    public Function getJqSetAttr() {
        return this.getLoader().getNativeLibrary().getFunction("jq_set_attr");
    }

    @Value.Auxiliary
    public Function getJqSetErrorCb() {
        return this.getLoader().getNativeLibrary().getFunction("jq_set_error_cb");
    }

    @Value.Auxiliary
    public Function getJqStart() {
        return this.getLoader().getNativeLibrary().getFunction("jq_start");
    }

    @Value.Auxiliary
    public Function getJqTeardown() {
        return this.getLoader().getNativeLibrary().getFunction("jq_teardown");
    }

    @Value.Auxiliary
    public Function getJvArray() {
        return this.getLoader().getNativeLibrary().getFunction("jv_array");
    }

    @Value.Auxiliary
    public Function getJvArrayAppend() {
        return this.getLoader().getNativeLibrary().getFunction("jv_array_append");
    }

    @Value.Auxiliary
    public Function getJvArrayConcat() {
        return this.getLoader().getNativeLibrary().getFunction("jv_array_concat");
    }

    @Value.Auxiliary
    public Function getJvCopy() {
        return this.getLoader().getNativeLibrary().getFunction("jv_copy");
    }

    @Value.Auxiliary
    public Function getJvDumpString() {
        return this.getLoader().getNativeLibrary().getFunction("jv_dump_string");
    }

    @Value.Auxiliary
    public Function getJvFree() {
        return this.getLoader().getNativeLibrary().getFunction("jv_free");
    }

    @Value.Auxiliary
    public Function getJvGetKind() {
        return this.getLoader().getNativeLibrary().getFunction("jv_get_kind");
    }

    @Value.Auxiliary
    public Function getJvInvalidGetMsg() {
        return this.getLoader().getNativeLibrary().getFunction("jv_invalid_get_msg");
    }

    @Value.Auxiliary
    public Function getJvInvalidHasMsg() {
        return this.getLoader().getNativeLibrary().getFunction("jv_invalid_has_msg");
    }

    @Value.Auxiliary
    public Function getJvObject() {
        return this.getLoader().getNativeLibrary().getFunction("jv_object");
    }

    @Value.Auxiliary
    public Function getJvObjectHas() {
        return this.getLoader().getNativeLibrary().getFunction("jv_object_has");
    }

    @Value.Auxiliary
    public Function getJvObjectSet() {
        return this.getLoader().getNativeLibrary().getFunction("jv_object_set");
    }

    @Value.Auxiliary
    public Function getJvParse() {
        return this.getLoader().getNativeLibrary().getFunction("jv_parse");
    }

    @Value.Auxiliary
    public Function getJvParserFree() {
        return this.getLoader().getNativeLibrary().getFunction("jv_parser_free");
    }

    @Value.Auxiliary
    public Function getJvParserNew() {
        return this.getLoader().getNativeLibrary().getFunction("jv_parser_new");
    }

    @Value.Auxiliary
    public Function getJvParserNext() {
        return this.getLoader().getNativeLibrary().getFunction("jv_parser_next");
    }

    @Value.Auxiliary
    public Function getJvParserSetBuf() {
        return this.getLoader().getNativeLibrary().getFunction("jv_parser_set_buf");
    }

    @Value.Auxiliary
    public Function getJvString() {
        return this.getLoader().getNativeLibrary().getFunction("jv_string");
    }

    @Value.Auxiliary
    public Function getJvStringValue() {
        return this.getLoader().getNativeLibrary().getFunction("jv_string_value");
    }

    @Value.Lazy
    @Value.Auxiliary
    public NativeLib getLoader() {
        ImmutableNativeLib jq = ImmutableNativeLib.builder().name("jq").build();
        Preconditions.checkState(jq.getNativeLibrary() != null, "Cannot load JQ library");
        LOGGER.log(Level.INFO, "Loaded {0}", new Object[]{jq.getLocalCopy()});
        return jq;
    }

    public boolean jq_compile(Pointer jq, String filter) {
        return this.getJqCompile().invokeInt(new Object[]{jq, filter}) != 0;
    }

    public boolean jq_compile_args(Pointer jq, String filter, Jv args) {
        return this.getJqCompileArgs().invokeInt(new Object[]{jq, filter, args}) != 0;
    }

    public Pointer jq_init() {
        return (Pointer)this.getJqInit().invoke(Pointer.class, NO_ARGS);
    }

    public Jv jq_next(Pointer jq) {
        return (Jv)this.getJqNext().invoke(Jv.class, new Object[]{jq});
    }

    public void jq_set_attr(Pointer jq, Jv name, Jv value) {
        this.getJqSetAttr().invoke(new Object[]{jq, name, value});
    }

    public void jq_set_error_cb(Pointer jq, ErrorCallback callback, Pointer data) {
        this.getJqSetErrorCb().invoke(new Object[]{jq, callback, data});
    }

    public void jq_start(Pointer jq, Jv jv) {
        this.getJqStart().invoke(new Object[]{jq, jv, 0});
    }

    public void jq_teardown(Pointer jq) {
        PointerByReference ref = new PointerByReference(jq);
        this.getJqTeardown().invoke(new Object[]{ref});
    }

    public Jv jv_array() {
        return (Jv)this.getJvArray().invoke(Jv.class, new Object[0]);
    }

    public Jv jv_array_append(Jv array, Jv value) {
        return (Jv)this.getJvArrayAppend().invoke(Jv.class, new Object[]{array, value});
    }

    public Jv jv_array_concat(Jv array, Jv anotherArray) {
        return (Jv)this.getJvArrayConcat().invoke(Jv.class, new Object[]{array, anotherArray});
    }

    public Jv jv_copy(Jv jv) {
        return (Jv)this.getJvCopy().invoke(Jv.class, new Object[]{jv});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String jv_dump_string(Jv next, int flags) {
        Jv dumped = (Jv)this.getJvDumpString().invoke(Jv.class, new Object[]{next, flags});
        try {
            String string = this.jv_string_value(dumped);
            return string;
        }
        finally {
            this.jv_free(dumped);
        }
    }

    public void jv_free(Jv jv) {
        this.getJvFree().invoke(new Object[]{jv});
    }

    public int jv_get_kind(Jv jv) {
        return this.getJvGetKind().invokeInt(new Object[]{jv});
    }

    public Jv jv_invalid_get_msg(Jv jv) {
        return (Jv)this.getJvInvalidGetMsg().invoke(Jv.class, new Object[]{jv});
    }

    public boolean jv_invalid_has_msg(Jv jv) {
        return this.getJvInvalidHasMsg().invokeInt(new Object[]{jv}) != 0;
    }

    public final boolean jv_is_valid(Jv jv) {
        int kind = this.getJvGetKind().invokeInt(new Object[]{jv});
        return kind != 0;
    }

    public Jv jv_object() {
        return (Jv)this.getJvObject().invoke(Jv.class, new Object[0]);
    }

    public boolean jv_object_has(Jv object, Jv key) {
        int has = this.getJvObjectHas().invokeInt(new Object[]{object, key});
        return has != 0;
    }

    public Jv jv_object_set(Jv object, Jv key, Jv value) {
        return (Jv)this.getJvObjectSet().invoke(Jv.class, new Object[]{object, key, value});
    }

    public Jv jv_parse(String json) {
        return (Jv)this.getJvParse().invoke(Jv.class, new Object[]{json});
    }

    public void jv_parser_free(Pointer parser) {
        this.getJvParserFree().invoke(new Object[]{parser});
    }

    public Pointer jv_parser_new(int flags) {
        return (Pointer)this.getJvParserNew().invoke(Pointer.class, new Object[]{flags});
    }

    public Jv jv_parser_next(Pointer parser) {
        return (Jv)this.getJvParserNext().invoke(Jv.class, new Object[]{parser});
    }

    public void jv_parser_set_buf(Pointer parser, Pointer pointer, int length, boolean finished) {
        this.getJvParserSetBuf().invoke(new Object[]{parser, pointer, length, finished ? 0 : 1});
    }

    public Jv jv_string(String value) {
        return (Jv)this.getJvString().invoke(Jv.class, new Object[]{value});
    }

    public String jv_string_value(Jv jv) {
        Pointer result = (Pointer)this.getJvStringValue().invoke(Pointer.class, new Object[]{jv});
        String error = result.getString(0L, Charsets.UTF_8.name());
        return error;
    }

    public static class JvRefCount
    extends Structure
    implements Structure.ByReference {
        public int count;

        @Override
        protected List<String> getFieldOrder() {
            return ImmutableList.of("count");
        }
    }

    public static class Jv
    extends Structure
    implements Structure.ByValue {
        public byte kind_flags;
        public byte pad_;
        public short offset;
        public int size;
        public U u;

        @Override
        protected List<String> getFieldOrder() {
            return ImmutableList.of("kind_flags", "pad_", "offset", "size", "u");
        }

        public static class U
        extends Union {
            public JvRefCount ptr;
            public double number;
        }
    }

    public static interface ErrorCallback
    extends Callback {
        public void callback(Pointer var1, Jv var2);
    }
}

