/*
 * Decompiled with CFR 0.152.
 */
package com.arakelian.jq;

import com.arakelian.jq.ImmutableJqResponse;
import com.arakelian.jq.JqLibrary;
import com.arakelian.jq.JqResponse;
import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.immutables.value.Value;
import repackaged.com.arakelian.jq.com.google.common.base.Charsets;
import repackaged.com.arakelian.jq.com.google.common.base.Preconditions;
import repackaged.com.arakelian.jq.com.google.common.collect.ImmutableMap;

@Value.Immutable
public abstract class JqRequest {
    private static final Logger LOGGER = Logger.getLogger(JqRequest.class.getName());
    private static final ReentrantLock SYNC = new ReentrantLock();

    public final JqResponse execute() {
        SYNC.lock();
        try {
            JqResponse jqResponse = this.jq();
            return jqResponse;
        }
        finally {
            SYNC.unlock();
        }
    }

    @Value.Default
    public Map<String, String> getArgJson() {
        return ImmutableMap.of();
    }

    @Value.Derived
    @Value.Auxiliary
    public int getDumpFlags() {
        int flags = 0;
        if (this.isPretty()) {
            flags |= 1;
        }
        switch (this.getIndent()) {
            case TAB: {
                flags = 64;
                break;
            }
            case SPACE: {
                flags = 512;
                break;
            }
            case TWO_SPACES: {
                flags = 1024;
                break;
            }
        }
        if (this.isSortKeys()) {
            flags |= 8;
        }
        return flags;
    }

    @Value.Default
    public String getFilter() {
        return ".";
    }

    @Value.Default
    public Indent getIndent() {
        return Indent.TWO_SPACES;
    }

    public abstract String getInput();

    public abstract JqLibrary getLib();

    public abstract List<File> getModulePaths();

    @Value.Default
    public String getStreamSeparator() {
        return "\n";
    }

    @Value.Default
    public boolean isPretty() {
        return true;
    }

    @Value.Default
    public boolean isSortKeys() {
        return false;
    }

    private String getInvalidMessage(JqLibrary.Jv value) {
        JqLibrary.Jv copy = this.getLib().jv_copy(value);
        if (this.getLib().jv_invalid_has_msg(copy)) {
            JqLibrary.Jv message = this.getLib().jv_invalid_get_msg(value);
            return this.getLib().jv_string_value(message);
        }
        this.getLib().jv_free(value);
        return null;
    }

    private boolean isValid(ImmutableJqResponse.Builder response, JqLibrary.Jv value) {
        if (this.getLib().jv_is_valid(value)) {
            return true;
        }
        String message = this.getInvalidMessage(value);
        if (message != null) {
            response.addError(message);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JqResponse jq() {
        LOGGER.log(Level.FINE, "Initializing JQ");
        JqLibrary lib = this.getLib();
        Pointer jq = lib.jq_init();
        Preconditions.checkState(jq != null, "jq must be non-null");
        JqLibrary.Jv moduleDirs = lib.jv_array();
        for (File file : this.getModulePaths()) {
            try {
                String dir = file.getCanonicalPath();
                LOGGER.log(Level.FINE, "Using module path: " + dir);
                moduleDirs = lib.jv_array_append(moduleDirs, lib.jv_string(dir));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        lib.jq_set_attr(jq, lib.jv_string("JQ_LIBRARY_PATH"), moduleDirs);
        try {
            JqResponse response = this.parse(jq);
            LOGGER.log(Level.FINE, "Response ready");
            JqResponse jqResponse = response;
            return jqResponse;
        }
        finally {
            LOGGER.log(Level.FINE, "Releasing JQ");
            lib.jq_teardown(jq);
            LOGGER.log(Level.FINE, "JQ released successfully");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JqResponse parse(Pointer jq) {
        ImmutableJqResponse.Builder response = ImmutableJqResponse.builder();
        LOGGER.log(Level.FINE, "Configuring callback");
        JqLibrary lib = this.getLib();
        lib.jq_set_error_cb(jq, (data, jv) -> {
            LOGGER.log(Level.FINE, "Error callback");
            int kind = lib.jv_get_kind(jv);
            if (kind == 5) {
                String error = lib.jv_string_value(jv).replaceAll("\\s++$", "");
                response.addError(error);
            }
        }, new Pointer(0L));
        JqLibrary.Jv args = lib.jv_object();
        Map<String, String> argJson = this.getArgJson();
        for (String string : argJson.keySet()) {
            String text = argJson.get(string);
            JqLibrary.Jv json = lib.jv_parse(text);
            if (!lib.jv_is_valid(json)) {
                response.addError("Invalid JSON text passed to --argjson (name: " + string + ")");
                return response.build();
            }
            args = lib.jv_object_set(args, lib.jv_string(string), json);
        }
        try {
            LOGGER.log(Level.FINE, "Compiling filter");
            String filter = this.getFilter();
            if (!lib.jq_compile_args(jq, filter, lib.jv_copy(args))) {
                LOGGER.log(Level.FINE, "Compilation failed");
                ImmutableJqResponse immutableJqResponse = response.build();
                return immutableJqResponse;
            }
            LOGGER.log(Level.FINE, "Creating parse");
            boolean bl = false;
            Pointer parser = lib.jv_parser_new(0);
            try {
                this.parse(jq, parser, this.getInput(), response);
                ImmutableJqResponse immutableJqResponse = response.build();
                LOGGER.log(Level.FINE, "Releasing parser");
                lib.jv_parser_free(parser);
                return immutableJqResponse;
            }
            catch (Throwable throwable) {
                LOGGER.log(Level.FINE, "Releasing parser");
                lib.jv_parser_free(parser);
                throw throwable;
            }
        }
        finally {
            LOGGER.log(Level.FINE, "Releasing callback");
            lib.jq_set_error_cb(jq, null, null);
        }
    }

    private void parse(Pointer jq, Pointer parser, String text, ImmutableJqResponse.Builder response) {
        byte[] input = text.getBytes(Charsets.UTF_8);
        Memory memory = new Memory(input.length);
        memory.write(0L, input, 0, input.length);
        LOGGER.log(Level.FINE, "Sending text to parser");
        this.getLib().jv_parser_set_buf(parser, memory, input.length, true);
        int flags = this.getDumpFlags();
        StringBuilder buf = new StringBuilder();
        block0: while (true) {
            LOGGER.log(Level.FINE, "Parsing text");
            JqLibrary.Jv parsed = this.getLib().jv_parser_next(parser);
            if (!this.isValid(response, parsed)) break;
            LOGGER.log(Level.FINE, "Consuming JQ response");
            this.getLib().jq_start(jq, parsed);
            while (true) {
                JqLibrary.Jv next;
                if (!this.isValid(response, next = this.getLib().jq_next(jq))) continue block0;
                LOGGER.log(Level.FINE, "Dumping response");
                String out = this.getLib().jv_dump_string(next, flags);
                if (buf.length() != 0) {
                    buf.append(this.getStreamSeparator());
                }
                buf.append(out);
            }
            break;
        }
        LOGGER.log(Level.FINE, "Finishing with parser");
        String output = buf.toString();
        response.output(output);
    }

    public static enum Indent {
        NONE,
        TAB,
        SPACE,
        TWO_SPACES;

    }
}

