/*
 * Decompiled with CFR 0.152.
 */
package com.arakelian.jq;

import com.sun.jna.NativeLibrary;
import com.sun.jna.Platform;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.immutables.value.Value;
import repackaged.com.arakelian.jq.com.google.common.base.Preconditions;
import repackaged.com.arakelian.jq.com.google.common.collect.ImmutableList;
import repackaged.com.arakelian.jq.com.google.common.io.Files;

@Value.Immutable(copy=false)
public abstract class NativeLib {
    private static final Logger LOGGER = Logger.getLogger(NativeLib.class.getName());

    @Value.Derived
    @Value.Auxiliary
    public String getArchitecture() {
        return this.getOsName() + ":" + this.getOsArch();
    }

    @Value.Default
    @Value.Auxiliary
    public List<String> getDependencies() {
        return ImmutableList.of();
    }

    @Value.Derived
    public List<String> getFilenames() {
        ImmutableList.Builder builder = ImmutableList.builder();
        String name = this.getName();
        if (Platform.isWindows()) {
            builder.add(name + ".dll");
        } else if (Platform.isLinux()) {
            builder.add("lib" + name + ".so");
        } else if (Platform.isMac()) {
            builder.add("lib" + name + ".dylib");
        } else {
            throw new IllegalStateException("Unsupported architecture: " + this.getArchitecture());
        }
        for (String dependency : this.getDependencies()) {
            builder.add(dependency);
        }
        return builder.build();
    }

    @Value.Lazy
    @Value.Auxiliary
    public File getLocalCopy() throws UncheckedIOException {
        File tmpdir = this.getTemporaryFolder();
        for (String filename : this.getFilenames()) {
            try {
                File local = new File(tmpdir, filename);
                String resource = "lib/" + this.getPath() + filename;
                LOGGER.log(Level.INFO, "Copying resource {0} to: {1}", new Object[]{resource, local});
                InputStream in = this.getClass().getClassLoader().getResourceAsStream(resource);
                try (FileOutputStream out = new FileOutputStream(local);){
                    int n;
                    Preconditions.checkState(in != null, "Cannot find resource %s", resource);
                    byte[] buf = new byte[0x100000];
                    while (-1 != (n = in.read(buf))) {
                        ((OutputStream)out).write(buf, 0, n);
                    }
                }
                finally {
                    if (in == null) continue;
                    in.close();
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException("Unable to copy library " + filename + " to temporary folder " + tmpdir, e);
            }
        }
        return tmpdir;
    }

    public abstract String getName();

    @Value.Lazy
    @Value.Auxiliary
    public NativeLibrary getNativeLibrary() throws UncheckedIOException {
        String name = this.getName();
        File libPath = this.getLocalCopy();
        LOGGER.log(Level.INFO, "{0} library path: {1}", new Object[]{name, libPath});
        NativeLibrary.addSearchPath(name, libPath.getAbsolutePath());
        NativeLibrary instance = NativeLibrary.getInstance(name);
        LOGGER.log(Level.INFO, "{0} loaded from path: {1} ", new Object[]{name, libPath});
        return instance;
    }

    @Value.Derived
    public String getOsArch() {
        String arch = System.getProperty("os.arch");
        return arch != null ? arch.toLowerCase() : "";
    }

    @Value.Derived
    public String getOsName() {
        String name = System.getProperty("os.name");
        return name != null ? name.toLowerCase() : "";
    }

    @Value.Derived
    public String getPath() {
        String osArch = this.getOsArch();
        if (Platform.isWindows()) {
            if ("x86".equalsIgnoreCase(osArch)) {
                return "win-x86/";
            }
        } else if (Platform.isLinux()) {
            if ("amd64".equalsIgnoreCase(osArch)) {
                return "linux-x86_64/";
            }
            if ("ia64".equalsIgnoreCase(osArch)) {
                return "linux-ia64/";
            }
            if ("i386".equalsIgnoreCase(osArch)) {
                return "linux-x86/";
            }
        } else if (Platform.isMac() && "x86_64".equalsIgnoreCase("x86_64")) {
            return "darwin-x86_64/";
        }
        throw new IllegalStateException("Unsupported architecture: " + this.getArchitecture());
    }

    @Value.Default
    @Value.Auxiliary
    public File getTemporaryFolder() throws UncheckedIOException {
        File tmpdir = Files.createTempDir();
        return tmpdir;
    }
}

