/*
 * Decompiled with CFR 0.152.
 */
package com.arakelian.jq;

import com.arakelian.jq.JqLibrary;
import com.arakelian.jq.JqRequest;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="JqRequest", generator="Immutables")
@Immutable
public final class ImmutableJqRequest
extends JqRequest {
    private final ImmutableMap<String, String> argJson;
    private final transient int dumpFlags;
    private final String filter;
    private final JqRequest.Indent indent;
    private final String input;
    private final JqLibrary lib;
    private final ImmutableList<File> modulePaths;
    private final String streamSeparator;
    private final boolean pretty;
    private final boolean sortKeys;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableJqRequest(Builder builder) {
        this.input = builder.input;
        this.lib = builder.lib;
        this.modulePaths = builder.modulePaths.build();
        if (builder.argJsonIsSet()) {
            this.initShim.argJson((ImmutableMap<String, String>)builder.argJson.build());
        }
        if (builder.filter != null) {
            this.initShim.filter(builder.filter);
        }
        if (builder.indent != null) {
            this.initShim.indent(builder.indent);
        }
        if (builder.streamSeparator != null) {
            this.initShim.streamSeparator(builder.streamSeparator);
        }
        if (builder.prettyIsSet()) {
            this.initShim.pretty(builder.pretty);
        }
        if (builder.sortKeysIsSet()) {
            this.initShim.sortKeys(builder.sortKeys);
        }
        this.argJson = this.initShim.getArgJson();
        this.dumpFlags = this.initShim.getDumpFlags();
        this.filter = this.initShim.getFilter();
        this.indent = this.initShim.getIndent();
        this.streamSeparator = this.initShim.getStreamSeparator();
        this.pretty = this.initShim.isPretty();
        this.sortKeys = this.initShim.isSortKeys();
        this.initShim = null;
    }

    private ImmutableJqRequest(ImmutableMap<String, String> argJson, String filter, JqRequest.Indent indent, String input, JqLibrary lib, ImmutableList<File> modulePaths, String streamSeparator, boolean pretty, boolean sortKeys) {
        this.initShim.argJson(argJson);
        this.initShim.filter(filter);
        this.initShim.indent(indent);
        this.input = input;
        this.lib = lib;
        this.modulePaths = modulePaths;
        this.initShim.streamSeparator(streamSeparator);
        this.initShim.pretty(pretty);
        this.initShim.sortKeys(sortKeys);
        this.argJson = this.initShim.getArgJson();
        this.dumpFlags = this.initShim.getDumpFlags();
        this.filter = this.initShim.getFilter();
        this.indent = this.initShim.getIndent();
        this.streamSeparator = this.initShim.getStreamSeparator();
        this.pretty = this.initShim.isPretty();
        this.sortKeys = this.initShim.isSortKeys();
        this.initShim = null;
    }

    public ImmutableMap<String, String> getArgJson() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getArgJson() : this.argJson;
    }

    @Override
    public int getDumpFlags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getDumpFlags() : this.dumpFlags;
    }

    @Override
    public String getFilter() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getFilter() : this.filter;
    }

    @Override
    public JqRequest.Indent getIndent() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getIndent() : this.indent;
    }

    @Override
    public String getInput() {
        return this.input;
    }

    @Override
    public JqLibrary getLib() {
        return this.lib;
    }

    public ImmutableList<File> getModulePaths() {
        return this.modulePaths;
    }

    @Override
    public String getStreamSeparator() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getStreamSeparator() : this.streamSeparator;
    }

    @Override
    public boolean isPretty() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isPretty() : this.pretty;
    }

    @Override
    public boolean isSortKeys() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isSortKeys() : this.sortKeys;
    }

    public final ImmutableJqRequest withArgJson(Map<String, ? extends String> entries) {
        if (this.argJson == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new ImmutableJqRequest((ImmutableMap<String, String>)newValue, this.filter, this.indent, this.input, this.lib, this.modulePaths, this.streamSeparator, this.pretty, this.sortKeys);
    }

    public final ImmutableJqRequest withFilter(String value) {
        String newValue = Objects.requireNonNull(value, "filter");
        if (this.filter.equals(newValue)) {
            return this;
        }
        return new ImmutableJqRequest(this.argJson, newValue, this.indent, this.input, this.lib, this.modulePaths, this.streamSeparator, this.pretty, this.sortKeys);
    }

    public final ImmutableJqRequest withIndent(JqRequest.Indent value) {
        JqRequest.Indent newValue = Objects.requireNonNull(value, "indent");
        if (this.indent == newValue) {
            return this;
        }
        return new ImmutableJqRequest(this.argJson, this.filter, newValue, this.input, this.lib, this.modulePaths, this.streamSeparator, this.pretty, this.sortKeys);
    }

    public final ImmutableJqRequest withInput(String value) {
        String newValue = Objects.requireNonNull(value, "input");
        if (this.input.equals(newValue)) {
            return this;
        }
        return new ImmutableJqRequest(this.argJson, this.filter, this.indent, newValue, this.lib, this.modulePaths, this.streamSeparator, this.pretty, this.sortKeys);
    }

    public final ImmutableJqRequest withLib(JqLibrary value) {
        if (this.lib == value) {
            return this;
        }
        JqLibrary newValue = Objects.requireNonNull(value, "lib");
        return new ImmutableJqRequest(this.argJson, this.filter, this.indent, this.input, newValue, this.modulePaths, this.streamSeparator, this.pretty, this.sortKeys);
    }

    public final ImmutableJqRequest withModulePaths(File ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableJqRequest(this.argJson, this.filter, this.indent, this.input, this.lib, (ImmutableList<File>)newValue, this.streamSeparator, this.pretty, this.sortKeys);
    }

    public final ImmutableJqRequest withModulePaths(Iterable<? extends File> elements) {
        if (this.modulePaths == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableJqRequest(this.argJson, this.filter, this.indent, this.input, this.lib, (ImmutableList<File>)newValue, this.streamSeparator, this.pretty, this.sortKeys);
    }

    public final ImmutableJqRequest withStreamSeparator(String value) {
        String newValue = Objects.requireNonNull(value, "streamSeparator");
        if (this.streamSeparator.equals(newValue)) {
            return this;
        }
        return new ImmutableJqRequest(this.argJson, this.filter, this.indent, this.input, this.lib, this.modulePaths, newValue, this.pretty, this.sortKeys);
    }

    public final ImmutableJqRequest withPretty(boolean value) {
        if (this.pretty == value) {
            return this;
        }
        return new ImmutableJqRequest(this.argJson, this.filter, this.indent, this.input, this.lib, this.modulePaths, this.streamSeparator, value, this.sortKeys);
    }

    public final ImmutableJqRequest withSortKeys(boolean value) {
        if (this.sortKeys == value) {
            return this;
        }
        return new ImmutableJqRequest(this.argJson, this.filter, this.indent, this.input, this.lib, this.modulePaths, this.streamSeparator, this.pretty, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableJqRequest && this.equalTo(0, (ImmutableJqRequest)another);
    }

    private boolean equalTo(int synthetic, ImmutableJqRequest another) {
        return this.argJson.equals(another.argJson) && this.filter.equals(another.filter) && this.indent.equals((Object)another.indent) && this.input.equals(another.input) && this.lib.equals(another.lib) && this.modulePaths.equals(another.modulePaths) && this.streamSeparator.equals(another.streamSeparator) && this.pretty == another.pretty && this.sortKeys == another.sortKeys;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.argJson.hashCode();
        h += (h << 5) + this.filter.hashCode();
        h += (h << 5) + this.indent.hashCode();
        h += (h << 5) + this.input.hashCode();
        h += (h << 5) + this.lib.hashCode();
        h += (h << 5) + this.modulePaths.hashCode();
        h += (h << 5) + this.streamSeparator.hashCode();
        h += (h << 5) + Booleans.hashCode((boolean)this.pretty);
        h += (h << 5) + Booleans.hashCode((boolean)this.sortKeys);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"JqRequest").omitNullValues().add("argJson", this.argJson).add("filter", (Object)this.filter).add("indent", (Object)this.indent).add("input", (Object)this.input).add("lib", (Object)this.lib).add("modulePaths", this.modulePaths).add("streamSeparator", (Object)this.streamSeparator).add("pretty", this.pretty).add("sortKeys", this.sortKeys).toString();
    }

    public static ImmutableJqRequest copyOf(JqRequest instance) {
        if (instance instanceof ImmutableJqRequest) {
            return (ImmutableJqRequest)instance;
        }
        return ImmutableJqRequest.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="JqRequest", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_INPUT = 1L;
        private static final long INIT_BIT_LIB = 2L;
        private static final long OPT_BIT_ARG_JSON = 1L;
        private static final long OPT_BIT_PRETTY = 2L;
        private static final long OPT_BIT_SORT_KEYS = 4L;
        private long initBits = 3L;
        private long optBits;
        private ImmutableMap.Builder<String, String> argJson = ImmutableMap.builder();
        @Nullable
        private String filter;
        @Nullable
        private JqRequest.Indent indent;
        @Nullable
        private String input;
        @Nullable
        private JqLibrary lib;
        private ImmutableList.Builder<File> modulePaths = ImmutableList.builder();
        @Nullable
        private String streamSeparator;
        private boolean pretty;
        private boolean sortKeys;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(JqRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.putAllArgJson(instance.getArgJson());
            this.filter(instance.getFilter());
            this.indent(instance.getIndent());
            this.input(instance.getInput());
            this.lib(instance.getLib());
            this.addAllModulePaths(instance.getModulePaths());
            this.streamSeparator(instance.getStreamSeparator());
            this.pretty(instance.isPretty());
            this.sortKeys(instance.isSortKeys());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putArgJson(String key, String value) {
            this.argJson.put((Object)key, (Object)value);
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putArgJson(Map.Entry<String, ? extends String> entry) {
            this.argJson.put(entry);
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder argJson(Map<String, ? extends String> entries) {
            this.argJson = ImmutableMap.builder();
            this.optBits |= 1L;
            return this.putAllArgJson(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllArgJson(Map<String, ? extends String> entries) {
            this.argJson.putAll(entries);
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder filter(String filter) {
            this.filter = Objects.requireNonNull(filter, "filter");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder indent(JqRequest.Indent indent) {
            this.indent = Objects.requireNonNull(indent, "indent");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder input(String input) {
            this.input = Objects.requireNonNull(input, "input");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder lib(JqLibrary lib) {
            this.lib = Objects.requireNonNull(lib, "lib");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addModulePath(File element) {
            this.modulePaths.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addModulePaths(File ... elements) {
            this.modulePaths.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder modulePaths(Iterable<? extends File> elements) {
            this.modulePaths = ImmutableList.builder();
            return this.addAllModulePaths(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllModulePaths(Iterable<? extends File> elements) {
            this.modulePaths.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder streamSeparator(String streamSeparator) {
            this.streamSeparator = Objects.requireNonNull(streamSeparator, "streamSeparator");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder pretty(boolean pretty) {
            this.pretty = pretty;
            this.optBits |= 2L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder sortKeys(boolean sortKeys) {
            this.sortKeys = sortKeys;
            this.optBits |= 4L;
            return this;
        }

        public ImmutableJqRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableJqRequest(this);
        }

        private boolean argJsonIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean prettyIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean sortKeysIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("input");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("lib");
            }
            return "Cannot build JqRequest, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="JqRequest", generator="Immutables")
    private final class InitShim {
        private byte argJsonBuildStage = 0;
        private ImmutableMap<String, String> argJson;
        private byte dumpFlagsBuildStage = 0;
        private int dumpFlags;
        private byte filterBuildStage = 0;
        private String filter;
        private byte indentBuildStage = 0;
        private JqRequest.Indent indent;
        private byte streamSeparatorBuildStage = 0;
        private String streamSeparator;
        private byte prettyBuildStage = 0;
        private boolean pretty;
        private byte sortKeysBuildStage = 0;
        private boolean sortKeys;

        private InitShim() {
        }

        ImmutableMap<String, String> getArgJson() {
            if (this.argJsonBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.argJsonBuildStage == 0) {
                this.argJsonBuildStage = (byte)-1;
                this.argJson = ImmutableMap.copyOf((Map)ImmutableJqRequest.super.getArgJson());
                this.argJsonBuildStage = 1;
            }
            return this.argJson;
        }

        void argJson(ImmutableMap<String, String> argJson) {
            this.argJson = argJson;
            this.argJsonBuildStage = 1;
        }

        int getDumpFlags() {
            if (this.dumpFlagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.dumpFlagsBuildStage == 0) {
                this.dumpFlagsBuildStage = (byte)-1;
                this.dumpFlags = ImmutableJqRequest.super.getDumpFlags();
                this.dumpFlagsBuildStage = 1;
            }
            return this.dumpFlags;
        }

        String getFilter() {
            if (this.filterBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.filterBuildStage == 0) {
                this.filterBuildStage = (byte)-1;
                this.filter = Objects.requireNonNull(ImmutableJqRequest.super.getFilter(), "filter");
                this.filterBuildStage = 1;
            }
            return this.filter;
        }

        void filter(String filter) {
            this.filter = filter;
            this.filterBuildStage = 1;
        }

        JqRequest.Indent getIndent() {
            if (this.indentBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.indentBuildStage == 0) {
                this.indentBuildStage = (byte)-1;
                this.indent = Objects.requireNonNull(ImmutableJqRequest.super.getIndent(), "indent");
                this.indentBuildStage = 1;
            }
            return this.indent;
        }

        void indent(JqRequest.Indent indent) {
            this.indent = indent;
            this.indentBuildStage = 1;
        }

        String getStreamSeparator() {
            if (this.streamSeparatorBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.streamSeparatorBuildStage == 0) {
                this.streamSeparatorBuildStage = (byte)-1;
                this.streamSeparator = Objects.requireNonNull(ImmutableJqRequest.super.getStreamSeparator(), "streamSeparator");
                this.streamSeparatorBuildStage = 1;
            }
            return this.streamSeparator;
        }

        void streamSeparator(String streamSeparator) {
            this.streamSeparator = streamSeparator;
            this.streamSeparatorBuildStage = 1;
        }

        boolean isPretty() {
            if (this.prettyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.prettyBuildStage == 0) {
                this.prettyBuildStage = (byte)-1;
                this.pretty = ImmutableJqRequest.super.isPretty();
                this.prettyBuildStage = 1;
            }
            return this.pretty;
        }

        void pretty(boolean pretty) {
            this.pretty = pretty;
            this.prettyBuildStage = 1;
        }

        boolean isSortKeys() {
            if (this.sortKeysBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.sortKeysBuildStage == 0) {
                this.sortKeysBuildStage = (byte)-1;
                this.sortKeys = ImmutableJqRequest.super.isSortKeys();
                this.sortKeysBuildStage = 1;
            }
            return this.sortKeys;
        }

        void sortKeys(boolean sortKeys) {
            this.sortKeys = sortKeys;
            this.sortKeysBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.argJsonBuildStage == -1) {
                attributes.add("argJson");
            }
            if (this.dumpFlagsBuildStage == -1) {
                attributes.add("dumpFlags");
            }
            if (this.filterBuildStage == -1) {
                attributes.add("filter");
            }
            if (this.indentBuildStage == -1) {
                attributes.add("indent");
            }
            if (this.streamSeparatorBuildStage == -1) {
                attributes.add("streamSeparator");
            }
            if (this.prettyBuildStage == -1) {
                attributes.add("pretty");
            }
            if (this.sortKeysBuildStage == -1) {
                attributes.add("sortKeys");
            }
            return "Cannot build JqRequest, attribute initializers form cycle " + attributes;
        }
    }
}

