/*
 * Decompiled with CFR 0.152.
 */
package com.arakelian.jq;

import com.arakelian.jq.NativeLib;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.sun.jna.NativeLibrary;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="NativeLib", generator="Immutables")
@Immutable
public final class ImmutableNativeLib
extends NativeLib {
    private final transient String architecture;
    private final ImmutableList<String> dependencies;
    private final transient List<String> filenames;
    private final String name;
    private final transient String osArch;
    private final transient String osName;
    private final transient String path;
    private final File temporaryFolder;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();
    private volatile transient long lazyInitBitmap;
    private static final long LOCAL_COPY_LAZY_INIT_BIT = 1L;
    private transient File localCopy;
    private static final long NATIVE_LIBRARY_LAZY_INIT_BIT = 2L;
    private transient NativeLibrary nativeLibrary;

    private ImmutableNativeLib(Builder builder) {
        this.name = builder.name;
        if (builder.dependenciesIsSet()) {
            this.initShim.dependencies((ImmutableList<String>)builder.dependencies.build());
        }
        if (builder.temporaryFolder != null) {
            this.initShim.temporaryFolder(builder.temporaryFolder);
        }
        this.architecture = this.initShim.getArchitecture();
        this.dependencies = this.initShim.getDependencies();
        this.filenames = this.initShim.getFilenames();
        this.osArch = this.initShim.getOsArch();
        this.osName = this.initShim.getOsName();
        this.path = this.initShim.getPath();
        this.temporaryFolder = this.initShim.getTemporaryFolder();
        this.initShim = null;
    }

    @Override
    public String getArchitecture() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getArchitecture() : this.architecture;
    }

    public ImmutableList<String> getDependencies() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getDependencies() : this.dependencies;
    }

    @Override
    public List<String> getFilenames() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getFilenames() : this.filenames;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getOsArch() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getOsArch() : this.osArch;
    }

    @Override
    public String getOsName() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getOsName() : this.osName;
    }

    @Override
    public String getPath() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getPath() : this.path;
    }

    @Override
    public File getTemporaryFolder() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getTemporaryFolder() : this.temporaryFolder;
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableNativeLib && this.equalTo(0, (ImmutableNativeLib)another);
    }

    private boolean equalTo(int synthetic, ImmutableNativeLib another) {
        return this.filenames.equals(another.filenames) && this.name.equals(another.name) && this.osArch.equals(another.osArch) && this.osName.equals(another.osName) && this.path.equals(another.path);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.filenames.hashCode();
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.osArch.hashCode();
        h += (h << 5) + this.osName.hashCode();
        h += (h << 5) + this.path.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"NativeLib").omitNullValues().add("filenames", this.filenames).add("name", (Object)this.name).add("osArch", (Object)this.osArch).add("osName", (Object)this.osName).add("path", (Object)this.path).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File getLocalCopy() {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            ImmutableNativeLib immutableNativeLib = this;
            synchronized (immutableNativeLib) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.localCopy = Objects.requireNonNull(super.getLocalCopy(), "localCopy");
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.localCopy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NativeLibrary getNativeLibrary() {
        if ((this.lazyInitBitmap & 2L) == 0L) {
            ImmutableNativeLib immutableNativeLib = this;
            synchronized (immutableNativeLib) {
                if ((this.lazyInitBitmap & 2L) == 0L) {
                    this.nativeLibrary = Objects.requireNonNull(super.getNativeLibrary(), "nativeLibrary");
                    this.lazyInitBitmap |= 2L;
                }
            }
        }
        return this.nativeLibrary;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="NativeLib", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long OPT_BIT_DEPENDENCIES = 1L;
        private long initBits = 1L;
        private long optBits;
        private ImmutableList.Builder<String> dependencies = ImmutableList.builder();
        @Nullable
        private String name;
        @Nullable
        private File temporaryFolder;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(NativeLib instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllDependencies(instance.getDependencies());
            this.name(instance.getName());
            this.temporaryFolder(instance.getTemporaryFolder());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addDependency(String element) {
            this.dependencies.add((Object)element);
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addDependencies(String ... elements) {
            this.dependencies.add((Object[])elements);
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder dependencies(Iterable<String> elements) {
            this.dependencies = ImmutableList.builder();
            return this.addAllDependencies(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllDependencies(Iterable<String> elements) {
            this.dependencies.addAll(elements);
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder temporaryFolder(File temporaryFolder) {
            this.temporaryFolder = Objects.requireNonNull(temporaryFolder, "temporaryFolder");
            return this;
        }

        public ImmutableNativeLib build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableNativeLib(this);
        }

        private boolean dependenciesIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            return "Cannot build NativeLib, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="NativeLib", generator="Immutables")
    private final class InitShim {
        private byte architectureBuildStage = 0;
        private String architecture;
        private byte dependenciesBuildStage = 0;
        private ImmutableList<String> dependencies;
        private byte filenamesBuildStage = 0;
        private List<String> filenames;
        private byte osArchBuildStage = 0;
        private String osArch;
        private byte osNameBuildStage = 0;
        private String osName;
        private byte pathBuildStage = 0;
        private String path;
        private byte temporaryFolderBuildStage = 0;
        private File temporaryFolder;

        private InitShim() {
        }

        String getArchitecture() {
            if (this.architectureBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.architectureBuildStage == 0) {
                this.architectureBuildStage = (byte)-1;
                this.architecture = Objects.requireNonNull(ImmutableNativeLib.super.getArchitecture(), "architecture");
                this.architectureBuildStage = 1;
            }
            return this.architecture;
        }

        ImmutableList<String> getDependencies() {
            if (this.dependenciesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.dependenciesBuildStage == 0) {
                this.dependenciesBuildStage = (byte)-1;
                this.dependencies = ImmutableList.copyOf((Collection)ImmutableNativeLib.super.getDependencies());
                this.dependenciesBuildStage = 1;
            }
            return this.dependencies;
        }

        void dependencies(ImmutableList<String> dependencies) {
            this.dependencies = dependencies;
            this.dependenciesBuildStage = 1;
        }

        List<String> getFilenames() {
            if (this.filenamesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.filenamesBuildStage == 0) {
                this.filenamesBuildStage = (byte)-1;
                this.filenames = Objects.requireNonNull(ImmutableNativeLib.super.getFilenames(), "filenames");
                this.filenamesBuildStage = 1;
            }
            return this.filenames;
        }

        String getOsArch() {
            if (this.osArchBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.osArchBuildStage == 0) {
                this.osArchBuildStage = (byte)-1;
                this.osArch = Objects.requireNonNull(ImmutableNativeLib.super.getOsArch(), "osArch");
                this.osArchBuildStage = 1;
            }
            return this.osArch;
        }

        String getOsName() {
            if (this.osNameBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.osNameBuildStage == 0) {
                this.osNameBuildStage = (byte)-1;
                this.osName = Objects.requireNonNull(ImmutableNativeLib.super.getOsName(), "osName");
                this.osNameBuildStage = 1;
            }
            return this.osName;
        }

        String getPath() {
            if (this.pathBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.pathBuildStage == 0) {
                this.pathBuildStage = (byte)-1;
                this.path = Objects.requireNonNull(ImmutableNativeLib.super.getPath(), "path");
                this.pathBuildStage = 1;
            }
            return this.path;
        }

        File getTemporaryFolder() {
            if (this.temporaryFolderBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.temporaryFolderBuildStage == 0) {
                this.temporaryFolderBuildStage = (byte)-1;
                this.temporaryFolder = Objects.requireNonNull(ImmutableNativeLib.super.getTemporaryFolder(), "temporaryFolder");
                this.temporaryFolderBuildStage = 1;
            }
            return this.temporaryFolder;
        }

        void temporaryFolder(File temporaryFolder) {
            this.temporaryFolder = temporaryFolder;
            this.temporaryFolderBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.architectureBuildStage == -1) {
                attributes.add("architecture");
            }
            if (this.dependenciesBuildStage == -1) {
                attributes.add("dependencies");
            }
            if (this.filenamesBuildStage == -1) {
                attributes.add("filenames");
            }
            if (this.osArchBuildStage == -1) {
                attributes.add("osArch");
            }
            if (this.osNameBuildStage == -1) {
                attributes.add("osName");
            }
            if (this.pathBuildStage == -1) {
                attributes.add("path");
            }
            if (this.temporaryFolderBuildStage == -1) {
                attributes.add("temporaryFolder");
            }
            return "Cannot build NativeLib, attribute initializers form cycle " + attributes;
        }
    }
}

