/*
 * Decompiled with CFR 0.152.
 */
package com.arakelian.store;

import com.arakelian.store.AbstractStore;
import com.arakelian.store.MutableStore;
import com.arakelian.store.StoreConfig;
import com.arakelian.store.StoreException;
import com.arakelian.store.event.StoreListener;
import com.arakelian.store.feature.HasId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import repackaged.com.arakelian.store.com.google.common.base.MoreObjects;
import repackaged.com.arakelian.store.com.google.common.collect.Lists;
import repackaged.com.arakelian.store.org.apache.commons.lang3.StringUtils;

public abstract class AbstractMutableStore<T extends HasId>
extends AbstractStore<T>
implements MutableStore<T> {
    public AbstractMutableStore(StoreConfig<T> config) {
        super(config);
    }

    @Override
    public void delete(String id) {
        if (!StringUtils.isEmpty(id)) {
            this.doDelete(id);
            this.notifyDeleted(id);
        }
    }

    @Override
    public void delete(T value) {
        String id;
        if (value != null && !StringUtils.isEmpty(id = value.getId())) {
            this.doDelete(id);
            this.notifyDeleted(value);
        }
    }

    @Override
    public void deleteAll(Collection<T> values) {
        if (values == null || values.size() == 0) {
            return;
        }
        ArrayList<T> valuesList = values instanceof List ? (ArrayList<T>)values : Lists.newArrayList(values);
        for (List<T> partition : Lists.partition(valuesList, this.config.getPartitionSize())) {
            this.doDeleteAllValues(partition);
            for (HasId value : partition) {
                this.notifyDeleted(value);
            }
        }
    }

    @Override
    public void deleteAll(String ... ids) {
        if (ids == null || ids.length == 0) {
            return;
        }
        ArrayList<String> list = Lists.newArrayList(ids);
        for (List<String> partition : Lists.partition(list, this.config.getPartitionSize())) {
            this.doDeleteAllIds(partition);
            for (String id : partition) {
                this.notifyDeleted(id);
            }
        }
    }

    @Override
    public void put(T value) {
        if (value == null) {
            return;
        }
        String id = value.getId();
        if (StringUtils.isEmpty(id)) {
            throw new StoreException("Id not specified for " + value);
        }
        this.doPut(value);
        for (StoreListener<T> listener : this.config.getListeners()) {
            listener.put(value);
        }
    }

    @Override
    public void putAll(Collection<T> values) {
        if (values == null || values.size() == 0) {
            return;
        }
        for (HasId value : values) {
            this.put(value);
        }
    }

    @Override
    public void putAll(T[] values) {
        if (values == null || values.length == 0) {
            return;
        }
        for (T value : values) {
            this.put(value);
        }
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this).add("config", this.config).toString();
    }

    protected abstract void doDelete(String var1);

    protected abstract void doDeleteAllIds(List<String> var1);

    protected abstract void doDeleteAllValues(List<T> var1);

    @Override
    protected abstract List<T> doGetAll(List<T> var1, List<String> var2);

    protected abstract void doPut(T var1);

    protected void notifyDeleted(String id) {
        if (!StringUtils.isEmpty(id)) {
            for (StoreListener listener : this.config.getListeners()) {
                listener.delete(id);
            }
        }
    }

    protected void notifyDeleted(T value) {
        if (value != null && !StringUtils.isEmpty(value.getId())) {
            for (StoreListener<T> listener : this.config.getListeners()) {
                listener.delete(value);
            }
        }
    }
}

