/*
 * Decompiled with CFR 0.152.
 */
package com.arakelian.store;

import com.arakelian.store.Store;
import com.arakelian.store.StoreConfig;
import com.arakelian.store.StoreException;
import com.arakelian.store.feature.HasId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import repackaged.com.arakelian.store.com.google.common.base.MoreObjects;
import repackaged.com.arakelian.store.com.google.common.collect.Lists;
import repackaged.com.arakelian.store.org.apache.commons.lang3.StringUtils;

public abstract class AbstractStore<T extends HasId>
implements Store<T> {
    protected final StoreConfig<T> config;

    public AbstractStore(StoreConfig<T> config) {
        this.config = config;
    }

    @Override
    public List<T> getAll(Collection<String> ids) {
        if (ids == null || ids.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> idList = ids instanceof List ? (ArrayList<String>)ids : Lists.newArrayList(ids);
        List<T> result = null;
        for (List<String> partition : Lists.partition(idList, this.config.getPartitionSize())) {
            result = this.doGetAll(result, partition);
        }
        if (result == null) {
            return Collections.emptyList();
        }
        return result;
    }

    @Override
    public List<T> getAll(String ... ids) {
        if (ids == null || ids.length == 0) {
            return Collections.emptyList();
        }
        return this.getAll(Lists.newArrayList(ids));
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("config", this.config).toString();
    }

    protected abstract List<T> doGetAll(List<T> var1, List<String> var2);

    protected Object[] idsOf(List<?> idsOrValues) {
        Object[] ids = idsOrValues.toArray();
        int length = 0;
        int i = 0;
        while (i < ids.length) {
            String id;
            Object p;
            if ((p = ids[i++]) instanceof HasId) {
                id = ((HasId)p).getId();
                if (StringUtils.isEmpty(id)) continue;
                ids[length++] = id;
                continue;
            }
            if (p instanceof String) {
                id = p.toString();
                if (StringUtils.isEmpty(id)) continue;
                ids[length++] = id;
                continue;
            }
            if (p == null) continue;
            throw new StoreException("Invalid id or value of type " + p);
        }
        if (length == 0) {
            return null;
        }
        if (length != ids.length) {
            Object[] tmp = new Object[length];
            System.arraycopy(ids, 0, tmp, 0, length);
            return tmp;
        }
        return ids;
    }
}

