/*
 * Decompiled with CFR 0.152.
 */
package com.arakelian.store.event;

import com.arakelian.core.utils.ExecutorUtils;
import com.arakelian.store.event.StoreEvent;
import com.arakelian.store.event.StoreEventFactory;
import com.arakelian.store.event.StoreListener;
import com.arakelian.store.feature.HasId;
import com.lmax.disruptor.BlockingWaitStrategy;
import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.dsl.Disruptor;
import com.lmax.disruptor.dsl.ProducerType;
import java.io.Closeable;
import java.util.concurrent.atomic.AtomicBoolean;
import repackaged.com.arakelian.store.com.google.common.base.Preconditions;
import repackaged.com.arakelian.store.org.apache.commons.lang3.StringUtils;

public class StoreEventPublisher<T extends HasId>
implements StoreListener<T>,
Closeable {
    private final Disruptor<StoreEvent<T>> disruptor;
    private final RingBuffer<StoreEvent<T>> ringBuffer;
    private final AtomicBoolean closed = new AtomicBoolean();

    @SafeVarargs
    public StoreEventPublisher(int ringBufferSize, EventHandler<StoreEvent<T>> ... handlers) {
        this.disruptor = new Disruptor(new StoreEventFactory(), ringBufferSize, ExecutorUtils.newThreadFactory(StoreEventPublisher.class, (boolean)false), ProducerType.SINGLE, (WaitStrategy)new BlockingWaitStrategy());
        this.disruptor.handleEventsWith(handlers);
        this.disruptor.start();
        this.ringBuffer = this.disruptor.getRingBuffer();
    }

    public StoreEventPublisher(RingBuffer<StoreEvent<T>> ringBuffer) {
        this.disruptor = null;
        this.ringBuffer = ringBuffer;
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true) && this.disruptor != null) {
            this.disruptor.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(String id) {
        Preconditions.checkArgument(!StringUtils.isEmpty(id), "id must be non-empty");
        long sequence = this.ringBuffer.next();
        try {
            StoreEvent event = (StoreEvent)this.ringBuffer.get(sequence);
            event.reset();
            event.setAction(StoreEvent.Action.DELETE);
            event.setId(id);
        }
        finally {
            this.ringBuffer.publish(sequence);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(T value) {
        Preconditions.checkArgument(value != null, "value must be non-null");
        long sequence = this.ringBuffer.next();
        try {
            StoreEvent event = (StoreEvent)this.ringBuffer.get(sequence);
            event.reset();
            event.setAction(StoreEvent.Action.DELETE);
            event.setId(value.getId());
            event.setValue(value);
        }
        finally {
            this.ringBuffer.publish(sequence);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(T value) {
        Preconditions.checkArgument(value != null, "value must be non-null");
        long sequence = this.ringBuffer.next();
        try {
            StoreEvent event = (StoreEvent)this.ringBuffer.get(sequence);
            event.reset();
            event.setAction(StoreEvent.Action.PUT);
            event.setId(value.getId());
            event.setValue(value);
        }
        finally {
            this.ringBuffer.publish(sequence);
        }
    }
}

