/*
 * Decompiled with CFR 0.152.
 */
package com.arakelian.store.json;

import com.arakelian.store.feature.HasId;
import com.arakelian.store.json.StoreObjectMapper;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import repackaged.com.arakelian.store.com.google.common.base.Preconditions;
import repackaged.com.arakelian.store.org.apache.commons.lang3.StringUtils;

public class JacksonStoreObjectMapper<T extends HasId>
implements StoreObjectMapper<T> {
    private final Class<T> clazz;
    private final ObjectMapper objectMapper;

    public JacksonStoreObjectMapper(Class<T> clazz, ObjectMapper objectMapper) {
        Preconditions.checkArgument(clazz != null, "clazz must be non-null");
        Preconditions.checkArgument(objectMapper != null, "objectMapper must be non-null");
        this.clazz = clazz;
        this.objectMapper = objectMapper;
    }

    @Override
    public T readValue(String value) throws IOException {
        if (StringUtils.isEmpty(value)) {
            return null;
        }
        return (T)(StringUtils.isEmpty(value) ? null : (HasId)this.objectMapper.readValue(value, this.clazz));
    }

    @Override
    public String writeValueAsString(T value) throws IOException {
        Preconditions.checkArgument(value != null, "value must be non-null");
        return this.objectMapper.writeValueAsString(value);
    }
}

