/*
 * Decompiled with CFR 0.152.
 */
package repackaged.com.arakelian.store.com.google.common.collect;

import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Function;
import repackaged.com.arakelian.store.com.google.common.base.Preconditions;

final class CollectSpliterators {
    static <InElementT, OutElementT> Spliterator<OutElementT> flatMap(Spliterator<InElementT> fromSpliterator, Function<? super InElementT, Spliterator<OutElementT>> function, int topCharacteristics, long topSize) {
        Preconditions.checkArgument((topCharacteristics & 0x4000) == 0, "flatMap does not support SUBSIZED characteristic");
        Preconditions.checkArgument((topCharacteristics & 4) == 0, "flatMap does not support SORTED characteristic");
        Preconditions.checkNotNull(fromSpliterator);
        Preconditions.checkNotNull(function);
        return new FlatMapSpliteratorOfObject<InElementT, OutElementT>(null, fromSpliterator, function, topCharacteristics, topSize);
    }

    static final class FlatMapSpliteratorOfObject<InElementT, OutElementT>
    extends FlatMapSpliterator<InElementT, OutElementT, Spliterator<OutElementT>> {
        FlatMapSpliteratorOfObject(Spliterator<OutElementT> prefix, Spliterator<InElementT> from, Function<? super InElementT, Spliterator<OutElementT>> function, int characteristics, long estimatedSize) {
            super(prefix, from, function, FlatMapSpliteratorOfObject::new, characteristics, estimatedSize);
        }
    }

    static abstract class FlatMapSpliterator<InElementT, OutElementT, OutSpliteratorT extends Spliterator<OutElementT>>
    implements Spliterator<OutElementT> {
        OutSpliteratorT prefix;
        final Spliterator<InElementT> from;
        final Function<? super InElementT, OutSpliteratorT> function;
        final Factory<InElementT, OutSpliteratorT> factory;
        int characteristics;
        long estimatedSize;

        FlatMapSpliterator(OutSpliteratorT prefix, Spliterator<InElementT> from, Function<? super InElementT, OutSpliteratorT> function, Factory<InElementT, OutSpliteratorT> factory, int characteristics, long estimatedSize) {
            this.prefix = prefix;
            this.from = from;
            this.function = function;
            this.factory = factory;
            this.characteristics = characteristics;
            this.estimatedSize = estimatedSize;
        }

        @Override
        public final boolean tryAdvance(Consumer<? super OutElementT> action) {
            do {
                if (this.prefix != null && this.prefix.tryAdvance(action)) {
                    if (this.estimatedSize != Long.MAX_VALUE) {
                        --this.estimatedSize;
                    }
                    return true;
                }
                this.prefix = null;
            } while (this.from.tryAdvance((? super T fromElement) -> {
                this.prefix = (Spliterator)this.function.apply(fromElement);
            }));
            return false;
        }

        @Override
        public final void forEachRemaining(Consumer<? super OutElementT> action) {
            if (this.prefix != null) {
                this.prefix.forEachRemaining(action);
                this.prefix = null;
            }
            this.from.forEachRemaining((? super T fromElement) -> {
                Spliterator elements = (Spliterator)this.function.apply(fromElement);
                if (elements != null) {
                    elements.forEachRemaining(action);
                }
            });
            this.estimatedSize = 0L;
        }

        public final OutSpliteratorT trySplit() {
            Spliterator<InElementT> fromSplit = this.from.trySplit();
            if (fromSplit != null) {
                int splitCharacteristics = this.characteristics & 0xFFFFFFBF;
                long estSplitSize = this.estimateSize();
                if (estSplitSize < Long.MAX_VALUE) {
                    this.estimatedSize -= (estSplitSize /= 2L);
                    this.characteristics = splitCharacteristics;
                }
                OutSpliteratorT result = this.factory.newFlatMapSpliterator(this.prefix, fromSplit, this.function, splitCharacteristics, estSplitSize);
                this.prefix = null;
                return result;
            }
            if (this.prefix != null) {
                OutSpliteratorT result = this.prefix;
                this.prefix = null;
                return result;
            }
            return null;
        }

        @Override
        public final long estimateSize() {
            if (this.prefix != null) {
                this.estimatedSize = Math.max(this.estimatedSize, this.prefix.estimateSize());
            }
            return Math.max(this.estimatedSize, 0L);
        }

        @Override
        public final int characteristics() {
            return this.characteristics;
        }

        @FunctionalInterface
        static interface Factory<InElementT, OutSpliteratorT extends Spliterator<?>> {
            public OutSpliteratorT newFlatMapSpliterator(OutSpliteratorT var1, Spliterator<InElementT> var2, Function<? super InElementT, OutSpliteratorT> var3, int var4, long var5);
        }
    }
}

