/*
 * Decompiled with CFR 0.152.
 */
package com.arakelian.core.utils;

import java.io.File;
import java.security.SecureRandom;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import repackaged.com.arakelian.core.com.google.common.base.Joiner;
import repackaged.com.arakelian.core.com.google.common.base.Splitter;
import repackaged.com.arakelian.core.com.google.common.io.BaseEncoding;
import repackaged.com.arakelian.core.org.apache.commons.lang3.StringUtils;

public class MoreStringUtils {
    public static final Splitter COMMA_SPLITTER = Splitter.on(",").trimResults().omitEmptyStrings();
    public static final Splitter COMMA_WHITESPACE_SPLITTER = Splitter.on("\\s*,\\s*").trimResults().omitEmptyStrings();
    public static final Joiner SPACE_JOINER = Joiner.on(" ");
    public static final Joiner COMMA_JOINER = Joiner.on(",");
    public static final Joiner COMMA_WHITESPACE_JOINER = Joiner.on(", ");
    public static final String[] EMPTY_STRINGS = new String[0];
    public static final BaseEncoding HEX_UPPERCASE = BaseEncoding.base16().upperCase();
    public static final BaseEncoding HEX_LOWERCASE = BaseEncoding.base16().lowerCase();
    public static final BaseEncoding BASE64_OMIT_PADDING = BaseEncoding.base64().omitPadding();
    public static final BaseEncoding BASE64 = BaseEncoding.base64();
    public static final Pattern UUID_PATTERN = Pattern.compile("[0-9a-fA-F]{8}-?[0-9a-fA-F]{4}-?[0-9a-fA-F]{4}-?[0-9a-fA-F]{4}-?[0-9a-fA-F]{12}");
    static final char[] HEX_CHARS = "0123456789abcdef".toCharArray();
    public static final char UNIX_SEPARATOR = '/';
    public static final char WINDOWS_SEPARATOR = '\\';
    public static final char SYSTEM_SEPARATOR = File.separatorChar;
    static final SecureRandom UUID_GENERATOR = new SecureRandom();

    public static File asFile(File parent, String filename) {
        String normalized = MoreStringUtils.normalizeSeparators(filename);
        return normalized != null ? new File(parent, normalized) : parent;
    }

    public static File asFile(String filename) {
        String normalized = MoreStringUtils.normalizeSeparators(filename);
        return normalized != null ? new File(normalized) : null;
    }

    public static boolean isUuid(String uuid) {
        return uuid != null && (uuid.length() == 36 || uuid.length() == 32) && UUID_PATTERN.matcher(uuid).matches();
    }

    public static String maskExcept(String s, int unmaskedLength) {
        return MoreStringUtils.maskExcept(s, unmaskedLength, '*');
    }

    public static String maskExcept(String s, int unmaskedLength, char maskChar) {
        if (s == null) {
            return null;
        }
        boolean maskLeading = unmaskedLength > 0;
        int length = s.length();
        int maskedLength = Math.max(0, length - Math.abs(unmaskedLength));
        if (maskedLength > 0) {
            String mask = StringUtils.repeat(maskChar, maskedLength);
            if (maskLeading) {
                return StringUtils.overlay(s, mask, 0, maskedLength);
            }
            return StringUtils.overlay(s, mask, length - maskedLength, length);
        }
        return s;
    }

    public static String normalizeSeparators(String filename) {
        if (filename == null) {
            return null;
        }
        switch (SYSTEM_SEPARATOR) {
            case '/': {
                return filename.replace('\\', '/');
            }
            case '\\': {
                return filename.replace('/', '\\');
            }
        }
        throw new IllegalStateException("Unexpected file separator");
    }

    public static String normalizeTypography(String value) {
        if (value == null || value.length() == 0) {
            return value;
        }
        boolean changing = false;
        int length = value.length();
        block17: for (int i = 0; i < length; ++i) {
            char ch = value.charAt(i);
            switch (ch) {
                case '\u00a0': 
                case '\u2002': 
                case '\u2003': 
                case '\u2004': 
                case '\u2005': 
                case '\u2006': 
                case '\u2007': 
                case '\u2008': 
                case '\u2009': 
                case '\u200a': 
                case '\u2010': 
                case '\u2011': 
                case '\u2012': 
                case '\u2013': 
                case '\u2014': 
                case '\u2018': 
                case '\u2019': 
                case '\u201c': 
                case '\u201d': 
                case '\u2024': 
                case '\u2025': 
                case '\u2026': 
                case '\u2038': 
                case '\u2039': 
                case '\u203a': {
                    changing = true;
                    continue block17;
                }
            }
        }
        if (!changing) {
            return value;
        }
        StringBuilder buf = new StringBuilder(value);
        int length2 = buf.length();
        block18: for (int i = 0; i < length2; ++i) {
            char ch = buf.charAt(i);
            switch (ch) {
                case '\u00a0': 
                case '\u2002': 
                case '\u2003': 
                case '\u2004': 
                case '\u2005': 
                case '\u2006': 
                case '\u2007': 
                case '\u2008': 
                case '\u2009': 
                case '\u200a': {
                    buf.setCharAt(i, ' ');
                    continue block18;
                }
                case '\u2010': 
                case '\u2011': 
                case '\u2012': 
                case '\u2013': 
                case '\u2014': {
                    buf.setCharAt(i, '-');
                    continue block18;
                }
                case '\u2024': {
                    buf.setCharAt(i, '.');
                    continue block18;
                }
                case '\u2025': {
                    buf.setCharAt(i, '.');
                    buf.insert(i + 1, ".");
                    length2 = buf.length();
                    continue block18;
                }
                case '\u2026': {
                    buf.setCharAt(i, '.');
                    buf.insert(i + 1, "..");
                    length2 = buf.length();
                    continue block18;
                }
                case '\u2038': {
                    buf.setCharAt(i, '^');
                    continue block18;
                }
                case '\u2039': {
                    buf.setCharAt(i, '<');
                    continue block18;
                }
                case '\u203a': {
                    buf.setCharAt(i, '>');
                    continue block18;
                }
                case '\u2018': {
                    buf.setCharAt(i, '\'');
                    continue block18;
                }
                case '\u2019': {
                    buf.setCharAt(i, '\'');
                    continue block18;
                }
                case '\u201c': {
                    buf.setCharAt(i, '\"');
                    continue block18;
                }
                case '\u201d': {
                    buf.setCharAt(i, '\"');
                    continue block18;
                }
            }
        }
        return buf.toString();
    }

    public static String replaceNonPrintableControlCharacters(String value) {
        if (value == null || value.length() == 0) {
            return value;
        }
        boolean changing = false;
        int length = value.length();
        for (int i = 0; i < length; ++i) {
            char ch = value.charAt(i);
            if (ch >= ' ' || ch == '\n' || ch == '\r' || ch == '\t') continue;
            changing = true;
            break;
        }
        if (!changing) {
            return value;
        }
        StringBuilder buf = new StringBuilder(value);
        int length2 = buf.length();
        for (int i = 0; i < length2; ++i) {
            char ch = buf.charAt(i);
            if (ch >= ' ' || ch == '\n' || ch == '\r' || ch == '\t') continue;
            buf.setCharAt(i, ' ');
        }
        return buf.toString();
    }

    public static String shortUuid() {
        byte[] randomBytes = new byte[16];
        UUID_GENERATOR.nextBytes(randomBytes);
        randomBytes[6] = (byte)(randomBytes[6] & 0xF);
        randomBytes[6] = (byte)(randomBytes[6] | 0x40);
        randomBytes[8] = (byte)(randomBytes[8] & 0x3F);
        randomBytes[8] = (byte)(randomBytes[8] | 0x80);
        return BaseEncoding.base64Url().omitPadding().encode(randomBytes);
    }

    public static String[] split(String value) {
        return MoreStringUtils.toStringArray(MoreStringUtils.splitToList(value));
    }

    public static List<String> splitToList(String value) {
        if (!StringUtils.isEmpty(value)) {
            return COMMA_SPLITTER.splitToList(value);
        }
        return Collections.emptyList();
    }

    public static String toString(long duration, TimeUnit units) {
        long nanos = TimeUnit.NANOSECONDS.convert(duration, units);
        TimeUnit bestUnit = MoreStringUtils.chooseUnit(nanos);
        double value = (double)nanos / (double)TimeUnit.NANOSECONDS.convert(1L, bestUnit);
        return String.format(Locale.ROOT, "%.4g", value) + MoreStringUtils.abbreviate(bestUnit);
    }

    public static String toString(UUID value) {
        char[] buf = new char[32];
        long msb = value.getMostSignificantBits();
        MoreStringUtils._appendInt((int)(msb >> 32), buf, 0);
        int i = (int)msb;
        MoreStringUtils._appendShort(i >>> 16, buf, 8);
        MoreStringUtils._appendShort(i, buf, 12);
        long lsb = value.getLeastSignificantBits();
        MoreStringUtils._appendShort((int)(lsb >>> 48), buf, 16);
        MoreStringUtils._appendShort((int)(lsb >>> 32), buf, 20);
        MoreStringUtils._appendInt((int)lsb, buf, 24);
        return new String(buf);
    }

    public static String[] toStringArray(Collection<String> collection) {
        return collection != null ? collection.toArray(new String[collection.size()]) : EMPTY_STRINGS;
    }

    public static String trimWhitespace(String s) {
        int start;
        int length;
        if (s == null || s.length() == 0) {
            return s;
        }
        int end = length = s.length();
        for (start = 0; start < end && Character.isWhitespace(s.charAt(start)); ++start) {
        }
        while (start < end && Character.isWhitespace(s.charAt(end - 1))) {
            --end;
        }
        return start > 0 || end < length ? s.substring(start, end) : s;
    }

    public static String trimWhitespaceToNull(String s) {
        String result = MoreStringUtils.trimWhitespace(s);
        return StringUtils.isEmpty(result) ? null : s;
    }

    public static String uuid() {
        return MoreStringUtils.toString(UUID.randomUUID());
    }

    private static void _appendInt(int bits, char[] buf, int offset) {
        MoreStringUtils._appendShort(bits >> 16, buf, offset);
        MoreStringUtils._appendShort(bits, buf, offset + 4);
    }

    private static void _appendShort(int bits, char[] buf, int offset) {
        buf[offset] = HEX_CHARS[bits >> 12 & 0xF];
        buf[++offset] = HEX_CHARS[bits >> 8 & 0xF];
        buf[++offset] = HEX_CHARS[bits >> 4 & 0xF];
        buf[++offset] = HEX_CHARS[bits & 0xF];
    }

    private static String abbreviate(TimeUnit unit) {
        switch (unit) {
            case NANOSECONDS: {
                return "ns";
            }
            case MICROSECONDS: {
                return "\u03bcs";
            }
            case MILLISECONDS: {
                return "ms";
            }
            case SECONDS: {
                return " seconds";
            }
            case MINUTES: {
                return " minutes";
            }
            case HOURS: {
                return " hours";
            }
            case DAYS: {
                return " days";
            }
        }
        throw new AssertionError();
    }

    private static TimeUnit chooseUnit(long nanos) {
        if (TimeUnit.DAYS.convert(nanos, TimeUnit.NANOSECONDS) > 0L) {
            return TimeUnit.DAYS;
        }
        if (TimeUnit.HOURS.convert(nanos, TimeUnit.NANOSECONDS) > 0L) {
            return TimeUnit.HOURS;
        }
        if (TimeUnit.MINUTES.convert(nanos, TimeUnit.NANOSECONDS) > 0L) {
            return TimeUnit.MINUTES;
        }
        if (TimeUnit.SECONDS.convert(nanos, TimeUnit.NANOSECONDS) > 0L) {
            return TimeUnit.SECONDS;
        }
        if (TimeUnit.MILLISECONDS.convert(nanos, TimeUnit.NANOSECONDS) > 0L) {
            return TimeUnit.MILLISECONDS;
        }
        if (TimeUnit.MICROSECONDS.convert(nanos, TimeUnit.NANOSECONDS) > 0L) {
            return TimeUnit.MICROSECONDS;
        }
        return TimeUnit.NANOSECONDS;
    }
}

