/*
 * Decompiled with CFR 0.152.
 */
package repackaged.com.arakelian.core.com.google.common.collect;

import java.util.Arrays;
import repackaged.com.arakelian.core.com.google.common.collect.BiMap;
import repackaged.com.arakelian.core.com.google.common.collect.ImmutableBiMapFauxverideShim;
import repackaged.com.arakelian.core.com.google.common.collect.ImmutableMap;
import repackaged.com.arakelian.core.com.google.common.collect.ImmutableSet;
import repackaged.com.arakelian.core.com.google.common.collect.Maps;
import repackaged.com.arakelian.core.com.google.common.collect.Ordering;
import repackaged.com.arakelian.core.com.google.common.collect.RegularImmutableBiMap;
import repackaged.com.arakelian.core.com.google.common.collect.SingletonImmutableBiMap;

public abstract class ImmutableBiMap<K, V>
extends ImmutableBiMapFauxverideShim<K, V>
implements BiMap<K, V> {
    public static <K, V> ImmutableBiMap<K, V> of() {
        return RegularImmutableBiMap.EMPTY;
    }

    public static <K, V> ImmutableBiMap<K, V> of(K k1, V v1) {
        return new SingletonImmutableBiMap<K, V>(k1, v1);
    }

    ImmutableBiMap() {
    }

    public abstract ImmutableBiMap<V, K> inverse();

    @Override
    public ImmutableSet<V> values() {
        return this.inverse().keySet();
    }

    @Override
    final ImmutableSet<V> createValues() {
        throw new AssertionError((Object)"should never be called");
    }

    @Override
    Object writeReplace() {
        return new SerializedForm(this);
    }

    private static class SerializedForm
    extends ImmutableMap.SerializedForm {
        private static final long serialVersionUID = 0L;

        SerializedForm(ImmutableBiMap<?, ?> bimap) {
            super(bimap);
        }

        @Override
        Object readResolve() {
            Builder<Object, Object> builder = new Builder<Object, Object>();
            return this.createMap(builder);
        }
    }

    public static final class Builder<K, V>
    extends ImmutableMap.Builder<K, V> {
        @Override
        public Builder<K, V> put(K key, V value) {
            super.put(key, value);
            return this;
        }

        @Override
        public ImmutableBiMap<K, V> build() {
            switch (this.size) {
                case 0: {
                    return ImmutableBiMap.of();
                }
                case 1: {
                    return ImmutableBiMap.of(this.entries[0].getKey(), this.entries[0].getValue());
                }
            }
            if (this.valueComparator != null) {
                if (this.entriesUsed) {
                    this.entries = Arrays.copyOf(this.entries, this.size);
                }
                Arrays.sort(this.entries, 0, this.size, Ordering.from(this.valueComparator).onResultOf(Maps.valueFunction()));
            }
            this.entriesUsed = true;
            return RegularImmutableBiMap.fromEntryArray(this.size, this.entries);
        }
    }
}

