/*
 * Decompiled with CFR 0.152.
 */
package repackaged.com.arakelian.core.com.google.common.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import repackaged.com.arakelian.core.com.google.common.base.Optional;
import repackaged.com.arakelian.core.com.google.common.base.Preconditions;
import repackaged.com.arakelian.core.com.google.common.io.ByteStreams;
import repackaged.com.arakelian.core.com.google.common.io.CharSource;
import repackaged.com.arakelian.core.com.google.common.io.Closer;

public abstract class ByteSource {
    protected ByteSource() {
    }

    public CharSource asCharSource(Charset charset) {
        return new AsCharSource(charset);
    }

    public abstract InputStream openStream() throws IOException;

    public Optional<Long> sizeIfKnown() {
        return Optional.absent();
    }

    public byte[] read() throws IOException {
        try (Closer closer = Closer.create();){
            InputStream in = closer.register(this.openStream());
            Optional<Long> size = this.sizeIfKnown();
            byte[] byArray = size.isPresent() ? ByteStreams.toByteArray(in, size.get()) : ByteStreams.toByteArray(in);
            return byArray;
        }
    }

    class AsCharSource
    extends CharSource {
        final Charset charset;

        AsCharSource(Charset charset) {
            this.charset = Preconditions.checkNotNull(charset);
        }

        @Override
        public Reader openStream() throws IOException {
            return new InputStreamReader(ByteSource.this.openStream(), this.charset);
        }

        @Override
        public String read() throws IOException {
            return new String(ByteSource.this.read(), this.charset);
        }

        public String toString() {
            return ByteSource.this.toString() + ".asCharSource(" + this.charset + ")";
        }
    }
}

