/*
 * Decompiled with CFR 0.152.
 */
package com.arakelian.core.utils;

import java.sql.Date;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Month;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.chrono.IsoChronology;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.format.ResolverStyle;
import java.time.format.SignStyle;
import java.time.format.TextStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalQuery;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import repackaged.com.arakelian.core.com.google.common.base.Preconditions;
import repackaged.com.arakelian.core.org.apache.commons.lang3.StringUtils;

public class DateUtils {
    private static final String SLASH = "/";
    private static final String DASH = "-";
    private static final String SPACE = " ";
    private static final String COMMA = ", ";
    private static final Logger LOGGER = LoggerFactory.getLogger(DateUtils.class);
    private static final DateTimeFormatter ISO_8601_NANOS = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR_OF_ERA, 4, 19, SignStyle.EXCEEDS_PAD).appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 2).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 2).appendLiteral('T').appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).optionalStart().appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).optionalStart().appendFraction(ChronoField.NANO_OF_SECOND, 9, 9, true).optionalEnd().optionalEnd().appendOffset("+HHmm", "Z").toFormatter();
    private static final long MILLIS_PER_DAY = 86400000L;
    private static final DateTimeFormatter TIME = DateUtils.build(builder -> builder.appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).optionalStart().appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).optionalStart().appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, true));
    public static final DateTimeFormatter MMDDYYYY_HHMM = DateTimeFormatter.ofPattern("MM/dd/yyyy hh:mm a");
    public static final DateTimeFormatter MMDDYYYY_HHMMSS = DateTimeFormatter.ofPattern("MM/dd/yyyy hh:mm:ss a");
    public static final DateTimeFormatter YYYY_MM = DateTimeFormatter.ofPattern("yyyy/MM");
    public static final DateTimeFormatter YYYY_MM_DD = DateTimeFormatter.ofPattern("yyyy/MM/dd");
    public static final DateTimeFormatter M_D_YY = DateTimeFormatter.ofPattern("M/d/yy");
    public static final DateTimeFormatter EEE_M_D_YY = DateTimeFormatter.ofPattern("EEE M/d/yy");
    public static final DateTimeFormatter H_MM_ampm = DateTimeFormatter.ofPattern("h:mma");
    private static final DateTimeFormatter ZONED_DATE_TIME_PARSER = DateUtils.build(builder -> builder.appendPattern("[uuuu-MM-dd'T'HH:mm:ss.SSSZZZ]").optionalStart().append(DateUtils.yearMonthDay(null, DASH, DASH, 4, true)).optionalEnd().optionalStart().append(DateTimeFormatter.ISO_ZONED_DATE_TIME).optionalEnd().optionalStart().append(DateTimeFormatter.ISO_LOCAL_DATE_TIME).optionalEnd().optionalStart().append(DateTimeFormatter.ISO_DATE).optionalEnd().optionalStart().append(DateTimeFormatter.ISO_OFFSET_DATE).optionalEnd().optionalStart().append(DateTimeFormatter.RFC_1123_DATE_TIME).optionalEnd().optionalStart().append(DateUtils.monthDayYear(null, SLASH, SLASH, 4, true)).optionalEnd().optionalStart().append(DateUtils.monthDayYear(null, SLASH, SLASH, 4, false)).optionalEnd().optionalStart().append(DateUtils.monthDayYear(null, DASH, DASH, 4, true)).optionalEnd().optionalStart().append(DateUtils.monthDayYear(null, DASH, DASH, 4, false)).optionalEnd().optionalStart().append(DateUtils.yearMonthDay(null, SLASH, SLASH, 4, true)).optionalEnd().optionalStart().append(DateUtils.yearMonthDay(null, SLASH, SLASH, 4, false)).optionalEnd().optionalStart().append(DateUtils.yearMonthDay(TextStyle.FULL, "", "", 4, false)).optionalEnd().optionalStart().append(DateUtils.yearMonthDay(TextStyle.SHORT, "", "", 4, false)).optionalEnd().optionalStart().append(DateUtils.dayMonthYear(TextStyle.FULL, DASH, DASH, 4)).optionalEnd().optionalStart().append(DateUtils.dayMonthYear(TextStyle.FULL, SPACE, SPACE, 4)).optionalEnd().optionalStart().append(DateUtils.dayMonthYear(TextStyle.FULL, SPACE, COMMA, 4)).optionalEnd().optionalStart().append(DateUtils.dayMonthYear(TextStyle.SHORT, DASH, DASH, 4)).optionalEnd().optionalStart().append(DateUtils.dayMonthYear(TextStyle.SHORT, SPACE, SPACE, 4)).optionalEnd().optionalStart().append(DateUtils.dayMonthYear(TextStyle.SHORT, SPACE, COMMA, 4)).optionalEnd().optionalStart().append(DateUtils.monthDayYear(TextStyle.FULL, DASH, DASH, 4, false)).optionalEnd().optionalStart().append(DateUtils.monthDayYear(TextStyle.FULL, SPACE, SPACE, 4, false)).optionalEnd().optionalStart().append(DateUtils.monthDayYear(TextStyle.FULL, SPACE, COMMA, 4, false)).optionalEnd().optionalStart().append(DateUtils.monthDayYear(TextStyle.SHORT, DASH, DASH, 4, false)).optionalEnd().optionalStart().append(DateUtils.monthDayYear(TextStyle.SHORT, SPACE, SPACE, 4, false)).optionalEnd().optionalStart().append(DateUtils.monthDayYear(TextStyle.SHORT, SPACE, COMMA, 4, false)).optionalEnd().optionalStart().append(DateUtils.monthDayYear(null, SLASH, SLASH, 2, true)).optionalEnd().optionalStart().append(DateUtils.monthDayYear(null, SLASH, SLASH, 2, false)).optionalEnd().optionalStart().append(DateUtils.monthDayYear(null, DASH, DASH, 2, true)).optionalEnd().optionalStart().append(DateUtils.monthDayYear(null, DASH, DASH, 2, false)).optionalEnd().optionalStart().append(DateUtils.dayMonthYear(TextStyle.FULL, DASH, DASH, 2)).optionalEnd().optionalStart().append(DateUtils.dayMonthYear(TextStyle.FULL, SPACE, SPACE, 2)).optionalEnd().optionalStart().append(DateUtils.dayMonthYear(TextStyle.FULL, SPACE, COMMA, 2)).optionalEnd().optionalStart().append(DateUtils.dayMonthYear(TextStyle.SHORT, DASH, DASH, 2)).optionalEnd().optionalStart().append(DateUtils.dayMonthYear(TextStyle.SHORT, SPACE, SPACE, 2)).optionalEnd().optionalStart().append(DateUtils.dayMonthYear(TextStyle.SHORT, SPACE, COMMA, 2)).optionalEnd().optionalStart().append(DateUtils.monthDayYear(null, DASH, DASH, 2, false)).optionalEnd().optionalStart().append(DateUtils.monthDayYear(TextStyle.FULL, DASH, DASH, 2, false)).optionalEnd().optionalStart().append(DateUtils.monthDayYear(TextStyle.FULL, SPACE, SPACE, 2, false)).optionalEnd().optionalStart().append(DateUtils.monthDayYear(TextStyle.FULL, SPACE, COMMA, 2, false)).optionalEnd().optionalStart().append(DateUtils.monthDayYear(TextStyle.SHORT, DASH, DASH, 2, false)).optionalEnd().optionalStart().append(DateUtils.monthDayYear(TextStyle.SHORT, SPACE, SPACE, 2, false)).optionalEnd().optionalStart().append(DateUtils.monthDayYear(TextStyle.SHORT, SPACE, COMMA, 2, false)).optionalEnd().appendPattern("[uuuuMMdd]").optionalStart().append(DateTimeFormatter.ISO_INSTANT).optionalEnd());
    public static final ZoneId UTC_ZONE = ZoneId.of("Z");
    private static final Random JVM_RANDOM = new Random();

    public static ZonedDateTime atStartOfDay(ZonedDateTime date) {
        return date != null ? date.truncatedTo(ChronoUnit.DAYS) : null;
    }

    private static DateTimeFormatter build(Consumer<DateTimeFormatterBuilder> consumer) {
        DateTimeFormatterBuilder builder = new DateTimeFormatterBuilder().parseStrict().parseCaseInsensitive();
        consumer.accept(builder);
        return builder.parseDefaulting(ChronoField.HOUR_OF_DAY, 0L).parseDefaulting(ChronoField.MINUTE_OF_HOUR, 0L).parseDefaulting(ChronoField.SECOND_OF_MINUTE, 0L).parseDefaulting(ChronoField.NANO_OF_SECOND, 0L).parseDefaulting(ChronoField.ERA, 1L).toFormatter().withChronology(IsoChronology.INSTANCE).withResolverStyle(ResolverStyle.STRICT);
    }

    public static int compare(java.util.Date d1, java.util.Date d2) {
        if (d1 == null) {
            if (d2 != null) {
                return -1;
            }
        } else {
            long t2;
            if (d2 == null) {
                return 1;
            }
            long t1 = d1.toInstant().toEpochMilli();
            if (t1 < (t2 = d2.toInstant().toEpochMilli())) {
                return -1;
            }
            if (t1 > t2) {
                return -1;
            }
        }
        return 0;
    }

    public static DateTimeFormatter dayMonthYear(TextStyle monthStyle, String daySeparator, String monthSeparator, int yearDigits) {
        return DateUtils.build(builder -> {
            builder.appendValue(ChronoField.DAY_OF_MONTH);
            builder.appendLiteral(daySeparator);
            if (monthStyle != null) {
                builder.appendText((TemporalField)ChronoField.MONTH_OF_YEAR, monthStyle);
            } else {
                builder.appendValue(ChronoField.MONTH_OF_YEAR);
            }
            builder.appendLiteral(monthSeparator);
            if (yearDigits == 2) {
                builder.appendValueReduced((TemporalField)ChronoField.YEAR, 2, 2, LocalDate.now(ZoneId.systemDefault()).minusYears(80L));
            } else if (yearDigits == 4) {
                builder.appendValue(ChronoField.YEAR, 4, 10, SignStyle.NEVER);
            } else {
                throw new IllegalStateException();
            }
        });
    }

    public static boolean hasSameDate(ZonedDateTime lhs, ZonedDateTime rhs) {
        if (lhs == null) {
            return rhs == null;
        }
        if (rhs == null) {
            return false;
        }
        return lhs.getMonth() == rhs.getMonth() && lhs.getDayOfMonth() == rhs.getDayOfMonth() && lhs.getYear() == rhs.getYear();
    }

    public static boolean hasTimeComponent(java.util.Date date) {
        if (date != null) {
            long epochMillis = date.toInstant().toEpochMilli();
            long timePortion = epochMillis % 86400000L;
            return timePortion != 0L;
        }
        return false;
    }

    public static boolean hasTimeComponent(ZonedDateTime dateTime) {
        return dateTime != null && (dateTime.getHour() != 0 || dateTime.getMinute() != 0 || dateTime.getSecond() != 0 || dateTime.getNano() != 0);
    }

    public static boolean isUtc(ZonedDateTime date) {
        if (date == null) {
            return false;
        }
        return UTC_ZONE.equals(date.getZone());
    }

    public static DateTimeFormatter monthDayYear(TextStyle monthStyle, String monthSeparator, String daySeparator, int yearDigits, boolean time) {
        return DateUtils.build(builder -> {
            if (monthStyle != null) {
                builder.appendText((TemporalField)ChronoField.MONTH_OF_YEAR, monthStyle);
            } else {
                builder.appendValue(ChronoField.MONTH_OF_YEAR);
            }
            builder.appendLiteral(monthSeparator);
            builder.appendValue(ChronoField.DAY_OF_MONTH);
            builder.appendLiteral(daySeparator);
            if (yearDigits == 2) {
                builder.appendValueReduced((TemporalField)ChronoField.YEAR, 2, 2, LocalDate.now(ZoneId.systemDefault()).minusYears(80L));
            } else if (yearDigits == 4) {
                builder.appendValue(ChronoField.YEAR, 4, 10, SignStyle.NEVER);
            } else {
                throw new IllegalStateException();
            }
            if (time) {
                builder.appendLiteral(' ').append(TIME);
            }
        });
    }

    public static ZonedDateTime nowWithZoneUtc() {
        return ZonedDateTime.now(ZoneOffset.UTC);
    }

    public static <T> T parse(String text, ZoneId zoneIfNotSpecified, TemporalQuery<T> query) {
        try {
            T date = DateUtils.parseChecked(text, zoneIfNotSpecified, query);
            return date;
        }
        catch (DateTimeParseException e2) {
            LOGGER.trace("{}", (Object)e2.getMessage());
            return null;
        }
    }

    public static <T> T parseChecked(String text, ZoneId zoneIfNotSpecified, TemporalQuery<T> query) throws DateTimeParseException {
        if (StringUtils.isBlank(text)) {
            return null;
        }
        try {
            T date = ZONED_DATE_TIME_PARSER.parse((CharSequence)text, query);
            return date;
        }
        catch (DateTimeParseException e1) {
            T date = ZONED_DATE_TIME_PARSER.withZone(zoneIfNotSpecified).parse((CharSequence)text, query);
            return date;
        }
    }

    public static ZonedDateTime randomZonedDateTimeUtc(Random random, ZonedDateTime from, ZonedDateTime to) {
        long begin = DateUtils.toEpochMillisUtc(from);
        long end = DateUtils.toEpochMillisUtc(to);
        long range = end - begin + 1L;
        long epoch = begin + (long)(random.nextDouble() * (double)range);
        return DateUtils.toZonedDateTimeUtc(epoch, EpochUnits.MILLISECONDS);
    }

    public static ZonedDateTime randomZonedDateTimeUtc(ZonedDateTime from, ZonedDateTime to) {
        return DateUtils.randomZonedDateTimeUtc(JVM_RANDOM, from, to);
    }

    public static long timeBetween(ZonedDateTime firstDate, ZonedDateTime secondDate, ChronoUnit units) {
        Preconditions.checkArgument(units != null, "units must be non-null");
        LocalDate first = DateUtils.toUtc(firstDate).toLocalDate();
        LocalDate after = DateUtils.toUtc(secondDate).toLocalDate();
        return Math.abs(units.between(first, after));
    }

    public static java.util.Date toDate(Instant instant) {
        return instant != null ? java.util.Date.from(instant) : null;
    }

    public static java.util.Date toDate(LocalDateTime date) {
        return date != null ? DateUtils.toDate(date.atZone(ZoneOffset.systemDefault())) : null;
    }

    public static java.util.Date toDate(LocalDateTime date, ZoneOffset offset) {
        return date != null ? DateUtils.toDate(date.toInstant(offset)) : null;
    }

    public static java.util.Date toDate(ZonedDateTime date) {
        return date != null ? java.util.Date.from(date.toInstant()) : null;
    }

    public static long toEpochMillisUtc(ZonedDateTime date) {
        Preconditions.checkArgument(date != null, "date must be non-null");
        return DateUtils.toUtc(date).toInstant().toEpochMilli();
    }

    private static Instant toInstant(java.util.Date date) {
        Instant instant = date instanceof Date ? Instant.ofEpochMilli(date.getTime()) : date.toInstant();
        return instant;
    }

    public static LocalDateTime toLocalDateTime(String text) {
        return DateUtils.parse(text, ZoneOffset.systemDefault(), LocalDateTime::from);
    }

    public static LocalDateTime toLocalDateTimeChecked(String text) throws DateTimeParseException {
        return DateUtils.parseChecked(text, ZoneOffset.systemDefault(), LocalDateTime::from);
    }

    public static long toNanos(int millis) {
        return TimeUnit.MILLISECONDS.toNanos(millis);
    }

    public static String toStringIsoFormat(String date) {
        return DateUtils.toStringIsoFormat(DateUtils.toZonedDateTimeUtc(date));
    }

    public static String toStringIsoFormat(ZonedDateTime date) {
        return date != null ? date.withZoneSameInstant(ZoneOffset.UTC).format(ISO_8601_NANOS) : null;
    }

    public static ZonedDateTime toUtc(ZonedDateTime date) {
        return date != null ? date.withZoneSameInstant(ZoneOffset.UTC) : null;
    }

    public static ZonedDateTime toZonedDateTimeUtc(java.util.Date date) {
        return date != null ? DateUtils.toZonedDateTimeUtc(DateUtils.toInstant(date)) : null;
    }

    public static ZonedDateTime toZonedDateTimeUtc(Instant instant) {
        return instant != null ? ZonedDateTime.ofInstant(instant, ZoneOffset.UTC) : null;
    }

    public static ZonedDateTime toZonedDateTimeUtc(int year, Month month, int dayOfMonth) {
        return DateUtils.toZonedDateTimeUtc(LocalDate.of(year, month, dayOfMonth));
    }

    public static ZonedDateTime toZonedDateTimeUtc(LocalDate date) {
        return date != null ? date.atStartOfDay(UTC_ZONE) : null;
    }

    public static ZonedDateTime toZonedDateTimeUtc(long epoch) {
        EpochUnits units = EpochUnits.valueOf(epoch);
        return DateUtils.toZonedDateTimeUtc(epoch, units);
    }

    public static ZonedDateTime toZonedDateTimeUtc(long epochValue, EpochUnits units) {
        Preconditions.checkArgument(units != null, "units must be non-null");
        Instant instant = units.toInstant(epochValue);
        return ZonedDateTime.ofInstant(instant, ZoneOffset.UTC);
    }

    public static ZonedDateTime toZonedDateTimeUtc(String text) {
        ZonedDateTime date = DateUtils.parse(text, ZoneOffset.systemDefault(), ZonedDateTime::from);
        return date != null ? DateUtils.toUtc(date) : null;
    }

    public static ZonedDateTime toZonedDateTimeUtcChecked(String text) throws DateTimeParseException {
        ZonedDateTime date = DateUtils.parseChecked(text, ZoneOffset.systemDefault(), ZonedDateTime::from);
        return date != null ? DateUtils.toUtc(date) : null;
    }

    public static ZonedDateTime withDatePrecision(ZonedDateTime date) {
        return DateUtils.toZonedDateTimeUtc(DateUtils.toDate(date));
    }

    public static DateTimeFormatter yearMonthDay(TextStyle monthStyle, String yearSeparator, String monthSeparator, int yearDigits, boolean time) {
        return DateUtils.build(builder -> {
            if (yearDigits == 2) {
                builder.appendValueReduced((TemporalField)ChronoField.YEAR, 2, 2, LocalDate.now(ZoneId.systemDefault()).minusYears(80L));
            } else if (yearDigits == 4) {
                builder.appendValue(ChronoField.YEAR, 4, 10, SignStyle.NEVER);
            } else {
                throw new IllegalStateException();
            }
            builder.appendLiteral(yearSeparator);
            if (monthStyle != null) {
                builder.appendText((TemporalField)ChronoField.MONTH_OF_YEAR, monthStyle);
            } else {
                builder.appendValue(ChronoField.MONTH_OF_YEAR);
            }
            builder.appendLiteral(monthSeparator);
            builder.appendValue(ChronoField.DAY_OF_MONTH);
            if (time) {
                builder.appendLiteral(' ').append(TIME);
            }
        });
    }

    public static enum EpochUnits {
        NANOSECONDS{

            @Override
            public boolean isValid(long epoch) {
                return epoch <= -10000000000000000L || epoch >= 10000000000000000L;
            }

            @Override
            public long toMillis(long value) {
                return value / 1000000L;
            }
        }
        ,
        MICROSECONDS{

            @Override
            public boolean isValid(long epoch) {
                return epoch <= -100000000000000L || epoch >= 100000000000000L;
            }

            @Override
            public long toMillis(long value) {
                return value / 1000L;
            }
        }
        ,
        MILLISECONDS{

            @Override
            public boolean isValid(long epoch) {
                return epoch <= -30000000000L || epoch >= 100000000000L;
            }

            @Override
            public long toMillis(long value) {
                return value;
            }
        }
        ,
        SECONDS{

            @Override
            public boolean isValid(long epoch) {
                return true;
            }

            @Override
            public long toMillis(long value) {
                return value * 1000L;
            }
        };


        public static EpochUnits valueOf(long epoch) {
            if (NANOSECONDS.isValid(epoch)) {
                return NANOSECONDS;
            }
            if (MICROSECONDS.isValid(epoch)) {
                return MICROSECONDS;
            }
            if (MILLISECONDS.isValid(epoch)) {
                return MILLISECONDS;
            }
            return SECONDS;
        }

        public abstract boolean isValid(long var1);

        public Instant toInstant(long value) {
            long epochMillis = this.toMillis(value);
            return Instant.ofEpochMilli(epochMillis);
        }

        public abstract long toMillis(long var1);
    }
}

