/*
 * Decompiled with CFR 0.152.
 */
package com.arakelian.core.enums;

import com.google.common.collect.ImmutableSortedSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public enum IsoCountryCode {
    AF("Afghanistan", false, false, "\\d{4}", null, null, null, null),
    AX("\u00c5land Islands", false, false, "22\\d{3}", "%O%n%N%n%1%n%2%nAX-%Z %C%n\u00c5LAND%n%I", null, null, null),
    AL("Albania", false, false, "\\d{4}", null, null, null, null),
    DZ("Algeria", false, false, "\\d{5}", "%N%n%O%n%1%n%2%n%Z %C%n%I", null, null, null),
    AS("American Samoa", false, false, "(96799)(?:[ \\-](\\d{4}))?", "%N%n%O%n%1%n%2%n%C %S %Z%n%I", null, null, null),
    AD("Andorra", false, false, "AD[1-7]0\\d", "%N%n%O%n%1%n%2%n%Z %C%n%I", new String[]{"Parr\u00f2quia d'Andorra la Vella", "Canillo", "Encamp", "Escaldes-Engordany", "La Massana", "Ordino", "Sant Juli\u00e0 de L\u00f2ria"}, new String[]{"Andorra la Vella", "Canillo", "Encamp", "Escaldes-Engordany", "La Massana", "Ordino", "Sant Juli\u00e0 de L\u00f2ria"}, null),
    AO("Angola", false, false, null, null, null, null, null),
    AI("Anguilla", false, false, "2640", null, null, null, null),
    AQ("Antarctica", false, false, null, null, null, null, null),
    AG("Antigua And Barbuda", false, false, null, null, null, null, null),
    AR("Argentina", false, false, "((?:[A-HJ-NP-Z])?\\d{4})([A-Z]{3})?", "%N%n%O%n%1%n%2%n%Z %C%n%S%n%I", new String[]{"Buenos Aires", "Catamarca", "Chaco", "Chubut", "Ciudad Aut\u00f3noma de Buenos Aires", "C\u00f3rdoba", "Corrientes", "Entre R\u00edos", "Formosa", "Jujuy", "La Pampa", "La Rioja", "Mendoza", "Misiones", "Neuqu\u00e9n", "R\u00edo Negro", "Salta", "San Juan", "San Luis", "Santa Cruz", "Santa Fe", "Santiago del Estero", "Tierra del Fuego", "Tucum\u00e1n"}, new String[]{"Buenos Aires", "Catamarca", "Chaco", "Chubut", "Ciudad de Buenos Aires", "C\u00f3rdoba", "Corrientes", "Entre R\u00edos", "Formosa", "Jujuy", "La Pampa", "La Rioja", "Mendoza", "Misiones", "Neuqu\u00e9n", "R\u00edo Negro", "Salta", "San Juan", "San Luis", "Santa Cruz", "Santa Fe", "Santiago del Estero", "Tierra del Fuego", "Tucum\u00e1n"}, null),
    AM("Armenia", false, false, "(37)?\\d{4}", "%N%n%O%n%1%n%2%n%Z%n%C%n%S%n%I", new String[]{"\u0531\u0580\u0561\u0563\u0561\u056e\u0578\u057f\u0576", "\u0531\u0580\u0561\u0580\u0561\u057f", "\u0531\u0580\u0574\u0561\u057e\u056b\u0580", "\u0533\u0565\u0572\u0561\u0580\u0584\u0578\u0582\u0576\u056b\u0584", "\u0535\u0580\u0587\u0561\u0576", "\u053c\u0578\u057c\u056b", "\u053f\u0578\u057f\u0561\u0575\u0584", "\u0547\u056b\u0580\u0561\u056f", "\u054d\u0575\u0578\u0582\u0576\u056b\u0584", "\u054e\u0561\u0575\u0578\u0581 \u0571\u0578\u0580", "\u054f\u0561\u057e\u0578\u0582\u0577"}, null, new String[]{"Aragatsotn", "Ararat", "Armavir", "Gegharkunik", "Yerevan", "Lori", "Kotayk", "Shirak", "Syunik", "Vayots Dzor", "Tavush"}),
    AW("Aruba", false, false, null, null, null, null, null),
    AU("Australia", false, false, "\\d{4}", "%O%n%N%n%1%n%2%n%C %S %Z%n%I", new String[]{"ACT", "NSW", "NT", "QLD", "SA", "TAS", "VIC", "WA"}, new String[]{"Australian Capital Territory", "New South Wales", "Northern Territory", "Queensland", "South Australia", "Tasmania", "Victoria", "Western Australia"}, null),
    AT("Austria", true, true, "\\d{4}", "%O%n%N%n%1%n%2%n%Z %C%n%I", null, null, null),
    AZ("Azerbaijan", false, false, "\\d{4}", "%N%n%O%n%1%n%2%nAZ %Z %C%n%I", null, null, null),
    BS("Bahamas", false, false, null, "%N%n%O%n%1%n%2%n%C, %S%n%I", new String[]{"ABACO", "ACKLINS", "ANDROS", "BERRY ISLANDS", "BIMINI", "CAT ISLAND", "CROOKED ISLAND", "ELEUTHERA", "EXUMA", "GRAND BAHAMA", "HARBOUR ISLAND", "INAGUA", "LONG ISLAND", "MAYAGUANA", "N.P.", "RAGGED ISLAND", "RUM CAY", "SAN SALVADOR", "SPANISH WELLS"}, new String[]{"Abaco Islands", "Acklins", "Andros Island", "Berry Islands", "Bimini", "Cat Island", "Crooked Island", "Eleuthera", "Exuma and Cays", "Grand Bahama", "Harbour Island", "Inagua", "Long Island", "Mayaguana", "New Providence", "Ragged Island", "Rum Cay", "San Salvador", "Spanish Wells"}, null),
    BH("Bahrain", false, false, "(?:(?:\\d|1[0-2])\\d{2})?", "%N%n%O%n%1%n%2%n%C %Z%n%I", null, null, null),
    BD("Bangladesh", false, false, "\\d{4}", "%N%n%O%n%1%n%2%n%C - %Z%n%I", null, null, null),
    BB("Barbados", false, false, "(?:BB\\d{5})?", null, null, null, null),
    BY("Belarus", false, false, "\\d{6}", "%S%n%Z %C %X%n%1%n%2%n%O%n%N%n%I", null, null, null),
    BE("Belgium", true, true, "\\d{4}", "%O%n%N%n%1%n%2%n%Z %C%n%I", null, null, null),
    BZ("Belize", false, false, null, null, null, null, null),
    BJ("Benin", false, false, null, null, null, null, null),
    BM("Bermuda", false, false, "[A-Z]{2}[ ]?[A-Z0-9]{2}", "%N%n%O%n%1%n%2%n%C %Z%n%I", null, null, null),
    BT("Bhutan", false, false, "\\d{5}", null, null, null, null),
    BO("Bolivia, Plurinational State Of", false, false, null, null, null, null, null),
    BQ("Bonaire, Sint Eustatius And Saba", false, false, null, null, null, null, null),
    BA("Bosnia And Herzegovina", false, false, "\\d{5}", "%N%n%O%n%1%n%2%n%Z %C%n%I", null, null, null),
    BW("Botswana", false, false, null, null, null, null, null),
    BV("Bouvet Island", false, false, null, null, null, null, null),
    BR("Brazil", false, false, "\\d{5}[\\-]?\\d{3}", "%O%n%N%n%1%n%2%n%D%n%C-%S%n%Z%n%I", new String[]{"AC", "AL", "AP", "AM", "BA", "CE", "DF", "ES", "GO", "MA", "MT", "MS", "MG", "PA", "PB", "PR", "PE", "PI", "RJ", "RN", "RS", "RO", "RR", "SC", "SP", "SE", "TO"}, new String[]{"Acre", "Alagoas", "Amap\u00e1", "Amazonas", "Bahia", "Cear\u00e1", "Distrito Federal", "Esp\u00edrito Santo", "Goi\u00e1s", "Maranh\u00e3o", "Mato Grosso", "Mato Grosso do Sul", "Minas Gerais", "Par\u00e1", "Para\u00edba", "Paran\u00e1", "Pernambuco", "Piau\u00ed", "Rio de Janeiro", "Rio Grande do Norte", "Rio Grande do Sul", "Rond\u00f4nia", "Roraima", "Santa Catarina", "S\u00e3o Paulo", "Sergipe", "Tocantins"}, null),
    IO("British Indian Ocean Territory", false, false, "BBND 1ZZ", "%N%n%O%n%1%n%2%n%X%n%C%n%Z%n%I", null, null, null),
    BN("Brunei Darussalam", false, false, "[A-Z]{2}[ ]?\\d{4}", "%N%n%O%n%1%n%2%n%C %Z%n%I", null, null, null),
    BG("Bulgaria", true, false, "\\d{4}", "%N%n%O%n%1%n%2%n%Z %C%n%I", null, null, null),
    BF("Burkina Faso", false, false, null, "%N%n%O%n%1%n%2%n%C %X%n%I", null, null, null),
    BI("Burundi", false, false, null, null, null, null, null),
    KH("Cambodia", false, false, "\\d{5}", "%N%n%O%n%1%n%2%n%C %Z%n%I", null, null, null),
    CM("Cameroon", false, false, null, null, null, null, null),
    CA("Canada", false, false, "[ABCEGHJKLMNPRSTVXY]\\d[ABCEGHJ-NPRSTV-Z][ ]?\\d[ABCEGHJ-NPRSTV-Z]\\d", "%N%n%O%n%1%n%2%n%C %S %Z%n%I", new String[]{"AB", "BC", "MB", "NB", "NL", "NT", "NS", "NU", "ON", "PE", "QC", "SK", "YT"}, new String[]{"Alberta", "British Columbia", "Manitoba", "New Brunswick", "Newfoundland and Labrador", "Northwest Territories", "Nova Scotia", "Nunavut", "Ontario", "Prince Edward Island", "Quebec", "Saskatchewan", "Yukon"}, null),
    CV("Cape Verde", false, false, "\\d{4}", "%N%n%O%n%1%n%2%n%Z %C%n%S%n%I", new String[]{"Boa Vista", "Brava", "Fogo", "Maio", "Sal", "Santiago", "Santo Ant\u00e3o", "S\u00e3o Nicolau", "S\u00e3o Vicente"}, null, null),
    KY("Cayman Islands", false, false, "KY\\d-\\d{4}", "%N%n%O%n%1%n%2%n%S %Z%n%I", new String[]{"CAYMAN BRAC", "GRAND CAYMAN", "LITTLE CAYMAN"}, null, null),
    CF("Central African Republic", false, false, null, null, null, null, null),
    TD("Chad", false, false, null, null, null, null, null),
    CL("Chile", false, false, "\\d{7}", "%N%n%O%n%1%n%2%n%Z %C%n%S%n%I", new String[]{"Antofagasta", "Araucan\u00eda", "Arica y Parinacota", "Atacama", "Ays\u00e9n", "Biob\u00edo", "Coquimbo", "O'Higgins", "Los Lagos", "Los R\u00edos", "Magallanes", "Maule", "Regi\u00f3n Metropolitana", "Tarapac\u00e1", "Valpara\u00edso"}, new String[]{"Antofagasta", "Araucan\u00eda", "Arica y Parinacota", "Atacama", "Ays\u00e9n del General Carlos Ib\u00e1\u00f1ez del Campo", "Biob\u00edo", "Coquimbo", "Libertador General Bernardo O'Higgins", "Los Lagos", "Los R\u00edos", "Magallanes y de la Ant\u00e1rtica Chilena", "Maule", "Metropolitana de Santiago", "Tarapac\u00e1", "Valpara\u00edso"}, null),
    CN("China", false, false, "\\d{6}", "%Z%n%S%C%D%n%1%n%2%n%O%n%N%n%I", new String[]{"\u5b89\u5fbd\u7701", "\u6fb3\u95e8", "\u5317\u4eac\u5e02", "\u91cd\u5e86\u5e02", "\u798f\u5efa\u7701", "\u7518\u8083\u7701", "\u5e7f\u4e1c\u7701", "\u5e7f\u897f\u58ee\u65cf\u81ea\u6cbb\u533a", "\u8d35\u5dde\u7701", "\u6d77\u5357\u7701", "\u6cb3\u5317\u7701", "\u6cb3\u5357\u7701", "\u9ed1\u9f99\u6c5f\u7701", "\u6e56\u5317\u7701", "\u6e56\u5357\u7701", "\u5409\u6797\u7701", "\u6c5f\u82cf\u7701", "\u6c5f\u897f\u7701", "\u8fbd\u5b81\u7701", "\u5185\u8499\u53e4\u81ea\u6cbb\u533a", "\u5b81\u590f\u56de\u65cf\u81ea\u6cbb\u533a", "\u9752\u6d77\u7701", "\u5c71\u4e1c\u7701", "\u5c71\u897f\u7701", "\u9655\u897f\u7701", "\u4e0a\u6d77\u5e02", "\u56db\u5ddd\u7701", "\u53f0\u6e7e", "\u5929\u6d25\u5e02", "\u897f\u85cf\u81ea\u6cbb\u533a", "\u9999\u6e2f", "\u65b0\u7586\u7ef4\u543e\u5c14\u81ea\u6cbb\u533a", "\u4e91\u5357\u7701", "\u6d59\u6c5f\u7701"}, new String[]{"\u5b89\u5fbd\u7701", "\u6fb3\u95e8", "\u5317\u4eac\u5e02", "\u91cd\u5e86\u5e02", "\u798f\u5efa\u7701", "\u7518\u8083\u7701", "\u5e7f\u4e1c\u7701", "\u5e7f\u897f", "\u8d35\u5dde\u7701", "\u6d77\u5357\u7701", "\u6cb3\u5317\u7701", "\u6cb3\u5357\u7701", "\u9ed1\u9f99\u6c5f\u7701", "\u6e56\u5317\u7701", "\u6e56\u5357\u7701", "\u5409\u6797\u7701", "\u6c5f\u82cf\u7701", "\u6c5f\u897f\u7701", "\u8fbd\u5b81\u7701", "\u5185\u8499\u53e4", "\u5b81\u590f", "\u9752\u6d77\u7701", "\u5c71\u4e1c\u7701", "\u5c71\u897f\u7701", "\u9655\u897f\u7701", "\u4e0a\u6d77\u5e02", "\u56db\u5ddd\u7701", "\u53f0\u6e7e", "\u5929\u6d25\u5e02", "\u897f\u85cf", "\u9999\u6e2f", "\u65b0\u7586", "\u4e91\u5357\u7701", "\u6d59\u6c5f\u7701"}, new String[]{"Anhui Sheng", "Macau", "Beijing Shi", "Chongqing Shi", "Fujian Sheng", "Gansu Sheng", "Guangdong Sheng", "Guangxi Zhuangzuzizhiqu", "Guizhou Sheng", "Hainan Sheng", "Hebei Sheng", "Henan Sheng", "Heilongjiang Sheng", "Hubei Sheng", "Hunan Sheng", "Jilin Sheng", "Jiangsu Sheng", "Jiangxi Sheng", "Liaoning Sheng", "Neimenggu Zizhiqu", "Ningxia Huizuzizhiqu", "Qinghai Sheng", "Shandong Sheng", "Shanxi Sheng", "Shaanxi Sheng", "Shanghai Shi", "Sichuan Sheng", "Taiwan", "Tianjin Shi", "Xizang Zizhiqu", "Hong Kong", "Xinjiang Weiwuerzizhiqu", "Yunnan Sheng", "Zhejiang Sheng"}),
    CX("Christmas Island", false, false, "6798", "%O%n%N%n%1%n%2%n%C %S %Z%n%I", null, null, null),
    CC("Cocos (keeling) Islands", false, false, "6799", "%O%n%N%n%1%n%2%n%C %S %Z%n%I", null, null, null),
    CO("Colombia", false, false, "\\d{6}", "%N%n%O%n%1%n%2%n%C, %S%n%I", null, null, null),
    KM("Comoros", false, false, null, null, null, null, null),
    CG("Congo", false, false, null, null, null, null, null),
    CD("Congo, The Democratic Republic Of The", false, false, null, "%N%n%O%n%1%n%2%n%C %X%n%I", null, null, null),
    CK("Cook Islands", false, false, null, null, null, null, null),
    CR("Costa Rica", false, false, "\\d{4,5}|\\d{3}-\\d{4}", "%N%n%O%n%1%n%2%n%Z %C%n%I", null, null, null),
    CI("C\u00f4te D'ivoire", false, false, null, "%N%n%O%n%X %1 %2 %C %X%n%I", null, null, null),
    HR("Croatia", true, false, "\\d{5}", "%N%n%O%n%1%n%2%nHR-%Z %C%n%I", null, null, null),
    CU("Cuba", false, false, null, null, null, null, null),
    CW("Cura\u00e7ao", false, false, null, null, null, null, null),
    CY("Cyprus", true, true, "\\d{4}", "%N%n%O%n%1%n%2%n%Z %C%n%I", null, null, null),
    CZ("Czech Republic", true, false, "\\d{3}[ ]?\\d{2}", "%N%n%O%n%1%n%2%n%Z %C%n%I", null, null, null),
    DK("Denmark", true, false, "\\d{4}", "%N%n%O%n%1%n%2%n%Z %C%n%I", null, null, null),
    DJ("Djibouti", false, false, null, null, null, null, null),
    DM("Dominica", false, false, null, null, null, null, null),
    DO("Dominican Republic", false, false, "\\d{5}", "%N%n%O%n%1%n%2%n%Z %C%n%I", null, null, null),
    EC("Ecuador", false, false, "(?:[A-Z]\\d{4}[A-Z]|(?:[A-Z]{2})?\\d{6})?", "%N%n%O%n%1%n%2%n%Z%n%C%n%I", null, null, null),
    EG("Egypt", false, false, "\\d{5}", "%N%n%O%n%1%n%2%n%C%n%S%n%Z%n%I", new String[]{"\u0623\u0633\u0648\u0627\u0646", "\u0623\u0633\u064a\u0648\u0637", "\u0627\u0644\u0625\u0633\u0643\u0646\u062f\u0631\u064a\u0629", "\u0627\u0644\u0625\u0633\u0645\u0627\u0639\u064a\u0644\u064a\u0629", "\u0627\u0644\u0623\u0642\u0635\u0631", "\u0627\u0644\u0628\u062d\u0631 \u0627\u0644\u0623\u062d\u0645\u0631", "\u0627\u0644\u0628\u062d\u064a\u0631\u0629", "\u0627\u0644\u062c\u064a\u0632\u0629", "\u0627\u0644\u062f\u0642\u0647\u0644\u064a\u0629", "\u0627\u0644\u0633\u0648\u064a\u0633", "\u0627\u0644\u0634\u0631\u0642\u064a\u0629", "\u0627\u0644\u063a\u0631\u0628\u064a\u0629", "\u0627\u0644\u0641\u064a\u0648\u0645", "\u0627\u0644\u0642\u0627\u0647\u0631\u0629", "\u0627\u0644\u0642\u0644\u064a\u0648\u0628\u064a\u0629", "\u0627\u0644\u0645\u0646\u0648\u0641\u064a\u0629", "\u0627\u0644\u0645\u0646\u064a\u0627", "\u0627\u0644\u0648\u0627\u062f\u064a \u0627\u0644\u062c\u062f\u064a\u062f", "\u0628\u0646\u064a \u0633\u0648\u064a\u0641", "\u0628\u0648\u0631\u0633\u0639\u064a\u062f", "\u062c\u0646\u0648\u0628 \u0633\u064a\u0646\u0627\u0621", "\u062f\u0645\u064a\u0627\u0637", "\u0633\u0648\u0647\u0627\u062c", "\u0634\u0645\u0627\u0644 \u0633\u064a\u0646\u0627\u0621", "\u0642\u0646\u0627", "\u0643\u0641\u0631 \u0627\u0644\u0634\u064a\u062e", "\u0645\u0637\u0631\u0648\u062d"}, null, new String[]{"Aswan Governorate", "Asyut Governorate", "Alexandria Governorate", "Ismailia Governorate", "Luxor Governorate", "Red Sea Governorate", "El Beheira Governorate", "Giza Governorate", "Dakahlia Governorate", "Suez Governorate", "Ash Sharqia Governorate", "Gharbia Governorate", "Faiyum Governorate", "Cairo Governorate", "Qalyubia Governorate", "Menofia Governorate", "Menia Governorate", "New Valley Governorate", "Beni Suef Governorate", "Port Said Governorate", "South Sinai Governorate", "Damietta Governorate", "Sohag Governorate", "North Sinai Governorate", "Qena Governorate", "Kafr El Sheikh Governorate", "Matruh Governorate"}),
    SV("El Salvador", false, false, "CP [1-3][1-7][0-2]\\d", "%N%n%O%n%1%n%2%n%Z-%C%n%S%n%I", new String[]{"AHUACHAPAN", "CABANAS", "CALATENANGO", "CUSCATLAN", "LA LIBERTAD", "LA PAZ", "LA UNION", "MORAZAN", "SAN MIGUEL", "SAN SALVADOR", "SAN VICENTE", "SANTA ANA", "SONSONATE", "USULUTAN"}, new String[]{"Ahuachap\u00e1n", "Caba\u00f1as", "Chalatenango", "Cuscatl\u00e1n", "La Libertad", "La Paz", "La Uni\u00f3n", "Moraz\u00e1n", "San Miguel", "San Salvador", "San Vicente", "Santa Ana", "Sonsonate", "Usulut\u00e1n"}, null),
    GQ("Equatorial Guinea", false, false, null, null, null, null, null),
    ER("Eritrea", false, false, null, null, null, null, null),
    EE("Estonia", true, true, "\\d{5}", "%N%n%O%n%1%n%2%n%Z %C%n%I", null, null, null),
    ET("Ethiopia", false, false, "\\d{4}", "%N%n%O%n%1%n%2%n%Z %C%n%I", null, null, null),
    FK("Falkland Islands (malvinas)", false, false, "FIQQ 1ZZ", "%N%n%O%n%1%n%2%n%X%n%C%n%Z%n%I", null, null, null),
    FO("Faroe Islands", false, false, "\\d{3}", "%N%n%O%n%1%n%2%nFO%Z %C%n%I", null, null, null),
    FJ("Fiji", false, false, null, null, null, null, null),
    FI("Finland", true, true, "\\d{5}", "%O%n%N%n%1%n%2%nFI-%Z %C%n%I", null, null, null),
    FR("France", true, true, "\\d{2}[ ]?\\d{3}", "%O%n%N%n%1%n%2%n%Z %C %X%n%I", null, null, null),
    GF("French Guiana", false, false, "9[78]3\\d{2}", "%O%n%N%n%1%n%2%n%Z %C %X%n%I", null, null, null),
    PF("French Polynesia", false, false, "987\\d{2}", "%N%n%O%n%1%n%2%n%Z %C %S%n%I", null, null, null),
    TF("French Southern Territories", false, false, null, null, null, null, null),
    GA("Gabon", false, false, null, null, null, null, null),
    GM("Gambia", false, false, null, null, null, null, null),
    GE("Georgia", false, false, "\\d{4}", "%N%n%O%n%1%n%2%n%Z %C%n%I", null, null, null),
    DE("Germany", true, true, "\\d{5}", "%N%n%O%n%1%n%2%n%Z %C%n%I", null, null, null),
    GH("Ghana", false, false, null, null, null, null, null),
    GI("Gibraltar", false, false, "GX11 1AA", "%N%n%O%n%1%n%2%nGIBRALTAR%n%Z%n%I", null, null, null),
    GR("Greece", true, true, "\\d{3} ?\\d{2}", "%N%n%O%n%1%n%2%n%Z %C%n%I", null, null, null),
    GL("Greenland", false, false, "39\\d{2}", "%N%n%O%n%1%n%2%n%Z %C%n%I", null, null, null),
    GD("Grenada", false, false, null, null, null, null, null),
    GP("Guadeloupe", false, false, "9[78][01]\\d{2}", "%O%n%N%n%1%n%2%n%Z %C %X%n%I", null, null, null),
    GU("Guam", false, false, "(969(?:[12]\\d|3[12]))(?:[ \\-](\\d{4}))?", "%N%n%O%n%1%n%2%n%C %S %Z%n%I", null, null, null),
    GT("Guatemala", false, false, "\\d{5}", "%N%n%O%n%1%n%2%n%Z- %C%n%I", null, null, null),
    GG("Guernsey", false, false, "GY\\d[\\dA-Z]?[ ]?\\d[ABD-HJLN-UW-Z]{2}", "%N%n%O%n%1%n%2%n%X%n%C%nGUERNSEY%n%Z%n%I", null, null, null),
    GN("Guinea", false, false, "\\d{3}", "%N%n%O%n%Z %1 %2 %C%n%I", null, null, null),
    GW("Guinea-bissau", false, false, "\\d{4}", "%N%n%O%n%1%n%2%n%Z %C%n%I", null, null, null),
    GY("Guyana", false, false, null, null, null, null, null),
    HT("Haiti", false, false, "\\d{4}", "%N%n%O%n%1%n%2%nHT%Z %C %X%n%I", null, null, null),
    HM("Heard Island And Mcdonald Islands", false, false, "\\d{4}", "%O%n%N%n%1%n%2%n%C %S %Z%n%I", null, null, null),
    VA("Holy See (vatican City State)", false, false, "00120", "%N%n%O%n%1%n%2%n%Z %C%n%I", null, null, null),
    HN("Honduras", false, false, "\\d{5}", "%N%n%O%n%1%n%2%n%C, %S%n%Z%n%I", null, null, null),
    HK("Hong Kong", false, false, null, "%S%n%C%n%1%n%2%n%O%n%N%n%I", new String[]{"\u4e5d\u9f8d", "\u9999\u6e2f\u5cf6", "\u65b0\u754c"}, null, new String[]{"Kowloon", "Hong Kong Island", "New Territories"}),
    HU("Hungary", true, false, "\\d{4}", "%N%n%O%n%C%n%1%n%2%n%Z%n%I", null, null, null),
    IS("Iceland", false, false, "\\d{3}", "%N%n%O%n%1%n%2%n%Z %C%n%I", null, null, null),
    IN("India", false, false, "\\d{6}", "%N%n%O%n%1%n%2%n%C %Z%n%S%n%I", new String[]{"Andaman and Nicobar Islands", "Andhra Pradesh", "Arunachal Pradesh", "Assam", "Bihar", "Chandigarh", "Chhattisgarh", "Dadra and Nagar Haveli", "Daman and Diu", "Delhi", "Goa", "Gujarat", "Haryana", "Himachal Pradesh", "Jammu and Kashmir", "Jharkhand", "Karnataka", "Kerala", "Lakshadweep", "Madhya Pradesh", "Maharashtra", "Manipur", "Meghalaya", "Mizoram", "Nagaland", "Odisha", "Puducherry", "Punjab", "Rajasthan", "Sikkim", "Tamil Nadu", "Telangana", "Tripura", "Uttar Pradesh", "Uttarakhand", "West Bengal"}, new String[]{"Andaman & Nicobar", "Andhra Pradesh", "Arunachal Pradesh", "Assam", "Bihar", "Chandigarh", "Chhattisgarh", "Dadra & Nagar Haveli", "Daman & Diu", "Delhi", "Goa", "Gujarat", "Haryana", "Himachal Pradesh", "Jammu & Kashmir", "Jharkhand", "Karnataka", "Kerala", "Lakshadweep", "Madhya Pradesh", "Maharashtra", "Manipur", "Meghalaya", "Mizoram", "Nagaland", "Odisha", "Puducherry", "Punjab", "Rajasthan", "Sikkim", "Tamil Nadu", "Telangana", "Tripura", "Uttar Pradesh", "Uttarakhand", "West Bengal"}, null),
    ID("Indonesia", false, false, "\\d{5}", "%N%n%O%n%1%n%2%n%C%n%S %Z%n%I", new String[]{"Aceh", "Bali", "Banten", "Bengkulu", "Daerah Istimewa Yogyakarta", "DKI Jakarta", "Gorontalo", "Jambi", "Jawa Barat", "Jawa Tengah", "Jawa Timur", "Kalimantan Barat", "Kalimantan Selatan", "Kalimantan Tengah", "Kalimantan Timur", "Kepulauan Bangka Belitung", "Kepulauan Riau", "Lampung", "Maluku", "Maluku Utara", "Nusa Tenggara Barat", "Nusa Tenggara Timur", "Papua", "Papua Barat", "Riau", "Sulawesi Barat", "Sulawesi Selatan", "Sulawesi Tengah", "Sulawesi Tenggara", "Sulawesi Utara", "Sumatera Barat", "Sumatera Selatan", "Sumatera Utara"}, null, null),
    IR("Iran, Islamic Republic Of", false, false, "\\d{5}-?\\d{5}", "%O%n%N%n%S%n%C, %D%n%1%n%2%n%Z%n%I", null, null, null),
    IQ("Iraq", false, false, "\\d{5}", "%O%n%N%n%1%n%2%n%C, %S%n%Z%n%I", null, null, null),
    IE("Ireland", true, true, null, "%N%n%O%n%1%n%2%n%C%n%S%n%I", new String[]{"Co. Carlow", "Co. Cavan", "Co. Clare", "Co. Cork", "Co. Donegal", "Co. Dublin", "Co. Galway", "Co. Kerry", "Co. Kildare", "Co. Kilkenny", "Co. Laois", "Co. Leitrim", "Co. Limerick", "Co. Longford", "Co. Louth", "Co. Mayo", "Co. Meath", "Co. Monaghan", "Co. Offaly", "Co. Roscommon", "Co. Sligo", "Co. Tipperary", "Co. Waterford", "Co. Westmeath", "Co. Wexford", "Co. Wicklow"}, null, null),
    IM("Isle Of Man", false, false, "IM\\d[\\dA-Z]?[ ]?\\d[ABD-HJLN-UW-Z]{2}", "%N%n%O%n%1%n%2%n%X%n%C%n%Z%n%I", null, null, null),
    IL("Israel", false, false, "\\d{5}(?:\\d{2})?", "%N%n%O%n%1%n%2%n%C %Z%n%I", null, null, null),
    IT("Italy", true, true, "\\d{5}", "%N%n%O%n%1%n%2%n%Z %C %S%n%I", new String[]{"AG", "AL", "AN", "AR", "AP", "AT", "AV", "BA", "BT", "BL", "BN", "BG", "BI", "BO", "BZ", "BS", "BR", "CA", "CL", "CB", "CI", "CE", "CT", "CZ", "CH", "CO", "CS", "CR", "KR", "CN", "EN", "FM", "FE", "FI", "FG", "FC", "FR", "GE", "GO", "GR", "IM", "IS", "AQ", "SP", "LT", "LE", "LC", "LI", "LO", "LU", "MC", "MN", "MS", "MT", "VS", "ME", "MI", "MO", "MB", "NA", "NO", "NU", "OG", "OT", "OR", "PD", "PA", "PR", "PV", "PG", "PU", "PE", "PC", "PI", "PT", "PN", "PZ", "PO", "RG", "RA", "RC", "RE", "RI", "RN", "RM", "RO", "SA", "SS", "SV", "SI", "SR", "SO", "TA", "TE", "TR", "TO", "TP", "TN", "TV", "TS", "UD", "AO", "VA", "VE", "VB", "VC", "VR", "VV", "VI", "VT"}, new String[]{"Agrigento", "Alessandria", "Ancona", "Arezzo", "Ascoli Piceno", "Asti", "Avellino", "Bari", "Barletta-Andria-Trani", "Belluno", "Benevento", "Bergamo", "Biella", "Bologna", "Bolzano", "Brescia", "Brindisi", "Cagliari", "Caltanissetta", "Campobasso", "Carbonia-Iglesias", "Caserta", "Catania", "Catanzaro", "Chieti", "Como", "Cosenza", "Cremona", "Crotone", "Cuneo", "Enna", "Fermo", "Ferrara", "Firenze", "Foggia", "Forl\u00ec-Cesena", "Frosinone", "Genova", "Gorizia", "Grosseto", "Imperia", "Isernia", "L'Aquila", "La Spezia", "Latina", "Lecce", "Lecco", "Livorno", "Lodi", "Lucca", "Macerata", "Mantova", "Massa-Carrara", "Matera", "Medio Campidano", "Messina", "Milano", "Modena", "Monza e della Brianza", "Napoli", "Novara", "Nuoro", "Ogliastra", "Olbia-Tempio", "Oristano", "Padova", "Palermo", "Parma", "Pavia", "Perugia", "Pesaro e Urbino", "Pescara", "Piacenza", "Pisa", "Pistoia", "Pordenone", "Potenza", "Prato", "Ragusa", "Ravenna", "Reggio Calabria", "Reggio nell'Emilia", "Rieti", "Rimini", "Roma", "Rovigo", "Salerno", "Sassari", "Savona", "Siena", "Siracusa", "Sondrio", "Taranto", "Teramo", "Terni", "Torino", "Trapani", "Trento", "Treviso", "Trieste", "Udine", "Valle d'Aosta", "Varese", "Venezia", "Verbano-Cusio-Ossola", "Vercelli", "Verona", "Vibo Valentia", "Vicenza", "Viterbo"}, null),
    JM("Jamaica", false, false, null, "%N%n%O%n%1%n%2%n%C%n%S %X%n%I", new String[]{"Clarendon", "Hanover", "Kingston", "Manchester", "Portland", "St. Andrew", "St. Ann", "St. Catherine", "St. Elizabeth", "St. James", "St. Mary", "St. Thomas", "Trelawny", "Westmoreland"}, null, null),
    JP("Japan", false, false, "\\d{3}-?\\d{4}", "\u3012%Z%n%S%C%n%1%n%2%n%O%n%N%n%I", new String[]{"\u5317\u6d77\u9053", "\u9752\u68ee\u770c", "\u5ca9\u624b\u770c", "\u5bae\u57ce\u770c", "\u79cb\u7530\u770c", "\u5c71\u5f62\u770c", "\u798f\u5cf6\u770c", "\u8328\u57ce\u770c", "\u6803\u6728\u770c", "\u7fa4\u99ac\u770c", "\u57fc\u7389\u770c", "\u5343\u8449\u770c", "\u6771\u4eac\u90fd", "\u795e\u5948\u5ddd\u770c", "\u65b0\u6f5f\u770c", "\u5bcc\u5c71\u770c", "\u77f3\u5ddd\u770c", "\u798f\u4e95\u770c", "\u5c71\u68a8\u770c", "\u9577\u91ce\u770c", "\u5c90\u961c\u770c", "\u9759\u5ca1\u770c", "\u611b\u77e5\u770c", "\u4e09\u91cd\u770c", "\u6ecb\u8cc0\u770c", "\u4eac\u90fd\u5e9c", "\u5927\u962a\u5e9c", "\u5175\u5eab\u770c", "\u5948\u826f\u770c", "\u548c\u6b4c\u5c71\u770c", "\u9ce5\u53d6\u770c", "\u5cf6\u6839\u770c", "\u5ca1\u5c71\u770c", "\u5e83\u5cf6\u770c", "\u5c71\u53e3\u770c", "\u5fb3\u5cf6\u770c", "\u9999\u5ddd\u770c", "\u611b\u5a9b\u770c", "\u9ad8\u77e5\u770c", "\u798f\u5ca1\u770c", "\u4f50\u8cc0\u770c", "\u9577\u5d0e\u770c", "\u718a\u672c\u770c", "\u5927\u5206\u770c", "\u5bae\u5d0e\u770c", "\u9e7f\u5150\u5cf6\u770c", "\u6c96\u7e04\u770c"}, null, new String[]{"Hokkaido", "Aomori", "Iwate", "Miyagi", "Akita", "Yamagata", "Fukushima", "Ibaraki", "Tochigi", "Gunma", "Saitama", "Chiba", "Tokyo", "Kanagawa", "Niigata", "Toyama", "Ishikawa", "Fukui", "Yamanashi", "Nagano", "Gifu", "Shizuoka", "Aichi", "Mie", "Shiga", "Kyoto", "Osaka", "Hyogo", "Nara", "Wakayama", "Tottori", "Shimane", "Okayama", "Hiroshima", "Yamaguchi", "Tokushima", "Kagawa", "Ehime", "Kochi", "Fukuoka", "Saga", "Nagasaki", "Kumamoto", "Oita", "Miyazaki", "Kagoshima", "Okinawa"}),
    JE("Jersey", false, false, "JE\\d[\\dA-Z]?[ ]?\\d[ABD-HJLN-UW-Z]{2}", "%N%n%O%n%1%n%2%n%X%n%C%nJERSEY%n%Z%n%I", null, null, null),
    JO("Jordan", false, false, "\\d{5}", "%N%n%O%n%1%n%2%n%C %Z%n%I", null, null, null),
    KZ("Kazakhstan", false, false, "\\d{6}", "%Z%n%S%n%C%n%1%n%2%n%O%n%N%n%I", null, null, null),
    KE("Kenya", false, false, "\\d{5}", "%N%n%O%n%1%n%2%n%C%n%Z%n%I", null, null, null),
    KI("Kiribati", false, false, null, "%N%n%O%n%1%n%2%n%S%n%C%n%I", null, null, null),
    KP("Korea, Democratic People's Republic Of", false, false, null, null, null, null, null),
    KR("Korea, Republic Of", false, false, "\\d{3}[\\-]\\d{3}", "%S %C%D%n%1%n%2%n%O%n%N%n%Z%n%I", new String[]{"\uac15\uc6d0\ub3c4", "\uacbd\uae30\ub3c4", "\uacbd\uc0c1\ub0a8\ub3c4", "\uacbd\uc0c1\ubd81\ub3c4", "\uad11\uc8fc\uad11\uc5ed\uc2dc", "\ub300\uad6c\uad11\uc5ed\uc2dc", "\ub300\uc804\uad11\uc5ed\uc2dc", "\ubd80\uc0b0\uad11\uc5ed\uc2dc", "\uc11c\uc6b8\ud2b9\ubcc4\uc2dc", "\uc138\uc885\ud2b9\ubcc4\uc790\uce58\uc2dc", "\uc6b8\uc0b0\uad11\uc5ed\uc2dc", "\uc778\ucc9c\uad11\uc5ed\uc2dc", "\uc804\ub77c\ub0a8\ub3c4", "\uc804\ub77c\ubd81\ub3c4", "\uc81c\uc8fc\ud2b9\ubcc4\uc790\uce58\ub3c4", "\ucda9\uccad\ub0a8\ub3c4", "\ucda9\uccad\ubd81\ub3c4"}, new String[]{"\uac15\uc6d0", "\uacbd\uae30", "\uacbd\ub0a8", "\uacbd\ubd81", "\uad11\uc8fc", "\ub300\uad6c", "\ub300\uc804", "\ubd80\uc0b0", "\uc11c\uc6b8", "\uc138\uc885", "\uc6b8\uc0b0", "\uc778\ucc9c", "\uc804\ub0a8", "\uc804\ubd81", "\uc81c\uc8fc", "\ucda9\ub0a8", "\ucda9\ubd81"}, new String[]{"Gangwon-do", "Gyeonggi-do", "Gyeongsangnam-do", "Gyeongsangbuk-do", "Gwangju", "Daegu", "Daejeon", "Busan", "Seoul", "Sejong", "Ulsan", "Incheon", "Jeollanam-do", "Jeollabuk-do", "Jeju-do", "Chungcheongnam-do", "Chungcheongbuk-do"}),
    KW("Kuwait", false, false, "\\d{5}", "%N%n%O%n%1%n%2%n%Z %C%n%I", null, null, null),
    KG("Kyrgyzstan", false, false, "\\d{6}", "%Z %C %X%n%1%n%2%n%O%n%N%n%I", null, null, null),
    LA("Lao People's Democratic Republic", false, false, "\\d{5}", "%N%n%O%n%1%n%2%n%Z %C%n%I", null, null, null),
    LV("Latvia", true, true, "LV-\\d{4}", "%N%n%O%n%1%n%2%n%C, %Z%n%I", null, null, null),
    LB("Lebanon", false, false, "(?:(?:\\d{4})(?:[ ]?(?:\\d{4}))?)?", "%N%n%O%n%1%n%2%n%C %Z%n%I", null, null, null),
    LS("Lesotho", false, false, "\\d{3}", "%N%n%O%n%1%n%2%n%C %Z%n%I", null, null, null),
    LR("Liberia", false, false, "\\d{4}", "%N%n%O%n%1%n%2%n%Z %C %X%n%I", null, null, null),
    LY("Libya", false, false, null, null, null, null, null),
    LI("Liechtenstein", false, false, "(948[5-9])|(949[0-7])", "%O%n%N%n%1%n%2%nFL-%Z %C%n%I", null, null, null),
    LT("Lithuania", true, false, "\\d{5}", "%O%n%N%n%1%n%2%nLT-%Z %C%n%I", null, null, null),
    LU("Luxembourg", true, true, "\\d{4}", "%O%n%N%n%1%n%2%nL-%Z %C%n%I", null, null, null),
    MO("Macao", false, false, null, "%1%n%2%n%O%n%N%n%I", null, null, null),
    MK("Macedonia, The Former Yugoslav Republic Of", false, false, "\\d{4}", "%N%n%O%n%1%n%2%n%Z %C%n%I", null, null, null),
    MG("Madagascar", false, false, "\\d{3}", "%N%n%O%n%1%n%2%n%Z %C%n%I", null, null, null),
    MW("Malawi", false, false, null, "%N%n%O%n%1%n%2%n%C %X%n%I", null, null, null),
    MY("Malaysia", false, false, "\\d{5}", "%N%n%O%n%1%n%2%n%D%n%Z %C%n%S%n%I", new String[]{"JOHOR", "KEDAH", "KELANTAN", "KUALA LUMPUR", "LABUAN", "MELAKA", "NEGERI SEMBILAN", "PAHANG", "PERAK", "PERLIS", "PULAU PINANG", "PUTRAJAYA", "SABAH", "SARAWAK", "SELANGOR", "TERENGGANU"}, null, null),
    MV("Maldives", false, false, "\\d{5}", "%N%n%O%n%1%n%2%n%C %Z%n%I", null, null, null),
    ML("Mali", false, false, null, null, null, null, null),
    MT("Malta", true, true, "[A-Z]{3}[ ]?\\d{2,4}", "%N%n%O%n%1%n%2%n%C %Z%n%I", null, null, null),
    MH("Marshall Islands", false, false, "(969[67]\\d)(?:[ \\-](\\d{4}))?", "%N%n%O%n%1%n%2%n%C %S %Z%n%I", null, null, null),
    MQ("Martinique", false, false, "9[78]2\\d{2}", "%O%n%N%n%1%n%2%n%Z %C %X%n%I", null, null, null),
    MR("Mauritania", false, false, null, null, null, null, null),
    MU("Mauritius", false, false, "(?:\\d{3}(?:\\d{2}|[A-Z]{2}\\d{3}))?", "%N%n%O%n%1%n%2%n%Z%n%C%n%I", null, null, null),
    YT("Mayotte", false, false, "976\\d{2}", "%O%n%N%n%1%n%2%n%Z %C %X%n%I", null, null, null),
    MX("Mexico", false, false, "\\d{5}", "%N%n%O%n%1%n%2%n%D%n%Z %C, %S%n%I", new String[]{"AGS", "BC", "BCS", "CAMP", "CHIS", "CHIH", "COAH", "COL", "D.F.", "DGO", "MEX", "GTO", "GRO", "HGO", "JAL", "MICH", "MOR", "NAY", "NL", "OAX", "PUE", "QRO", "QROO", "SLP", "SIN", "SON", "TAB", "TAMPS", "TLAX", "VER", "YUC", "ZAC"}, new String[]{"Aguascalientes", "Baja California", "Baja California Sur", "Campeche", "Chiapas", "Chihuahua", "Coahuila", "Colima", "Distrito Federal", "Durango", "Estado de M\u00e9xico", "Guanajuato", "Guerrero", "Hidalgo", "Jalisco", "Michoac\u00e1n", "Morelos", "Nayarit", "Nuevo Le\u00f3n", "Oaxaca", "Puebla", "Quer\u00e9taro", "Quintana Roo", "San Lu\u00eds Potos\u00ed", "Sinal\u00f3a", "Sonora", "Tabasco", "Tamaulipas", "Tlaxcala", "Veracruz", "Yucat\u00e1n", "Zacatecas"}, null),
    FM("Micronesia, Federated States Of", false, false, "(9694[1-4])(?:[ \\-](\\d{4}))?", "%N%n%O%n%1%n%2%n%C %S %Z%n%I", null, null, null),
    MD("Moldova, Republic Of", false, false, "\\d{4}", "%N%n%O%n%1%n%2%nMD-%Z %C%n%I", null, null, null),
    MC("Monaco", false, false, "980\\d{2}", "%N%n%O%n%1%n%2%nMC-%Z %C %X%n%I", null, null, null),
    MN("Mongolia", false, false, "\\d{5}", "%N%n%O%n%1%n%2%n%S %C-%X%n%Z%n%I", null, null, null),
    ME("Montenegro", false, false, "8\\d{4}", "%N%n%O%n%1%n%2%n%Z %C%n%I", null, null, null),
    MS("Montserrat", false, false, null, null, null, null, null),
    MA("Morocco", false, false, "\\d{5}", "%N%n%O%n%1%n%2%n%Z %C%n%I", null, null, null),
    MZ("Mozambique", false, false, "\\d{4}", null, null, null, null),
    MM("Myanmar", false, false, "\\d{5}", "%N%n%O%n%1%n%2%n%C, %Z%n%I", null, null, null),
    NA("Namibia", false, false, null, null, null, null, null),
    NR("Nauru", false, false, null, "%N%n%O%n%1%n%2%n%S%n%I", new String[]{"AIWO DISTRICT", "ANABAR DISTRICT", "ANETAN DISTRICT", "ANIBARE DISTRICT", "BAITI DISTRICT", "BOE DISTRICT", "BUADA DISTRICT", "DENIGOMODU DISTRICT", "EWA DISTRICT", "IJUW DISTRICT", "MENENG DISTRICT", "NIBOK DISTRICT", "UABOE DISTRICT", "YAREN DISTRICT"}, null, null),
    NP("Nepal", false, false, "\\d{5}", "%N%n%O%n%1%n%2%n%C %Z%n%I", null, null, null),
    NL("Netherlands", true, true, "\\d{4}[ ]?[A-Z]{2}", "%O%n%N%n%1%n%2%n%Z %C%n%I", null, null, null),
    NC("New Caledonia", false, false, "988\\d{2}", "%O%n%N%n%1%n%2%n%Z %C %X%n%I", null, null, null),
    NZ("New Zealand", false, false, "\\d{4}", "%N%n%O%n%1%n%2%n%D%n%C %Z%n%I", null, null, null),
    NI("Nicaragua", false, false, "\\d{5}", "%N%n%O%n%1%n%2%n%Z%n%C, %S%n%I", new String[]{"Boaco", "Carazo", "Chinandega", "Chontales", "Esteli", "Granada", "Jinotega", "Leon", "Madriz", "Managua", "Masaya", "Matagalpa", "Nueva Segovia", "Raan", "Raas", "Rio San Juan", "Rivas"}, null, null),
    NE("Niger", false, false, "\\d{4}", "%N%n%O%n%1%n%2%n%Z %C%n%I", null, null, null),
    NG("Nigeria", false, false, "(?:\\d{6})?", "%N%n%O%n%1%n%2%n%C %Z%n%S%n%I", new String[]{"Abia", "Adamawa", "Akwa Ibom", "Anambra", "Bauchi", "Bayelsa", "Benue", "Borno", "Cross River", "Delta", "Ebonyi", "Edo", "Ekiti", "Enugu", "Federal Capital Territory", "Gombe", "Imo", "Jigawa", "Kaduna", "Kano", "Katsina", "Kebbi", "Kogi", "Kwara", "Lagos", "Nasarawa", "Niger", "Ogun State", "Ondo", "Osun", "Oyo", "Plateau", "Rivers", "Sokoto", "Taraba", "Yobe", "Zamfara"}, null, null),
    NU("Niue", false, false, null, null, null, null, null),
    NF("Norfolk Island", false, false, "2899", "%O%n%N%n%1%n%2%n%C %S %Z%n%I", null, null, null),
    MP("Northern Mariana Islands", false, false, "(9695[012])(?:[ \\-](\\d{4}))?", "%N%n%O%n%1%n%2%n%C %S %Z%n%I", null, null, null),
    NO("Norway", false, false, "\\d{4}", "%N%n%O%n%1%n%2%n%Z %C%n%I", null, null, null),
    OM("Oman", false, false, "(PC )?\\d{3}", "%N%n%O%n%1%n%2%n%Z%n%C%n%I", null, null, null),
    PK("Pakistan", false, false, "\\d{5}", "%N%n%O%n%1%n%2%n%C-%Z%n%I", null, null, null),
    PW("Palau", false, false, "(969(?:39|40))(?:[ \\-](\\d{4}))?", "%N%n%O%n%1%n%2%n%C %S %Z%n%I", null, null, null),
    PS("Palestine, State Of", false, false, null, null, null, null, null),
    PA("Panama", false, false, null, "%N%n%O%n%1%n%2%n%C%n%S%n%I", null, null, null),
    PG("Papua New Guinea", false, false, "\\d{3}", "%N%n%O%n%1%n%2%n%C %Z %S%n%I", null, null, null),
    PY("Paraguay", false, false, "\\d{4}", "%N%n%O%n%1%n%2%n%Z %C%n%I", null, null, null),
    PE("Peru", false, false, "(?:LIMA \\d|CALLAO 0?)\\d|[0-2]\\d{4}", null, null, null, null),
    PH("Philippines", false, false, "\\d{4}", "%N%n%O%n%1%n%2%n%D, %C%n%Z %S%n%I", new String[]{"Abra", "Agusan del Norte", "Agusan del Sur", "Aklan", "Albay", "Antique", "Apayao", "Aurora", "Basilan", "Bataan", "Batanes", "Batangas", "Benguet", "Biliran", "Bohol", "Bukidnon", "Bulacan", "Cagayan", "Camarines Norte", "Camarines Sur", "Camiguin", "Capiz", "Catanduanes", "Cavite", "Cebu", "Compostela Valley", "Cotabato", "Davao del Norte", "Davao del Sur", "Davao Occidental", "Davao Oriental", "Dinagat Islands", "Eastern Samar", "Guimaras", "Ifugao", "Ilocos Norte", "Ilocos Sur", "Iloilo", "Isabela", "Kalinga", "La Union", "Laguna", "Lanao del Norte", "Lanao del Sur", "Leyte", "Maguindanao", "Marinduque", "Masbate", "Metro Manila", "Mindoro Occidental", "Mindoro Oriental", "Misamis Occidental", "Misamis Oriental", "Mountain Province", "Negros Occidental", "Negros Oriental", "Northern Samar", "Nueva Ecija", "Nueva Vizcaya", "Palawan", "Pampanga", "Pangasinan", "Quezon Province", "Quirino", "Rizal", "Romblon", "Samar", "Sarangani", "Siquijor", "Sorsogon", "South Cotabato", "Southern Leyte", "Sultan Kudarat", "Sulu", "Surigao del Norte", "Surigao del Sur", "Tarlac", "Tawi-Tawi", "Zambales", "Zamboanga del Norte", "Zamboanga del Sur", "Zamboanga Sibuguey"}, null, null),
    PN("Pitcairn", false, false, "PCRN 1ZZ", "%N%n%O%n%1%n%2%n%X%n%C%n%Z%n%I", null, null, null),
    PL("Poland", true, false, "\\d{2}-\\d{3}", "%N%n%O%n%1%n%2%n%Z %C%n%I", null, null, null),
    PT("Portugal", true, true, "\\d{4}-\\d{3}", "%N%n%O%n%1%n%2%n%Z %C%n%I", null, null, null),
    PR("Puerto Rico", false, false, "(00[679]\\d{2})(?:[ \\-](\\d{4}))?", "%N%n%O%n%1%n%2%n%C PR %Z%n%I", null, null, null),
    QA("Qatar", false, false, null, null, null, null, null),
    RE("R\u00e9union", false, false, "9[78]4\\d{2}", "%O%n%N%n%1%n%2%n%Z %C %X%n%I", null, null, null),
    RO("Romania", true, false, "\\d{6}", "%N%n%O%n%1%n%2%n%Z %C%n%I", null, null, null),
    RU("Russian Federation", false, false, "\\d{6}", "%N%n%O%n%1%n%2%n%C%n%S%n%Z%n%I", new String[]{"\u0410\u043b\u0442\u0430\u0439\u0441\u043a\u0438\u0439 \u043a\u0440\u0430\u0439", "\u0410\u043c\u0443\u0440\u0441\u043a\u0430\u044f \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u0410\u0440\u0445\u0430\u043d\u0433\u0435\u043b\u044c\u0441\u043a\u0430\u044f \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u0410\u0441\u0442\u0440\u0430\u0445\u0430\u043d\u0441\u043a\u0430\u044f \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u0430\u044f \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u0411\u0440\u044f\u043d\u0441\u043a\u0430\u044f \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u0412\u043b\u0430\u0434\u0438\u043c\u0438\u0440\u0441\u043a\u0430\u044f \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u0412\u043e\u043b\u0433\u043e\u0433\u0440\u0430\u0434\u0441\u043a\u0430\u044f \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u0412\u043e\u043b\u043e\u0433\u043e\u0434\u0441\u043a\u0430\u044f \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u0412\u043e\u0440\u043e\u043d\u0435\u0436\u0441\u043a\u0430\u044f \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u0415\u0432\u0440\u0435\u0439\u0441\u043a\u0430\u044f \u0430\u0432\u0442\u043e\u043d\u043e\u043c\u043d\u0430\u044f \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u0417\u0430\u0431\u0430\u0439\u043a\u0430\u043b\u044c\u0441\u043a\u0438\u0439 \u043a\u0440\u0430\u0439", "\u0418\u0432\u0430\u043d\u043e\u0432\u0441\u043a\u0430\u044f \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u0418\u0440\u043a\u0443\u0442\u0441\u043a\u0430\u044f \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u041a\u0430\u0431\u0430\u0440\u0434\u0438\u043d\u043e-\u0411\u0430\u043b\u043a\u0430\u0440\u0441\u043a\u0430\u044f \u0420\u0435\u0441\u043f\u0443\u0431\u043b\u0438\u043a\u0430", "\u041a\u0430\u043b\u0438\u043d\u0438\u043d\u0433\u0440\u0430\u0434\u0441\u043a\u0430\u044f \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u041a\u0430\u043b\u0443\u0436\u0441\u043a\u0430\u044f \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u041a\u0430\u043c\u0447\u0430\u0442\u0441\u043a\u0438\u0439 \u043a\u0440\u0430\u0439", "\u041a\u0430\u0440\u0430\u0447\u0430\u0435\u0432\u043e-\u0427\u0435\u0440\u043a\u0435\u0441\u0441\u043a\u0430\u044f \u0420\u0435\u0441\u043f\u0443\u0431\u043b\u0438\u043a\u0430", "\u041a\u0435\u043c\u0435\u0440\u043e\u0432\u0441\u043a\u0430\u044f \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u041a\u0438\u0440\u043e\u0432\u0441\u043a\u0430\u044f \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u041a\u043e\u0441\u0442\u0440\u043e\u043c\u0441\u043a\u0430\u044f \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u041a\u0440\u0430\u0441\u043d\u043e\u0434\u0430\u0440\u0441\u043a\u0438\u0439 \u043a\u0440\u0430\u0439", "\u041a\u0440\u0430\u0441\u043d\u043e\u044f\u0440\u0441\u043a\u0438\u0439 \u043a\u0440\u0430\u0439", "\u041a\u0443\u0440\u0433\u0430\u043d\u0441\u043a\u0430\u044f \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u041a\u0443\u0440\u0441\u043a\u0430\u044f \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u041b\u0435\u043d\u0438\u043d\u0433\u0440\u0430\u0434\u0441\u043a\u0430\u044f \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u041b\u0438\u043f\u0435\u0446\u043a\u0430\u044f \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u041c\u0430\u0433\u0430\u0434\u0430\u043d\u0441\u043a\u0430\u044f \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u0433\u043e\u0440\u043e\u0434 \u041c\u043e\u0441\u043a\u0432\u0430", "\u041c\u043e\u0441\u043a\u043e\u0432\u0441\u043a\u0430\u044f \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u041c\u0443\u0440\u043c\u0430\u043d\u0441\u043a\u0430\u044f \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u041d\u0435\u043d\u0435\u0446\u043a\u0438\u0439 \u0430\u0432\u0442\u043e\u043d\u043e\u043c\u043d\u044b\u0439 \u043e\u043a\u0440\u0443\u0433", "\u041d\u0438\u0436\u0435\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u0430\u044f \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u041d\u043e\u0432\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u0430\u044f \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u041d\u043e\u0432\u043e\u0441\u0438\u0431\u0438\u0440\u0441\u043a\u0430\u044f \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u041e\u043c\u0441\u043a\u0430\u044f \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u041e\u0440\u0435\u043d\u0431\u0443\u0440\u0433\u0441\u043a\u0430\u044f \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u041e\u0440\u043b\u043e\u0432\u0441\u043a\u0430\u044f \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u041f\u0435\u043d\u0437\u0435\u043d\u0441\u043a\u0430\u044f \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u041f\u0435\u0440\u043c\u0441\u043a\u0438\u0439 \u043a\u0440\u0430\u0439", "\u041f\u0440\u0438\u043c\u043e\u0440\u0441\u043a\u0438\u0439 \u043a\u0440\u0430\u0439", "\u041f\u0441\u043a\u043e\u0432\u0441\u043a\u0430\u044f \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u0420\u0435\u0441\u043f\u0443\u0431\u043b\u0438\u043a\u0430 \u0410\u0434\u044b\u0433\u0435\u044f", "\u0420\u0435\u0441\u043f\u0443\u0431\u043b\u0438\u043a\u0430 \u0410\u043b\u0442\u0430\u0439", "\u0420\u0435\u0441\u043f\u0443\u0431\u043b\u0438\u043a\u0430 \u0411\u0430\u0448\u043a\u043e\u0440\u0442\u043e\u0441\u0442\u0430\u043d", "\u0420\u0435\u0441\u043f\u0443\u0431\u043b\u0438\u043a\u0430 \u0411\u0443\u0440\u044f\u0442\u0438\u044f", "\u0420\u0435\u0441\u043f\u0443\u0431\u043b\u0438\u043a\u0430 \u0414\u0430\u0433\u0435\u0441\u0442\u0430\u043d", "\u0420\u0435\u0441\u043f\u0443\u0431\u043b\u0438\u043a\u0430 \u0418\u043d\u0433\u0443\u0448\u0435\u0442\u0438\u044f", "\u0420\u0435\u0441\u043f\u0443\u0431\u043b\u0438\u043a\u0430 \u041a\u0430\u043b\u043c\u044b\u043a\u0438\u044f", "\u0420\u0435\u0441\u043f\u0443\u0431\u043b\u0438\u043a\u0430 \u041a\u0430\u0440\u0435\u043b\u0438\u044f", "\u0420\u0435\u0441\u043f\u0443\u0431\u043b\u0438\u043a\u0430 \u041a\u043e\u043c\u0438", "\u0410\u0432\u0442\u043e\u043d\u043e\u043c\u043d\u0430 \u0420\u0435\u0441\u043f\u0443\u0431\u043b\u0456\u043a\u0430 \u041a\u0440\u0438\u043c", "\u0420\u0435\u0441\u043f\u0443\u0431\u043b\u0438\u043a\u0430 \u041c\u0430\u0440\u0438\u0439 \u042d\u043b", "\u0420\u0435\u0441\u043f\u0443\u0431\u043b\u0438\u043a\u0430 \u041c\u043e\u0440\u0434\u043e\u0432\u0438\u044f", "\u0420\u0435\u0441\u043f\u0443\u0431\u043b\u0438\u043a\u0430 \u0421\u0430\u0445\u0430 (\u042f\u043a\u0443\u0442\u0438\u044f)", "\u0420\u0435\u0441\u043f\u0443\u0431\u043b\u0438\u043a\u0430 \u0421\u0435\u0432\u0435\u0440\u043d\u0430\u044f \u041e\u0441\u0435\u0442\u0438\u044f-\u0410\u043b\u0430\u043d\u0438\u044f", "\u0420\u0435\u0441\u043f\u0443\u0431\u043b\u0438\u043a\u0430 \u0422\u0430\u0442\u0430\u0440\u0441\u0442\u0430\u043d", "\u0420\u0435\u0441\u043f\u0443\u0431\u043b\u0438\u043a\u0430 \u0422\u044b\u0432\u0430", "\u0420\u0435\u0441\u043f\u0443\u0431\u043b\u0438\u043a\u0430 \u0423\u0434\u043c\u0443\u0440\u0442\u0438\u044f", "\u0420\u0435\u0441\u043f\u0443\u0431\u043b\u0438\u043a\u0430 \u0425\u0430\u043a\u0430\u0441\u0438\u044f", "\u0420\u043e\u0441\u0442\u043e\u0432\u0441\u043a\u0430\u044f \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u0420\u044f\u0437\u0430\u043d\u0441\u043a\u0430\u044f \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u0421\u0430\u043c\u0430\u0440\u0441\u043a\u0430\u044f \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u0433\u043e\u0440\u043e\u0434 \u0421\u0430\u043d\u043a\u0442-\u041f\u0435\u0442\u0435\u0440\u0431\u0443\u0440\u0433", "\u0421\u0430\u0440\u0430\u0442\u043e\u0432\u0441\u043a\u0430\u044f \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u0421\u0430\u0445\u0430\u043b\u0438\u043d\u0441\u043a\u0430\u044f \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u0421\u0432\u0435\u0440\u0434\u043b\u043e\u0432\u0441\u043a\u0430\u044f \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u0433\u043e\u0440\u043e\u0434 \u0421\u0435\u0432\u0430\u0441\u0442\u043e\u043f\u043e\u043b\u044c", "\u0421\u043c\u043e\u043b\u0435\u043d\u0441\u043a\u0430\u044f \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u0421\u0442\u0430\u0432\u0440\u043e\u043f\u043e\u043b\u044c\u0441\u043a\u0438\u0439 \u043a\u0440\u0430\u0439", "\u0422\u0430\u043c\u0431\u043e\u0432\u0441\u043a\u0430\u044f \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u0422\u0432\u0435\u0440\u0441\u043a\u0430\u044f \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u0422\u043e\u043c\u0441\u043a\u0430\u044f \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u0422\u0443\u043b\u044c\u0441\u043a\u0430\u044f \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u0422\u044e\u043c\u0435\u043d\u0441\u043a\u0430\u044f \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u0423\u043b\u044c\u044f\u043d\u043e\u0432\u0441\u043a\u0430\u044f \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u0425\u0430\u0431\u0430\u0440\u043e\u0432\u0441\u043a\u0438\u0439 \u043a\u0440\u0430\u0439", "\u0425\u0430\u043d\u0442\u044b-\u041c\u0430\u043d\u0441\u0438\u0439\u0441\u043a\u0438\u0439 \u0430\u0432\u0442\u043e\u043d\u043e\u043c\u043d\u044b\u0439 \u043e\u043a\u0440\u0443\u0433", "\u0427\u0435\u043b\u044f\u0431\u0438\u043d\u0441\u043a\u0430\u044f \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u0427\u0435\u0447\u0435\u043d\u0441\u043a\u0430\u044f \u0420\u0435\u0441\u043f\u0443\u0431\u043b\u0438\u043a\u0430", "\u0427\u0443\u0432\u0430\u0448\u0441\u043a\u0430\u044f \u0420\u0435\u0441\u043f\u0443\u0431\u043b\u0438\u043a\u0430", "\u0427\u0443\u043a\u043e\u0442\u0441\u043a\u0438\u0439 \u0430\u0432\u0442\u043e\u043d\u043e\u043c\u043d\u044b\u0439 \u043e\u043a\u0440\u0443\u0433", "\u042f\u043c\u0430\u043b\u043e-\u041d\u0435\u043d\u0435\u0446\u043a\u0438\u0439 \u0430\u0432\u0442\u043e\u043d\u043e\u043c\u043d\u044b\u0439 \u043e\u043a\u0440\u0443\u0433", "\u042f\u0440\u043e\u0441\u043b\u0430\u0432\u0441\u043a\u0430\u044f \u043e\u0431\u043b\u0430\u0441\u0442\u044c"}, new String[]{"\u0410\u043b\u0442\u0430\u0439\u0441\u043a\u0438\u0439 \u043a\u0440\u0430\u0439", "\u0410\u043c\u0443\u0440\u0441\u043a\u0430\u044f \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u0410\u0440\u0445\u0430\u043d\u0433\u0435\u043b\u044c\u0441\u043a\u0430\u044f \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u0410\u0441\u0442\u0440\u0430\u0445\u0430\u043d\u0441\u043a\u0430\u044f \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u0430\u044f \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u0411\u0440\u044f\u043d\u0441\u043a\u0430\u044f \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u0412\u043b\u0430\u0434\u0438\u043c\u0438\u0440\u0441\u043a\u0430\u044f \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u0412\u043e\u043b\u0433\u043e\u0433\u0440\u0430\u0434\u0441\u043a\u0430\u044f \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u0412\u043e\u043b\u043e\u0433\u043e\u0434\u0441\u043a\u0430\u044f \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u0412\u043e\u0440\u043e\u043d\u0435\u0436\u0441\u043a\u0430\u044f \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u0415\u0432\u0440\u0435\u0439\u0441\u043a\u0430\u044f \u0430\u0432\u0442\u043e\u043d\u043e\u043c\u043d\u0430\u044f \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u0417\u0430\u0431\u0430\u0439\u043a\u0430\u043b\u044c\u0441\u043a\u0438\u0439 \u043a\u0440\u0430\u0439", "\u0418\u0432\u0430\u043d\u043e\u0432\u0441\u043a\u0430\u044f \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u0418\u0440\u043a\u0443\u0442\u0441\u043a\u0430\u044f \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u041a\u0430\u0431\u0430\u0440\u0434\u0438\u043d\u043e-\u0411\u0430\u043b\u043a\u0430\u0440\u0441\u043a\u0430\u044f \u0420\u0435\u0441\u043f\u0443\u0431\u043b\u0438\u043a\u0430", "\u041a\u0430\u043b\u0438\u043d\u0438\u043d\u0433\u0440\u0430\u0434\u0441\u043a\u0430\u044f \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u041a\u0430\u043b\u0443\u0436\u0441\u043a\u0430\u044f \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u041a\u0430\u043c\u0447\u0430\u0442\u0441\u043a\u0438\u0439 \u043a\u0440\u0430\u0439", "\u041a\u0430\u0440\u0430\u0447\u0430\u0435\u0432\u043e-\u0427\u0435\u0440\u043a\u0435\u0441\u0441\u043a\u0430\u044f \u0420\u0435\u0441\u043f\u0443\u0431\u043b\u0438\u043a\u0430", "\u041a\u0435\u043c\u0435\u0440\u043e\u0432\u0441\u043a\u0430\u044f \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u041a\u0438\u0440\u043e\u0432\u0441\u043a\u0430\u044f \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u041a\u043e\u0441\u0442\u0440\u043e\u043c\u0441\u043a\u0430\u044f \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u041a\u0440\u0430\u0441\u043d\u043e\u0434\u0430\u0440\u0441\u043a\u0438\u0439 \u043a\u0440\u0430\u0439", "\u041a\u0440\u0430\u0441\u043d\u043e\u044f\u0440\u0441\u043a\u0438\u0439 \u043a\u0440\u0430\u0439", "\u041a\u0443\u0440\u0433\u0430\u043d\u0441\u043a\u0430\u044f \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u041a\u0443\u0440\u0441\u043a\u0430\u044f \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u041b\u0435\u043d\u0438\u043d\u0433\u0440\u0430\u0434\u0441\u043a\u0430\u044f \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u041b\u0438\u043f\u0435\u0446\u043a\u0430\u044f \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u041c\u0430\u0433\u0430\u0434\u0430\u043d\u0441\u043a\u0430\u044f \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u041c\u043e\u0441\u043a\u0432\u0430", "\u041c\u043e\u0441\u043a\u043e\u0432\u0441\u043a\u0430\u044f \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u041c\u0443\u0440\u043c\u0430\u043d\u0441\u043a\u0430\u044f \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u041d\u0435\u043d\u0435\u0446\u043a\u0438\u0439 \u0430\u0432\u0442\u043e\u043d\u043e\u043c\u043d\u044b\u0439 \u043e\u043a\u0440\u0443\u0433", "\u041d\u0438\u0436\u0435\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u0430\u044f \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u041d\u043e\u0432\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u0430\u044f \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u041d\u043e\u0432\u043e\u0441\u0438\u0431\u0438\u0440\u0441\u043a\u0430\u044f \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u041e\u043c\u0441\u043a\u0430\u044f \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u041e\u0440\u0435\u043d\u0431\u0443\u0440\u0433\u0441\u043a\u0430\u044f \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u041e\u0440\u043b\u043e\u0432\u0441\u043a\u0430\u044f \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u041f\u0435\u043d\u0437\u0435\u043d\u0441\u043a\u0430\u044f \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u041f\u0435\u0440\u043c\u0441\u043a\u0438\u0439 \u043a\u0440\u0430\u0439", "\u041f\u0440\u0438\u043c\u043e\u0440\u0441\u043a\u0438\u0439 \u043a\u0440\u0430\u0439", "\u041f\u0441\u043a\u043e\u0432\u0441\u043a\u0430\u044f \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u0420\u0435\u0441\u043f\u0443\u0431\u043b\u0438\u043a\u0430 \u0410\u0434\u044b\u0433\u0435\u044f", "\u0420\u0435\u0441\u043f\u0443\u0431\u043b\u0438\u043a\u0430 \u0410\u043b\u0442\u0430\u0439", "\u0420\u0435\u0441\u043f\u0443\u0431\u043b\u0438\u043a\u0430 \u0411\u0430\u0448\u043a\u043e\u0440\u0442\u043e\u0441\u0442\u0430\u043d", "\u0420\u0435\u0441\u043f\u0443\u0431\u043b\u0438\u043a\u0430 \u0411\u0443\u0440\u044f\u0442\u0438\u044f", "\u0420\u0435\u0441\u043f\u0443\u0431\u043b\u0438\u043a\u0430 \u0414\u0430\u0433\u0435\u0441\u0442\u0430\u043d", "\u0420\u0435\u0441\u043f\u0443\u0431\u043b\u0438\u043a\u0430 \u0418\u043d\u0433\u0443\u0448\u0435\u0442\u0438\u044f", "\u0420\u0435\u0441\u043f\u0443\u0431\u043b\u0438\u043a\u0430 \u041a\u0430\u043b\u043c\u044b\u043a\u0438\u044f", "\u0420\u0435\u0441\u043f\u0443\u0431\u043b\u0438\u043a\u0430 \u041a\u0430\u0440\u0435\u043b\u0438\u044f", "\u0420\u0435\u0441\u043f\u0443\u0431\u043b\u0438\u043a\u0430 \u041a\u043e\u043c\u0438", "\u0420\u0435\u0441\u043f\u0443\u0431\u043b\u0438\u043a\u0430 \u041a\u0440\u044b\u043c", "\u0420\u0435\u0441\u043f\u0443\u0431\u043b\u0438\u043a\u0430 \u041c\u0430\u0440\u0438\u0439 \u042d\u043b", "\u0420\u0435\u0441\u043f\u0443\u0431\u043b\u0438\u043a\u0430 \u041c\u043e\u0440\u0434\u043e\u0432\u0438\u044f", "\u0420\u0435\u0441\u043f\u0443\u0431\u043b\u0438\u043a\u0430 \u0421\u0430\u0445\u0430 (\u042f\u043a\u0443\u0442\u0438\u044f)", "\u0420\u0435\u0441\u043f\u0443\u0431\u043b\u0438\u043a\u0430 \u0421\u0435\u0432\u0435\u0440\u043d\u0430\u044f \u041e\u0441\u0435\u0442\u0438\u044f-\u0410\u043b\u0430\u043d\u0438\u044f", "\u0420\u0435\u0441\u043f\u0443\u0431\u043b\u0438\u043a\u0430 \u0422\u0430\u0442\u0430\u0440\u0441\u0442\u0430\u043d", "\u0420\u0435\u0441\u043f\u0443\u0431\u043b\u0438\u043a\u0430 \u0422\u044b\u0432\u0430", "\u0420\u0435\u0441\u043f\u0443\u0431\u043b\u0438\u043a\u0430 \u0423\u0434\u043c\u0443\u0440\u0442\u0438\u044f", "\u0420\u0435\u0441\u043f\u0443\u0431\u043b\u0438\u043a\u0430 \u0425\u0430\u043a\u0430\u0441\u0438\u044f", "\u0420\u043e\u0441\u0442\u043e\u0432\u0441\u043a\u0430\u044f \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u0420\u044f\u0437\u0430\u043d\u0441\u043a\u0430\u044f \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u0421\u0430\u043c\u0430\u0440\u0441\u043a\u0430\u044f \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u0421\u0430\u043d\u043a\u0442-\u041f\u0435\u0442\u0435\u0440\u0431\u0443\u0440\u0433", "\u0421\u0430\u0440\u0430\u0442\u043e\u0432\u0441\u043a\u0430\u044f \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u0421\u0430\u0445\u0430\u043b\u0438\u043d\u0441\u043a\u0430\u044f \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u0421\u0432\u0435\u0440\u0434\u043b\u043e\u0432\u0441\u043a\u0430\u044f \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u0421\u0435\u0432\u0430\u0441\u0442\u043e\u043f\u043e\u043b\u044c", "\u0421\u043c\u043e\u043b\u0435\u043d\u0441\u043a\u0430\u044f \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u0421\u0442\u0430\u0432\u0440\u043e\u043f\u043e\u043b\u044c\u0441\u043a\u0438\u0439 \u043a\u0440\u0430\u0439", "\u0422\u0430\u043c\u0431\u043e\u0432\u0441\u043a\u0430\u044f \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u0422\u0432\u0435\u0440\u0441\u043a\u0430\u044f \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u0422\u043e\u043c\u0441\u043a\u0430\u044f \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u0422\u0443\u043b\u044c\u0441\u043a\u0430\u044f \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u0422\u044e\u043c\u0435\u043d\u0441\u043a\u0430\u044f \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u0423\u043b\u044c\u044f\u043d\u043e\u0432\u0441\u043a\u0430\u044f \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u0425\u0430\u0431\u0430\u0440\u043e\u0432\u0441\u043a\u0438\u0439 \u043a\u0440\u0430\u0439", "\u0425\u0430\u043d\u0442\u044b-\u041c\u0430\u043d\u0441\u0438\u0439\u0441\u043a\u0438\u0439 \u0430\u0432\u0442\u043e\u043d\u043e\u043c\u043d\u044b\u0439 \u043e\u043a\u0440\u0443\u0433", "\u0427\u0435\u043b\u044f\u0431\u0438\u043d\u0441\u043a\u0430\u044f \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u0427\u0435\u0447\u0435\u043d\u0441\u043a\u0430\u044f \u0420\u0435\u0441\u043f\u0443\u0431\u043b\u0438\u043a\u0430", "\u0427\u0443\u0432\u0430\u0448\u0441\u043a\u0430\u044f \u0420\u0435\u0441\u043f\u0443\u0431\u043b\u0438\u043a\u0430", "\u0427\u0443\u043a\u043e\u0442\u0441\u043a\u0438\u0439 \u0430\u0432\u0442\u043e\u043d\u043e\u043c\u043d\u044b\u0439 \u043e\u043a\u0440\u0443\u0433", "\u042f\u043c\u0430\u043b\u043e-\u041d\u0435\u043d\u0435\u0446\u043a\u0438\u0439 \u0430\u0432\u0442\u043e\u043d\u043e\u043c\u043d\u044b\u0439 \u043e\u043a\u0440\u0443\u0433", "\u042f\u0440\u043e\u0441\u043b\u0430\u0432\u0441\u043a\u0430\u044f \u043e\u0431\u043b\u0430\u0441\u0442\u044c"}, new String[]{"Altayskiy kray", "Amurskaya oblast'", "Arkhangelskaya oblast'", "Astrakhanskaya oblast'", "Belgorodskaya oblast'", "Bryanskaya oblast'", "Vladimirskaya oblast'", "Volgogradskaya oblast'", "Vologodskaya oblast'", "Voronezhskaya oblast'", "Evreyskaya avtonomnaya oblast'", "Zabaykalskiy kray", "Ivanovskaya oblast'", "Irkutskaya oblast'", "Kabardino-Balkarskaya Republits", "Kaliningradskaya oblast'", "Kaluzhskaya oblast'", "Kamchatskiy kray", "Karachaevo-Cherkesskaya Republits", "Kemerovskaya oblast'", "Kirovskaya oblast'", "Kostromskaya oblast'", "Krasnodarskiy kray", "Krasnoyarskiy kray", "Kurganskaya oblast'", "Kurskaya oblast'", "Leningradskaya oblast'", "Lipetskaya oblast'", "Magadanskaya oblast'", "gorod Moskva", "Moskovskaya oblast'", "Murmanskaya oblast'", "Nenetskiy", "Nizhegorodskaya oblast'", "Novgorodskaya oblast'", "Novosibirskaya oblast'", "Omskaya oblast'", "Orenburgskaya oblast'", "Orlovskaya oblast'", "Penzenskaya oblast'", "Permskiy kray", "Primorskiy kray", "Pskovskaya oblast'", "Respublika Adygeya", "Altay Republits", "Bashkortostan Republits", "Buryatiya Republits", "Dagestan Republits", "Ingushetiya Republits", "Respublika Kalmykiya", "Kareliya Republits", "Komi Republits", "Respublika Krym", "Respublika Mariy El", "Respublika Mordoviya", "Sakha (Yakutiya) Republits", "Respublika Severnaya Osetiya-Alaniya", "Respublika Tatarstan", "Tyva Republits", "Respublika Udmurtiya", "Khakasiya Republits", "Rostovskaya oblast'", "Ryazanskaya oblast'", "Samarskaya oblast'", "gorod Sankt-Peterburg", "Saratovskaya oblast'", "Sakhalinskaya oblast'", "Sverdlovskaya oblast'", "gorod Sevastopol'", "Smolenskaya oblast'", "Stavropolskiy kray", "Tambovskaya oblast'", "Tverskaya oblast'", "Tomskaya oblast'", "Tulskaya oblast'", "Tyumenskaya oblast'", "Ulyanovskaya oblast'", "Khabarovskiy kray", "Khanty-Mansiyskiy avtonomnyy okrug", "Chelyabinskaya oblast'", "Chechenskaya Republits", "Chuvashia", "Chukotskiy", "Yamalo-Nenetskiy", "Yaroslavskaya oblast'"}),
    RW("Rwanda", false, false, null, null, null, null, null),
    BL("Saint Barth\u00e9lemy", false, false, "9[78][01]\\d{2}", "%O%n%N%n%1%n%2%n%Z %C %X%n%I", null, null, null),
    SH("Saint Helena, Ascension And Tristan Da Cunha", false, false, "(ASCN|STHL) 1ZZ", "%N%n%O%n%1%n%2%n%X%n%C%n%Z%n%I", null, null, null),
    KN("Saint Kitts And Nevis", false, false, null, "%N%n%O%n%1%n%2%n%C, %S%n%I", new String[]{"Nevis", "St. Kitts"}, null, null),
    LC("Saint Lucia", false, false, null, null, null, null, null),
    MF("Saint Martin (french Part)", false, false, "9[78][01]\\d{2}", "%O%n%N%n%1%n%2%n%Z %C %X%n%I", null, null, null),
    PM("Saint Pierre And Miquelon", false, false, "9[78]5\\d{2}", "%O%n%N%n%1%n%2%n%Z %C %X%n%I", null, null, null),
    VC("Saint Vincent And The Grenadines", false, false, "VC\\d{4}", null, null, null, null),
    WS("Samoa", false, false, null, null, null, null, null),
    SM("San Marino", false, false, "4789\\d", "%N%n%O%n%1%n%2%n%Z %C%n%I", null, null, null),
    ST("Sao Tome And Principe", false, false, null, "%N%n%O%n%1%n%2%n%C %X%n%I", null, null, null),
    SA("Saudi Arabia", false, false, "\\d{5}", "%N%n%O%n%1%n%2%n%C %Z%n%I", null, null, null),
    SN("Senegal", false, false, "\\d{5}", "%N%n%O%n%1%n%2%n%Z %C%n%I", null, null, null),
    RS("Serbia", false, false, "\\d{5,6}", "%N%n%O%n%1%n%2%n%Z %C%n%I", null, null, null),
    SC("Seychelles", false, false, null, "%N%n%O%n%1%n%2%n%C%n%S%n%I", null, null, null),
    SL("Sierra Leone", false, false, null, null, null, null, null),
    SG("Singapore", false, false, "\\d{6}", "%N%n%O%n%1%n%2%nSINGAPORE %Z%n%I", null, null, null),
    SX("Sint Maarten (dutch Part)", false, false, null, null, null, null, null),
    SK("Slovakia", true, true, "\\d{3}[ ]?\\d{2}", "%N%n%O%n%1%n%2%n%Z %C%n%I", null, null, null),
    SI("Slovenia", true, true, "\\d{4}", "%N%n%O%n%1%n%2%nSI- %Z %C%n%I", null, null, null),
    SB("Solomon Islands", false, false, null, null, null, null, null),
    SO("Somalia", false, false, "\\d{5}", "%N%n%O%n%1%n%2%n%C, %S %Z%n%I", new String[]{"AD", "BK", "BN", "BR", "BY", "GG", "GD", "HR", "JD", "JH", "MD", "NG", "SG", "SD", "SH", "SL", "TG", "WG"}, new String[]{"AWDAL", "BAKOOL", "BANAADIR", "BARI", "BAY", "GALGUDUUD", "GEDO", "HIIRAAN", "JUBBADA DHEXE", "JUBBADA HOOSE", "MUDUG", "NUGAAL", "SANAAG", "SHABEELLAHA DHEXE", "SHABEELLAHA HOOSE", "SOOL", "TOGDHEER", "WOQOOYI GALBEED"}, null),
    ZA("South Africa", false, false, "\\d{4}", "%N%n%O%n%1%n%2%n%D%n%C%n%Z%n%I", null, null, null),
    GS("South Georgia And The South Sandwich Islands", false, false, "SIQQ 1ZZ", "%N%n%O%n%1%n%2%n%X%n%C%n%Z%n%I", null, null, null),
    SS("South Sudan", false, false, null, null, null, null, null),
    ES("Spain", true, true, "\\d{5}", "%N%n%O%n%1%n%2%n%Z %C %S%n%I", new String[]{"A Coru\u00f1a", "\u00c1lava", "Albacete", "Alicante", "Almer\u00eda", "Asturias", "\u00c1vila", "Badajoz", "Barcelona", "Burgos", "C\u00e1ceres", "C\u00e1diz", "Cantabria", "Castell\u00f3n", "Ceuta", "Ciudad Real", "C\u00f3rdoba", "Cuenca", "Girona", "Granada", "Guadalajara", "Guip\u00fazcoa", "Huelva", "Huesca", "Islas Baleares", "Ja\u00e9n", "La Rioja", "Las Palmas", "Le\u00f3n", "Lleida", "Lugo", "Madrid", "M\u00e1laga", "Melilla", "Murcia", "Navarra", "Ourense", "Palencia", "Pontevedra", "Salamanca", "Santa Cruz de Tenerife", "Segovia", "Sevilla", "Soria", "Tarragona", "Teruel", "Toledo", "Valencia", "Valladolid", "Vizcaya", "Zamora", "Zaragoza"}, null, null),
    LK("Sri Lanka", false, false, "\\d{5}", "%N%n%O%n%1%n%2%n%C%n%Z%n%I", null, null, null),
    SD("Sudan", false, false, null, null, null, null, null),
    SR("Suriname", false, false, null, "%N%n%O%n%1%n%2%n%C %X%n%S%n%I", new String[]{"BROKOPONDO", "COMMEWIJNE", "CORONIE", "MAROWIJNE", "NICKERIE", "PARA", "PARAMARIBO", "SARAMACCA", "SIPALIWINI", "WANICA"}, null, null),
    SJ("Svalbard And Jan Mayen", false, false, "\\d{4}", "%N%n%O%n%1%n%2%n%Z %C%n%I", null, null, null),
    SZ("Swaziland", false, false, "[HLMS]\\d{3}", "%N%n%O%n%1%n%2%n%C%n%Z%n%I", null, null, null),
    SE("Sweden", true, false, "\\d{3}[ ]?\\d{2}", "%O%n%N%n%1%n%2%nSE-%Z %C%n%I", null, null, null),
    CH("Switzerland", false, false, "\\d{4}", "%O%n%N%n%1%n%2%nCH-%Z %C%n%I", new String[]{"AG", "AR", "AI", "BL", "BS", "BE", "FR", "GE", "GL", "GR", "JU", "LU", "NE", "NW", "OW", "SH", "SZ", "SO", "SG", "TI", "TG", "UR", "VD", "VS", "ZG", "ZH"}, new String[]{"Aargau", "Appenzell Ausserrhoden", "Appenzell Innerrhoden", "Basel-Landschaft", "Basel-Stadt", "Bern", "Freiburg", "Genf", "Glarus", "Graub\u00fcnden", "Jura", "Luzern", "Neuenburg", "Nidwalden", "Obwalden", "Schaffhausen", "Schwyz", "Solothurn", "St. Gallen", "Tessin", "Thurgau", "Uri", "Waadt", "Wallis", "Zug", "Z\u00fcrich"}, null),
    SY("Syrian Arab Republic", false, false, null, null, null, null, null),
    TW("Taiwan, Province Of China", false, false, "\\d{3}(\\d{2})?", "%Z%n%S%C%n%1%n%2%n%O%n%N%n%I", new String[]{"\u53f0\u4e2d\u5e02", "\u53f0\u5317\u5e02", "\u53f0\u6771\u7e23", "\u53f0\u5357\u5e02", "\u5b9c\u862d\u7e23", "\u82b1\u84ee\u7e23", "\u91d1\u9580\u7e23", "\u5357\u6295\u7e23", "\u5c4f\u6771\u7e23", "\u82d7\u6817\u7e23", "\u6843\u5712\u7e23", "\u9ad8\u96c4\u5e02", "\u57fa\u9686\u5e02", "\u9023\u6c5f\u7e23", "\u96f2\u6797\u7e23", "\u65b0\u5317\u5e02", "\u65b0\u7af9\u5e02", "\u65b0\u7af9\u7e23", "\u5609\u7fa9\u5e02", "\u5609\u7fa9\u7e23", "\u5f70\u5316\u7e23", "\u6f8e\u6e56\u7e23"}, null, new String[]{"Taichung City", "Taipei City", "Taitung County", "Tainan City", "Yilan County", "Hualien County", "Kinmen County", "Nantou County", "Pingtung County", "Miaoli County", "Taoyuan County", "Kaohsiung City", "Keelung City", "Lienchiang County", "Yunlin County", "New Taipei City", "Hsinchu City", "Hsinchu County", "Chiayi City", "Chiayi County", "Changhua County", "Penghu County"}),
    TJ("Tajikistan", false, false, "\\d{6}", "%N%n%O%n%1%n%2%n%Z %C%n%I", null, null, null),
    TZ("Tanzania, United Republic Of", false, false, "\\d{4}", null, null, null, null),
    TH("Thailand", false, false, "\\d{5}", "%N%n%O%n%1%n%2%n%D %C%n%S %Z%n%I", new String[]{"\u0e01\u0e23\u0e30\u0e1a\u0e35\u0e48", "\u0e01\u0e23\u0e38\u0e07\u0e40\u0e17\u0e1e\u0e21\u0e2b\u0e32\u0e19\u0e04\u0e23", "\u0e01\u0e32\u0e0d\u0e08\u0e19\u0e1a\u0e38\u0e23\u0e35", "\u0e01\u0e32\u0e2c\u0e2a\u0e34\u0e19\u0e18\u0e38\u0e4c", "\u0e01\u0e33\u0e41\u0e1e\u0e07\u0e40\u0e1e\u0e0a\u0e23", "\u0e02\u0e2d\u0e19\u0e41\u0e01\u0e48\u0e19", "\u0e08\u0e31\u0e07\u0e2b\u0e27\u0e31\u0e14 \u0e1a\u0e36\u0e07\u0e01\u0e32\u0e2c", "\u0e08\u0e31\u0e19\u0e17\u0e1a\u0e38\u0e23\u0e35", "\u0e09\u0e30\u0e40\u0e0a\u0e34\u0e07\u0e40\u0e17\u0e23\u0e32", "\u0e0a\u0e25\u0e1a\u0e38\u0e23\u0e35", "\u0e0a\u0e31\u0e22\u0e19\u0e32\u0e17", "\u0e0a\u0e31\u0e22\u0e20\u0e39\u0e21\u0e34", "\u0e0a\u0e38\u0e21\u0e1e\u0e23", "\u0e40\u0e0a\u0e35\u0e22\u0e07\u0e23\u0e32\u0e22", "\u0e40\u0e0a\u0e35\u0e22\u0e07\u0e43\u0e2b\u0e21\u0e48", "\u0e15\u0e23\u0e31\u0e07", "\u0e15\u0e23\u0e32\u0e14", "\u0e15\u0e32\u0e01", "\u0e19\u0e04\u0e23\u0e19\u0e32\u0e22\u0e01", "\u0e19\u0e04\u0e23\u0e1b\u0e10\u0e21", "\u0e19\u0e04\u0e23\u0e1e\u0e19\u0e21", "\u0e19\u0e04\u0e23\u0e23\u0e32\u0e0a\u0e2a\u0e35\u0e21\u0e32", "\u0e19\u0e04\u0e23\u0e28\u0e23\u0e35\u0e18\u0e23\u0e23\u0e21\u0e23\u0e32\u0e0a", "\u0e19\u0e04\u0e23\u0e2a\u0e27\u0e23\u0e23\u0e04\u0e4c", "\u0e19\u0e19\u0e17\u0e1a\u0e38\u0e23\u0e35", "\u0e19\u0e23\u0e32\u0e18\u0e34\u0e27\u0e32\u0e2a", "\u0e19\u0e48\u0e32\u0e19", "\u0e1a\u0e38\u0e23\u0e35\u0e23\u0e31\u0e21\u0e22\u0e4c", "\u0e1b\u0e17\u0e38\u0e21\u0e18\u0e32\u0e19\u0e35", "\u0e1b\u0e23\u0e30\u0e08\u0e27\u0e1a\u0e04\u0e35\u0e23\u0e35\u0e02\u0e31\u0e19\u0e18\u0e4c", "\u0e1b\u0e23\u0e32\u0e08\u0e35\u0e19\u0e1a\u0e38\u0e23\u0e35", "\u0e1b\u0e31\u0e15\u0e15\u0e32\u0e19\u0e35", "\u0e1e\u0e23\u0e30\u0e19\u0e04\u0e23\u0e28\u0e23\u0e35\u0e2d\u0e22\u0e38\u0e18\u0e22\u0e32", "\u0e1e\u0e30\u0e40\u0e22\u0e32", "\u0e1e\u0e31\u0e07\u0e07\u0e32", "\u0e1e\u0e31\u0e17\u0e25\u0e38\u0e07", "\u0e1e\u0e34\u0e08\u0e34\u0e15\u0e23", "\u0e1e\u0e34\u0e29\u0e13\u0e38\u0e42\u0e25\u0e01", "\u0e40\u0e1e\u0e0a\u0e23\u0e1a\u0e38\u0e23\u0e35", "\u0e40\u0e1e\u0e0a\u0e23\u0e1a\u0e39\u0e23\u0e13\u0e4c", "\u0e41\u0e1e\u0e23\u0e48", "\u0e20\u0e39\u0e40\u0e01\u0e47\u0e15", "\u0e21\u0e2b\u0e32\u0e2a\u0e32\u0e23\u0e04\u0e32\u0e21", "\u0e21\u0e38\u0e01\u0e14\u0e32\u0e2b\u0e32\u0e23", "\u0e41\u0e21\u0e48\u0e2e\u0e48\u0e2d\u0e07\u0e2a\u0e2d\u0e19", "\u0e22\u0e42\u0e2a\u0e18\u0e23", "\u0e22\u0e30\u0e25\u0e32", "\u0e23\u0e49\u0e2d\u0e22\u0e40\u0e2d\u0e47\u0e14", "\u0e23\u0e30\u0e19\u0e2d\u0e07", "\u0e23\u0e30\u0e22\u0e2d\u0e07", "\u0e23\u0e32\u0e0a\u0e1a\u0e38\u0e23\u0e35", "\u0e25\u0e1e\u0e1a\u0e38\u0e23\u0e35", "\u0e25\u0e33\u0e1b\u0e32\u0e07", "\u0e25\u0e33\u0e1e\u0e39\u0e19", "\u0e40\u0e25\u0e22", "\u0e28\u0e23\u0e35\u0e2a\u0e30\u0e40\u0e01\u0e29", "\u0e2a\u0e01\u0e25\u0e19\u0e04\u0e23", "\u0e2a\u0e07\u0e02\u0e25\u0e32", "\u0e2a\u0e15\u0e39\u0e25", "\u0e2a\u0e21\u0e38\u0e17\u0e23\u0e1b\u0e23\u0e32\u0e01\u0e32\u0e23", "\u0e2a\u0e21\u0e38\u0e17\u0e23\u0e2a\u0e07\u0e04\u0e23\u0e32\u0e21", "\u0e2a\u0e21\u0e38\u0e17\u0e23\u0e2a\u0e32\u0e04\u0e23", "\u0e2a\u0e23\u0e30\u0e41\u0e01\u0e49\u0e27", "\u0e2a\u0e23\u0e30\u0e1a\u0e38\u0e23\u0e35", "\u0e2a\u0e34\u0e07\u0e2b\u0e4c\u0e1a\u0e38\u0e23\u0e35", "\u0e2a\u0e38\u0e42\u0e02\u0e17\u0e31\u0e22", "\u0e2a\u0e38\u0e1e\u0e23\u0e23\u0e13\u0e1a\u0e38\u0e23\u0e35", "\u0e2a\u0e38\u0e23\u0e32\u0e29\u0e0e\u0e23\u0e4c\u0e18\u0e32\u0e19\u0e35", "\u0e2a\u0e38\u0e23\u0e34\u0e19\u0e17\u0e23\u0e4c", "\u0e2b\u0e19\u0e2d\u0e07\u0e04\u0e32\u0e22", "\u0e2b\u0e19\u0e2d\u0e07\u0e1a\u0e31\u0e27\u0e25\u0e33\u0e20\u0e39", "\u0e2d\u0e48\u0e32\u0e07\u0e17\u0e2d\u0e07", "\u0e2d\u0e33\u0e19\u0e32\u0e08\u0e40\u0e08\u0e23\u0e34\u0e0d", "\u0e2d\u0e38\u0e14\u0e23\u0e18\u0e32\u0e19\u0e35", "\u0e2d\u0e38\u0e15\u0e23\u0e14\u0e34\u0e15\u0e16\u0e4c", "\u0e2d\u0e38\u0e17\u0e31\u0e22\u0e18\u0e32\u0e19\u0e35", "\u0e2d\u0e38\u0e1a\u0e25\u0e23\u0e32\u0e0a\u0e18\u0e32\u0e19\u0e35"}, null, new String[]{"Krabi", "Bangkok", "Kanchanaburi", "Kalasin", "Kamphaeng Phet", "Khon Kaen", "Bueng Kan", "Chanthaburi", "Chachoengsao", "Chon Buri", "Chai Nat", "Chaiyaphum", "Chumpon", "Chiang Rai", "Chiang Mai", "Trang", "Trat", "Tak", "Nakhon Nayok", "Nakhon Pathom", "Nakhon Phanom", "Nakhon Ratchasima", "Nakhon Si Thammarat", "Nakhon Sawan", "Nonthaburi", "Narathiwat", "Nan", "Buri Ram", "Pathum Thani", "Prachuap Khiri Khan", "Prachin Buri", "Pattani", "Phra Nakhon Si Ayutthaya", "Phayao", "Phang Nga", "Phattalung", "Phichit", "Phitsanulok", "Phetchaburi", "Phetchabun", "Phrae", "Phuket", "Maha Sarakham", "Mukdahan", "Mae Hong Son", "Yasothon", "Yala", "Roi Et", "Ranong", "Rayong", "Ratchaburi", "Lop Buri", "Lampang", "Lamphun", "Loei", "Si Sa Ket", "Sakon Nakhon", "Songkhla", "Satun", "Samut Prakan", "Samut Songkhram", "Samut Sakhon", "Sa Kaeo", "Saraburi", "Sing Buri", "Sukhothai", "Suphanburi", "Surat Thani", "Surin", "Nong Khai", "Nong Bua Lam Phu", "Ang Thong", "Amnat Charoen", "Udon Thani", "Uttaradit", "Uthai Thani", "Ubon Ratchathani"}),
    TL("Timor-leste", false, false, null, null, null, null, null),
    TG("Togo", false, false, null, null, null, null, null),
    TK("Tokelau", false, false, null, null, null, null, null),
    TO("Tonga", false, false, null, null, null, null, null),
    TT("Trinidad And Tobago", false, false, null, null, null, null, null),
    TN("Tunisia", false, false, "\\d{4}", "%N%n%O%n%1%n%2%n%Z %C%n%I", null, null, null),
    TR("Turkey", false, false, "\\d{5}", "%N%n%O%n%1%n%2%n%Z %C/%S%n%I", new String[]{"Adana", "Ad\u0131yaman", "Afyon", "A\u011fr\u0131", "Aksaray", "Amasya", "Ankara", "Antalya", "Ardahan", "Artvin", "Ayd\u0131n", "Bal\u0131kesir", "Bart\u0131n", "Batman", "Bayburt", "Bilecik", "Bing\u00f6l", "Bitlis", "Bolu", "Burdur", "Bursa", "\u00c7anakkale", "\u00c7ank\u0131r\u0131", "\u00c7orum", "Denizli", "Diyarbak\u0131r", "D\u00fczce", "Edirne", "Elaz\u0131\u011f", "Erzincan", "Erzurum", "Eski\u015fehir", "Gaziantep", "Giresun", "G\u00fcm\u00fc\u015fhane", "Hakkari", "Hatay", "I\u011fd\u0131r", "Isparta", "\u0130stanbul", "\u0130zmir", "Kahramanmara\u015f", "Karab\u00fck", "Karaman", "Kars", "Kastamonu", "Kayseri", "K\u0131r\u0131kkale", "K\u0131rklareli", "K\u0131r\u015fehir", "Kilis", "Kocaeli", "Konya", "K\u00fctahya", "Malatya", "Manisa", "Mardin", "Mersin", "Mu\u011fla", "Mu\u015f", "Nev\u015fehir", "Ni\u011fde", "Ordu", "Osmaniye", "Rize", "Sakarya", "Samsun", "Siirt", "Sinop", "Sivas", "\u015eanl\u0131urfa", "\u015e\u0131rnak", "Tekirda\u011f", "Tokat", "Trabzon", "Tunceli", "U\u015fak", "Van", "Yalova", "Yozgat", "Zonguldak"}, null, null),
    TM("Turkmenistan", false, false, "\\d{6}", "%N%n%O%n%1%n%2%n%Z %C%n%I", null, null, null),
    TC("Turks And Caicos Islands", false, false, "TKCA 1ZZ", "%N%n%O%n%1%n%2%n%X%n%C%n%Z%n%I", null, null, null),
    TV("Tuvalu", false, false, null, "%N%n%O%n%1%n%2%n%X%n%C%n%S%n%I", new String[]{"FUNAFUTI", "NANUMANGA", "NANUMEA", "NIULAKITA", "NIUTAO", "NUI", "NUKUFETAU", "NUKULAELAE", "VAITUPU"}, null, null),
    UG("Uganda", false, false, null, null, null, null, null),
    UA("Ukraine", false, false, "\\d{5}", "%N%n%O%n%1%n%2%n%C%n%S%n%Z%n%I", new String[]{"\u0410\u0432\u0442\u043e\u043d\u043e\u043c\u043d\u0430 \u0420\u0435\u0441\u043f\u0443\u0431\u043b\u0456\u043a\u0430 \u041a\u0440\u0438\u043c", "\u0412\u0456\u043d\u043d\u0438\u0446\u044c\u043a\u0430 \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u0412\u043e\u043b\u0438\u043d\u0441\u044c\u043a\u0430 \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u0414\u043d\u0456\u043f\u0440\u043e\u043f\u0435\u0442\u0440\u043e\u0432\u0441\u044c\u043a\u0430 \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u0414\u043e\u043d\u0435\u0446\u044c\u043a\u0430 \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u0416\u0438\u0442\u043e\u043c\u0438\u0440\u0441\u044c\u043a\u0430 \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u0417\u0430\u043a\u0430\u0440\u043f\u0430\u0442\u0441\u044c\u043a\u0430 \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u0417\u0430\u043f\u043e\u0440\u0456\u0437\u044c\u043a\u0430 \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u0406\u0432\u0430\u043d\u043e-\u0424\u0440\u0430\u043d\u043a\u0456\u0432\u0441\u044c\u043a\u0430 \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u043c\u0456\u0441\u0442\u043e \u041a\u0438\u0457\u0432", "\u041a\u0438\u0457\u0432\u0441\u044c\u043a\u0430 \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u041a\u0456\u0440\u043e\u0432\u043e\u0433\u0440\u0430\u0434\u0441\u044c\u043a\u0430 \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u041b\u0443\u0433\u0430\u043d\u0441\u044c\u043a\u0430 \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u041b\u044c\u0432\u0456\u0432\u0441\u044c\u043a\u0430 \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u041c\u0438\u043a\u043e\u043b\u0430\u0457\u0432\u0441\u044c\u043a\u0430 \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u041e\u0434\u0435\u0441\u044c\u043a\u0430 \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u041f\u043e\u043b\u0442\u0430\u0432\u0441\u044c\u043a\u0430 \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u0420\u0456\u0432\u043d\u0435\u043d\u0441\u044c\u043a\u0430 \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u043c\u0456\u0441\u0442\u043e \u0421\u0435\u0432\u0430\u0441\u0442\u043e\u043f\u043e\u043b\u044c", "\u0421\u0443\u043c\u0441\u044c\u043a\u0430 \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u0422\u0435\u0440\u043d\u043e\u043f\u0456\u043b\u044c\u0441\u044c\u043a\u0430 \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u0425\u0430\u0440\u043a\u0456\u0432\u0441\u044c\u043a\u0430 \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u0425\u0435\u0440\u0441\u043e\u043d\u0441\u044c\u043a\u0430 \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u0425\u043c\u0435\u043b\u044c\u043d\u0438\u0446\u044c\u043a\u0430 \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u0427\u0435\u0440\u043a\u0430\u0441\u044c\u043a\u0430 \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u0427\u0435\u0440\u043d\u0456\u0432\u0435\u0446\u044c\u043a\u0430 \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u0427\u0435\u0440\u043d\u0456\u0433\u0456\u0432\u0441\u044c\u043a\u0430 \u043e\u0431\u043b\u0430\u0441\u0442\u044c"}, new String[]{"\u0410\u0432\u0442\u043e\u043d\u043e\u043c\u043d\u0430 \u0420\u0435\u0441\u043f\u0443\u0431\u043b\u0456\u043a\u0430 \u041a\u0440\u0438\u043c", "\u0412\u0456\u043d\u043d\u0438\u0446\u044c\u043a\u0430 \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u0412\u043e\u043b\u0438\u043d\u0441\u044c\u043a\u0430 \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u0414\u043d\u0456\u043f\u0440\u043e\u043f\u0435\u0442\u0440\u043e\u0432\u0441\u044c\u043a\u0430 \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u0414\u043e\u043d\u0435\u0446\u044c\u043a\u0430 \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u0416\u0438\u0442\u043e\u043c\u0438\u0440\u0441\u044c\u043a\u0430 \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u0417\u0430\u043a\u0430\u0440\u043f\u0430\u0442\u0441\u044c\u043a\u0430 \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u0417\u0430\u043f\u043e\u0440\u0456\u0437\u044c\u043a\u0430 \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u0406\u0432\u0430\u043d\u043e-\u0424\u0440\u0430\u043d\u043a\u0456\u0432\u0441\u044c\u043a\u0430 \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u041a\u0438\u0457\u0432", "\u041a\u0438\u0457\u0432\u0441\u044c\u043a\u0430 \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u041a\u0456\u0440\u043e\u0432\u043e\u0433\u0440\u0430\u0434\u0441\u044c\u043a\u0430 \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u041b\u0443\u0433\u0430\u043d\u0441\u044c\u043a\u0430 \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u041b\u044c\u0432\u0456\u0432\u0441\u044c\u043a\u0430 \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u041c\u0438\u043a\u043e\u043b\u0430\u0457\u0432\u0441\u044c\u043a\u0430 \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u041e\u0434\u0435\u0441\u044c\u043a\u0430 \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u041f\u043e\u043b\u0442\u0430\u0432\u0441\u044c\u043a\u0430 \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u0420\u0456\u0432\u043d\u0435\u043d\u0441\u044c\u043a\u0430 \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u0421\u0435\u0432\u0430\u0441\u0442\u043e\u043f\u043e\u043b\u044c", "\u0421\u0443\u043c\u0441\u044c\u043a\u0430 \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u0422\u0435\u0440\u043d\u043e\u043f\u0456\u043b\u044c\u0441\u044c\u043a\u0430 \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u0425\u0430\u0440\u043a\u0456\u0432\u0441\u044c\u043a\u0430 \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u0425\u0435\u0440\u0441\u043e\u043d\u0441\u044c\u043a\u0430 \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u0425\u043c\u0435\u043b\u044c\u043d\u0438\u0446\u044c\u043a\u0430 \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u0427\u0435\u0440\u043a\u0430\u0441\u044c\u043a\u0430 \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u0427\u0435\u0440\u043d\u0456\u0432\u0435\u0446\u044c\u043a\u0430 \u043e\u0431\u043b\u0430\u0441\u0442\u044c", "\u0427\u0435\u0440\u043d\u0456\u0433\u0456\u0432\u0441\u044c\u043a\u0430 \u043e\u0431\u043b\u0430\u0441\u0442\u044c"}, new String[]{"Crimea", "Vinnyts'ka oblast", "Volyns'ka oblast", "Dnipropetrovsk Oblast", "Donetsk Oblast", "Zhytomyrs'ka oblast", "Zakarpats'ka oblast", "Zaporiz'ka oblast", "Ivano-Frankivs'ka oblast", "Kyiv city", "Kiev Oblast", "Kirovohrads'ka oblast", "Luhans'ka oblast", "Lviv Oblast", "Mykolaivs'ka oblast", "Odessa Oblast", "Poltavs'ka oblast", "Rivnens'ka oblast", "Sevastopol' city", "Sums'ka oblast", "Ternopil's'ka oblast", "Kharkiv Oblast", "Khersons'ka oblast", "Khmel'nyts'ka oblast", "Cherkas'ka oblast", "Chernivets'ka oblast", "Chernihivs'ka oblast"}),
    AE("United Arab Emirates", false, false, null, "%N%n%O%n%1%n%2%n%S%n%I", new String[]{"\u0623\u0628\u0648 \u0638\u0628\u064a", "\u0627\u0644\u0641\u062c\u064a\u0631\u0629", "\u0627\u0645 \u0627\u0644\u0642\u064a\u0648\u064a\u0646", "\u0625\u0645\u0627\u0631\u0629 \u0627\u0644\u0634\u0627\u0631\u0642\u0629\u0651", "\u0625\u0645\u0627\u0631\u0629 \u062f\u0628\u064a\u0651", "\u0625\u0645\u0627\u0631\u0629 \u0631\u0623\u0633 \u0627\u0644\u062e\u064a\u0645\u0629", "\u0639\u062c\u0645\u0627\u0646"}, null, new String[]{"Abu Dhabi", "Fujairah", "Umm Al Quwain", "Sharjah", "Dubai", "Ras al Khaimah", "Ajm\u0101n"}),
    GB("United Kingdom", true, false, "GIR[ ]?0AA|((AB|AL|B|BA|BB|BD|BH|BL|BN|BR|BS|BT|BX|CA|CB|CF|CH|CM|CO|CR|CT|CV|CW|DA|DD|DE|DG|DH|DL|DN|DT|DY|E|EC|EH|EN|EX|FK|FY|G|GL|GY|GU|HA|HD|HG|HP|HR|HS|HU|HX|IG|IM|IP|IV|JE|KA|KT|KW|KY|L|LA|LD|LE|LL|LN|LS|LU|M|ME|MK|ML|N|NE|NG|NN|NP|NR|NW|OL|OX|PA|PE|PH|PL|PO|PR|RG|RH|RM|S|SA|SE|SG|SK|SL|SM|SN|SO|SP|SR|SS|ST|SW|SY|TA|TD|TF|TN|TQ|TR|TS|TW|UB|W|WA|WC|WD|WF|WN|WR|WS|WV|YO|ZE)(\\d[\\dA-Z]?[ ]?\\d[ABD-HJLN-UW-Z]{2}))|BFPO[ ]?\\d{1,4}", "%N%n%O%n%1%n%2%n%C%n%S%n%Z%n%I", null, null, null),
    US("United States", false, false, "(\\d{5})(?:[ \\-](\\d{4}))?", "%N%n%O%n%1%n%2%n%C, %S %Z%n%I", new String[]{"AL", "AK", "AS", "AZ", "AR", "AA", "AE", "AP", "CA", "CO", "CT", "DE", "DC", "FL", "GA", "GU", "HI", "ID", "IL", "IN", "IA", "KS", "KY", "LA", "ME", "MH", "MD", "MA", "MI", "FM", "MN", "MS", "MO", "MT", "NE", "NV", "NH", "NJ", "NM", "NY", "NC", "ND", "MP", "OH", "OK", "OR", "PW", "PA", "PR", "RI", "SC", "SD", "TN", "TX", "UT", "VT", "VI", "VA", "WA", "WV", "WI", "WY"}, new String[]{"Alabama", "Alaska", "American Samoa", "Arizona", "Arkansas", "Armed Forces (AA)", "Armed Forces (AE)", "Armed Forces (AP)", "California", "Colorado", "Connecticut", "Delaware", "District of Columbia", "Florida", "Georgia", "Guam", "Hawaii", "Idaho", "Illinois", "Indiana", "Iowa", "Kansas", "Kentucky", "Louisiana", "Maine", "Marshall Islands", "Maryland", "Massachusetts", "Michigan", "Micronesia", "Minnesota", "Mississippi", "Missouri", "Montana", "Nebraska", "Nevada", "New Hampshire", "New Jersey", "New Mexico", "New York", "North Carolina", "North Dakota", "Northern Mariana Islands", "Ohio", "Oklahoma", "Oregon", "Palau", "Pennsylvania", "Puerto Rico", "Rhode Island", "South Carolina", "South Dakota", "Tennessee", "Texas", "Utah", "Vermont", "Virgin Islands", "Virginia", "Washington", "West Virginia", "Wisconsin", "Wyoming"}, null),
    UM("United States Minor Outlying Islands", false, false, "96898", "%N%n%O%n%1%n%2%n%C %S %Z%n%I", null, null, null),
    UY("Uruguay", false, false, "\\d{5}", "%N%n%O%n%1%n%2%n%Z %C %S%n%I", new String[]{"ARTIGAS", "CANELONES", "CERRO LARGO", "COLONIA", "DURAZNO", "FLORES", "FLORIDA", "LAVALLEJA", "MALDONADO", "MONTEVIDEO", "PAYSAND\u00da", "R\u00cdO NEGRO", "RIVERA", "ROCHA", "SALTO", "SAN JOS\u00c9", "SORIANO", "TACUAREMB\u00d3", "TREINTA Y TRES"}, null, null),
    UZ("Uzbekistan", false, false, "\\d{6}", "%N%n%O%n%1%n%2%n%Z %C%n%S%n%I", null, null, null),
    VU("Vanuatu", false, false, null, null, null, null, null),
    VE("Venezuela, Bolivarian Republic Of", false, false, "\\d{4}", "%N%n%O%n%1%n%2%n%C %Z, %S%n%I", new String[]{"Amazonas", "Anzo\u00e1tegui", "Apure", "Aragua", "Barinas", "Bol\u00edvar", "Carabobo", "Cojedes", "Delta Amacuro", "Dependencias Federales", "Distrito Federal", "Falc\u00f3n", "Gu\u00e1rico", "Lara", "M\u00e9rida", "Miranda", "Monagas", "Nueva Esparta", "Portuguesa", "Sucre", "T\u00e1chira", "Trujillo", "Vargas", "Yaracuy", "Zulia"}, null, null),
    VN("Viet Nam", false, false, "\\d{6}", "%N%n%O%n%1%n%2%n%C%n%S %Z%n%I", new String[]{"An Giang", "B\u00e0 R\u1ecba\u2013V\u0169ng T\u00e0u", "B\u1eafc Giang", "B\u1eafc K\u1ea1n", "B\u1eafc Lieu", "B\u1eafc Ninh", "B\u1ebfn Tre", "B\u00ecnh D\u01b0\u01a1ng", "B\u00ecnh \u0110\u1ecbnh", "B\u00ecnh Ph\u01b0\u1edbc", "B\u00ecnh Thu\u1eadn", "C\u00e0 Mau", "Cao B\u1eb1ng", "C\u1ea7n Th\u01a1", "\u0110\u00e0 N\u1eb5ng", "\u0110\u1eafk L\u1eafk", "\u0110\u0103k N\u00f4ng", "\u0110i\u1ec7n Bi\u00ean", "\u0110\u1ed3ng Nai", "\u0110\u1ed3ng Th\u00e1p", "Gia Lai", "H\u00e0 Giang", "H\u00e0 Nam", "H\u00e0 N\u1ed9i", "H\u00e0 T\u00e2y", "H\u00e0 T\u0129nh", "H\u1ea3i D\u01b0\u01a1ng", "H\u1ea3i Ph\u00f2ng", "H\u1eadu Giang", "H\u00f2a B\u00ecnh", "H\u01b0ng Y\u00ean", "Kh\u00e1nh H\u00f2a", "Ki\u00ean Giang", "Kon Tum", "Lai Ch\u00e2u", "L\u1ea1ng S\u01a1n", "L\u00e0o Cai", "L\u00e2m \u0110\u1ed3ng", "Long An", "Nam \u0110\u1ecbnh", "Ngh\u1ec7 An", "Ninh B\u00ecnh", "Ninh Thu\u1eadn", "Ph\u00fa Th\u1ecd", "Ph\u00fa Y\u00ean", "Qu\u1ea3ng B\u00ecnh", "Qu\u1ea3ng Nam", "Qu\u1ea3ng Ng\u00e3i", "Qu\u1ea3ng Ninh", "Qu\u1ea3ng Tr\u1ecb", "S\u00f3c Tr\u0103ng", "S\u01a1n La", "T\u00e2y Ninh", "Th\u00e1i B\u00ecnh", "Th\u00e1i Nguy\u00ean", "Thanh H\u00f3a", "Th\u00e0nh ph\u1ed1 H\u1ed3 Ch\u00ed Minh", "Th\u1eeba Thi\u00ean\u2013Hu\u1ebf", "Ti\u1ec1n Giang", "Tr\u00e0 Vinh", "Tuy\u00ean Quang", "V\u0129nh Long", "V\u0129nh Ph\u00fac", "Y\u00ean B\u00e1i"}, null, new String[]{"AN GIANG PROVINCE", "BA RIA-VUNG TAU PROVINCE", "BAC GIANG PROVINCE", "BAC KAN PROVINCE", "BAC LIEU PROVINCE", "BAC NINH PROVINCE", "BEN TRE PROVINCE", "BINH DUONG PROVINCE", "BINH DINH PROVINCE", "BINH PHUOC PROVINCE", "BINH THUAN PROVINCE", "CA MAU PROVINCE", "CAO BANG PROVINCE", "CAN THO CITY", "DA NANG CITY", "DAK LAK PROVINCE", "DAK NONG PROVINCE", "DIEN BIEN PROVINCE", "DONG NAI PROVINCE", "DONG THAP PROVINCE", "GIA LAI PROVINCE", "HA GIANG PROVINCE", "HA NAM PROVINCE", "HANOI CITY", "HA TAY PROVINCE", "HA TINH PROVINCE", "HAI DUONG PROVINCE", "HAIPHONG CITY", "HAU GIANG PROVINCE", "HOA BINH PROVINCE", "HUNG YEN PROVINCE", "KHANH HOA PROVINCE", "KIEN GIANG PROVINCE", "KON TUM PROVINCE", "LAI CHAU PROVINCE", "LANG SONG PROVINCE", "LAO CAI PROVINCE", "LAM DONG PROVINCE", "LONG AN PROVINCE", "NAM DINH PROVINCE", "NGHE AN PROVINCE", "NINH BINH PROVINCE", "NINH THUAN PROVINCE", "PHU THO PROVINCE", "PHU YEN PROVINCE", "QUANG BINH PROVINCE", "QUANG NAM PROVINCE", "QUANG NGAI PROVINCE", "QUANG NINH PROVINCE", "QUANG TRI PROVINCE", "SOC TRANG PROVINCE", "SON LA PROVINCE", "TAY NINH PROVINCE", "THAI BINH PROVINCE", "THAI NGUYEN PROVINCE", "THANH HOA PROVINCE", "HO CHI MINH CITY", "THUA THIEN-HUE PROVINCE", "TIEN GIANG PROVINCE", "TRA VINH PROVINCE", "TUYEN QUANG PROVINCE", "VINH LONG PROVINCE", "VINH PHUC PROVINCE", "YEN BAI PROVINCE"}),
    VG("Virgin Islands, British", false, false, "VG\\d{4}", "%N%n%O%n%1%n%2%n%C%n%Z%n%I", null, null, null),
    VI("Virgin Islands, U.s.", false, false, "(008(?:(?:[0-4]\\d)|(?:5[01])))(?:[ \\-](\\d{4}))?", "%N%n%O%n%1%n%2%n%C %S %Z%n%I", null, null, null),
    WF("Wallis And Futuna", false, false, "986\\d{2}", "%O%n%N%n%1%n%2%n%Z %C %X%n%I", null, null, null),
    EH("Western Sahara", false, false, "\\d{5}", "%N%n%O%n%1%n%2%n%Z %C%n%I", null, null, null),
    YE("Yemen", false, false, null, null, null, null, null),
    ZM("Zambia", false, false, "\\d{5}", "%N%n%O%n%1%n%2%n%Z %C%n%I", null, null, null),
    ZW("Zimbabwe", false, false, null, null, null, null, null);

    private static final long serialVersionUID = 1L;
    private static final transient Map<String, IsoCountryCode> CODES;
    private final String countryName;
    private final boolean eu;
    private final boolean euro;
    private final Pattern postalCodePattern;
    private final String addressFormat;
    private final ImmutableSortedSet<String> statesProvinces;
    private final ImmutableSortedSet<String> stateProvinceNames;
    private final ImmutableSortedSet<String> stateProvinceLatinNames;

    public static IsoCountryCode findCountry(String postalCode, String stateOrProvince, IsoCountryCode ... countries) {
        boolean haveStateOrProvince;
        int numCountries;
        int n = numCountries = countries != null ? countries.length : 0;
        if (numCountries == 0) {
            return IsoCountryCode.findCountry(postalCode, stateOrProvince, IsoCountryCode.values());
        }
        boolean havePostalCode = !StringUtils.isBlank((CharSequence)postalCode);
        boolean bl = haveStateOrProvince = !StringUtils.isBlank((CharSequence)stateOrProvince);
        if (!havePostalCode && !haveStateOrProvince) {
            return null;
        }
        for (int i = 0; i < numCountries; ++i) {
            IsoCountryCode country = countries[i];
            if (havePostalCode && !country.isValidPostalCode(postalCode) || haveStateOrProvince && !country.isValidStateOrProvince(stateOrProvince)) continue;
            return country;
        }
        return null;
    }

    public static IsoCountryCode fromLocaleCountry(Locale locale) {
        if (locale != null) {
            return IsoCountryCode.fromString(locale.getCountry());
        }
        return null;
    }

    public static IsoCountryCode fromString(String countryCode) {
        if (!StringUtils.isEmpty((CharSequence)countryCode)) {
            return CODES.get(countryCode);
        }
        return null;
    }

    private IsoCountryCode(String countryName, boolean eu, boolean euro, String postalCodePattern, String addressFormat, String[] states, String[] stateNames, String[] stateLatinNames) {
        this.countryName = countryName;
        this.eu = eu;
        this.euro = euro;
        this.postalCodePattern = StringUtils.isEmpty((CharSequence)postalCodePattern) ? null : Pattern.compile("^\\s*" + postalCodePattern + "\\s*$", 66);
        this.addressFormat = addressFormat;
        this.statesProvinces = states != null ? ImmutableSortedSet.orderedBy((Comparator)String.CASE_INSENSITIVE_ORDER).add((Object[])states).build() : ImmutableSortedSet.of();
        this.stateProvinceNames = stateNames != null ? ImmutableSortedSet.orderedBy((Comparator)String.CASE_INSENSITIVE_ORDER).add((Object[])stateNames).build() : ImmutableSortedSet.of();
        this.stateProvinceLatinNames = stateLatinNames != null ? ImmutableSortedSet.orderedBy((Comparator)String.CASE_INSENSITIVE_ORDER).add((Object[])stateLatinNames).build() : ImmutableSortedSet.of();
    }

    public String getAddressFormat() {
        return this.addressFormat != null && this.addressFormat.length() != 0 ? this.addressFormat : IsoCountryCode.US.addressFormat;
    }

    public String getCountryName() {
        return this.countryName;
    }

    public String getResourceBundleKey() {
        return ((Object)((Object)this)).getClass().getName() + "." + this.name();
    }

    public Set<String> getStateProvinceLatinNames() {
        return this.stateProvinceLatinNames;
    }

    public Set<String> getStateProvinceNames() {
        return this.stateProvinceNames;
    }

    public Set<String> getStatesProvinces() {
        return this.statesProvinces;
    }

    public boolean isEu() {
        return this.eu;
    }

    public boolean isEuro() {
        return this.euro;
    }

    public boolean isValidPostalCode(String postalCode) {
        if (this.postalCodePattern == null || StringUtils.isEmpty((CharSequence)postalCode)) {
            return false;
        }
        return this.postalCodePattern.matcher(postalCode).find();
    }

    public boolean isValidStateOrProvince(String stateProvince) {
        if (StringUtils.isEmpty((CharSequence)stateProvince)) {
            return false;
        }
        return this.statesProvinces.contains((Object)stateProvince) || this.stateProvinceNames.contains((Object)stateProvince) || this.stateProvinceLatinNames.contains((Object)stateProvince);
    }

    /*
     * Opcode count of 13694 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    static {
        TreeMap<String, IsoCountryCode> countryNames = new TreeMap<String, IsoCountryCode>(String.CASE_INSENSITIVE_ORDER);
        for (IsoCountryCode country : IsoCountryCode.values()) {
            countryNames.put(country.name(), country);
        }
        CODES = Collections.unmodifiableMap(countryNames);
    }
}

