/*
 * Decompiled with CFR 0.152.
 */
package com.arakelian.core.utils;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutorUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExecutorUtils.class);

    public static Thread createShutdownHook(final Closeable closeable) {
        final String target = closeable.toString();
        Thread shutdownHook = new Thread(){

            @Override
            public void run() {
                LOGGER.info("Shutting down {}", (Object)target);
                try {
                    closeable.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }

            @Override
            public String toString() {
                return "ShutdownThread{closeable=" + target + "}";
            }
        };
        Runtime.getRuntime().addShutdownHook(shutdownHook);
        return shutdownHook;
    }

    public static ThreadFactory newThreadFactory(Class<?> clazz, boolean daemon) {
        return ExecutorUtils.newThreadFactory(clazz, null, daemon);
    }

    public static ThreadFactory newThreadFactory(Class<?> clazz, String suffix, boolean daemon) {
        StringBuilder buf = new StringBuilder();
        buf.append(clazz.getSimpleName());
        if (!StringUtils.isEmpty((CharSequence)suffix)) {
            buf.append(suffix);
        }
        buf.append("-%d");
        String format = buf.toString();
        return ExecutorUtils.newThreadFactory(format, daemon);
    }

    public static ThreadFactory newThreadFactory(String format, boolean daemon) {
        Object nameFormat = !format.contains("%d") ? format + "-%d" : format;
        return new ThreadFactoryBuilder().setNameFormat((String)nameFormat).setDaemon(daemon).build();
    }

    public static void removeShutdownHook(Thread shutdownHook) {
        if (shutdownHook != null) {
            try {
                Runtime.getRuntime().removeShutdownHook(shutdownHook);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    public static boolean shutdown(ExecutorService service, long timeout, TimeUnit unit, boolean forceTermination) {
        if (service == null) {
            return false;
        }
        if (service.isTerminated()) {
            return true;
        }
        if (!service.isShutdown()) {
            service.shutdown();
        }
        try {
            boolean terminated;
            boolean bl = terminated = timeout != 0L ? service.awaitTermination(timeout, unit) : false;
            if (!terminated && forceTermination) {
                service.shutdownNow();
            }
            return terminated;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    private ExecutorUtils() {
    }
}

