/*
 * Decompiled with CFR 0.152.
 */
package com.arakelian.core.utils;

import com.google.common.base.Preconditions;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.net.MediaType;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MediaTypeUtils {
    private static final Set<String> DANGEROUS_EXTENSIONS;
    private static final Set<String> DANGEROUS_MEDIA_TYPES;
    private static final Pattern VALID_EXTENSION;
    private static final Pattern VALID_MIME_TYPE;
    private static final Multimap<String, String> EXTENSION_TO_CONTENT_TYPE;
    private static final Multimap<String, String> CONTENT_TYPE_TO_EXTENSION;
    public static final Map<String, String> CONTENT_TYPE_TO_IMAGEIO_TYPE;
    private static final Logger LOGGER;

    public static Collection<String> getExtensionOfMediaType(String contentType) {
        String type = contentType.toLowerCase();
        return contentType != null && CONTENT_TYPE_TO_EXTENSION.containsKey((Object)type) ? CONTENT_TYPE_TO_EXTENSION.get((Object)type) : Collections.emptyList();
    }

    public static Collection<String> getMediaTypeOfExtension(String extension) {
        String ext = extension.toLowerCase();
        return extension != null && EXTENSION_TO_CONTENT_TYPE.containsKey((Object)ext) ? EXTENSION_TO_CONTENT_TYPE.get((Object)ext) : Collections.emptyList();
    }

    public static String getPrimaryExtensionOfMediaType(String contentType) {
        return MediaTypeUtils.getPrimaryExtensionOfMediaType(contentType, null);
    }

    public static String getPrimaryExtensionOfMediaType(String contentType, String defaultExtension) {
        Collection<String> extensions = MediaTypeUtils.getExtensionOfMediaType(contentType);
        if (extensions == null) {
            return defaultExtension;
        }
        Iterator<String> it = extensions.iterator();
        return it.hasNext() ? it.next() : defaultExtension;
    }

    public static String getSafeExtension(String filename) {
        String extension = FilenameUtils.getExtension((String)filename);
        return MediaTypeUtils.isSafeExtension(extension) ? "." + extension : "";
    }

    public static boolean isImage(String mimeType) {
        return StringUtils.startsWith((CharSequence)mimeType, (CharSequence)"image/");
    }

    public static boolean isPdf(String mimeType) {
        return MediaType.PDF.toString().equalsIgnoreCase(mimeType);
    }

    public static boolean isSafeExtension(String extension) {
        return extension != null && VALID_EXTENSION.matcher(extension).matches() && !DANGEROUS_EXTENSIONS.contains(extension);
    }

    public static boolean isSafeMediaType(String mediaType) {
        return mediaType != null && VALID_MIME_TYPE.matcher(mediaType).matches() && !DANGEROUS_MEDIA_TYPES.contains(mediaType);
    }

    public static boolean isValidMediaType(String mediaType) {
        return mediaType != null && VALID_MIME_TYPE.matcher(mediaType).matches();
    }

    private static Multimap<String, String> mapContentTypesToExtensions() {
        LinkedListMultimap extensions = LinkedListMultimap.create();
        extensions.put((Object)MediaType.BMP.toString(), (Object)".bmp");
        extensions.put((Object)MediaType.GIF.toString(), (Object)".gif");
        extensions.put((Object)MediaType.JPEG.toString(), (Object)".jpg");
        extensions.put((Object)MediaType.JPEG.toString(), (Object)".jpeg");
        extensions.put((Object)MediaType.JPEG.toString(), (Object)".jpe");
        extensions.put((Object)MediaType.PDF.toString(), (Object)".pdf");
        extensions.put((Object)MediaType.PNG.toString(), (Object)".png");
        extensions.put((Object)MediaType.TIFF.toString(), (Object)".tif");
        extensions.put((Object)MediaType.TIFF.toString(), (Object)".tiff");
        extensions.put((Object)MediaType.RTF_UTF_8.withoutParameters().toString(), (Object)".rtf");
        extensions.put((Object)MediaType.PLAIN_TEXT_UTF_8.withoutParameters().toString(), (Object)".txt");
        extensions.put((Object)MediaType.ZIP.toString(), (Object)".zip");
        extensions.put((Object)MediaType.MICROSOFT_EXCEL.toString(), (Object)".xls");
        extensions.put((Object)MediaType.MICROSOFT_POWERPOINT.toString(), (Object)".ppt");
        extensions.put((Object)MediaType.MICROSOFT_WORD.toString(), (Object)".doc");
        extensions.put((Object)MediaType.OOXML_DOCUMENT.toString(), (Object)".docx");
        extensions.put((Object)MediaType.OOXML_PRESENTATION.toString(), (Object)".pptx");
        extensions.put((Object)MediaType.OOXML_SHEET.toString(), (Object)".xlsx");
        extensions.put((Object)"application/vnd.ms-excel.addin.macroenabled.12", (Object)".xlam");
        extensions.put((Object)"application/vnd.ms-excel.sheet.binary.macroenabled.12", (Object)".xlsb");
        extensions.put((Object)"application/vnd.openxmlformats-officedocument.presentationml.slide", (Object)".sldx");
        extensions.put((Object)"application/vnd.openxmlformats-officedocument.presentationml.slideshow", (Object)".ppsx");
        extensions.put((Object)"application/vnd.openxmlformats-officedocument.presentationml.template", (Object)".potx");
        extensions.put((Object)"application/vnd.openxmlformats-officedocument.spreadsheetml.template", (Object)".xltx");
        extensions.put((Object)"application/vnd.openxmlformats-officedocument.wordprocessingml.template", (Object)".dotx");
        extensions.put((Object)"application/x-visio", (Object)".vsd");
        return extensions;
    }

    static {
        VALID_EXTENSION = Pattern.compile("^[A-Za-z0-9]{1,10}$");
        VALID_MIME_TYPE = Pattern.compile("^[A-Za-z0-9]+/[-.A-Za-z0-9]+(?:\\+[-.A-Za-z0-9]+)?");
        DANGEROUS_EXTENSIONS = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        DANGEROUS_EXTENSIONS.addAll(Sets.newHashSet((Object[])new String[]{"application", "bat", "cmd", "com", "exe", "gadget", "hta", "inf", "jar", "js", "jse", "lnk", "msc", "msh", "msh1", "msh1xml", "msh2", "msh2xml", "mshxml", "msi", "msp", "pif", "ps1", "ps1xml", "ps2", "ps2xml", "psc1", "psc2", "reg", "scf", "scr", "vb", "vbe", "vbs", "ws", "wsc", "wsf", "wsh"}));
        DANGEROUS_MEDIA_TYPES = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        DANGEROUS_MEDIA_TYPES.addAll(Sets.newHashSet((Object[])new String[]{"application/bat", "application/bittorrent", "application/chrome-extension", "application/com", "application/download", "application/exe", "application/hta", "application/java-jnlp-file", "application/javascript", "application/ms-shortcut", "application/msdos-program", "application/msdos-windows", "application/msdownload", "application/octet-stream", "application/opera-extension", "application/redhat-package-manager", "application/shockwave-flash", "application/winexe", "application/winhelp", "application/winhlp", "application/x-bat", "application/x-bittorrent", "application/x-chrome-extension", "application/x-com", "application/x-download", "application/x-exe", "application/x-java-jnlp-file", "application/x-javascript", "application/x-ms-shortcut", "application/x-msdos-program", "application/x-msdos-windows", "application/x-msdownload", "application/x-opera-extension", "application/x-redhat-package-manager", "application/x-shockwave-flash", "application/x-winexe", "application/x-winhelp", "application/x-winhlp", "application/x-xpinstall", "text/javascript", "text/scriptlet", "vms/exe"}));
        LOGGER = LoggerFactory.getLogger(MediaTypeUtils.class);
        CONTENT_TYPE_TO_EXTENSION = MediaTypeUtils.mapContentTypesToExtensions();
        LinkedListMultimap reverse = LinkedListMultimap.create();
        for (Map.Entry entry : CONTENT_TYPE_TO_EXTENSION.entries()) {
            String extension = (String)entry.getValue();
            String mediaType = (String)entry.getKey();
            Preconditions.checkState((boolean)extension.toLowerCase().equals(extension), (Object)(extension + " is not lowercase"));
            Preconditions.checkState((boolean)mediaType.toLowerCase().equals(mediaType), (Object)(mediaType + " is not lowercase"));
            LOGGER.info("Mapping extension {} to {}", (Object)extension, (Object)mediaType);
            reverse.put((Object)extension, (Object)mediaType);
        }
        EXTENSION_TO_CONTENT_TYPE = reverse;
        CONTENT_TYPE_TO_IMAGEIO_TYPE = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        CONTENT_TYPE_TO_IMAGEIO_TYPE.put(MediaType.JPEG.toString(), "jpg");
        CONTENT_TYPE_TO_IMAGEIO_TYPE.put(MediaType.PNG.toString(), "png");
        CONTENT_TYPE_TO_IMAGEIO_TYPE.put(MediaType.GIF.toString(), "gif");
        CONTENT_TYPE_TO_IMAGEIO_TYPE.put(MediaType.BMP.toString(), "bmp");
        CONTENT_TYPE_TO_IMAGEIO_TYPE.put(MediaType.TIFF.toString(), "tif");
    }
}

