/*
 * Decompiled with CFR 0.152.
 */
package com.arakelian.core.utils;

import com.arakelian.core.utils.MoreStringUtils;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessUtils.class);
    private static final AtomicLong ID = new AtomicLong();

    public static ProcessBuilder build(String ... commands) {
        Preconditions.checkArgument((commands != null && commands.length != 0 ? 1 : 0) != 0, (Object)"commands must be non-empty");
        return new ProcessBuilder(commands);
    }

    public static <O extends Consumer<String>, E extends Consumer<String>> int run(ProcessBuilder builder, O stdout, E stderr) throws IOException, InterruptedException {
        return ProcessUtils.start(builder, stdout, stderr).waitFor().getExitCode();
    }

    public static ProcessInfo<StringOut, StringOut> run(String ... commands) throws IOException, InterruptedException {
        return ProcessUtils.start(ProcessUtils.build(commands), new StringOut(), new StringOut()).waitFor();
    }

    public static <O extends Consumer<String>, E extends Consumer<String>> ProcessInfo<O, E> start(ProcessBuilder builder, O stdout, E stderr) throws IOException {
        return new ProcessInfo<O, E>(builder, stdout, stderr);
    }

    private ProcessUtils() {
    }

    private static final class StreamGobbler
    implements Runnable {
        private final InputStream inputStream;
        private final Consumer<String> consumeInputLine;

        public StreamGobbler(InputStream inputStream, Consumer<String> consumeInputLine) {
            this.inputStream = inputStream;
            this.consumeInputLine = consumeInputLine;
        }

        @Override
        public void run() {
            BufferedReader reader = new BufferedReader(new InputStreamReader(this.inputStream, Charsets.UTF_8));
            reader.lines().forEach(this.consumeInputLine);
        }
    }

    public static final class StringOut
    implements Consumer<String> {
        private final StringBuilder out = new StringBuilder();

        @Override
        public void accept(String line) {
            if (this.out.length() != 0) {
                this.out.append('\n');
            }
            this.out.append(line);
        }

        public String toString() {
            return this.out.toString();
        }
    }

    public static class ProcessInfo<O extends Consumer<String>, E extends Consumer<String>> {
        private final String commandLine;
        private final Process process;
        private final O stdout;
        private final E stderr;
        private Thread out;
        private Thread err;

        public ProcessInfo(ProcessBuilder builder, O stdout, E stderr) throws IOException {
            List<String> commands = builder.command();
            Preconditions.checkArgument((commands != null && commands.size() != 0 ? 1 : 0) != 0, (Object)"commands must be non-empty");
            this.stdout = stdout;
            this.stderr = stderr;
            this.commandLine = MoreStringUtils.SPACE_JOINER.join(commands);
            try {
                LOGGER.info("Starting {}", (Object)this.commandLine);
                this.process = builder.start();
            }
            catch (IOException e) {
                throw new IOException("Failed to start process: " + this.commandLine, e);
            }
            if (stdout != null) {
                this.out = new Thread((Runnable)new StreamGobbler(this.process.getInputStream(), (Consumer<String>)stdout), StreamGobbler.class.getSimpleName() + "-stdout-" + ID.incrementAndGet());
                this.out.start();
            }
            if (stderr != null) {
                this.err = new Thread((Runnable)new StreamGobbler(this.process.getErrorStream(), (Consumer<String>)stderr), StreamGobbler.class.getSimpleName() + "-stderr-" + ID.incrementAndGet());
                this.err.start();
            }
        }

        public final void ensureDestroyed() {
            this.ensureDestroyed(1L, TimeUnit.SECONDS);
        }

        public final void ensureDestroyed(long timeout, TimeUnit unit) {
            this.process.destroy();
            try {
                boolean dead = this.waitFor(timeout, unit);
                if (!dead) {
                    this.process.destroyForcibly();
                    LOGGER.info("Terminated forcibly {}", (Object)this);
                } else {
                    LOGGER.info("Terminated {}", (Object)this);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
        }

        public String getCommandLine() {
            return this.commandLine;
        }

        public final int getExitCode() throws IllegalThreadStateException {
            int exitValue = this.process.exitValue();
            return exitValue;
        }

        public final int getExitCodeQuietly(int defaultValue) {
            try {
                return this.process.exitValue();
            }
            catch (IllegalThreadStateException e) {
                return defaultValue;
            }
        }

        public E getStderr() {
            return this.stderr;
        }

        public O getStdout() {
            return this.stdout;
        }

        public final boolean isAlive() {
            return this.process.isAlive();
        }

        public String toString() {
            int exitCode;
            StringBuilder builder = new StringBuilder();
            String sep = "";
            builder.append("ProcessInfo [");
            if (this.commandLine != null) {
                builder.append("commandLine=");
                builder.append(this.commandLine);
                sep = ", ";
            }
            if ((exitCode = this.getExitCodeQuietly(Integer.MAX_VALUE)) != Integer.MAX_VALUE) {
                builder.append(sep);
                builder.append("exitCode=");
                builder.append(exitCode);
                sep = ", ";
            }
            builder.append("]");
            return builder.toString();
        }

        public final ProcessInfo<O, E> waitFor() throws InterruptedException {
            this.process.waitFor();
            this.waitForThreads();
            return this;
        }

        public final boolean waitFor(long timeout, TimeUnit unit) throws InterruptedException {
            boolean dead = this.process.waitFor(timeout, unit);
            if (dead) {
                this.waitForThreads();
            }
            return dead;
        }

        private void waitForThreads() throws InterruptedException {
            if (this.out != null) {
                this.out.join();
                this.out = null;
            }
            if (this.err != null) {
                this.err.join();
                this.err = null;
            }
        }
    }
}

