/*
 * Decompiled with CFR 0.152.
 */
package com.arakelian.core.utils;

import com.google.common.base.Charsets;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.text.MessageFormat;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlStreamReaderUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(XmlStreamReaderUtils.class);
    private static final String[] NAMES_OF_EVENTS = new String[]{"UNDEFINED", "START_ELEMENT", "END_ELEMENT", "PROCESSING_INSTRUCTIONS", "CHARACTERS", "COMMENT", "SPACE", "START_DOCUMENT", "END_DOCUMENT", "ENTITY_REFERENCE", "ATTRIBUTE", "DTD", "CDATA", "NAMESPACE", "NOTATION_DECLARATION", "ENTITY_DECLARATION"};
    public static final int COPY_START_DOCUMENT = 1;
    public static final int COPY_END_DOCUMENT = 2;
    public static final int COPY_COMMENTS = 4;
    public static final int COPY_IGNORABLE_WHITESPACE = 8;
    public static final int COPY_SINGLE_ELEMENT = 16;
    public static final int DEFAULT_COPY_FLAGS = 0;

    public static void closeEmptyTag(XMLStreamReader reader, String namespace, String localName) throws XMLStreamException {
        reader.nextTag();
        reader.require(2, namespace, localName);
        reader.nextTag();
    }

    public static void closeQuietly(XMLStreamReader reader) {
        block3: {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Throwable t) {
                if (!LOGGER.isDebugEnabled()) break block3;
                LOGGER.debug("Ignoring exception that occurred when closing XMLStreamReader", t);
            }
        }
    }

    public static void copyStartElement(XMLStreamReader reader, XMLStreamWriter writer) throws XMLStreamException {
        String prefix = reader.getPrefix();
        String localName = reader.getLocalName();
        String uri = reader.getNamespaceURI();
        if (prefix != null) {
            writer.writeStartElement(prefix, localName, uri);
        } else if (uri != null) {
            writer.writeStartElement(uri, localName);
        } else {
            writer.writeStartElement(localName);
        }
        int length = reader.getAttributeCount();
        for (int i = 0; i < length; ++i) {
            prefix = reader.getAttributePrefix(i);
            localName = reader.getAttributeLocalName(i);
            uri = reader.getAttributeNamespace(i);
            String value = reader.getAttributeValue(i);
            if (prefix != null) {
                writer.writeAttribute(prefix, uri, localName, value);
                continue;
            }
            if (uri != null) {
                writer.writeAttribute(uri, localName, value);
                continue;
            }
            writer.writeAttribute(localName, value);
        }
    }

    public static void copyText(XMLStreamReader reader, XMLStreamWriter writer, StringBuilder textBuilder, int flags) throws XMLStreamException {
        int eventType = reader.getEventType();
        while (true) {
            switch (eventType) {
                case 5: {
                    if (writer == null || (flags & 4) == 0) break;
                    writer.writeComment(reader.getText());
                    break;
                }
                case 12: {
                    if (writer != null) {
                        writer.writeCData(reader.getText());
                    }
                    if (textBuilder == null) break;
                    textBuilder.append(reader.getText());
                    break;
                }
                case 6: {
                    if ((flags & 8) == 0) break;
                    if (writer != null) {
                        writer.writeCharacters(reader.getText());
                    }
                    if (textBuilder == null) break;
                    textBuilder.append(reader.getText());
                    break;
                }
                case 4: {
                    if (writer != null) {
                        writer.writeCharacters(reader.getText());
                    }
                    if (textBuilder == null) break;
                    textBuilder.append(reader.getText());
                    break;
                }
                default: {
                    return;
                }
            }
            eventType = reader.next();
        }
    }

    public static void copyXMLStream(byte[] buf, int offset, int size, XMLStreamWriter writer, int copyFlags) throws XMLStreamException {
        XmlStreamReaderUtils.copyXMLStream(new ByteArrayInputStream(buf, offset, size), writer, copyFlags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyXMLStream(InputStream is, XMLStreamWriter writer, int flags) throws XMLStreamException {
        XMLInputFactory f = XMLInputFactory.newInstance();
        XMLStreamReader xmlReader = f.createXMLStreamReader(is, Charsets.UTF_8.name());
        try {
            XmlStreamReaderUtils.copyXMLStream(xmlReader, writer, flags);
        }
        finally {
            XmlStreamReaderUtils.closeQuietly(xmlReader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyXMLStream(Reader reader, XMLStreamWriter writer, int flags) throws XMLStreamException {
        XMLInputFactory f = XMLInputFactory.newInstance();
        XMLStreamReader xmlReader = f.createXMLStreamReader(reader);
        try {
            XmlStreamReaderUtils.copyXMLStream(xmlReader, writer, flags);
        }
        finally {
            XmlStreamReaderUtils.closeQuietly(xmlReader);
        }
    }

    public static void copyXMLStream(XMLStreamReader reader, XMLStreamWriter writer, int flags) throws XMLStreamException {
        int depth = 0;
        int eventType = reader.getEventType();
        while (true) {
            switch (eventType) {
                case 10: 
                case 11: 
                case 13: 
                case 14: 
                case 15: {
                    break;
                }
                case 7: {
                    if (writer == null || (flags & 1) == 0) break;
                    writer.writeStartDocument();
                    break;
                }
                case 8: {
                    if (writer != null && (flags & 2) != 0) {
                        writer.writeEndDocument();
                    }
                    return;
                }
                case 1: {
                    ++depth;
                    if (writer == null) break;
                    XmlStreamReaderUtils.copyStartElement(reader, writer);
                    break;
                }
                case 2: {
                    if (writer != null) {
                        writer.writeEndElement();
                    }
                    if (--depth > 0 || (flags & 0x10) == 0) break;
                    return;
                }
                case 3: {
                    if (writer == null) break;
                    writer.writeProcessingInstruction(reader.getPITarget(), reader.getPIData());
                    break;
                }
                case 4: {
                    if (writer == null) break;
                    writer.writeCharacters(reader.getText());
                    break;
                }
                case 5: {
                    if (writer == null || (flags & 4) == 0) break;
                    writer.writeComment(reader.getText());
                    break;
                }
                case 6: {
                    if (writer == null || (flags & 8) == 0) break;
                    writer.writeCharacters(reader.getText());
                    break;
                }
                case 9: {
                    if (writer == null) break;
                    writer.writeEntityRef(reader.getText());
                    break;
                }
                case 12: {
                    if (writer == null) break;
                    writer.writeCData(reader.getText());
                }
            }
            eventType = reader.next();
        }
    }

    public static void copyXMLStream(XMLStreamReader reader, XMLStreamWriter writer, StringBuilder textBuilder, int flags, boolean indentParentElementText, String parentElement) throws XMLStreamException {
        int depth = 0;
        int eventType = reader.getEventType();
        while (true) {
            switch (eventType) {
                case 10: 
                case 11: 
                case 13: 
                case 14: 
                case 15: {
                    break;
                }
                case 7: {
                    if (writer == null || (flags & 1) == 0) break;
                    writer.writeStartDocument();
                    break;
                }
                case 8: {
                    if (writer != null && (flags & 2) != 0) {
                        writer.writeEndDocument();
                    }
                    return;
                }
                case 1: {
                    ++depth;
                    if (writer != null) {
                        XmlStreamReaderUtils.copyStartElement(reader, writer);
                    }
                    if (textBuilder == null) break;
                    String name = reader.getLocalName();
                    if (name.equals("document")) {
                        textBuilder.append("   ");
                    }
                    textBuilder.append('<').append(name).append('>');
                    break;
                }
                case 2: {
                    String name;
                    if (writer != null) {
                        writer.writeEndElement();
                    }
                    if (textBuilder != null) {
                        name = reader.getLocalName();
                        if (name.equals("document")) {
                            textBuilder.append("   ");
                        }
                        textBuilder.append("</").append(name).append('>');
                    }
                    if (--depth > 0 || (flags & 0x10) == 0) break;
                    return;
                }
                case 3: {
                    if (writer != null) {
                        writer.writeProcessingInstruction(reader.getPITarget(), reader.getPIData());
                    }
                    if (textBuilder == null) break;
                    textBuilder.append(reader.getText());
                    break;
                }
                case 4: {
                    String text = reader.getText();
                    if (writer != null) {
                        writer.writeCharacters(text);
                    }
                    if (textBuilder == null) break;
                    textBuilder.append(text);
                    break;
                }
                case 5: {
                    String text = reader.getText();
                    if (writer != null && (flags & 4) != 0) {
                        writer.writeComment(text);
                    }
                    if (textBuilder == null || (flags & 4) == 0) break;
                    textBuilder.append(text);
                    break;
                }
                case 6: {
                    String text = reader.getText();
                    if (writer != null && (flags & 8) != 0) {
                        writer.writeCharacters(text);
                    }
                    if (textBuilder == null || (flags & 8) == 0) break;
                    textBuilder.append(text);
                    break;
                }
                case 9: {
                    String text = reader.getText();
                    if (writer != null) {
                        writer.writeEntityRef(text);
                    }
                    if (textBuilder == null) break;
                    textBuilder.append(text);
                    break;
                }
                case 12: {
                    String text = reader.getText();
                    if (writer != null) {
                        writer.writeCData(text);
                    }
                    if (textBuilder == null) break;
                    textBuilder.append(text);
                }
            }
            eventType = reader.next();
        }
    }

    public static XMLStreamException createXMLStreamException(String message, XMLStreamReader reader, Throwable cause) {
        XMLStreamException exception = new XMLStreamException(message, reader.getLocation(), null);
        exception.initCause(cause);
        return exception;
    }

    public static XMLStreamException createXMLStreamException(Throwable cause) {
        XMLStreamException exception = new XMLStreamException();
        exception.initCause(cause);
        return exception;
    }

    public static String getEventTypeDescription(XMLStreamReader reader) {
        int eventType = reader.getEventType();
        if (eventType == 1) {
            String namespace = reader.getNamespaceURI();
            return "<" + reader.getLocalName() + (String)(!StringUtils.isEmpty((CharSequence)namespace) ? "@" + namespace : "") + ">";
        }
        if (eventType == 2) {
            String namespace = reader.getNamespaceURI();
            return "</" + reader.getLocalName() + (String)(!StringUtils.isEmpty((CharSequence)namespace) ? "@" + namespace : "") + ">";
        }
        return NAMES_OF_EVENTS[reader.getEventType()];
    }

    public static boolean isStartElement(XMLStreamReader reader, String namespace, String localName) {
        return reader.getEventType() == 1 && XmlStreamReaderUtils.nameEquals(reader, namespace, localName);
    }

    public static boolean nameEquals(XMLStreamReader reader, String namespace, String localName) {
        if (!reader.getLocalName().equals(localName)) {
            return false;
        }
        if (namespace == null) {
            return true;
        }
        String namespaceURI = reader.getNamespaceURI();
        if (namespaceURI == null) {
            return StringUtils.isEmpty((CharSequence)namespace);
        }
        return namespaceURI.equals(StringUtils.defaultString((String)namespace));
    }

    public static boolean optionalBooleanAttribute(XMLStreamReader reader, String localName, boolean defaultValue) {
        return XmlStreamReaderUtils.optionalBooleanAttribute(reader, null, localName, defaultValue);
    }

    public static boolean optionalBooleanAttribute(XMLStreamReader reader, String namespace, String localName, boolean defaultValue) {
        String value = reader.getAttributeValue(namespace, localName);
        if (value != null) {
            return BooleanUtils.toBoolean((String)value);
        }
        return defaultValue;
    }

    public static byte optionalByteAttribute(XMLStreamReader reader, String localName, byte defaultValue) {
        return XmlStreamReaderUtils.optionalByteAttribute(reader, null, localName, defaultValue);
    }

    public static byte optionalByteAttribute(XMLStreamReader reader, String namespace, String localName, byte defaultValue) {
        String value = reader.getAttributeValue(namespace, localName);
        if (value != null) {
            return Byte.parseByte(value);
        }
        return defaultValue;
    }

    public static Class optionalClassAttribute(XMLStreamReader reader, String localName, Class defaultValue) throws XMLStreamException {
        return XmlStreamReaderUtils.optionalClassAttribute(reader, null, localName, defaultValue);
    }

    public static Class optionalClassAttribute(XMLStreamReader reader, String namespace, String localName, Class defaultValue) throws XMLStreamException {
        String value = reader.getAttributeValue(namespace, localName);
        if (value != null) {
            try {
                return Class.forName(value.toString());
            }
            catch (ClassNotFoundException e) {
                throw XmlStreamReaderUtils.createXMLStreamException(MessageFormat.format("\"{0}\" is not a valid class name.", value), reader, e);
            }
        }
        return defaultValue;
    }

    public static double optionalDoubleAttribute(XMLStreamReader reader, String localName, double defaultValue) {
        return XmlStreamReaderUtils.optionalDoubleAttribute(reader, null, localName, defaultValue);
    }

    public static double optionalDoubleAttribute(XMLStreamReader reader, String namespace, String localName, double defaultValue) {
        String value = reader.getAttributeValue(namespace, localName);
        if (value != null) {
            return Double.parseDouble(value);
        }
        return defaultValue;
    }

    public static float optionalFloatAttribute(XMLStreamReader reader, String localName, float defaultValue) {
        return XmlStreamReaderUtils.optionalFloatAttribute(reader, null, localName, defaultValue);
    }

    public static float optionalFloatAttribute(XMLStreamReader reader, String namespace, String localName, float defaultValue) {
        String value = reader.getAttributeValue(namespace, localName);
        if (value != null) {
            return Float.parseFloat(value);
        }
        return defaultValue;
    }

    public static int optionalIntAttribute(XMLStreamReader reader, String localName, int defaultValue) {
        return XmlStreamReaderUtils.optionalIntAttribute(reader, null, localName, defaultValue);
    }

    public static int optionalIntAttribute(XMLStreamReader reader, String namespace, String localName, int defaultValue) {
        String value = reader.getAttributeValue(namespace, localName);
        if (value != null) {
            return Integer.parseInt(value);
        }
        return defaultValue;
    }

    public static long optionalLongAttribute(XMLStreamReader reader, String localName, long defaultValue) {
        return XmlStreamReaderUtils.optionalLongAttribute(reader, null, localName, defaultValue);
    }

    public static long optionalLongAttribute(XMLStreamReader reader, String namespace, String localName, long defaultValue) {
        String value = reader.getAttributeValue(namespace, localName);
        if (value != null) {
            return Long.parseLong(value);
        }
        return defaultValue;
    }

    public static short optionalShortAttribute(XMLStreamReader reader, String localName, short defaultValue) {
        return XmlStreamReaderUtils.optionalShortAttribute(reader, null, localName, defaultValue);
    }

    public static short optionalShortAttribute(XMLStreamReader reader, String namespace, String localName, short defaultValue) {
        String value = reader.getAttributeValue(namespace, localName);
        if (value != null) {
            return Short.parseShort(value);
        }
        return defaultValue;
    }

    public static String optionalStringAttribute(XMLStreamReader reader, String localName, String defaultValue) {
        return XmlStreamReaderUtils.optionalStringAttribute(reader, null, localName, defaultValue);
    }

    public static String optionalStringAttribute(XMLStreamReader reader, String namespace, String localName, String defaultValue) {
        String value = reader.getAttributeValue(namespace, localName);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    public static void readKeyValuePairs(XMLStreamReader reader, Map<String, String> map) throws XMLStreamException {
        StringBuilder buf = new StringBuilder();
        while (reader.isStartElement()) {
            String key = reader.getLocalName().toString();
            reader.next();
            buf.setLength(0);
            XmlStreamReaderUtils.copyText(reader, null, buf, 0);
            String value = buf.toString();
            map.put(key, value);
            reader.require(2, null, key);
            reader.nextTag();
        }
    }

    public static boolean requiredBooleanAttribute(XMLStreamReader reader, String localName) throws XMLStreamException {
        return XmlStreamReaderUtils.requiredBooleanAttribute(reader, null, localName);
    }

    public static boolean requiredBooleanAttribute(XMLStreamReader reader, String namespace, String localName) throws XMLStreamException {
        String value = reader.getAttributeValue(namespace, localName);
        if (value != null) {
            return BooleanUtils.toBoolean((String)value);
        }
        throw new XMLStreamException(MessageFormat.format("Attribute {0}:{1} is required", namespace, localName));
    }

    public static byte requiredByteAttribute(XMLStreamReader reader, String localName) throws XMLStreamException {
        return XmlStreamReaderUtils.requiredByteAttribute(reader, null, localName);
    }

    public static byte requiredByteAttribute(XMLStreamReader reader, String namespace, String localName) throws XMLStreamException {
        String value = reader.getAttributeValue(namespace, localName);
        if (value != null) {
            return Byte.parseByte(value);
        }
        throw new XMLStreamException(MessageFormat.format("Attribute {0}:{1} is required", namespace, localName));
    }

    public static Class requiredClassAttribute(XMLStreamReader reader, String localName) throws XMLStreamException {
        return XmlStreamReaderUtils.requiredClassAttribute(reader, null, localName);
    }

    public static Class requiredClassAttribute(XMLStreamReader reader, String namespace, String localName) throws XMLStreamException {
        String value = reader.getAttributeValue(namespace, localName);
        if (value != null) {
            try {
                return Class.forName(value.toString());
            }
            catch (ClassNotFoundException e) {
                throw XmlStreamReaderUtils.createXMLStreamException(MessageFormat.format("\"{0}\" is not a valid class name.", value), reader, e);
            }
        }
        throw new XMLStreamException(MessageFormat.format("Attribute {0}:{1} is required", namespace, localName));
    }

    public static double requiredDoubleAttribute(XMLStreamReader reader, String localName) throws XMLStreamException {
        return XmlStreamReaderUtils.requiredDoubleAttribute(reader, null, localName);
    }

    public static double requiredDoubleAttribute(XMLStreamReader reader, String namespace, String localName) throws XMLStreamException {
        String value = reader.getAttributeValue(namespace, localName);
        if (value != null) {
            return Double.parseDouble(value);
        }
        throw new XMLStreamException(MessageFormat.format("Attribute {0}:{1} is required", namespace, localName));
    }

    public static float requiredFloatAttribute(XMLStreamReader reader, String localName) throws XMLStreamException {
        return XmlStreamReaderUtils.requiredFloatAttribute(reader, null, localName);
    }

    public static float requiredFloatAttribute(XMLStreamReader reader, String namespace, String localName) throws XMLStreamException {
        String value = reader.getAttributeValue(namespace, localName);
        if (value != null) {
            return Float.parseFloat(value);
        }
        throw new XMLStreamException(MessageFormat.format("Attribute {0}:{1} is required", namespace, localName));
    }

    public static int requiredIntAttribute(XMLStreamReader reader, String localName) throws XMLStreamException {
        return XmlStreamReaderUtils.requiredIntAttribute(reader, null, localName);
    }

    public static int requiredIntAttribute(XMLStreamReader reader, String namespace, String localName) throws XMLStreamException {
        String value = reader.getAttributeValue(namespace, localName);
        if (value != null) {
            return Integer.parseInt(value);
        }
        throw new XMLStreamException(MessageFormat.format("Attribute {0}:{1} is required", namespace, localName));
    }

    public static long requiredLongAttribute(XMLStreamReader reader, String localName) throws XMLStreamException {
        return XmlStreamReaderUtils.requiredLongAttribute(reader, null, localName);
    }

    public static long requiredLongAttribute(XMLStreamReader reader, String namespace, String localName) throws XMLStreamException {
        String value = reader.getAttributeValue(namespace, localName);
        if (value != null) {
            return Long.parseLong(value);
        }
        throw new XMLStreamException(MessageFormat.format("Attribute {0}:{1} is required", namespace, localName));
    }

    public static short requiredShortAttribute(XMLStreamReader reader, String localName) throws XMLStreamException {
        return XmlStreamReaderUtils.requiredShortAttribute(reader, null, localName);
    }

    public static short requiredShortAttribute(XMLStreamReader reader, String namespace, String localName) throws XMLStreamException {
        String value = reader.getAttributeValue(namespace, localName);
        if (value != null) {
            return Short.parseShort(value);
        }
        throw new XMLStreamException(MessageFormat.format("Attribute {0}:{1} is required", namespace, localName));
    }

    public static String requiredStringAttribute(XMLStreamReader reader, String localName) throws XMLStreamException {
        return XmlStreamReaderUtils.requiredStringAttribute(reader, null, localName);
    }

    public static String requiredStringAttribute(XMLStreamReader reader, String namespace, String localName) throws XMLStreamException {
        String value = reader.getAttributeValue(namespace, localName);
        if (value != null) {
            return value.toString();
        }
        throw new XMLStreamException(MessageFormat.format("Attribute {0}:{1} is required", namespace, localName));
    }

    public static final void requireEndDocument(XMLStreamReader reader) throws XMLStreamException {
        XmlStreamReaderUtils.skipWhitespace(reader);
        reader.require(8, null, null);
    }

    public static void skipElement(XMLStreamReader reader) throws XMLStreamException, IOException {
        if (reader.getEventType() != 1) {
            return;
        }
        String namespace = reader.getNamespaceURI();
        String name = reader.getLocalName();
        while (true) {
            switch (reader.nextTag()) {
                case 1: {
                    XmlStreamReaderUtils.skipElement(reader);
                    break;
                }
                case 2: 
                case 8: {
                    reader.require(2, namespace, name);
                    reader.next();
                    return;
                }
            }
        }
    }

    public static void skipToMatchingEndElement(XMLStreamReader reader) throws XMLStreamException {
        if (reader.getEventType() != 1) {
            throw new XMLStreamException("Starting element expected.");
        }
        XmlStreamReaderUtils.copyXMLStream(reader, null, 16);
    }

    public static final void skipWhitespace(XMLStreamReader reader) throws XMLStreamException {
        int eventType = reader.getEventType();
        while (eventType == 4 && reader.isWhiteSpace() || eventType == 12 && reader.isWhiteSpace() || eventType == 6 || eventType == 3 || eventType == 5) {
            eventType = reader.next();
        }
    }

    public static final XMLStreamException wrapException(XMLStreamException e) {
        return new XMLStreamException(e);
    }

    private XmlStreamReaderUtils() {
    }
}

