/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb;

import com.arangodb.ArangoDBException;
import com.arangodb.ArangoDatabase;
import com.arangodb.ArangoMetrics;
import com.arangodb.ArangoSerdeAccessor;
import com.arangodb.Protocol;
import com.arangodb.Request;
import com.arangodb.Response;
import com.arangodb.entity.ArangoDBEngine;
import com.arangodb.entity.ArangoDBVersion;
import com.arangodb.entity.LogEntriesEntity;
import com.arangodb.entity.LogLevelEntity;
import com.arangodb.entity.Permissions;
import com.arangodb.entity.QueryOptimizerRule;
import com.arangodb.entity.ServerRole;
import com.arangodb.entity.UserEntity;
import com.arangodb.internal.ArangoDBImpl;
import com.arangodb.internal.InternalArangoDBBuilder;
import com.arangodb.internal.net.ConnectionFactory;
import com.arangodb.internal.net.Host;
import com.arangodb.internal.net.HostHandler;
import com.arangodb.internal.net.HostResolver;
import com.arangodb.internal.net.ProtocolProvider;
import com.arangodb.model.DBCreateOptions;
import com.arangodb.model.LogLevelOptions;
import com.arangodb.model.LogOptions;
import com.arangodb.model.UserCreateOptions;
import com.arangodb.model.UserUpdateOptions;
import java.util.Collection;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public interface ArangoDB
extends ArangoSerdeAccessor {
    public void shutdown();

    public void updateJwt(String var1);

    public ArangoDatabase db();

    public ArangoDatabase db(String var1);

    public ArangoMetrics metrics();

    public Boolean createDatabase(String var1);

    public Boolean createDatabase(DBCreateOptions var1);

    public Collection<String> getDatabases();

    public Collection<String> getAccessibleDatabases();

    public Collection<String> getAccessibleDatabasesFor(String var1);

    public ArangoDBVersion getVersion();

    public ArangoDBEngine getEngine();

    public ServerRole getRole();

    public String getServerId();

    public UserEntity createUser(String var1, String var2);

    public UserEntity createUser(String var1, String var2, UserCreateOptions var3);

    public void deleteUser(String var1);

    public UserEntity getUser(String var1);

    public Collection<UserEntity> getUsers();

    public UserEntity updateUser(String var1, UserUpdateOptions var2);

    public UserEntity replaceUser(String var1, UserUpdateOptions var2);

    public void grantDefaultDatabaseAccess(String var1, Permissions var2);

    public void grantDefaultCollectionAccess(String var1, Permissions var2);

    public <T> Response<T> execute(Request<?> var1, Class<T> var2);

    public LogEntriesEntity getLogEntries(LogOptions var1);

    public LogLevelEntity getLogLevel();

    public LogLevelEntity getLogLevel(LogLevelOptions var1);

    public LogLevelEntity setLogLevel(LogLevelEntity var1);

    public LogLevelEntity setLogLevel(LogLevelEntity var1, LogLevelOptions var2);

    public Collection<QueryOptimizerRule> getQueryOptimizerRules();

    public static class Builder
    extends InternalArangoDBBuilder<Builder> {
        public Builder protocol(Protocol protocol) {
            this.config.setProtocol(protocol);
            return this;
        }

        public ArangoDB build() {
            if (this.config.getHosts().isEmpty()) {
                throw new ArangoDBException("No host has been set!");
            }
            ProtocolProvider protocolProvider = this.protocolProvider(this.config.getProtocol());
            this.config.setProtocolModule(protocolProvider.protocolModule());
            ConnectionFactory connectionFactory = protocolProvider.createConnectionFactory();
            Collection<Host> hostList = this.createHostList(connectionFactory);
            HostResolver hostResolver = this.createHostResolver(hostList, connectionFactory);
            HostHandler hostHandler = this.createHostHandler(hostResolver);
            hostHandler.setJwt(this.config.getJwt());
            return new ArangoDBImpl(this.config, hostResolver, protocolProvider, hostHandler);
        }
    }
}

