/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.http;

import com.arangodb.ArangoDBException;
import com.arangodb.config.HostDescription;
import com.arangodb.http.HttpConnection;
import com.arangodb.internal.InternalRequest;
import com.arangodb.internal.InternalResponse;
import com.arangodb.internal.RequestType;
import com.arangodb.internal.config.ArangoConfig;
import com.arangodb.internal.net.AccessType;
import com.arangodb.internal.net.ArangoDBRedirectException;
import com.arangodb.internal.net.Host;
import com.arangodb.internal.net.HostHandle;
import com.arangodb.internal.net.HostHandler;
import com.arangodb.internal.serde.InternalSerde;
import com.arangodb.internal.util.HostUtils;
import com.arangodb.internal.util.RequestUtils;
import com.arangodb.internal.util.ResponseUtils;
import java.io.Closeable;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpCommunication
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpCommunication.class);
    private final HostHandler hostHandler;
    private final InternalSerde serde;
    private final AtomicLong reqCount;

    HttpCommunication(HostHandler hostHandler, ArangoConfig config) {
        this.hostHandler = hostHandler;
        this.serde = config.getInternalSerde();
        this.reqCount = new AtomicLong();
    }

    @Override
    public void close() throws IOException {
        this.hostHandler.close();
    }

    public InternalResponse execute(InternalRequest request, HostHandle hostHandle) {
        return this.execute(request, hostHandle, 0);
    }

    private InternalResponse execute(InternalRequest request, HostHandle hostHandle, int attemptCount) {
        AccessType accessType = RequestUtils.determineAccessType(request);
        Host host = this.hostHandler.get(hostHandle, accessType);
        try {
            while (true) {
                long reqId = this.reqCount.getAndIncrement();
                try {
                    HttpConnection connection = (HttpConnection)host.connection();
                    if (LOGGER.isDebugEnabled()) {
                        String body = request.getBody() == null ? "" : this.serde.toJsonString(request.getBody());
                        LOGGER.debug("Send Request [id={}]: {} {}", new Object[]{reqId, request, body});
                    }
                    InternalResponse response = connection.execute(request);
                    if (LOGGER.isDebugEnabled()) {
                        String body = response.getBody() == null ? "" : this.serde.toJsonString(response.getBody());
                        LOGGER.debug("Received Response [id={}]: {} {}", new Object[]{reqId, response, body});
                    }
                    ResponseUtils.checkError(this.serde, response);
                    this.hostHandler.success();
                    this.hostHandler.confirm();
                    return response;
                }
                catch (SocketTimeoutException e) {
                    TimeoutException te = new TimeoutException(e.getMessage());
                    te.initCause(e);
                    throw new ArangoDBException(te, reqId);
                }
                catch (IOException e) {
                    this.hostHandler.fail(e);
                    if (hostHandle != null && hostHandle.getHost() != null) {
                        hostHandle.setHost(null);
                    }
                    Host failedHost = host;
                    host = this.hostHandler.get(hostHandle, accessType);
                    if (host != null && this.isSafe(request)) {
                        LOGGER.warn("Could not connect to {} while executing request [id={}]", new Object[]{failedHost.getDescription(), reqId, e});
                        LOGGER.debug("Try connecting to {}", (Object)host.getDescription());
                        continue;
                    }
                    LOGGER.error(e.getMessage(), (Throwable)e);
                    throw new ArangoDBException(e, reqId);
                }
                break;
            }
        }
        catch (ArangoDBRedirectException e) {
            if (attemptCount < 3) {
                String location = e.getLocation();
                HostDescription redirectHost = HostUtils.createFromLocation(location);
                this.hostHandler.failIfNotMatch(redirectHost, e);
                return this.execute(request, new HostHandle().setHost(redirectHost), attemptCount + 1);
            }
            throw e;
        }
    }

    private boolean isSafe(InternalRequest request) {
        RequestType type = request.getRequestType();
        return type == RequestType.GET || type == RequestType.HEAD || type == RequestType.OPTIONS;
    }
}

