/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal;

import com.arangodb.ArangoCollection;
import com.arangodb.ArangoDBException;
import com.arangodb.entity.CollectionEntity;
import com.arangodb.entity.CollectionPropertiesEntity;
import com.arangodb.entity.CollectionRevisionEntity;
import com.arangodb.entity.DocumentCreateEntity;
import com.arangodb.entity.DocumentDeleteEntity;
import com.arangodb.entity.DocumentImportEntity;
import com.arangodb.entity.DocumentUpdateEntity;
import com.arangodb.entity.IndexEntity;
import com.arangodb.entity.InvertedIndexEntity;
import com.arangodb.entity.MultiDocumentEntity;
import com.arangodb.entity.Permissions;
import com.arangodb.entity.ShardEntity;
import com.arangodb.internal.ArangoDBImpl;
import com.arangodb.internal.ArangoDatabaseImpl;
import com.arangodb.internal.ArangoErrors;
import com.arangodb.internal.ArangoExecutorSync;
import com.arangodb.internal.InternalArangoCollection;
import com.arangodb.internal.serde.SerdeUtils;
import com.arangodb.internal.util.DocumentUtil;
import com.arangodb.model.CollectionCountOptions;
import com.arangodb.model.CollectionCreateOptions;
import com.arangodb.model.CollectionPropertiesOptions;
import com.arangodb.model.CollectionTruncateOptions;
import com.arangodb.model.DocumentCreateOptions;
import com.arangodb.model.DocumentDeleteOptions;
import com.arangodb.model.DocumentExistsOptions;
import com.arangodb.model.DocumentImportOptions;
import com.arangodb.model.DocumentReadOptions;
import com.arangodb.model.DocumentReplaceOptions;
import com.arangodb.model.DocumentUpdateOptions;
import com.arangodb.model.FulltextIndexOptions;
import com.arangodb.model.GeoIndexOptions;
import com.arangodb.model.InvertedIndexOptions;
import com.arangodb.model.PersistentIndexOptions;
import com.arangodb.model.TtlIndexOptions;
import com.arangodb.model.ZKDIndexOptions;
import com.arangodb.util.RawData;
import java.lang.reflect.Type;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArangoCollectionImpl
extends InternalArangoCollection<ArangoDBImpl, ArangoDatabaseImpl, ArangoExecutorSync>
implements ArangoCollection {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArangoCollectionImpl.class);

    protected ArangoCollectionImpl(ArangoDatabaseImpl db, String name) {
        super(db, name);
    }

    @Override
    public DocumentCreateEntity<Void> insertDocument(Object value) {
        return (DocumentCreateEntity)((ArangoExecutorSync)this.executor).execute(this.insertDocumentRequest(value, new DocumentCreateOptions()), SerdeUtils.constructParametricType(DocumentCreateEntity.class, new Type[]{Void.class}));
    }

    @Override
    public <T> DocumentCreateEntity<T> insertDocument(T value, DocumentCreateOptions options) {
        return this.insertDocument(value, options, value.getClass());
    }

    @Override
    public <T> DocumentCreateEntity<T> insertDocument(T value, DocumentCreateOptions options, Class<T> type) {
        return (DocumentCreateEntity)((ArangoExecutorSync)this.executor).execute(this.insertDocumentRequest(value, options), SerdeUtils.constructParametricType(DocumentCreateEntity.class, type));
    }

    @Override
    public MultiDocumentEntity<DocumentCreateEntity<Void>> insertDocuments(RawData values) {
        return ((ArangoExecutorSync)this.executor).execute(this.insertDocumentsRequest(values, new DocumentCreateOptions()), this.insertDocumentsResponseDeserializer(Void.class));
    }

    @Override
    public MultiDocumentEntity<DocumentCreateEntity<RawData>> insertDocuments(RawData values, DocumentCreateOptions options) {
        return ((ArangoExecutorSync)this.executor).execute(this.insertDocumentsRequest(values, options), this.insertDocumentsResponseDeserializer(values.getClass()));
    }

    @Override
    public MultiDocumentEntity<DocumentCreateEntity<Void>> insertDocuments(Collection<?> values) {
        return this.insertDocuments(values, new DocumentCreateOptions());
    }

    @Override
    public MultiDocumentEntity<DocumentCreateEntity<Void>> insertDocuments(Collection<?> values, DocumentCreateOptions options) {
        return ((ArangoExecutorSync)this.executor).execute(this.insertDocumentsRequest(values, options), this.insertDocumentsResponseDeserializer(Void.class));
    }

    @Override
    public <T> MultiDocumentEntity<DocumentCreateEntity<T>> insertDocuments(Collection<? extends T> values, DocumentCreateOptions options, Class<T> type) {
        return ((ArangoExecutorSync)this.executor).execute(this.insertDocumentsRequest(values, options), this.insertDocumentsResponseDeserializer(type));
    }

    @Override
    public DocumentImportEntity importDocuments(Collection<?> values) {
        return this.importDocuments(values, new DocumentImportOptions());
    }

    @Override
    public DocumentImportEntity importDocuments(Collection<?> values, DocumentImportOptions options) {
        return (DocumentImportEntity)((ArangoExecutorSync)this.executor).execute(this.importDocumentsRequest(values, options), (Type)((Object)DocumentImportEntity.class));
    }

    @Override
    public DocumentImportEntity importDocuments(RawData values) {
        return this.importDocuments(values, new DocumentImportOptions());
    }

    @Override
    public DocumentImportEntity importDocuments(RawData values, DocumentImportOptions options) {
        return (DocumentImportEntity)((ArangoExecutorSync)this.executor).execute(this.importDocumentsRequest(values, options), (Type)((Object)DocumentImportEntity.class));
    }

    @Override
    public <T> T getDocument(String key, Class<T> type) {
        return this.getDocument(key, type, new DocumentReadOptions());
    }

    @Override
    public <T> T getDocument(String key, Class<T> type, DocumentReadOptions options) {
        DocumentUtil.validateDocumentKey(key);
        try {
            return ((ArangoExecutorSync)this.executor).execute(this.getDocumentRequest(key, options), this.getDocumentResponseDeserializer(type));
        }
        catch (ArangoDBException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(e.getMessage(), (Throwable)e);
            }
            if (e.getErrorNum() != null && e.getErrorNum() == 1655) {
                throw e;
            }
            if (e.getResponseCode() != null && (e.getResponseCode() == 404 || e.getResponseCode() == 304 || e.getResponseCode() == 412)) {
                return null;
            }
            throw e;
        }
    }

    @Override
    public <T> MultiDocumentEntity<T> getDocuments(Collection<String> keys, Class<T> type) {
        return this.getDocuments(keys, type, new DocumentReadOptions());
    }

    @Override
    public <T> MultiDocumentEntity<T> getDocuments(Collection<String> keys, Class<T> type, DocumentReadOptions options) {
        return ((ArangoExecutorSync)this.executor).execute(this.getDocumentsRequest(keys, options), this.getDocumentsResponseDeserializer(type));
    }

    @Override
    public DocumentUpdateEntity<Void> replaceDocument(String key, Object value) {
        return (DocumentUpdateEntity)((ArangoExecutorSync)this.executor).execute(this.replaceDocumentRequest(key, value, new DocumentReplaceOptions()), SerdeUtils.constructParametricType(DocumentUpdateEntity.class, new Type[]{Void.class}));
    }

    @Override
    public <T> DocumentUpdateEntity<T> replaceDocument(String key, T value, DocumentReplaceOptions options) {
        return this.replaceDocument(key, value, options, value.getClass());
    }

    @Override
    public <T> DocumentUpdateEntity<T> replaceDocument(String key, T value, DocumentReplaceOptions options, Class<T> type) {
        return (DocumentUpdateEntity)((ArangoExecutorSync)this.executor).execute(this.replaceDocumentRequest(key, value, options), SerdeUtils.constructParametricType(DocumentUpdateEntity.class, type));
    }

    @Override
    public MultiDocumentEntity<DocumentUpdateEntity<Void>> replaceDocuments(RawData values) {
        return ((ArangoExecutorSync)this.executor).execute(this.replaceDocumentsRequest(values, new DocumentReplaceOptions()), this.replaceDocumentsResponseDeserializer(Void.class));
    }

    @Override
    public MultiDocumentEntity<DocumentUpdateEntity<RawData>> replaceDocuments(RawData values, DocumentReplaceOptions options) {
        return ((ArangoExecutorSync)this.executor).execute(this.replaceDocumentsRequest(values, options), this.replaceDocumentsResponseDeserializer(values.getClass()));
    }

    @Override
    public MultiDocumentEntity<DocumentUpdateEntity<Void>> replaceDocuments(Collection<?> values) {
        return this.replaceDocuments(values, new DocumentReplaceOptions());
    }

    @Override
    public MultiDocumentEntity<DocumentUpdateEntity<Void>> replaceDocuments(Collection<?> values, DocumentReplaceOptions options) {
        return ((ArangoExecutorSync)this.executor).execute(this.replaceDocumentsRequest(values, options), this.replaceDocumentsResponseDeserializer(Void.class));
    }

    @Override
    public <T> MultiDocumentEntity<DocumentUpdateEntity<T>> replaceDocuments(Collection<? extends T> values, DocumentReplaceOptions options, Class<T> type) {
        return ((ArangoExecutorSync)this.executor).execute(this.replaceDocumentsRequest(values, options), this.replaceDocumentsResponseDeserializer(type));
    }

    @Override
    public DocumentUpdateEntity<Void> updateDocument(String key, Object value) {
        return this.updateDocument(key, value, new DocumentUpdateOptions(), Void.class);
    }

    @Override
    public <T> DocumentUpdateEntity<T> updateDocument(String key, T value, DocumentUpdateOptions options) {
        return this.updateDocument(key, value, options, value.getClass());
    }

    @Override
    public <T> DocumentUpdateEntity<T> updateDocument(String key, Object value, DocumentUpdateOptions options, Class<T> returnType) {
        return (DocumentUpdateEntity)((ArangoExecutorSync)this.executor).execute(this.updateDocumentRequest(key, value, options), SerdeUtils.constructParametricType(DocumentUpdateEntity.class, returnType));
    }

    @Override
    public MultiDocumentEntity<DocumentUpdateEntity<Void>> updateDocuments(RawData values) {
        return ((ArangoExecutorSync)this.executor).execute(this.updateDocumentsRequest(values, new DocumentUpdateOptions()), this.updateDocumentsResponseDeserializer(Void.class));
    }

    @Override
    public MultiDocumentEntity<DocumentUpdateEntity<RawData>> updateDocuments(RawData values, DocumentUpdateOptions options) {
        return ((ArangoExecutorSync)this.executor).execute(this.updateDocumentsRequest(values, options), this.updateDocumentsResponseDeserializer(values.getClass()));
    }

    @Override
    public MultiDocumentEntity<DocumentUpdateEntity<Void>> updateDocuments(Collection<?> values) {
        return this.updateDocuments(values, new DocumentUpdateOptions());
    }

    @Override
    public MultiDocumentEntity<DocumentUpdateEntity<Void>> updateDocuments(Collection<?> values, DocumentUpdateOptions options) {
        return this.updateDocuments(values, options, Void.class);
    }

    @Override
    public <T> MultiDocumentEntity<DocumentUpdateEntity<T>> updateDocuments(Collection<?> values, DocumentUpdateOptions options, Class<T> returnType) {
        return ((ArangoExecutorSync)this.executor).execute(this.updateDocumentsRequest(values, options), this.updateDocumentsResponseDeserializer(returnType));
    }

    @Override
    public DocumentDeleteEntity<Void> deleteDocument(String key) {
        return this.deleteDocument(key, new DocumentDeleteOptions());
    }

    @Override
    public DocumentDeleteEntity<Void> deleteDocument(String key, DocumentDeleteOptions options) {
        return this.deleteDocument(key, options, Void.class);
    }

    @Override
    public <T> DocumentDeleteEntity<T> deleteDocument(String key, DocumentDeleteOptions options, Class<T> type) {
        return (DocumentDeleteEntity)((ArangoExecutorSync)this.executor).execute(this.deleteDocumentRequest(key, options), SerdeUtils.constructParametricType(DocumentDeleteEntity.class, type));
    }

    @Override
    public MultiDocumentEntity<DocumentDeleteEntity<Void>> deleteDocuments(RawData values) {
        return ((ArangoExecutorSync)this.executor).execute(this.deleteDocumentsRequest(values, new DocumentDeleteOptions()), this.deleteDocumentsResponseDeserializer(Void.class));
    }

    @Override
    public MultiDocumentEntity<DocumentDeleteEntity<RawData>> deleteDocuments(RawData values, DocumentDeleteOptions options) {
        return ((ArangoExecutorSync)this.executor).execute(this.deleteDocumentsRequest(values, options), this.deleteDocumentsResponseDeserializer(values.getClass()));
    }

    @Override
    public MultiDocumentEntity<DocumentDeleteEntity<Void>> deleteDocuments(Collection<?> values) {
        return this.deleteDocuments(values, new DocumentDeleteOptions());
    }

    @Override
    public MultiDocumentEntity<DocumentDeleteEntity<Void>> deleteDocuments(Collection<?> values, DocumentDeleteOptions options) {
        return this.deleteDocuments(values, options, Void.class);
    }

    @Override
    public <T> MultiDocumentEntity<DocumentDeleteEntity<T>> deleteDocuments(Collection<?> values, DocumentDeleteOptions options, Class<T> type) {
        return ((ArangoExecutorSync)this.executor).execute(this.deleteDocumentsRequest(values, options), this.deleteDocumentsResponseDeserializer(type));
    }

    @Override
    public Boolean documentExists(String key) {
        return this.documentExists(key, new DocumentExistsOptions());
    }

    @Override
    public Boolean documentExists(String key, DocumentExistsOptions options) {
        try {
            ((ArangoExecutorSync)this.executor).execute(this.documentExistsRequest(key, options), (Type)((Object)Void.class));
            return true;
        }
        catch (ArangoDBException e) {
            if (e.getErrorNum() != null && e.getErrorNum() == 1655) {
                throw e;
            }
            if (e.getResponseCode() != null && (e.getResponseCode() == 404 || e.getResponseCode() == 304 || e.getResponseCode() == 412)) {
                return false;
            }
            throw e;
        }
    }

    @Override
    public IndexEntity getIndex(String id) {
        return (IndexEntity)((ArangoExecutorSync)this.executor).execute(this.getIndexRequest(id), (Type)((Object)IndexEntity.class));
    }

    @Override
    public InvertedIndexEntity getInvertedIndex(String id) {
        return (InvertedIndexEntity)((ArangoExecutorSync)this.executor).execute(this.getIndexRequest(id), (Type)((Object)InvertedIndexEntity.class));
    }

    @Override
    public String deleteIndex(String id) {
        return ((ArangoExecutorSync)this.executor).execute(this.deleteIndexRequest(id), this.deleteIndexResponseDeserializer());
    }

    @Override
    public IndexEntity ensurePersistentIndex(Iterable<String> fields, PersistentIndexOptions options) {
        return (IndexEntity)((ArangoExecutorSync)this.executor).execute(this.createPersistentIndexRequest(fields, options), (Type)((Object)IndexEntity.class));
    }

    @Override
    public InvertedIndexEntity ensureInvertedIndex(InvertedIndexOptions options) {
        return (InvertedIndexEntity)((ArangoExecutorSync)this.executor).execute(this.createInvertedIndexRequest(options), (Type)((Object)InvertedIndexEntity.class));
    }

    @Override
    public IndexEntity ensureGeoIndex(Iterable<String> fields, GeoIndexOptions options) {
        return (IndexEntity)((ArangoExecutorSync)this.executor).execute(this.createGeoIndexRequest(fields, options), (Type)((Object)IndexEntity.class));
    }

    @Override
    @Deprecated
    public IndexEntity ensureFulltextIndex(Iterable<String> fields, FulltextIndexOptions options) {
        return (IndexEntity)((ArangoExecutorSync)this.executor).execute(this.createFulltextIndexRequest(fields, options), (Type)((Object)IndexEntity.class));
    }

    @Override
    public IndexEntity ensureTtlIndex(Iterable<String> fields, TtlIndexOptions options) {
        return (IndexEntity)((ArangoExecutorSync)this.executor).execute(this.createTtlIndexRequest(fields, options), (Type)((Object)IndexEntity.class));
    }

    @Override
    public IndexEntity ensureZKDIndex(Iterable<String> fields, ZKDIndexOptions options) {
        return (IndexEntity)((ArangoExecutorSync)this.executor).execute(this.createZKDIndexRequest(fields, options), (Type)((Object)IndexEntity.class));
    }

    @Override
    public Collection<IndexEntity> getIndexes() {
        return ((ArangoExecutorSync)this.executor).execute(this.getIndexesRequest(), this.getIndexesResponseDeserializer());
    }

    @Override
    public Collection<InvertedIndexEntity> getInvertedIndexes() {
        return ((ArangoExecutorSync)this.executor).execute(this.getIndexesRequest(), this.getInvertedIndexesResponseDeserializer());
    }

    @Override
    public boolean exists() {
        try {
            this.getInfo();
            return true;
        }
        catch (ArangoDBException e) {
            if (ArangoErrors.ERROR_ARANGO_DATA_SOURCE_NOT_FOUND.equals(e.getErrorNum())) {
                return false;
            }
            throw e;
        }
    }

    @Override
    public CollectionEntity truncate() {
        return this.truncate(null);
    }

    @Override
    public CollectionEntity truncate(CollectionTruncateOptions options) {
        return (CollectionEntity)((ArangoExecutorSync)this.executor).execute(this.truncateRequest(options), (Type)((Object)CollectionEntity.class));
    }

    @Override
    public CollectionPropertiesEntity count() {
        return this.count(null);
    }

    @Override
    public CollectionPropertiesEntity count(CollectionCountOptions options) {
        return (CollectionPropertiesEntity)((ArangoExecutorSync)this.executor).execute(this.countRequest(options), (Type)((Object)CollectionPropertiesEntity.class));
    }

    @Override
    public CollectionEntity create() {
        return ((ArangoDatabaseImpl)this.db()).createCollection(this.name());
    }

    @Override
    public CollectionEntity create(CollectionCreateOptions options) {
        return ((ArangoDatabaseImpl)this.db()).createCollection(this.name(), options);
    }

    @Override
    public void drop() {
        ((ArangoExecutorSync)this.executor).execute(this.dropRequest(null), (Type)((Object)Void.class));
    }

    @Override
    public void drop(boolean isSystem) {
        ((ArangoExecutorSync)this.executor).execute(this.dropRequest(isSystem), (Type)((Object)Void.class));
    }

    @Override
    public CollectionEntity getInfo() {
        return (CollectionEntity)((ArangoExecutorSync)this.executor).execute(this.getInfoRequest(), (Type)((Object)CollectionEntity.class));
    }

    @Override
    public CollectionPropertiesEntity getProperties() {
        return (CollectionPropertiesEntity)((ArangoExecutorSync)this.executor).execute(this.getPropertiesRequest(), (Type)((Object)CollectionPropertiesEntity.class));
    }

    @Override
    public CollectionPropertiesEntity changeProperties(CollectionPropertiesOptions options) {
        return (CollectionPropertiesEntity)((ArangoExecutorSync)this.executor).execute(this.changePropertiesRequest(options), (Type)((Object)CollectionPropertiesEntity.class));
    }

    @Override
    public CollectionEntity rename(String newName) {
        return (CollectionEntity)((ArangoExecutorSync)this.executor).execute(this.renameRequest(newName), (Type)((Object)CollectionEntity.class));
    }

    @Override
    public ShardEntity getResponsibleShard(Object value) {
        return (ShardEntity)((ArangoExecutorSync)this.executor).execute(this.responsibleShardRequest(value), (Type)((Object)ShardEntity.class));
    }

    @Override
    public CollectionRevisionEntity getRevision() {
        return (CollectionRevisionEntity)((ArangoExecutorSync)this.executor).execute(this.getRevisionRequest(), (Type)((Object)CollectionRevisionEntity.class));
    }

    @Override
    public void grantAccess(String user, Permissions permissions) {
        ((ArangoExecutorSync)this.executor).execute(this.grantAccessRequest(user, permissions), (Type)((Object)Void.class));
    }

    @Override
    public void revokeAccess(String user) {
        ((ArangoExecutorSync)this.executor).execute(this.grantAccessRequest(user, Permissions.NONE), (Type)((Object)Void.class));
    }

    @Override
    public void resetAccess(String user) {
        ((ArangoExecutorSync)this.executor).execute(this.resetAccessRequest(user), (Type)((Object)Void.class));
    }

    @Override
    public Permissions getPermissions(String user) {
        return ((ArangoExecutorSync)this.executor).execute(this.getPermissionsRequest(user), this.getPermissionsResponseDeserialzer());
    }
}

