/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal;

import com.arangodb.ArangoDB;
import com.arangodb.ArangoDatabase;
import com.arangodb.ArangoMetrics;
import com.arangodb.Request;
import com.arangodb.Response;
import com.arangodb.entity.ArangoDBEngine;
import com.arangodb.entity.ArangoDBVersion;
import com.arangodb.entity.LogEntriesEntity;
import com.arangodb.entity.LogLevelEntity;
import com.arangodb.entity.Permissions;
import com.arangodb.entity.QueryOptimizerRule;
import com.arangodb.entity.ServerRole;
import com.arangodb.entity.UserEntity;
import com.arangodb.internal.ArangoDatabaseImpl;
import com.arangodb.internal.ArangoExecutorSync;
import com.arangodb.internal.ArangoMetricsImpl;
import com.arangodb.internal.InternalArangoDB;
import com.arangodb.internal.config.ArangoConfig;
import com.arangodb.internal.net.HostHandler;
import com.arangodb.internal.net.HostResolver;
import com.arangodb.internal.net.ProtocolProvider;
import com.arangodb.internal.serde.SerdeUtils;
import com.arangodb.model.DBCreateOptions;
import com.arangodb.model.LogLevelOptions;
import com.arangodb.model.LogOptions;
import com.arangodb.model.UserCreateOptions;
import com.arangodb.model.UserUpdateOptions;
import java.lang.reflect.Type;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArangoDBImpl
extends InternalArangoDB<ArangoExecutorSync>
implements ArangoDB {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArangoDBImpl.class);
    private final HostHandler hostHandler;

    public ArangoDBImpl(ArangoConfig config, HostResolver hostResolver, ProtocolProvider protocolProvider, HostHandler hostHandler) {
        super(new ArangoExecutorSync(protocolProvider.createProtocol(config, hostHandler), config), config.getInternalSerde());
        this.hostHandler = hostHandler;
        hostResolver.init((ArangoExecutorSync)this.executor(), this.getSerde());
        LOGGER.debug("ArangoDB Client is ready to use");
    }

    @Override
    public void shutdown() {
        ((ArangoExecutorSync)this.executor).disconnect();
    }

    @Override
    public void updateJwt(String jwt) {
        this.hostHandler.setJwt(jwt);
        ((ArangoExecutorSync)this.executor).setJwt(jwt);
    }

    @Override
    public ArangoDatabase db() {
        return this.db("_system");
    }

    @Override
    public ArangoDatabase db(String dbName) {
        return new ArangoDatabaseImpl(this, dbName);
    }

    @Override
    public ArangoMetrics metrics() {
        return new ArangoMetricsImpl(((ArangoExecutorSync)this.executor).getQueueTimeMetrics());
    }

    @Override
    public Boolean createDatabase(String dbName) {
        return this.createDatabase(new DBCreateOptions().name(dbName));
    }

    @Override
    public Boolean createDatabase(DBCreateOptions options) {
        return ((ArangoExecutorSync)this.executor).execute(this.createDatabaseRequest(options), this.createDatabaseResponseDeserializer());
    }

    @Override
    public Collection<String> getDatabases() {
        return ((ArangoExecutorSync)this.executor).execute(this.getDatabasesRequest(this.db().name()), this.getDatabaseResponseDeserializer());
    }

    @Override
    public Collection<String> getAccessibleDatabases() {
        return this.db().getAccessibleDatabases();
    }

    @Override
    public Collection<String> getAccessibleDatabasesFor(String user) {
        return ((ArangoExecutorSync)this.executor).execute(this.getAccessibleDatabasesForRequest(this.db().name(), user), this.getAccessibleDatabasesForResponseDeserializer());
    }

    @Override
    public ArangoDBVersion getVersion() {
        return this.db().getVersion();
    }

    @Override
    public ArangoDBEngine getEngine() {
        return this.db().getEngine();
    }

    @Override
    public ServerRole getRole() {
        return ((ArangoExecutorSync)this.executor).execute(this.getRoleRequest(), this.getRoleResponseDeserializer());
    }

    @Override
    public String getServerId() {
        return ((ArangoExecutorSync)this.executor).execute(this.getServerIdRequest(), this.getServerIdResponseDeserializer());
    }

    @Override
    public UserEntity createUser(String user, String passwd) {
        return (UserEntity)((ArangoExecutorSync)this.executor).execute(this.createUserRequest(this.db().name(), user, passwd, new UserCreateOptions()), (Type)((Object)UserEntity.class));
    }

    @Override
    public UserEntity createUser(String user, String passwd, UserCreateOptions options) {
        return (UserEntity)((ArangoExecutorSync)this.executor).execute(this.createUserRequest(this.db().name(), user, passwd, options), (Type)((Object)UserEntity.class));
    }

    @Override
    public void deleteUser(String user) {
        ((ArangoExecutorSync)this.executor).execute(this.deleteUserRequest(this.db().name(), user), (Type)((Object)Void.class));
    }

    @Override
    public UserEntity getUser(String user) {
        return (UserEntity)((ArangoExecutorSync)this.executor).execute(this.getUserRequest(this.db().name(), user), (Type)((Object)UserEntity.class));
    }

    @Override
    public Collection<UserEntity> getUsers() {
        return ((ArangoExecutorSync)this.executor).execute(this.getUsersRequest(this.db().name()), this.getUsersResponseDeserializer());
    }

    @Override
    public UserEntity updateUser(String user, UserUpdateOptions options) {
        return (UserEntity)((ArangoExecutorSync)this.executor).execute(this.updateUserRequest(this.db().name(), user, options), (Type)((Object)UserEntity.class));
    }

    @Override
    public UserEntity replaceUser(String user, UserUpdateOptions options) {
        return (UserEntity)((ArangoExecutorSync)this.executor).execute(this.replaceUserRequest(this.db().name(), user, options), (Type)((Object)UserEntity.class));
    }

    @Override
    public void grantDefaultDatabaseAccess(String user, Permissions permissions) {
        ((ArangoExecutorSync)this.executor).execute(this.updateUserDefaultDatabaseAccessRequest(user, permissions), (Type)((Object)Void.class));
    }

    @Override
    public void grantDefaultCollectionAccess(String user, Permissions permissions) {
        ((ArangoExecutorSync)this.executor).execute(this.updateUserDefaultCollectionAccessRequest(user, permissions), (Type)((Object)Void.class));
    }

    @Override
    public <T> Response<T> execute(Request<?> request, Class<T> type) {
        return ((ArangoExecutorSync)this.executor).execute(this.executeRequest(request), this.responseDeserializer(type));
    }

    @Override
    public LogEntriesEntity getLogEntries(LogOptions options) {
        return (LogEntriesEntity)((ArangoExecutorSync)this.executor).execute(this.getLogEntriesRequest(options), (Type)((Object)LogEntriesEntity.class));
    }

    @Override
    public LogLevelEntity getLogLevel() {
        return this.getLogLevel(new LogLevelOptions());
    }

    @Override
    public LogLevelEntity getLogLevel(LogLevelOptions options) {
        return (LogLevelEntity)((ArangoExecutorSync)this.executor).execute(this.getLogLevelRequest(options), (Type)((Object)LogLevelEntity.class));
    }

    @Override
    public LogLevelEntity setLogLevel(LogLevelEntity entity) {
        return this.setLogLevel(entity, new LogLevelOptions());
    }

    @Override
    public LogLevelEntity setLogLevel(LogLevelEntity entity, LogLevelOptions options) {
        return (LogLevelEntity)((ArangoExecutorSync)this.executor).execute(this.setLogLevelRequest(entity, options), (Type)((Object)LogLevelEntity.class));
    }

    @Override
    public Collection<QueryOptimizerRule> getQueryOptimizerRules() {
        return (Collection)((ArangoExecutorSync)this.executor).execute(this.getQueryOptimizerRulesRequest(), SerdeUtils.constructListType(QueryOptimizerRule.class));
    }
}

