/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal;

import com.arangodb.ArangoCollection;
import com.arangodb.ArangoCursor;
import com.arangodb.ArangoDBException;
import com.arangodb.ArangoDatabase;
import com.arangodb.ArangoGraph;
import com.arangodb.ArangoSearch;
import com.arangodb.ArangoView;
import com.arangodb.SearchAlias;
import com.arangodb.entity.AqlExecutionExplainEntity;
import com.arangodb.entity.AqlFunctionEntity;
import com.arangodb.entity.AqlParseEntity;
import com.arangodb.entity.ArangoDBEngine;
import com.arangodb.entity.ArangoDBVersion;
import com.arangodb.entity.CollectionEntity;
import com.arangodb.entity.DatabaseEntity;
import com.arangodb.entity.EdgeDefinition;
import com.arangodb.entity.GraphEntity;
import com.arangodb.entity.IndexEntity;
import com.arangodb.entity.Permissions;
import com.arangodb.entity.QueryCachePropertiesEntity;
import com.arangodb.entity.QueryEntity;
import com.arangodb.entity.QueryTrackingPropertiesEntity;
import com.arangodb.entity.StreamTransactionEntity;
import com.arangodb.entity.TransactionEntity;
import com.arangodb.entity.ViewEntity;
import com.arangodb.entity.ViewType;
import com.arangodb.entity.arangosearch.analyzer.SearchAnalyzer;
import com.arangodb.internal.ArangoCollectionImpl;
import com.arangodb.internal.ArangoCursorExecute;
import com.arangodb.internal.ArangoDBImpl;
import com.arangodb.internal.ArangoErrors;
import com.arangodb.internal.ArangoExecutorSync;
import com.arangodb.internal.ArangoGraphImpl;
import com.arangodb.internal.ArangoSearchImpl;
import com.arangodb.internal.ArangoViewImpl;
import com.arangodb.internal.InternalArangoDatabase;
import com.arangodb.internal.InternalRequest;
import com.arangodb.internal.SearchAliasImpl;
import com.arangodb.internal.cursor.ArangoCursorImpl;
import com.arangodb.internal.cursor.entity.InternalCursorEntity;
import com.arangodb.internal.net.HostHandle;
import com.arangodb.internal.serde.SerdeUtils;
import com.arangodb.internal.util.DocumentUtil;
import com.arangodb.model.AqlFunctionCreateOptions;
import com.arangodb.model.AqlFunctionDeleteOptions;
import com.arangodb.model.AqlFunctionGetOptions;
import com.arangodb.model.AqlQueryExplainOptions;
import com.arangodb.model.AqlQueryOptions;
import com.arangodb.model.CollectionCreateOptions;
import com.arangodb.model.CollectionsReadOptions;
import com.arangodb.model.GraphCreateOptions;
import com.arangodb.model.StreamTransactionOptions;
import com.arangodb.model.TransactionOptions;
import com.arangodb.model.arangosearch.AnalyzerDeleteOptions;
import com.arangodb.model.arangosearch.ArangoSearchCreateOptions;
import com.arangodb.model.arangosearch.SearchAliasCreateOptions;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;

public class ArangoDatabaseImpl
extends InternalArangoDatabase<ArangoDBImpl, ArangoExecutorSync>
implements ArangoDatabase {
    protected ArangoDatabaseImpl(ArangoDBImpl arangoDB, String name) {
        super(arangoDB, name);
    }

    @Override
    public ArangoDBVersion getVersion() {
        return (ArangoDBVersion)((ArangoExecutorSync)this.executor).execute(this.getVersionRequest(), (Type)((Object)ArangoDBVersion.class));
    }

    @Override
    public ArangoDBEngine getEngine() {
        return (ArangoDBEngine)((ArangoExecutorSync)this.executor).execute(this.getEngineRequest(), (Type)((Object)ArangoDBEngine.class));
    }

    @Override
    public boolean exists() {
        try {
            this.getInfo();
            return true;
        }
        catch (ArangoDBException e) {
            if (ArangoErrors.ERROR_ARANGO_DATABASE_NOT_FOUND.equals(e.getErrorNum())) {
                return false;
            }
            throw e;
        }
    }

    @Override
    public Collection<String> getAccessibleDatabases() {
        return ((ArangoExecutorSync)this.executor).execute(this.getAccessibleDatabasesRequest(), this.getDatabaseResponseDeserializer());
    }

    @Override
    public ArangoCollection collection(String name) {
        return new ArangoCollectionImpl(this, name);
    }

    @Override
    public CollectionEntity createCollection(String name) {
        return (CollectionEntity)((ArangoExecutorSync)this.executor).execute(this.createCollectionRequest(name, new CollectionCreateOptions()), (Type)((Object)CollectionEntity.class));
    }

    @Override
    public CollectionEntity createCollection(String name, CollectionCreateOptions options) {
        return (CollectionEntity)((ArangoExecutorSync)this.executor).execute(this.createCollectionRequest(name, options), (Type)((Object)CollectionEntity.class));
    }

    @Override
    public Collection<CollectionEntity> getCollections() {
        return ((ArangoExecutorSync)this.executor).execute(this.getCollectionsRequest(new CollectionsReadOptions()), this.getCollectionsResponseDeserializer());
    }

    @Override
    public Collection<CollectionEntity> getCollections(CollectionsReadOptions options) {
        return ((ArangoExecutorSync)this.executor).execute(this.getCollectionsRequest(options), this.getCollectionsResponseDeserializer());
    }

    @Override
    public IndexEntity getIndex(String id) {
        DocumentUtil.validateIndexId(id);
        String[] split = id.split("/");
        return this.collection(split[0]).getIndex(split[1]);
    }

    @Override
    public String deleteIndex(String id) {
        DocumentUtil.validateIndexId(id);
        String[] split = id.split("/");
        return this.collection(split[0]).deleteIndex(split[1]);
    }

    @Override
    public Boolean create() {
        return ((ArangoDBImpl)this.arango()).createDatabase(this.name());
    }

    @Override
    public Boolean drop() {
        return ((ArangoExecutorSync)this.executor).execute(this.dropRequest(), this.createDropResponseDeserializer());
    }

    @Override
    public void grantAccess(String user, Permissions permissions) {
        ((ArangoExecutorSync)this.executor).execute(this.grantAccessRequest(user, permissions), (Type)((Object)Void.class));
    }

    @Override
    public void grantAccess(String user) {
        ((ArangoExecutorSync)this.executor).execute(this.grantAccessRequest(user, Permissions.RW), (Type)((Object)Void.class));
    }

    @Override
    public void revokeAccess(String user) {
        ((ArangoExecutorSync)this.executor).execute(this.grantAccessRequest(user, Permissions.NONE), (Type)((Object)Void.class));
    }

    @Override
    public void resetAccess(String user) {
        ((ArangoExecutorSync)this.executor).execute(this.resetAccessRequest(user), (Type)((Object)Void.class));
    }

    @Override
    public void grantDefaultCollectionAccess(String user, Permissions permissions) {
        ((ArangoExecutorSync)this.executor).execute(this.updateUserDefaultCollectionAccessRequest(user, permissions), (Type)((Object)Void.class));
    }

    @Override
    public Permissions getPermissions(String user) {
        return ((ArangoExecutorSync)this.executor).execute(this.getPermissionsRequest(user), this.getPermissionsResponseDeserialzer());
    }

    @Override
    public <T> ArangoCursor<T> query(String query, Class<T> type, Map<String, Object> bindVars, AqlQueryOptions options) {
        InternalRequest request = this.queryRequest(query, bindVars, options);
        HostHandle hostHandle = new HostHandle();
        InternalCursorEntity result = ((ArangoExecutorSync)this.executor).execute(request, this.internalCursorEntityDeserializer(), hostHandle);
        return this.createCursor(result, type, options, hostHandle);
    }

    @Override
    public <T> ArangoCursor<T> query(String query, Class<T> type, Map<String, Object> bindVars) {
        return this.query(query, type, bindVars, new AqlQueryOptions());
    }

    @Override
    public <T> ArangoCursor<T> query(String query, Class<T> type, AqlQueryOptions options) {
        return this.query(query, type, null, options);
    }

    @Override
    public <T> ArangoCursor<T> query(String query, Class<T> type) {
        return this.query(query, type, null, new AqlQueryOptions());
    }

    @Override
    public <T> ArangoCursor<T> cursor(String cursorId, Class<T> type) {
        HostHandle hostHandle = new HostHandle();
        InternalCursorEntity result = ((ArangoExecutorSync)this.executor).execute(this.queryNextRequest(cursorId, null), this.internalCursorEntityDeserializer(), hostHandle);
        return this.createCursor(result, type, null, hostHandle);
    }

    @Override
    public <T> ArangoCursor<T> cursor(String cursorId, Class<T> type, String nextBatchId) {
        HostHandle hostHandle = new HostHandle();
        InternalCursorEntity result = ((ArangoExecutorSync)this.executor).execute(this.queryNextByBatchIdRequest(cursorId, nextBatchId, null), this.internalCursorEntityDeserializer(), hostHandle);
        return this.createCursor(result, type, null, hostHandle);
    }

    private <T> ArangoCursor<T> createCursor(InternalCursorEntity result, Class<T> type, final AqlQueryOptions options, final HostHandle hostHandle) {
        ArangoCursorExecute execute = new ArangoCursorExecute(){

            @Override
            public InternalCursorEntity next(String id, String nextBatchId) {
                InternalRequest request = nextBatchId == null ? ArangoDatabaseImpl.this.queryNextRequest(id, options) : ArangoDatabaseImpl.this.queryNextByBatchIdRequest(id, nextBatchId, options);
                return ((ArangoExecutorSync)ArangoDatabaseImpl.this.executor).execute(request, ArangoDatabaseImpl.this.internalCursorEntityDeserializer(), hostHandle);
            }

            @Override
            public void close(String id) {
                ((ArangoExecutorSync)ArangoDatabaseImpl.this.executor).execute(ArangoDatabaseImpl.this.queryCloseRequest(id, options), (Type)((Object)Void.class), hostHandle);
            }
        };
        return new ArangoCursorImpl<T>(this, execute, type, result);
    }

    @Override
    public AqlExecutionExplainEntity explainQuery(String query, Map<String, Object> bindVars, AqlQueryExplainOptions options) {
        return (AqlExecutionExplainEntity)((ArangoExecutorSync)this.executor).execute(this.explainQueryRequest(query, bindVars, options), (Type)((Object)AqlExecutionExplainEntity.class));
    }

    @Override
    public AqlParseEntity parseQuery(String query) {
        return (AqlParseEntity)((ArangoExecutorSync)this.executor).execute(this.parseQueryRequest(query), (Type)((Object)AqlParseEntity.class));
    }

    @Override
    public void clearQueryCache() {
        ((ArangoExecutorSync)this.executor).execute(this.clearQueryCacheRequest(), (Type)((Object)Void.class));
    }

    @Override
    public QueryCachePropertiesEntity getQueryCacheProperties() {
        return (QueryCachePropertiesEntity)((ArangoExecutorSync)this.executor).execute(this.getQueryCachePropertiesRequest(), (Type)((Object)QueryCachePropertiesEntity.class));
    }

    @Override
    public QueryCachePropertiesEntity setQueryCacheProperties(QueryCachePropertiesEntity properties) {
        return (QueryCachePropertiesEntity)((ArangoExecutorSync)this.executor).execute(this.setQueryCachePropertiesRequest(properties), (Type)((Object)QueryCachePropertiesEntity.class));
    }

    @Override
    public QueryTrackingPropertiesEntity getQueryTrackingProperties() {
        return (QueryTrackingPropertiesEntity)((ArangoExecutorSync)this.executor).execute(this.getQueryTrackingPropertiesRequest(), (Type)((Object)QueryTrackingPropertiesEntity.class));
    }

    @Override
    public QueryTrackingPropertiesEntity setQueryTrackingProperties(QueryTrackingPropertiesEntity properties) {
        return (QueryTrackingPropertiesEntity)((ArangoExecutorSync)this.executor).execute(this.setQueryTrackingPropertiesRequest(properties), (Type)((Object)QueryTrackingPropertiesEntity.class));
    }

    @Override
    public Collection<QueryEntity> getCurrentlyRunningQueries() {
        return (Collection)((ArangoExecutorSync)this.executor).execute(this.getCurrentlyRunningQueriesRequest(), SerdeUtils.constructListType(QueryEntity.class));
    }

    @Override
    public Collection<QueryEntity> getSlowQueries() {
        return (Collection)((ArangoExecutorSync)this.executor).execute(this.getSlowQueriesRequest(), SerdeUtils.constructListType(QueryEntity.class));
    }

    @Override
    public void clearSlowQueries() {
        ((ArangoExecutorSync)this.executor).execute(this.clearSlowQueriesRequest(), (Type)((Object)Void.class));
    }

    @Override
    public void killQuery(String id) {
        ((ArangoExecutorSync)this.executor).execute(this.killQueryRequest(id), (Type)((Object)Void.class));
    }

    @Override
    public void createAqlFunction(String name, String code, AqlFunctionCreateOptions options) {
        ((ArangoExecutorSync)this.executor).execute(this.createAqlFunctionRequest(name, code, options), (Type)((Object)Void.class));
    }

    @Override
    public Integer deleteAqlFunction(String name, AqlFunctionDeleteOptions options) {
        return ((ArangoExecutorSync)this.executor).execute(this.deleteAqlFunctionRequest(name, options), this.deleteAqlFunctionResponseDeserializer());
    }

    @Override
    public Collection<AqlFunctionEntity> getAqlFunctions(AqlFunctionGetOptions options) {
        return ((ArangoExecutorSync)this.executor).execute(this.getAqlFunctionsRequest(options), this.getAqlFunctionsResponseDeserializer());
    }

    @Override
    public ArangoGraph graph(String name) {
        return new ArangoGraphImpl(this, name);
    }

    @Override
    public GraphEntity createGraph(String name, Collection<EdgeDefinition> edgeDefinitions) {
        return this.createGraph(name, edgeDefinitions, new GraphCreateOptions());
    }

    @Override
    public GraphEntity createGraph(String name, Collection<EdgeDefinition> edgeDefinitions, GraphCreateOptions options) {
        return ((ArangoExecutorSync)this.executor).execute(this.createGraphRequest(name, edgeDefinitions, options), this.createGraphResponseDeserializer());
    }

    @Override
    public Collection<GraphEntity> getGraphs() {
        return ((ArangoExecutorSync)this.executor).execute(this.getGraphsRequest(), this.getGraphsResponseDeserializer());
    }

    @Override
    public <T> T transaction(String action, Class<T> type, TransactionOptions options) {
        return ((ArangoExecutorSync)this.executor).execute(this.transactionRequest(action, options), this.transactionResponseDeserializer(type));
    }

    @Override
    public StreamTransactionEntity beginStreamTransaction(StreamTransactionOptions options) {
        return ((ArangoExecutorSync)this.executor).execute(this.beginStreamTransactionRequest(options), this.streamTransactionResponseDeserializer());
    }

    @Override
    public StreamTransactionEntity abortStreamTransaction(String id) {
        return ((ArangoExecutorSync)this.executor).execute(this.abortStreamTransactionRequest(id), this.streamTransactionResponseDeserializer());
    }

    @Override
    public StreamTransactionEntity getStreamTransaction(String id) {
        return ((ArangoExecutorSync)this.executor).execute(this.getStreamTransactionRequest(id), this.streamTransactionResponseDeserializer());
    }

    @Override
    public Collection<TransactionEntity> getStreamTransactions() {
        return ((ArangoExecutorSync)this.executor).execute(this.getStreamTransactionsRequest(), this.transactionsResponseDeserializer());
    }

    @Override
    public StreamTransactionEntity commitStreamTransaction(String id) {
        return ((ArangoExecutorSync)this.executor).execute(this.commitStreamTransactionRequest(id), this.streamTransactionResponseDeserializer());
    }

    @Override
    public DatabaseEntity getInfo() {
        return ((ArangoExecutorSync)this.executor).execute(this.getInfoRequest(), this.getInfoResponseDeserializer());
    }

    @Override
    public void reloadRouting() {
        ((ArangoExecutorSync)this.executor).execute(this.reloadRoutingRequest(), (Type)((Object)Void.class));
    }

    @Override
    public Collection<ViewEntity> getViews() {
        return ((ArangoExecutorSync)this.executor).execute(this.getViewsRequest(), this.getViewsResponseDeserializer());
    }

    @Override
    public ArangoView view(String name) {
        return new ArangoViewImpl(this, name);
    }

    @Override
    public ArangoSearch arangoSearch(String name) {
        return new ArangoSearchImpl(this, name);
    }

    @Override
    public SearchAlias searchAlias(String name) {
        return new SearchAliasImpl(this, name);
    }

    @Override
    public ViewEntity createView(String name, ViewType type) {
        return (ViewEntity)((ArangoExecutorSync)this.executor).execute(this.createViewRequest(name, type), (Type)((Object)ViewEntity.class));
    }

    @Override
    public ViewEntity createArangoSearch(String name, ArangoSearchCreateOptions options) {
        return (ViewEntity)((ArangoExecutorSync)this.executor).execute(this.createArangoSearchRequest(name, options), (Type)((Object)ViewEntity.class));
    }

    @Override
    public ViewEntity createSearchAlias(String name, SearchAliasCreateOptions options) {
        return (ViewEntity)((ArangoExecutorSync)this.executor).execute(this.createSearchAliasRequest(name, options), (Type)((Object)ViewEntity.class));
    }

    @Override
    public SearchAnalyzer createSearchAnalyzer(SearchAnalyzer analyzer) {
        return (SearchAnalyzer)((ArangoExecutorSync)this.executor).execute(this.createAnalyzerRequest(analyzer), (Type)((Object)SearchAnalyzer.class));
    }

    @Override
    public SearchAnalyzer getSearchAnalyzer(String name) {
        return (SearchAnalyzer)((ArangoExecutorSync)this.executor).execute(this.getAnalyzerRequest(name), (Type)((Object)SearchAnalyzer.class));
    }

    @Override
    public Collection<SearchAnalyzer> getSearchAnalyzers() {
        return ((ArangoExecutorSync)this.executor).execute(this.getAnalyzersRequest(), this.getSearchAnalyzersResponseDeserializer());
    }

    @Override
    public void deleteSearchAnalyzer(String name) {
        this.deleteSearchAnalyzer(name, null);
    }

    @Override
    public void deleteSearchAnalyzer(String name, AnalyzerDeleteOptions options) {
        ((ArangoExecutorSync)this.executor).execute(this.deleteAnalyzerRequest(name, options), (Type)((Object)Void.class));
    }
}

