/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal;

import com.arangodb.ArangoSerdeAccessor;
import com.arangodb.internal.ArangoExecutor;
import com.arangodb.internal.InternalRequest;
import com.arangodb.internal.RequestType;
import com.arangodb.internal.serde.InternalSerde;
import com.arangodb.internal.util.EncodeUtils;

public abstract class ArangoExecuteable<E extends ArangoExecutor>
implements ArangoSerdeAccessor {
    private static final String SLASH = "/";
    protected final E executor;
    protected final InternalSerde serde;

    protected ArangoExecuteable(E executor, InternalSerde serde) {
        this.executor = executor;
        this.serde = serde;
    }

    protected static String createPath(String ... params) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < params.length; ++i) {
            if (i > 0) {
                sb.append(SLASH);
            }
            String param = params[i].contains(SLASH) ? ArangoExecuteable.createPath(params[i].split(SLASH)) : EncodeUtils.encodeURIComponent(params[i]);
            sb.append(param);
        }
        return sb.toString();
    }

    protected E executor() {
        return this.executor;
    }

    @Override
    public InternalSerde getSerde() {
        return this.serde;
    }

    protected InternalRequest request(String dbName, RequestType requestType, String ... path) {
        return new InternalRequest(dbName, requestType, ArangoExecuteable.createPath(path));
    }
}

