/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal;

import com.arangodb.ArangoDBException;
import com.arangodb.Protocol;
import com.arangodb.config.ArangoConfigProperties;
import com.arangodb.config.HostDescription;
import com.arangodb.entity.LoadBalancingStrategy;
import com.arangodb.internal.config.ArangoConfig;
import com.arangodb.internal.net.Connection;
import com.arangodb.internal.net.ConnectionFactory;
import com.arangodb.internal.net.DirtyReadHostHandler;
import com.arangodb.internal.net.ExtendedHostResolver;
import com.arangodb.internal.net.FallbackHostHandler;
import com.arangodb.internal.net.Host;
import com.arangodb.internal.net.HostHandler;
import com.arangodb.internal.net.HostResolver;
import com.arangodb.internal.net.ProtocolProvider;
import com.arangodb.internal.net.RandomHostHandler;
import com.arangodb.internal.net.RoundRobinHostHandler;
import com.arangodb.internal.net.SimpleHostResolver;
import com.arangodb.internal.util.HostUtils;
import com.arangodb.serde.ArangoSerde;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ServiceLoader;
import javax.net.ssl.SSLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class InternalArangoDBBuilder<T extends InternalArangoDBBuilder<T>> {
    protected static final Logger LOG = LoggerFactory.getLogger(InternalArangoDBBuilder.class);
    protected final ArangoConfig config = new ArangoConfig();

    public T loadProperties(ArangoConfigProperties properties) {
        this.config.loadProperties(properties);
        return (T)this;
    }

    public T host(String host, int port) {
        this.config.addHost(new HostDescription(host, port));
        return (T)this;
    }

    public T timeout(Integer timeout) {
        this.config.setTimeout(timeout);
        return (T)this;
    }

    public T user(String user) {
        this.config.setUser(user);
        return (T)this;
    }

    public T password(String password) {
        this.config.setPassword(password);
        return (T)this;
    }

    public T jwt(String jwt) {
        this.config.setJwt(jwt);
        return (T)this;
    }

    public T useSsl(Boolean useSsl) {
        this.config.setUseSsl(useSsl);
        return (T)this;
    }

    public T sslContext(SSLContext sslContext) {
        this.config.setSslContext(sslContext);
        return (T)this;
    }

    public T verifyHost(Boolean verifyHost) {
        this.config.setVerifyHost(verifyHost);
        return (T)this;
    }

    public T chunkSize(Integer chunkSize) {
        this.config.setChunkSize(chunkSize);
        return (T)this;
    }

    public T maxConnections(Integer maxConnections) {
        this.config.setMaxConnections(maxConnections);
        return (T)this;
    }

    public T connectionTtl(Long connectionTtl) {
        this.config.setConnectionTtl(connectionTtl);
        return (T)this;
    }

    public T keepAliveInterval(Integer keepAliveInterval) {
        this.config.setKeepAliveInterval(keepAliveInterval);
        return (T)this;
    }

    public T acquireHostList(Boolean acquireHostList) {
        this.config.setAcquireHostList(acquireHostList);
        return (T)this;
    }

    public T acquireHostListInterval(Integer acquireHostListInterval) {
        this.config.setAcquireHostListInterval(acquireHostListInterval);
        return (T)this;
    }

    public T loadBalancingStrategy(LoadBalancingStrategy loadBalancingStrategy) {
        this.config.setLoadBalancingStrategy(loadBalancingStrategy);
        return (T)this;
    }

    public T responseQueueTimeSamples(Integer responseQueueTimeSamples) {
        this.config.setResponseQueueTimeSamples(responseQueueTimeSamples);
        return (T)this;
    }

    public T serde(ArangoSerde serde) {
        this.config.setUserDataSerde(serde);
        return (T)this;
    }

    protected ProtocolProvider protocolProvider(Protocol protocol) {
        ServiceLoader<ProtocolProvider> loader = ServiceLoader.load(ProtocolProvider.class);
        for (ProtocolProvider p : loader) {
            if (p.supportsProtocol(protocol)) {
                return p;
            }
            LOG.debug("Required protocol ({}) not supported by ProtocolProvider: {}", (Object)protocol, (Object)p.getClass().getName());
        }
        throw new ArangoDBException("No ProtocolProvider found for protocol: " + (Object)((Object)protocol));
    }

    protected HostHandler createHostHandler(HostResolver hostResolver) {
        HostHandler hostHandler;
        LoadBalancingStrategy loadBalancingStrategy = this.config.getLoadBalancingStrategy();
        if (loadBalancingStrategy != null) {
            switch (loadBalancingStrategy) {
                case ONE_RANDOM: {
                    hostHandler = new RandomHostHandler(hostResolver, new FallbackHostHandler(hostResolver));
                    break;
                }
                case ROUND_ROBIN: {
                    hostHandler = new RoundRobinHostHandler(hostResolver);
                    break;
                }
                default: {
                    hostHandler = new FallbackHostHandler(hostResolver);
                    break;
                }
            }
        } else {
            hostHandler = new FallbackHostHandler(hostResolver);
        }
        LOG.debug("HostHandler is {}", (Object)hostHandler.getClass().getSimpleName());
        return new DirtyReadHostHandler(hostHandler, new RoundRobinHostHandler(hostResolver));
    }

    protected HostResolver createHostResolver(Collection<Host> hosts, ConnectionFactory connectionFactory) {
        Boolean acquireHostList = this.config.getAcquireHostList();
        if (acquireHostList != null && acquireHostList.booleanValue()) {
            LOG.debug("acquireHostList -> Use ExtendedHostResolver");
            return new ExtendedHostResolver(new ArrayList<Host>(hosts), this.config, connectionFactory, this.config.getAcquireHostListInterval());
        }
        LOG.debug("Use SimpleHostResolver");
        return new SimpleHostResolver(new ArrayList<Host>(hosts));
    }

    protected <C extends Connection> Collection<Host> createHostList(ConnectionFactory connectionFactory) {
        ArrayList<Host> hostList = new ArrayList<Host>();
        for (HostDescription host : this.config.getHosts()) {
            hostList.add(HostUtils.createHost(host, this.config, connectionFactory));
        }
        return hostList;
    }
}

