/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal;

import com.arangodb.entity.EdgeEntity;
import com.arangodb.entity.EdgeUpdateEntity;
import com.arangodb.internal.ArangoExecuteable;
import com.arangodb.internal.ArangoExecutor;
import com.arangodb.internal.InternalArangoDB;
import com.arangodb.internal.InternalArangoDatabase;
import com.arangodb.internal.InternalArangoGraph;
import com.arangodb.internal.InternalRequest;
import com.arangodb.internal.RequestType;
import com.arangodb.internal.util.DocumentUtil;
import com.arangodb.internal.util.RequestUtils;
import com.arangodb.model.EdgeCollectionDropOptions;
import com.arangodb.model.EdgeCreateOptions;
import com.arangodb.model.EdgeDeleteOptions;
import com.arangodb.model.EdgeReplaceOptions;
import com.arangodb.model.EdgeUpdateOptions;
import com.arangodb.model.GraphDocumentReadOptions;

public abstract class InternalArangoEdgeCollection<A extends InternalArangoDB<E>, D extends InternalArangoDatabase<A, E>, G extends InternalArangoGraph<A, D, E>, E extends ArangoExecutor>
extends ArangoExecuteable<E> {
    private static final String PATH_API_GHARIAL = "/_api/gharial";
    private static final String TRANSACTION_ID = "x-arango-trx-id";
    private static final String EDGE_PATH = "edge";
    private static final String EDGE_JSON_POINTER = "/edge";
    private final G graph;
    private final String name;

    protected InternalArangoEdgeCollection(G graph, String name) {
        super(((InternalArangoGraph)graph).executor, ((InternalArangoGraph)graph).serde);
        this.graph = graph;
        this.name = name;
    }

    public G graph() {
        return this.graph;
    }

    public String name() {
        return this.name;
    }

    protected InternalRequest removeEdgeDefinitionRequest(EdgeCollectionDropOptions options) {
        return this.request(((InternalArangoDatabase)((InternalArangoGraph)this.graph).db()).name(), RequestType.DELETE, PATH_API_GHARIAL, ((InternalArangoGraph)this.graph).name(), EDGE_PATH, this.name).putQueryParam("waitForSync", options.getWaitForSync()).putQueryParam("dropCollections", options.getDropCollections());
    }

    protected <T> InternalRequest insertEdgeRequest(T value, EdgeCreateOptions options) {
        InternalRequest request = this.request(((InternalArangoDatabase)((InternalArangoGraph)this.graph).db()).name(), RequestType.POST, PATH_API_GHARIAL, ((InternalArangoGraph)this.graph).name(), EDGE_PATH, this.name);
        EdgeCreateOptions params = options != null ? options : new EdgeCreateOptions();
        request.putHeaderParam(TRANSACTION_ID, params.getStreamTransactionId());
        request.putQueryParam("waitForSync", params.getWaitForSync());
        request.setBody(this.getSerde().serializeUserData(value));
        return request;
    }

    protected ArangoExecutor.ResponseDeserializer<EdgeEntity> insertEdgeResponseDeserializer() {
        return response -> this.getSerde().deserialize(response.getBody(), EDGE_JSON_POINTER, EdgeEntity.class);
    }

    protected InternalRequest getEdgeRequest(String key, GraphDocumentReadOptions options) {
        InternalRequest request = this.request(((InternalArangoDatabase)((InternalArangoGraph)this.graph).db()).name(), RequestType.GET, PATH_API_GHARIAL, ((InternalArangoGraph)this.graph).name(), EDGE_PATH, DocumentUtil.createDocumentHandle(this.name, key));
        GraphDocumentReadOptions params = options != null ? options : new GraphDocumentReadOptions();
        request.putHeaderParam(TRANSACTION_ID, params.getStreamTransactionId());
        request.putHeaderParam("if-none-match", params.getIfNoneMatch());
        request.putHeaderParam("if-match", params.getIfMatch());
        if (Boolean.TRUE.equals(params.getAllowDirtyRead())) {
            RequestUtils.allowDirtyRead(request);
        }
        return request;
    }

    protected <T> ArangoExecutor.ResponseDeserializer<T> getEdgeResponseDeserializer(Class<T> type) {
        return response -> this.getSerde().deserializeUserData(this.getSerde().extract(response.getBody(), EDGE_JSON_POINTER), type);
    }

    protected <T> InternalRequest replaceEdgeRequest(String key, T value, EdgeReplaceOptions options) {
        InternalRequest request = this.request(((InternalArangoDatabase)((InternalArangoGraph)this.graph).db()).name(), RequestType.PUT, PATH_API_GHARIAL, ((InternalArangoGraph)this.graph).name(), EDGE_PATH, DocumentUtil.createDocumentHandle(this.name, key));
        EdgeReplaceOptions params = options != null ? options : new EdgeReplaceOptions();
        request.putHeaderParam(TRANSACTION_ID, params.getStreamTransactionId());
        request.putQueryParam("waitForSync", params.getWaitForSync());
        request.putHeaderParam("if-match", params.getIfMatch());
        request.setBody(this.getSerde().serializeUserData(value));
        return request;
    }

    protected ArangoExecutor.ResponseDeserializer<EdgeUpdateEntity> replaceEdgeResponseDeserializer() {
        return response -> this.getSerde().deserialize(response.getBody(), EDGE_JSON_POINTER, EdgeUpdateEntity.class);
    }

    protected <T> InternalRequest updateEdgeRequest(String key, T value, EdgeUpdateOptions options) {
        InternalRequest request = this.request(((InternalArangoDatabase)((InternalArangoGraph)this.graph).db()).name(), RequestType.PATCH, PATH_API_GHARIAL, ((InternalArangoGraph)this.graph).name(), EDGE_PATH, DocumentUtil.createDocumentHandle(this.name, key));
        EdgeUpdateOptions params = options != null ? options : new EdgeUpdateOptions();
        request.putHeaderParam(TRANSACTION_ID, params.getStreamTransactionId());
        request.putQueryParam("keepNull", params.getKeepNull());
        request.putQueryParam("waitForSync", params.getWaitForSync());
        request.putHeaderParam("if-match", params.getIfMatch());
        request.setBody(this.getSerde().serializeUserData(value));
        return request;
    }

    protected ArangoExecutor.ResponseDeserializer<EdgeUpdateEntity> updateEdgeResponseDeserializer() {
        return response -> this.getSerde().deserialize(response.getBody(), EDGE_JSON_POINTER, EdgeUpdateEntity.class);
    }

    protected InternalRequest deleteEdgeRequest(String key, EdgeDeleteOptions options) {
        InternalRequest request = this.request(((InternalArangoDatabase)((InternalArangoGraph)this.graph).db()).name(), RequestType.DELETE, PATH_API_GHARIAL, ((InternalArangoGraph)this.graph).name(), EDGE_PATH, DocumentUtil.createDocumentHandle(this.name, key));
        EdgeDeleteOptions params = options != null ? options : new EdgeDeleteOptions();
        request.putHeaderParam(TRANSACTION_ID, params.getStreamTransactionId());
        request.putQueryParam("waitForSync", params.getWaitForSync());
        request.putHeaderParam("if-match", params.getIfMatch());
        return request;
    }
}

