/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal;

import com.arangodb.entity.VertexEntity;
import com.arangodb.entity.VertexUpdateEntity;
import com.arangodb.internal.ArangoExecuteable;
import com.arangodb.internal.ArangoExecutor;
import com.arangodb.internal.InternalArangoDB;
import com.arangodb.internal.InternalArangoDatabase;
import com.arangodb.internal.InternalArangoGraph;
import com.arangodb.internal.InternalRequest;
import com.arangodb.internal.RequestType;
import com.arangodb.internal.util.DocumentUtil;
import com.arangodb.internal.util.RequestUtils;
import com.arangodb.model.GraphDocumentReadOptions;
import com.arangodb.model.VertexCollectionDropOptions;
import com.arangodb.model.VertexCreateOptions;
import com.arangodb.model.VertexDeleteOptions;
import com.arangodb.model.VertexReplaceOptions;
import com.arangodb.model.VertexUpdateOptions;

public abstract class InternalArangoVertexCollection<A extends InternalArangoDB<E>, D extends InternalArangoDatabase<A, E>, G extends InternalArangoGraph<A, D, E>, E extends ArangoExecutor>
extends ArangoExecuteable<E> {
    private static final String PATH_API_GHARIAL = "/_api/gharial";
    private static final String VERTEX_PATH = "vertex";
    private static final String VERTEX_JSON_POINTER = "/vertex";
    private static final String TRANSACTION_ID = "x-arango-trx-id";
    private final G graph;
    private final String name;

    protected InternalArangoVertexCollection(G graph, String name) {
        super(((InternalArangoGraph)graph).executor, ((InternalArangoGraph)graph).serde);
        this.graph = graph;
        this.name = name;
    }

    public G graph() {
        return this.graph;
    }

    public String name() {
        return this.name;
    }

    protected InternalRequest dropRequest(VertexCollectionDropOptions options) {
        return this.request(((InternalArangoDatabase)((InternalArangoGraph)this.graph).db()).name(), RequestType.DELETE, PATH_API_GHARIAL, ((InternalArangoGraph)this.graph).name(), VERTEX_PATH, this.name).putQueryParam("dropCollection", options.getDropCollection());
    }

    protected <T> InternalRequest insertVertexRequest(T value, VertexCreateOptions options) {
        InternalRequest request = this.request(((InternalArangoDatabase)((InternalArangoGraph)this.graph).db()).name(), RequestType.POST, PATH_API_GHARIAL, ((InternalArangoGraph)this.graph).name(), VERTEX_PATH, this.name);
        VertexCreateOptions params = options != null ? options : new VertexCreateOptions();
        request.putHeaderParam(TRANSACTION_ID, params.getStreamTransactionId());
        request.putQueryParam("waitForSync", params.getWaitForSync());
        request.setBody(this.getSerde().serializeUserData(value));
        return request;
    }

    protected ArangoExecutor.ResponseDeserializer<VertexEntity> insertVertexResponseDeserializer() {
        return response -> this.getSerde().deserialize(response.getBody(), VERTEX_JSON_POINTER, VertexEntity.class);
    }

    protected InternalRequest getVertexRequest(String key, GraphDocumentReadOptions options) {
        InternalRequest request = this.request(((InternalArangoDatabase)((InternalArangoGraph)this.graph).db()).name(), RequestType.GET, PATH_API_GHARIAL, ((InternalArangoGraph)this.graph).name(), VERTEX_PATH, DocumentUtil.createDocumentHandle(this.name, key));
        GraphDocumentReadOptions params = options != null ? options : new GraphDocumentReadOptions();
        request.putHeaderParam(TRANSACTION_ID, params.getStreamTransactionId());
        request.putHeaderParam("if-none-match", params.getIfNoneMatch());
        request.putHeaderParam("if-match", params.getIfMatch());
        if (Boolean.TRUE.equals(params.getAllowDirtyRead())) {
            RequestUtils.allowDirtyRead(request);
        }
        return request;
    }

    protected <T> ArangoExecutor.ResponseDeserializer<T> getVertexResponseDeserializer(Class<T> type) {
        return response -> this.getSerde().deserializeUserData(this.getSerde().extract(response.getBody(), VERTEX_JSON_POINTER), type);
    }

    protected <T> InternalRequest replaceVertexRequest(String key, T value, VertexReplaceOptions options) {
        InternalRequest request = this.request(((InternalArangoDatabase)((InternalArangoGraph)this.graph).db()).name(), RequestType.PUT, PATH_API_GHARIAL, ((InternalArangoGraph)this.graph).name(), VERTEX_PATH, DocumentUtil.createDocumentHandle(this.name, key));
        VertexReplaceOptions params = options != null ? options : new VertexReplaceOptions();
        request.putHeaderParam(TRANSACTION_ID, params.getStreamTransactionId());
        request.putQueryParam("waitForSync", params.getWaitForSync());
        request.putHeaderParam("if-match", params.getIfMatch());
        request.setBody(this.getSerde().serializeUserData(value));
        return request;
    }

    protected ArangoExecutor.ResponseDeserializer<VertexUpdateEntity> replaceVertexResponseDeserializer() {
        return response -> this.getSerde().deserialize(response.getBody(), VERTEX_JSON_POINTER, VertexUpdateEntity.class);
    }

    protected <T> InternalRequest updateVertexRequest(String key, T value, VertexUpdateOptions options) {
        InternalRequest request = this.request(((InternalArangoDatabase)((InternalArangoGraph)this.graph).db()).name(), RequestType.PATCH, PATH_API_GHARIAL, ((InternalArangoGraph)this.graph).name(), VERTEX_PATH, DocumentUtil.createDocumentHandle(this.name, key));
        VertexUpdateOptions params = options != null ? options : new VertexUpdateOptions();
        request.putHeaderParam(TRANSACTION_ID, params.getStreamTransactionId());
        request.putQueryParam("keepNull", params.getKeepNull());
        request.putQueryParam("waitForSync", params.getWaitForSync());
        request.putHeaderParam("if-match", params.getIfMatch());
        request.setBody(this.getSerde().serializeUserData(value));
        return request;
    }

    protected ArangoExecutor.ResponseDeserializer<VertexUpdateEntity> updateVertexResponseDeserializer() {
        return response -> this.getSerde().deserialize(response.getBody(), VERTEX_JSON_POINTER, VertexUpdateEntity.class);
    }

    protected InternalRequest deleteVertexRequest(String key, VertexDeleteOptions options) {
        InternalRequest request = this.request(((InternalArangoDatabase)((InternalArangoGraph)this.graph).db()).name(), RequestType.DELETE, PATH_API_GHARIAL, ((InternalArangoGraph)this.graph).name(), VERTEX_PATH, DocumentUtil.createDocumentHandle(this.name, key));
        VertexDeleteOptions params = options != null ? options : new VertexDeleteOptions();
        request.putHeaderParam(TRANSACTION_ID, params.getStreamTransactionId());
        request.putQueryParam("waitForSync", params.getWaitForSync());
        request.putHeaderParam("if-match", params.getIfMatch());
        return request;
    }
}

