/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal;

import com.arangodb.internal.ArangoExecuteable;
import com.arangodb.internal.ArangoExecutor;
import com.arangodb.internal.InternalArangoDB;
import com.arangodb.internal.InternalArangoDatabase;
import com.arangodb.internal.InternalRequest;
import com.arangodb.internal.RequestType;
import com.arangodb.model.OptionsBuilder;
import com.arangodb.model.ViewRenameOptions;

public abstract class InternalArangoView<A extends InternalArangoDB<E>, D extends InternalArangoDatabase<A, E>, E extends ArangoExecutor>
extends ArangoExecuteable<E> {
    protected static final String PATH_API_VIEW = "/_api/view";
    protected static final String PATH_API_ANALYZER = "/_api/analyzer";
    protected final D db;
    protected final String name;

    protected InternalArangoView(D db, String name) {
        super(((InternalArangoDatabase)db).executor, ((InternalArangoDatabase)db).serde);
        this.db = db;
        this.name = name;
    }

    public D db() {
        return this.db;
    }

    public String name() {
        return this.name;
    }

    protected InternalRequest dropRequest() {
        return this.request(((InternalArangoDatabase)this.db).name(), RequestType.DELETE, PATH_API_VIEW, this.name);
    }

    protected InternalRequest renameRequest(String newName) {
        InternalRequest request = this.request(((InternalArangoDatabase)this.db).name(), RequestType.PUT, PATH_API_VIEW, this.name, "rename");
        request.setBody(this.getSerde().serialize(OptionsBuilder.build(new ViewRenameOptions(), newName)));
        return request;
    }

    protected InternalRequest getInfoRequest() {
        return this.request(((InternalArangoDatabase)this.db).name(), RequestType.GET, PATH_API_VIEW, this.name);
    }
}

