/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal.cursor;

import com.arangodb.ArangoCursor;
import com.arangodb.ArangoIterator;
import com.arangodb.entity.CursorStats;
import com.arangodb.entity.CursorWarning;
import com.arangodb.internal.ArangoCursorExecute;
import com.arangodb.internal.InternalArangoDatabase;
import com.arangodb.internal.cursor.entity.InternalCursorEntity;
import com.arangodb.shaded.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArangoCursorImpl<T>
implements ArangoCursor<T> {
    private static final Logger LOG = LoggerFactory.getLogger(ArangoCursorImpl.class);
    protected final ArangoCursorIterator<T> iterator;
    private final Class<T> type;
    private final String id;
    private final ArangoCursorExecute execute;
    private final boolean pontentialDirtyRead;
    private final boolean allowRetry;

    public ArangoCursorImpl(InternalArangoDatabase<?, ?> db, ArangoCursorExecute execute, Class<T> type, InternalCursorEntity result) {
        this.execute = execute;
        this.type = type;
        this.id = result.getId();
        this.pontentialDirtyRead = result.isPontentialDirtyRead();
        this.iterator = new ArangoCursorIterator<T>(this.id, type, execute, db, result);
        this.allowRetry = result.getNextBatchId() != null;
    }

    @Override
    public void close() {
        if (this.getId() != null && (this.allowRetry || ((ArangoCursorIterator)this.iterator).result.getHasMore().booleanValue())) {
            this.getExecute().close(this.getId());
        }
    }

    @Override
    public T next() {
        return this.iterator.next();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Class<T> getType() {
        return this.type;
    }

    @Override
    public Integer getCount() {
        return ((ArangoCursorIterator)this.iterator).result.getCount();
    }

    @Override
    public CursorStats getStats() {
        InternalCursorEntity.Extras extra = ((ArangoCursorIterator)this.iterator).result.getExtra();
        return extra != null ? extra.getStats() : null;
    }

    @Override
    public Collection<CursorWarning> getWarnings() {
        InternalCursorEntity.Extras extra = ((ArangoCursorIterator)this.iterator).result.getExtra();
        return extra != null ? extra.getWarnings() : null;
    }

    @Override
    public boolean isCached() {
        Boolean cached = ((ArangoCursorIterator)this.iterator).result.getCached();
        return Boolean.TRUE.equals(cached);
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public List<T> asListRemaining() {
        ArrayList<T> remaining = new ArrayList<T>();
        while (this.hasNext()) {
            remaining.add(this.next());
        }
        try {
            this.close();
        }
        catch (Exception e) {
            LOG.warn("Could not close cursor: ", (Throwable)e);
        }
        return remaining;
    }

    @Override
    public boolean isPotentialDirtyRead() {
        return this.pontentialDirtyRead;
    }

    @Override
    public ArangoIterator<T> iterator() {
        return this.iterator;
    }

    @Override
    public String getNextBatchId() {
        return ((ArangoCursorIterator)this.iterator).result.getNextBatchId();
    }

    protected ArangoCursorExecute getExecute() {
        return this.execute;
    }

    @Override
    public Stream<T> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    protected static class ArangoCursorIterator<T>
    implements ArangoIterator<T> {
        private final String cursorId;
        private final Class<T> type;
        private final InternalArangoDatabase<?, ?> db;
        private final ArangoCursorExecute execute;
        private InternalCursorEntity result;
        private Iterator<JsonNode> arrayIterator;

        protected ArangoCursorIterator(String cursorId, Class<T> type, ArangoCursorExecute execute, InternalArangoDatabase<?, ?> db, InternalCursorEntity result) {
            this.cursorId = cursorId;
            this.type = type;
            this.execute = execute;
            this.db = db;
            this.result = result;
            this.arrayIterator = result.getResult().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.arrayIterator.hasNext() || this.result.getHasMore() != false;
        }

        @Override
        public T next() {
            if (!this.arrayIterator.hasNext() && Boolean.TRUE.equals(this.result.getHasMore())) {
                this.result = this.execute.next(this.cursorId, this.result.getNextBatchId());
                this.arrayIterator = this.result.getResult().iterator();
            }
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.deserialize(this.db.getSerde().serialize(this.arrayIterator.next()), this.type);
        }

        private <R> R deserialize(byte[] result, Class<R> type) {
            return this.db.getSerde().deserializeUserData(result, type);
        }
    }
}

