/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal.serde;

import com.arangodb.entity.CollectionStatus;
import com.arangodb.entity.CollectionType;
import com.arangodb.entity.InvertedIndexPrimarySort;
import com.arangodb.entity.ReplicationFactor;
import com.arangodb.entity.arangosearch.CollectionLink;
import com.arangodb.entity.arangosearch.FieldLink;
import com.arangodb.internal.InternalResponse;
import com.arangodb.internal.serde.SerdeUtils;
import com.arangodb.shaded.fasterxml.jackson.core.JsonGenerator;
import com.arangodb.shaded.fasterxml.jackson.core.JsonParser;
import com.arangodb.shaded.fasterxml.jackson.core.TreeNode;
import com.arangodb.shaded.fasterxml.jackson.databind.DeserializationContext;
import com.arangodb.shaded.fasterxml.jackson.databind.JsonDeserializer;
import com.arangodb.shaded.fasterxml.jackson.databind.JsonNode;
import com.arangodb.shaded.fasterxml.jackson.databind.node.ArrayNode;
import com.arangodb.shaded.fasterxml.jackson.databind.node.NumericNode;
import com.arangodb.shaded.fasterxml.jackson.databind.node.ObjectNode;
import com.arangodb.shaded.fasterxml.jackson.databind.node.TextNode;
import com.arangodb.shaded.fasterxml.jackson.databind.node.TreeTraversingParser;
import com.arangodb.util.RawBytes;
import com.arangodb.util.RawJson;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

public final class InternalDeserializers {
    static final JsonDeserializer<RawJson> RAW_JSON_DESERIALIZER = new JsonDeserializer<RawJson>(){

        @Override
        public RawJson deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            return RawJson.of(SerdeUtils.INSTANCE.writeJson((JsonNode)p.readValueAsTree()));
        }
    };
    static final JsonDeserializer<RawBytes> RAW_BYTES_DESERIALIZER = new JsonDeserializer<RawBytes>(){

        @Override
        public RawBytes deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            try (JsonGenerator g = p.getCodec().getFactory().createGenerator(os);){
                g.writeTree((TreeNode)p.readValueAsTree());
            }
            return RawBytes.of(os.toByteArray());
        }
    };
    static final JsonDeserializer<CollectionStatus> COLLECTION_STATUS = new JsonDeserializer<CollectionStatus>(){

        @Override
        public CollectionStatus deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            return CollectionStatus.fromStatus(p.getIntValue());
        }
    };
    static final JsonDeserializer<CollectionType> COLLECTION_TYPE = new JsonDeserializer<CollectionType>(){

        @Override
        public CollectionType deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            return CollectionType.fromType(p.getIntValue());
        }
    };
    static final JsonDeserializer<ReplicationFactor> REPLICATION_FACTOR = new JsonDeserializer<ReplicationFactor>(){

        @Override
        public ReplicationFactor deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            Object node = p.readValueAsTree();
            if (node instanceof NumericNode) {
                return ReplicationFactor.of(((NumericNode)node).intValue());
            }
            if (node instanceof TextNode && "satellite".equals(((TextNode)node).textValue())) {
                return ReplicationFactor.ofSatellite();
            }
            throw new IllegalArgumentException();
        }
    };
    static final JsonDeserializer<InternalResponse> RESPONSE = new JsonDeserializer<InternalResponse>(){

        @Override
        public InternalResponse deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            InternalResponse response = new InternalResponse();
            Iterator<JsonNode> it = ((ArrayNode)p.readValueAsTree()).iterator();
            response.setVersion(it.next().intValue());
            response.setType(it.next().intValue());
            response.setResponseCode(it.next().intValue());
            if (it.hasNext()) {
                response.putMetas((Map)InternalDeserializers.readTreeAsValue(p, ctxt, it.next(), Map.class));
            }
            return response;
        }
    };
    static final JsonDeserializer<InvertedIndexPrimarySort.Field> INVERTED_INDEX_PRIMARY_SORT_FIELD = new JsonDeserializer<InvertedIndexPrimarySort.Field>(){

        @Override
        public InvertedIndexPrimarySort.Field deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            ObjectNode tree = (ObjectNode)p.readValueAsTree();
            String field = tree.get("field").textValue();
            InvertedIndexPrimarySort.Field.Direction direction = tree.get("asc").booleanValue() ? InvertedIndexPrimarySort.Field.Direction.asc : InvertedIndexPrimarySort.Field.Direction.desc;
            return new InvertedIndexPrimarySort.Field(field, direction);
        }
    };

    private InternalDeserializers() {
    }

    private static <T> T readTreeAsValue(JsonParser p, DeserializationContext ctxt, JsonNode n, Class<T> targetType) throws IOException {
        try (TreeTraversingParser t = new TreeTraversingParser(n, p.getCodec());){
            t.nextToken();
            T t2 = ctxt.readValue((JsonParser)t, targetType);
            return t2;
        }
    }

    public static class CollectionSchemaRuleDeserializer
    extends JsonDeserializer<String> {
        @Override
        public String deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            return SerdeUtils.INSTANCE.writeJson((JsonNode)p.readValueAsTree());
        }
    }

    public static class FieldLinksDeserializer
    extends JsonDeserializer<FieldLink[]> {
        @Override
        public FieldLink[] deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            ArrayList<FieldLink> out = new ArrayList<FieldLink>();
            ObjectNode tree = (ObjectNode)p.readValueAsTree();
            Iterator<Map.Entry<String, JsonNode>> it = tree.fields();
            while (it.hasNext()) {
                Map.Entry<String, JsonNode> e = it.next();
                ObjectNode v = (ObjectNode)e.getValue();
                v.put("name", e.getKey());
                out.add((FieldLink)InternalDeserializers.readTreeAsValue(p, ctxt, v, FieldLink.class));
            }
            return out.toArray(new FieldLink[0]);
        }
    }

    public static class CollectionLinksDeserializer
    extends JsonDeserializer<Collection<CollectionLink>> {
        @Override
        public Collection<CollectionLink> deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            ArrayList<CollectionLink> out = new ArrayList<CollectionLink>();
            ObjectNode tree = (ObjectNode)p.readValueAsTree();
            Iterator<Map.Entry<String, JsonNode>> it = tree.fields();
            while (it.hasNext()) {
                Map.Entry<String, JsonNode> e = it.next();
                ObjectNode v = (ObjectNode)e.getValue();
                v.put("name", e.getKey());
                out.add((CollectionLink)InternalDeserializers.readTreeAsValue(p, ctxt, v, CollectionLink.class));
            }
            return out;
        }
    }
}

