/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal.serde;

import com.arangodb.ArangoDBException;
import com.arangodb.internal.serde.InternalParameterizedType;
import com.arangodb.shaded.fasterxml.jackson.core.JsonProcessingException;
import com.arangodb.shaded.fasterxml.jackson.core.json.PackageVersion;
import com.arangodb.shaded.fasterxml.jackson.databind.JavaType;
import com.arangodb.shaded.fasterxml.jackson.databind.JsonNode;
import com.arangodb.shaded.fasterxml.jackson.databind.ObjectMapper;
import com.arangodb.shaded.fasterxml.jackson.databind.type.TypeFactory;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum SerdeUtils {
    INSTANCE;

    private static final Logger LOGGER;
    private final ObjectMapper jsonMapper = new ObjectMapper();

    public static Type constructListType(Class<?> clazz) {
        return TypeFactory.defaultInstance().constructCollectionType(List.class, clazz);
    }

    public static Type constructParametricType(Class<?> rawType, Type ... rawArgs) {
        if (rawArgs == null || rawArgs.length == 0 || rawArgs[0] == null) {
            return rawType;
        }
        return new InternalParameterizedType(rawType, rawArgs);
    }

    public static Type convertToType(JavaType javaType) {
        ArrayList<Type> args = new ArrayList<Type>();
        for (JavaType it : javaType.getBindings().getTypeParameters()) {
            Type type = SerdeUtils.convertToType(it);
            args.add(type);
        }
        return SerdeUtils.constructParametricType(javaType.getRawClass(), args.toArray(new Type[0]));
    }

    static void checkSupportedJacksonVersion() {
        Arrays.asList(com.arangodb.shaded.fasterxml.jackson.databind.cfg.PackageVersion.VERSION, PackageVersion.VERSION).forEach(version -> {
            int major = version.getMajorVersion();
            int minor = version.getMinorVersion();
            if (major != 2 || minor < 10 || minor > 15) {
                LOGGER.warn("Unsupported Jackson version: {}", version);
            }
        });
    }

    public JsonNode parseJson(String json) {
        try {
            return this.jsonMapper.readTree(json);
        }
        catch (JsonProcessingException e) {
            throw new ArangoDBException(e);
        }
    }

    public String writeJson(JsonNode data) {
        try {
            return this.jsonMapper.writeValueAsString(data);
        }
        catch (JsonProcessingException e) {
            throw new ArangoDBException(e);
        }
    }

    static {
        LOGGER = LoggerFactory.getLogger(SerdeUtils.class);
    }
}

